/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.ImageComponent3D;
import org.jogamp.java3d.ImageComponentRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.TextureRetained;

class TextureCubeMapRetained
extends TextureRetained {
    static final int NUMFACES = 6;

    TextureCubeMapRetained() {
    }

    @Override
    void initialize(int format, int width, int widPower, int height, int heiPower, int mipmapMode, int boundaryWidth) {
        this.numFaces = 6;
        super.initialize(format, width, widPower, height, heiPower, mipmapMode, boundaryWidth);
    }

    void initImage(int level, int face, ImageComponent image) {
        this.checkImageSize(level, image);
        if (this.images == null) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureRetained0"));
        }
        if (image instanceof ImageComponent3D) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap3"));
        }
        if (face < 0 || face > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap4"));
        }
        if (this.source.isLive()) {
            if (this.images[face][level] != null) {
                this.images[face][level].clearLive(this.refCount);
            }
            if (image != null) {
                ((ImageComponentRetained)image.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.images[face][level] = image != null ? (ImageComponentRetained)image.retained : null;
    }

    final void setImage(int level, int face, ImageComponent image) {
        this.initImage(level, face, image);
        Object[] arg = new Object[]{new Integer(level), image, new Integer(face)};
        this.sendMessage(4, arg);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            if (image != null && level < this.maxLevels) {
                ImageComponentRetained img = (ImageComponentRetained)image.retained;
                if (img.isByReference()) {
                    if (img.getRefImage(0) == null) {
                        this.enable = false;
                    }
                } else if (img.getImageData(this.isUseAsRaster()).get() == null) {
                    this.enable = false;
                }
                if (!this.enable) {
                    this.sendMessage(1, Boolean.FALSE);
                }
            }
        }
    }

    void initImages(int face, ImageComponent[] images) {
        if (images.length != this.maxLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        for (int i2 = 0; i2 < images.length; ++i2) {
            this.initImage(i2, face, images[i2]);
        }
    }

    final void setImages(int face, ImageComponent[] images) {
        int i2;
        this.initImages(face, images);
        ImageComponent[] imgs = new ImageComponent[images.length];
        for (i2 = 0; i2 < images.length; ++i2) {
            imgs[i2] = images[i2];
        }
        Object[] args = new Object[]{imgs, new Integer(face)};
        this.sendMessage(32, args);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            for (i2 = 0; this.enable && i2 < this.maxLevels; ++i2) {
                if (images[i2] == null) continue;
                ImageComponentRetained img = (ImageComponentRetained)images[i2].retained;
                if (img.isByReference()) {
                    if (img.getRefImage(0) != null) continue;
                    this.enable = false;
                    continue;
                }
                if (img.getImageData(this.isUseAsRaster()).get() != null) continue;
                this.enable = false;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
    }

    final ImageComponent getImage(int level, int face) {
        if (face < 0 || face > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap4"));
        }
        return this.images != null && this.images[face][level] != null ? (ImageComponent)this.images[face][level].source : null;
    }

    final ImageComponent[] getImages(int face) {
        if (this.images == null) {
            return null;
        }
        if (face < 0 || face > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap4"));
        }
        ImageComponent[] rImages = new ImageComponent[this.images[face].length];
        for (int i2 = 0; i2 < this.images[face].length; ++i2) {
            rImages[i2] = this.images[face][i2] != null ? (ImageComponent)this.images[face][i2].source : null;
        }
        return rImages;
    }

    @Override
    void bindTexture(Context ctx, int objectId, boolean enable) {
        Pipeline.getPipeline().bindTextureCubeMap(ctx, objectId, enable);
    }

    @Override
    void updateTextureBoundary(Context ctx, int boundaryModeS, int boundaryModeT, float boundaryRed, float boundaryGreen, float boundaryBlue, float boundaryAlpha) {
        Pipeline.getPipeline().updateTextureCubeMapBoundary(ctx, boundaryModeS, boundaryModeT, boundaryRed, boundaryGreen, boundaryBlue, boundaryAlpha);
    }

    @Override
    void updateTextureFilterModes(Context ctx, int minFilter, int magFilter) {
        Pipeline.getPipeline().updateTextureCubeMapFilterModes(ctx, minFilter, magFilter);
    }

    @Override
    void updateTextureSharpenFunc(Context ctx, int numSharpenTextureFuncPts, float[] sharpenTextureFuncPts) {
        Pipeline.getPipeline().updateTextureCubeMapSharpenFunc(ctx, numSharpenTextureFuncPts, sharpenTextureFuncPts);
    }

    @Override
    void updateTextureFilter4Func(Context ctx, int numFilter4FuncPts, float[] filter4FuncPts) {
        Pipeline.getPipeline().updateTextureCubeMapFilter4Func(ctx, numFilter4FuncPts, filter4FuncPts);
    }

    @Override
    void updateTextureAnisotropicFilter(Context ctx, float degree) {
        Pipeline.getPipeline().updateTextureCubeMapAnisotropicFilter(ctx, degree);
    }

    @Override
    void updateTextureLodRange(Context ctx, int baseLevel, int maximumLevel, float minimumLod, float maximumLod) {
        Pipeline.getPipeline().updateTextureCubeMapLodRange(ctx, baseLevel, maximumLevel, minimumLod, maximumLod);
    }

    @Override
    void updateTextureLodOffset(Context ctx, float lodOffsetX, float lodOffsetY, float lodOffsetZ) {
        Pipeline.getPipeline().updateTextureCubeMapLodOffset(ctx, lodOffsetX, lodOffsetY, lodOffsetZ);
    }

    @Override
    void updateTextureDimensions(Canvas3D cv) {
        if (this.images[0][0] != null) {
            int imageFormat = this.images[0][0].getImageFormatTypeIntValue(false);
            int imageType = this.images[0][0].getImageDataTypeIntValue();
            for (int i2 = 0; i2 < 6; ++i2) {
                this.updateTextureImage(cv, i2, this.maxLevels, 0, this.format, imageFormat, this.width, this.height, this.boundaryWidth, imageType, null);
            }
        }
    }

    @Override
    void updateTextureImage(Canvas3D cv, int face, int numLevels, int level, int textureFormat, int imageFormat, int width, int height, int boundaryWidth, int imageDataType, Object imageData) {
        Pipeline.getPipeline().updateTextureCubeMapImage(cv.ctx, face, numLevels, level, textureFormat, imageFormat, width, height, boundaryWidth, imageDataType, imageData, this.useAutoMipMapGeneration(cv));
    }

    @Override
    void updateTextureSubImage(Canvas3D cv, int face, int level, int xoffset, int yoffset, int textureFormat, int imageFormat, int imgXOffset, int imgYOffset, int tilew, int width, int height, int imageDataType, Object imageData) {
        Pipeline.getPipeline().updateTextureCubeMapSubImage(cv.ctx, face, level, xoffset, yoffset, textureFormat, imageFormat, imgXOffset, imgYOffset, tilew, width, height, imageDataType, imageData, this.useAutoMipMapGeneration(cv));
    }
}

