/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.jogamp.java3d.AppearanceRetained;
import org.jogamp.java3d.AttributeBin;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.EnvironmentSet;
import org.jogamp.java3d.ObjectUpdate;
import org.jogamp.java3d.RenderAtom;
import org.jogamp.java3d.RenderAtomListInfo;
import org.jogamp.java3d.RenderBin;
import org.jogamp.java3d.RenderMolecule;
import org.jogamp.java3d.ShaderBin;
import org.jogamp.java3d.TexCoordGenerationRetained;
import org.jogamp.java3d.TextureAttributesRetained;
import org.jogamp.java3d.TextureRetained;
import org.jogamp.java3d.TextureUnitStateRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransparentRenderingInfo;
import org.jogamp.java3d.VirtualUniverse;

class TextureBin
implements ObjectUpdate {
    TextureUnitStateRetained[] texUnitState = null;
    private int numActiveTexUnit;
    RenderBin renderBin = null;
    EnvironmentSet environmentSet = null;
    AttributeBin attributeBin = null;
    ShaderBin shaderBin = null;
    TextureBin next = null;
    TextureBin prev = null;
    int equivalent = 0;
    AppearanceRetained app = null;
    int soleUserCompDirty;
    static final int SOLE_USER_DIRTY_REF = 1;
    static final int SOLE_USER_DIRTY_TA = 2;
    static final int SOLE_USER_DIRTY_TC = 4;
    static final int SOLE_USER_DIRTY_TEXTURE = 8;
    static final int SOLE_USER_DIRTY_TUS = 16;
    HashMap<Transform3D[], ArrayList<RenderMolecule>> addOpaqueRMs = new HashMap();
    HashMap<Transform3D[], ArrayList<RenderMolecule>> addTransparentRMs = new HashMap();
    HashMap<Transform3D[], RenderMolecule> opaqueRenderMoleculeMap = new HashMap();
    HashMap<Transform3D[], RenderMolecule> transparentRenderMoleculeMap = new HashMap();
    RenderMolecule opaqueRMList = null;
    RenderMolecule transparentRMList = null;
    TransparentRenderingInfo parentTInfo;
    int numRenderMolecules = 0;
    int numEditingRenderMolecules = 0;
    int tbFlag = 0;
    static final int ON_RENDER_BIN_LIST = 1;
    static final int ON_UPDATE_LIST = 2;
    static final int SOLE_USER = 4;
    static final int CONTIGUOUS_ACTIVE_UNITS = 8;
    static final int RESORT = 16;
    static final int ON_UPDATE_CHECK_LIST = 32;
    static final int USE_DISPLAYLIST = -2;
    static final int USE_VERTEXARRAY = -1;

    TextureBin(TextureUnitStateRetained[] state, AppearanceRetained app, RenderBin rb) {
        this.renderBin = rb;
        this.tbFlag = 0;
        this.reset(state, app);
    }

    void reset(TextureUnitStateRetained[] state, AppearanceRetained app) {
        this.prev = null;
        this.next = null;
        this.opaqueRMList = null;
        this.transparentRMList = null;
        this.numEditingRenderMolecules = 0;
        this.tbFlag &= 0xFFFFFFFB;
        if (VirtualUniverse.mc.allowSoleUser && app != null && (app.changedFrequent & 0x40E) != 0) {
            this.tbFlag |= 4;
        }
        this.app = (this.tbFlag & 4) != 0 ? app : null;
        this.resetTextureState(state);
        if ((this.tbFlag & 1) == 0) {
            this.renderBin.addTextureBin(this);
            this.tbFlag |= 1;
        }
    }

    void resetTextureState(TextureUnitStateRetained[] state) {
        boolean foundDisableUnit = false;
        this.numActiveTexUnit = 0;
        boolean soleUser = (this.tbFlag & 4) != 0;
        TextureRetained prevFirstTexture = null;
        this.tbFlag |= 8;
        if (state != null) {
            foundDisableUnit = false;
            if (this.texUnitState == null || this.texUnitState.length != state.length) {
                this.texUnitState = new TextureUnitStateRetained[state.length];
            } else if (this.texUnitState.length > 0 && this.texUnitState[0] != null) {
                prevFirstTexture = this.texUnitState[0].texture;
            }
            for (int i2 = 0; i2 < state.length; ++i2) {
                TextureRetained tex;
                if (state[i2] == null) {
                    this.texUnitState[i2] = null;
                    foundDisableUnit = true;
                    continue;
                }
                if (this.texUnitState[i2] == null) {
                    this.texUnitState[i2] = new TextureUnitStateRetained();
                }
                if (soleUser || state[i2].changedFrequent != 0) {
                    this.texUnitState[i2].mirror = state[i2];
                }
                if ((tex = this.texUnitState[i2].texture) != null) {
                    tex.decTextureBinRefCount(this);
                    if (soleUser && tex.getTextureBinRefCount(this) == 0 && tex != state[i2].texture) {
                        this.renderBin.addTextureResourceFreeList(tex);
                    }
                }
                this.texUnitState[i2].texture = state[i2].texture;
                if (this.texUnitState[i2].texture != null) {
                    this.texUnitState[i2].texture.incTextureBinRefCount(this);
                }
                if (state[i2].texAttrs != null) {
                    if (state[i2].texAttrs.changedFrequent != 0) {
                        this.texUnitState[i2].texAttrs = state[i2].texAttrs;
                    } else {
                        if (this.texUnitState[i2].texAttrs == null || this.texUnitState[i2].texAttrs.source != null) {
                            this.texUnitState[i2].texAttrs = new TextureAttributesRetained();
                        }
                        this.texUnitState[i2].texAttrs.set(state[i2].texAttrs);
                        this.texUnitState[i2].texAttrs.mirrorCompDirty = true;
                        this.texUnitState[i2].texAttrs.mirror = soleUser ? state[i2].texAttrs : null;
                    }
                } else {
                    this.texUnitState[i2].texAttrs = null;
                }
                if (state[i2].texGen != null) {
                    if (state[i2].texGen.changedFrequent != 0) {
                        this.texUnitState[i2].texGen = state[i2].texGen;
                    } else {
                        if (this.texUnitState[i2].texGen == null || this.texUnitState[i2].texGen.source != null) {
                            this.texUnitState[i2].texGen = new TexCoordGenerationRetained();
                        }
                        this.texUnitState[i2].texGen.set(state[i2].texGen);
                        this.texUnitState[i2].texGen.mirrorCompDirty = true;
                        this.texUnitState[i2].texGen.mirror = soleUser ? state[i2].texGen : null;
                    }
                } else {
                    this.texUnitState[i2].texGen = null;
                }
                if (this.texUnitState[i2].isTextureEnabled()) {
                    this.numActiveTexUnit = i2 + 1;
                    if (!foundDisableUnit) continue;
                    this.tbFlag &= 0xFFFFFFF7;
                    continue;
                }
                foundDisableUnit = true;
            }
            if (this.texUnitState[0] == null && prevFirstTexture != null || this.texUnitState[0] != null && this.texUnitState[0].texture != prevFirstTexture) {
                this.tbFlag |= 0x10;
            }
        } else {
            if (this.texUnitState != null && this.texUnitState[0].texture != null) {
                this.tbFlag |= 0x10;
            }
            this.texUnitState = null;
        }
        this.soleUserCompDirty = 0;
    }

    void clear() {
        this.app = null;
        if (this.texUnitState != null) {
            for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
                if (this.texUnitState[i2] == null) continue;
                if (this.texUnitState[i2].texture != null) {
                    TextureRetained tex = this.texUnitState[i2].texture;
                    tex.decTextureBinRefCount(this);
                    if (tex.getTextureBinRefCount(this) == 0) {
                        this.renderBin.addTextureResourceFreeList(tex);
                    }
                    this.texUnitState[i2].texture = null;
                }
                this.texUnitState[i2].mirror = null;
                this.texUnitState[i2].texture = null;
                if (this.texUnitState[i2].texAttrs != null && this.texUnitState[i2].texAttrs.source != null) {
                    this.texUnitState[i2].texAttrs = null;
                }
                if (this.texUnitState[i2].texGen == null || this.texUnitState[i2].texGen.source == null) continue;
                this.texUnitState[i2].texGen = null;
            }
        }
    }

    boolean equals(TextureUnitStateRetained[] state, RenderAtom ra) {
        if ((this.tbFlag & 4) != 0 || ra.app != null && (ra.app.changedFrequent & 0x40E) != 0) {
            if (this.app == ra.app) {
                if (this.numEditingRenderMolecules == 0) {
                    if (this.soleUserCompDirty == 0) {
                        this.renderBin.tbUpdateList.add(this);
                    }
                    this.soleUserCompDirty |= 1;
                }
                return true;
            }
            return false;
        }
        if (this.texUnitState == null && state == null) {
            return true;
        }
        if (this.texUnitState == null || state == null) {
            return false;
        }
        if (state.length != this.texUnitState.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
            if (!(this.texUnitState[i2] == null ? state[i2] != null : !this.texUnitState[i2].equivalent(state[i2]))) continue;
            return false;
        }
        if ((this.tbFlag & 1) == 0) {
            this.renderBin.addTextureBin(this);
            this.tbFlag |= 1;
        }
        return true;
    }

    public void updateNodeComponent() {
        if ((this.tbFlag & 1) == 0) {
            return;
        }
        if ((this.tbFlag & 4) != 0 && (this.soleUserCompDirty & 1) != 0) {
            this.resetTextureState(this.app.texUnitState);
            return;
        }
        if (this.texUnitState == null) {
            this.soleUserCompDirty = 0;
            return;
        }
        if ((this.soleUserCompDirty & 0x10) != 0) {
            TextureUnitStateRetained mirrorTUS = null;
            boolean soleUser = (this.tbFlag & 4) != 0;
            for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
                TextureUnitStateRetained tus = this.texUnitState[i2];
                if (tus == null || tus.mirror == null) continue;
                mirrorTUS = (TextureUnitStateRetained)tus.mirror;
                if (tus.texture != mirrorTUS.texture) {
                    if (tus.texture != null) {
                        tus.texture.decTextureBinRefCount(this);
                    }
                    tus.texture = mirrorTUS.texture;
                    if (tus.texture != null) {
                        tus.texture.incTextureBinRefCount(this);
                    }
                    if (i2 == 0) {
                        this.tbFlag |= 0x10;
                    }
                }
                if (mirrorTUS.texAttrs != null) {
                    if (mirrorTUS.texAttrs.changedFrequent != 0) {
                        tus.texAttrs = mirrorTUS.texAttrs;
                    } else {
                        if (tus.texAttrs == null || tus.texAttrs.source != null) {
                            tus.texAttrs = new TextureAttributesRetained();
                        }
                        tus.texAttrs.set(mirrorTUS.texAttrs);
                        tus.texAttrs.mirrorCompDirty = true;
                        tus.texAttrs.mirror = soleUser ? mirrorTUS.texAttrs : null;
                    }
                } else {
                    tus.texAttrs = null;
                }
                if (mirrorTUS.texGen != null) {
                    if (mirrorTUS.texGen.changedFrequent != 0) {
                        tus.texGen = mirrorTUS.texGen;
                        continue;
                    }
                    if (tus.texGen == null || tus.texGen.source != null) {
                        tus.texGen = new TexCoordGenerationRetained();
                    }
                    tus.texGen.set(mirrorTUS.texGen);
                    tus.texGen.mirrorCompDirty = true;
                    if (soleUser) {
                        tus.texGen.mirror = mirrorTUS.texGen;
                        continue;
                    }
                    tus.texGen.mirror = null;
                    continue;
                }
                tus.texGen = null;
            }
            this.soleUserCompDirty |= 8;
            this.soleUserCompDirty &= 0xFFFFFFF9;
        }
        if ((this.soleUserCompDirty & 8) != 0) {
            boolean foundDisableUnit = false;
            this.numActiveTexUnit = 0;
            this.tbFlag |= 8;
            for (int i3 = 0; i3 < this.texUnitState.length; ++i3) {
                if (this.texUnitState[i3] != null && this.texUnitState[i3].isTextureEnabled()) {
                    this.numActiveTexUnit = i3 + 1;
                    if (!foundDisableUnit) continue;
                    this.tbFlag &= 0xFFFFFFF7;
                    continue;
                }
                foundDisableUnit = true;
            }
        }
        if ((this.soleUserCompDirty & 2) != 0) {
            for (int i4 = 0; i4 < this.texUnitState.length; ++i4) {
                if (this.texUnitState[i4] == null || this.texUnitState[i4].texAttrs == null || this.texUnitState[i4].texAttrs.mirror == null || this.texUnitState[i4].texAttrs.mirror.changedFrequent == 0) continue;
                this.texUnitState[i4].texAttrs = (TextureAttributesRetained)this.texUnitState[i4].texAttrs.mirror;
            }
        }
        if ((this.soleUserCompDirty & 4) != 0) {
            for (int i5 = 0; i5 < this.texUnitState.length; ++i5) {
                if (this.texUnitState[i5] == null || this.texUnitState[i5].texGen == null || this.texUnitState[i5].texGen.mirror == null || this.texUnitState[i5].texGen.mirror.changedFrequent == 0) continue;
                this.texUnitState[i5].texGen = (TexCoordGenerationRetained)this.texUnitState[i5].texGen.mirror;
            }
        }
        this.soleUserCompDirty = 0;
    }

    @Override
    public void updateObject() {
        if (!this.addOpaqueRMs.isEmpty()) {
            this.opaqueRMList = this.addAll(this.opaqueRenderMoleculeMap, this.addOpaqueRMs, this.opaqueRMList, true);
        }
        if (!this.addTransparentRMs.isEmpty()) {
            if (this.transparentRMList == null && (this.renderBin.transpSortMode == 0 || this.environmentSet.lightBin.geometryBackground != null)) {
                this.transparentRMList = this.addAll(this.transparentRenderMoleculeMap, this.addTransparentRMs, this.transparentRMList, false);
                if (this.transparentRMList != null) {
                    this.renderBin.addTransparentObject(this);
                }
            } else {
                this.transparentRMList = this.addAll(this.transparentRenderMoleculeMap, this.addTransparentRMs, this.transparentRMList, false);
            }
        }
        this.tbFlag &= 0xFFFFFFFD;
    }

    RenderMolecule addAll(HashMap<Transform3D[], RenderMolecule> renderMoleculeMap, HashMap<Transform3D[], ArrayList<RenderMolecule>> addRMs, RenderMolecule startList, boolean opaqueList) {
        Collection<ArrayList<RenderMolecule>> c2 = addRMs.values();
        Iterator<ArrayList<RenderMolecule>> listIterator = c2.iterator();
        while (listIterator.hasNext()) {
            RenderMolecule head;
            boolean changed = false;
            ArrayList<RenderMolecule> curList = listIterator.next();
            RenderMolecule r = curList.get(0);
            if (r.isOpaqueOrInOG != opaqueList) continue;
            RenderMolecule renderMoleculeList = renderMoleculeMap.get(r.localToVworld);
            if (renderMoleculeList == null) {
                renderMoleculeList = r;
                renderMoleculeMap.put(r.localToVworld, renderMoleculeList);
                if (startList == null) {
                    startList = r;
                    r.nextMap = null;
                    r.prevMap = null;
                    startList.dirtyAttrsAcrossRms = 945;
                } else {
                    r.nextMap = startList;
                    startList.prevMap = r;
                    startList = r;
                    startList.nextMap.checkEquivalenceWithLeftNeighbor(r, 945);
                }
            } else {
                head = this.insertRenderMolecule(r, renderMoleculeList);
                if (head != null) {
                    if (renderMoleculeList.prevMap != null) {
                        renderMoleculeList.prevMap.nextMap = head;
                    }
                    head.prevMap = renderMoleculeList.prevMap;
                    renderMoleculeList.prevMap = null;
                    renderMoleculeList = head;
                    changed = true;
                }
            }
            for (int i2 = 1; i2 < curList.size(); ++i2) {
                r = curList.get(i2);
                if (r.isOpaqueOrInOG != opaqueList || (head = this.insertRenderMolecule(r, renderMoleculeList)) == null) continue;
                if (renderMoleculeList.prevMap != null) {
                    renderMoleculeList.prevMap.nextMap = head;
                }
                head.prevMap = renderMoleculeList.prevMap;
                renderMoleculeList.prevMap = null;
                renderMoleculeList = head;
                changed = true;
            }
            if (!changed) continue;
            renderMoleculeMap.put(r.localToVworld, renderMoleculeList);
            if (renderMoleculeList.prevMap != null) {
                renderMoleculeList.checkEquivalenceWithLeftNeighbor(renderMoleculeList.prevMap, 945);
                continue;
            }
            startList = renderMoleculeList;
            startList.dirtyAttrsAcrossRms = 945;
        }
        addRMs.clear();
        return startList;
    }

    RenderMolecule insertRenderMolecule(RenderMolecule r, RenderMolecule renderMoleculeList) {
        RenderMolecule rm = renderMoleculeList;
        while (rm != null) {
            if (rm.material == r.material || rm.definingMaterial != null && rm.definingMaterial.equivalent(r.definingMaterial)) {
                RenderMolecule retval;
                r.next = rm;
                r.prev = rm.prev;
                if (rm.prev == null) {
                    retval = renderMoleculeList = r;
                } else {
                    rm.prev.next = r;
                    retval = null;
                }
                rm.prev = r;
                r.checkEquivalenceWithBothNeighbors(945);
                return retval;
            }
            rm = rm.next;
            while (rm != null && (rm.dirtyAttrsAcrossRms & 1) == 0) {
                rm = rm.next;
            }
        }
        r.next = renderMoleculeList;
        renderMoleculeList.prev = r;
        renderMoleculeList = r;
        r.checkEquivalenceWithBothNeighbors(945);
        return renderMoleculeList;
    }

    void addRenderMolecule(RenderMolecule r, RenderBin rb) {
        r.textureBin = this;
        HashMap<Transform3D[], ArrayList<RenderMolecule>> map = r.isOpaqueOrInOG ? this.addOpaqueRMs : this.addTransparentRMs;
        ArrayList<RenderMolecule> list = map.get(r.localToVworld);
        if (list == null) {
            list = new ArrayList();
            map.put(r.localToVworld, list);
        }
        list.add(r);
        if ((this.tbFlag & 2) == 0) {
            this.tbFlag |= 2;
            rb.objUpdateList.add(this);
        }
    }

    void removeRenderMolecule(RenderMolecule r) {
        int index;
        HashMap<Transform3D[], ArrayList<RenderMolecule>> addMap;
        HashMap<Transform3D[], RenderMolecule> allMap;
        RenderMolecule rmlist;
        boolean found = false;
        r.textureBin = null;
        if (r.isOpaqueOrInOG) {
            rmlist = this.opaqueRMList;
            allMap = this.opaqueRenderMoleculeMap;
            addMap = this.addOpaqueRMs;
        } else {
            rmlist = this.transparentRMList;
            allMap = this.transparentRenderMoleculeMap;
            addMap = this.addTransparentRMs;
        }
        ArrayList<RenderMolecule> list = addMap.get(r.localToVworld);
        if (list != null && (index = list.indexOf(r)) != -1) {
            list.remove(index);
            if (list.isEmpty()) {
                addMap.remove(r.localToVworld);
            }
            r.prev = null;
            r.next = null;
            found = true;
        }
        if (!found) {
            RenderMolecule head = this.removeOneRM(r, allMap, rmlist);
            r.soleUserCompDirty = 0;
            r.onUpdateList = 0;
            if (r.definingPolygonAttributes != null && r.definingPolygonAttributes.changedFrequent != 0) {
                r.definingPolygonAttributes = null;
            }
            if (r.definingLineAttributes != null && r.definingLineAttributes.changedFrequent != 0) {
                r.definingLineAttributes = null;
            }
            if (r.definingPointAttributes != null && r.definingPointAttributes.changedFrequent != 0) {
                r.definingPointAttributes = null;
            }
            if (r.definingMaterial != null && r.definingMaterial.changedFrequent != 0) {
                r.definingMaterial = null;
            }
            if (r.definingColoringAttributes != null && r.definingColoringAttributes.changedFrequent != 0) {
                r.definingColoringAttributes = null;
            }
            if (r.definingTransparency != null && r.definingTransparency.changedFrequent != 0) {
                r.definingTransparency = null;
            }
            this.renderBin.removeRenderMolecule(r);
            if (r.isOpaqueOrInOG) {
                this.opaqueRMList = head;
            } else {
                this.transparentRMList = head;
            }
        }
        if (!(r.isOpaqueOrInOG || this.transparentRMList != null || this.renderBin.transpSortMode != 0 && this.environmentSet.lightBin.geometryBackground == null)) {
            this.renderBin.removeTransparentObject(this);
        } else if (this.parentTInfo != null && this.parentTInfo.rm == r) {
            this.parentTInfo.rm = this.transparentRMList;
        }
        if (this.opaqueRenderMoleculeMap.isEmpty() && this.addOpaqueRMs.isEmpty() && this.transparentRenderMoleculeMap.isEmpty() && this.addTransparentRMs.isEmpty()) {
            if ((this.tbFlag & 1) != 0) {
                this.tbFlag &= 0xFFFFFFFE;
                this.renderBin.removeTextureBin(this);
            }
            this.shaderBin.removeTextureBin(this);
            this.texUnitState = null;
        }
    }

    void updateAttributes(Canvas3D cv) {
        boolean dirty;
        boolean bl = dirty = (cv.canvasDirty & 0xC00) != 0;
        if (cv.textureBin == this && !dirty) {
            return;
        }
        cv.textureBin = this;
        int lastActiveTexUnitIdx = -1;
        boolean useShaders = this.shaderBin.shaderProgram != null;
        int availableTextureUnits = useShaders ? cv.maxTextureImageUnits : cv.maxTextureUnits;
        boolean disableTexture = false;
        if (this.numActiveTexUnit > availableTextureUnits) {
            disableTexture = true;
        }
        if (disableTexture) {
            cv.setNumActiveTexUnit(0);
        } else {
            cv.setNumActiveTexUnit(this.numActiveTexUnit);
        }
        if (this.numActiveTexUnit <= 0 || disableTexture) {
            if (cv.getLastActiveTexUnit() >= 0) {
                if (cv.multiTexAccelerated) {
                    for (int i2 = 0; i2 <= cv.getLastActiveTexUnit(); ++i2) {
                        cv.resetTexture(cv.ctx, i2);
                    }
                    cv.setNumActiveTexUnit(0);
                    cv.activeTextureUnit(cv.ctx, 0);
                } else {
                    cv.resetTexture(cv.ctx, -1);
                }
                cv.setLastActiveTexUnit(-1);
            }
        } else {
            int i3;
            int j2 = 0;
            for (i3 = 0; i3 < this.texUnitState.length && j2 < cv.texUnitState.length; ++j2, ++i3) {
                if (this.texUnitState[i3] != null && this.texUnitState[i3].isTextureEnabled()) {
                    if (dirty || cv.texUnitState[j2].mirror == null || cv.texUnitState[j2].mirror != this.texUnitState[i3].mirror) {
                        this.texUnitState[i3].updateNative(j2, cv, false, false);
                        cv.texUnitState[j2].mirror = this.texUnitState[i3].mirror;
                    }
                    lastActiveTexUnitIdx = j2;
                    continue;
                }
                if (j2 > cv.getLastActiveTexUnit()) continue;
                cv.resetTexture(cv.ctx, j2);
            }
            for (i3 = j2; i3 <= cv.getLastActiveTexUnit(); ++i3) {
                cv.resetTexture(cv.ctx, i3);
            }
            cv.setLastActiveTexUnit(lastActiveTexUnitIdx);
            cv.activeTextureUnit(cv.ctx, 0);
        }
        cv.canvasDirty &= 0xFFFFFBFF;
    }

    void render(Canvas3D cv) {
        this.render(cv, this.opaqueRMList);
    }

    void render(Canvas3D cv, RenderMolecule rlist) {
        cv.setStateToUpdate(3, this);
        this.renderList(cv, -2, rlist);
    }

    void render(Canvas3D cv, TransparentRenderingInfo rlist) {
        cv.setStateToUpdate(3, this);
        this.renderList(cv, -2, rlist);
    }

    void renderList(Canvas3D cv, int pass, RenderMolecule rlist) {
        assert (pass < 0);
        int combinedDirtyBits = 0;
        boolean rmVisible = true;
        RenderMolecule rm = rlist;
        while (rm != null) {
            combinedDirtyBits = rmVisible ? rm.dirtyAttrsAcrossRms : (combinedDirtyBits |= rm.dirtyAttrsAcrossRms);
            rmVisible = rm.render(cv, pass, combinedDirtyBits);
            if (rm.next == null) {
                rm = rm.nextMap;
                continue;
            }
            rm = rm.next;
        }
    }

    void renderList(Canvas3D cv, int pass, TransparentRenderingInfo tinfo) {
        assert (pass < 0);
        RenderMolecule rm = tinfo.rm;
        if (rm.isSwitchOn()) {
            rm.transparentSortRender(cv, pass, tinfo);
        }
    }

    void changeLists(RenderMolecule r) {
        HashMap<Transform3D[], RenderMolecule> renderMoleculeMap;
        RenderMolecule startList;
        RenderMolecule head;
        RenderMolecule rmlist = null;
        HashMap<Transform3D[], RenderMolecule> allMap = null;
        boolean newRM = false;
        if (r.isOpaqueOrInOG) {
            if (this.opaqueRMList == null && r.prev == null && r.prevMap == null && r.next == null && r.nextMap == null) {
                newRM = true;
            } else {
                rmlist = this.opaqueRMList;
                allMap = this.opaqueRenderMoleculeMap;
            }
        } else if (this.transparentRMList == null && r.prev == null && r.prevMap == null && r.next == null && r.nextMap == null) {
            newRM = true;
        } else {
            rmlist = this.transparentRMList;
            allMap = this.transparentRenderMoleculeMap;
        }
        if (!newRM) {
            head = this.removeOneRM(r, allMap, rmlist);
            if (r.isOpaqueOrInOG) {
                this.opaqueRMList = head;
            } else {
                this.transparentRMList = head;
                if (this.transparentRMList == null && (this.renderBin.transpSortMode == 0 || this.environmentSet.lightBin.geometryBackground != null)) {
                    this.renderBin.removeTransparentObject(this);
                }
                if (this.renderBin.transpSortMode == 1 && this.environmentSet.lightBin.geometryBackground == null) {
                    r.addRemoveTransparentObject(this.renderBin, false);
                }
            }
        }
        r.evalAlphaUsage(this.shaderBin.attributeBin.definingRenderingAttributes, this.texUnitState);
        boolean bl = r.isOpaqueOrInOG = r.isOpaque() || r.inOrderedGroup;
        if (r.isOpaqueOrInOG) {
            startList = this.opaqueRMList;
            renderMoleculeMap = this.opaqueRenderMoleculeMap;
            this.markDlistAsDirty(r);
        } else {
            startList = this.transparentRMList;
            renderMoleculeMap = this.transparentRenderMoleculeMap;
            if ((r.primaryMoleculeType & RenderMolecule.DLIST_MOLECULE) != 0 && this.renderBin.transpSortMode != 0) {
                this.renderBin.addDisplayListResourceFreeList(r);
                this.renderBin.removeDirtyRenderMolecule(r);
                r.vwcBounds.set(null);
                r.displayListId = 0;
                r.displayListIdObj = null;
                RenderAtomListInfo rinfo = r.primaryRenderAtomList;
                while (rinfo != null) {
                    rinfo.groupType = RenderAtom.SEPARATE_DLIST_PER_RINFO;
                    if (rinfo.renderAtom.dlistIds == null) {
                        rinfo.renderAtom.dlistIds = new int[rinfo.renderAtom.rListInfo.length];
                        for (int k2 = 0; k2 < rinfo.renderAtom.dlistIds.length; ++k2) {
                            rinfo.renderAtom.dlistIds[k2] = -1;
                        }
                    }
                    if (rinfo.renderAtom.dlistIds[rinfo.index] == -1) {
                        rinfo.renderAtom.dlistIds[rinfo.index] = VirtualUniverse.mc.getDisplayListId();
                        this.renderBin.addDlistPerRinfo.add(rinfo);
                    }
                    rinfo = rinfo.next;
                }
                r.primaryMoleculeType = RenderMolecule.SEPARATE_DLIST_PER_RINFO_MOLECULE;
            } else {
                this.markDlistAsDirty(r);
            }
        }
        RenderMolecule renderMoleculeList = renderMoleculeMap.get(r.localToVworld);
        if (renderMoleculeList == null) {
            renderMoleculeList = r;
            renderMoleculeMap.put(r.localToVworld, renderMoleculeList);
            if (startList == null) {
                startList = r;
                r.nextMap = null;
                r.prevMap = null;
            } else {
                r.nextMap = startList;
                startList.prevMap = r;
                startList = r;
                startList.nextMap.checkEquivalenceWithLeftNeighbor(r, 945);
            }
            startList.dirtyAttrsAcrossRms = 945;
        } else {
            head = this.insertRenderMolecule(r, renderMoleculeList);
            if (head != null) {
                if (renderMoleculeList.prevMap != null) {
                    renderMoleculeList.prevMap.nextMap = head;
                }
                head.prevMap = renderMoleculeList.prevMap;
                renderMoleculeList.prevMap = null;
                renderMoleculeList = head;
                renderMoleculeMap.put(r.localToVworld, renderMoleculeList);
                if (renderMoleculeList.prevMap != null) {
                    renderMoleculeList.checkEquivalenceWithLeftNeighbor(renderMoleculeList.prevMap, 945);
                } else {
                    startList.dirtyAttrsAcrossRms = 945;
                    startList = renderMoleculeList;
                }
            }
        }
        if (r.isOpaqueOrInOG) {
            this.opaqueRMList = startList;
        } else {
            if (this.transparentRMList == null && (this.renderBin.transpSortMode == 0 || this.environmentSet.lightBin.geometryBackground != null)) {
                this.transparentRMList = startList;
                this.renderBin.addTransparentObject(this);
            } else {
                this.transparentRMList = startList;
            }
            if (this.renderBin.transpSortMode == 1 && this.environmentSet.lightBin.geometryBackground == null) {
                r.addRemoveTransparentObject(this.renderBin, true);
            }
        }
    }

    RenderMolecule removeOneRM(RenderMolecule r, HashMap<Transform3D[], RenderMolecule> allMap, RenderMolecule list) {
        RenderMolecule rmlist = list;
        if (r.prev != null && r.next != null) {
            r.prev.next = r.next;
            r.next.prev = r.prev;
            r.next.checkEquivalenceWithLeftNeighbor(r.prev, 945);
        } else if (r.prev != null && r.next == null) {
            r.prev.next = r.next;
            r.prev.nextMap = r.nextMap;
            if (r.nextMap != null) {
                r.nextMap.prevMap = r.prev;
                r.nextMap.checkEquivalenceWithLeftNeighbor(r.prev, 945);
            }
        } else if (r.prev == null && r.next != null) {
            r.next.prev = null;
            r.next.prevMap = r.prevMap;
            if (r.prevMap != null) {
                r.prevMap.nextMap = r.next;
                r.next.checkEquivalenceWithLeftNeighbor(r.prevMap, 945);
            } else {
                rmlist = r.next;
                rmlist.dirtyAttrsAcrossRms = 945;
            }
            allMap.put(r.localToVworld, r.next);
        } else if (r.prev == null && r.next == null) {
            if (r.prevMap != null) {
                r.prevMap.nextMap = r.nextMap;
            } else {
                rmlist = r.nextMap;
                if (r.nextMap != null) {
                    rmlist.dirtyAttrsAcrossRms = 945;
                }
            }
            if (r.nextMap != null) {
                r.nextMap.prevMap = r.prevMap;
                if (r.prevMap != null) {
                    r.nextMap.checkEquivalenceWithLeftNeighbor(r.prevMap, 945);
                }
            }
            allMap.remove(r.localToVworld);
        }
        r.prev = null;
        r.next = null;
        r.prevMap = null;
        r.nextMap = null;
        return rmlist;
    }

    void markDlistAsDirty(RenderMolecule r) {
        if (r.primaryMoleculeType == RenderMolecule.DLIST_MOLECULE) {
            this.renderBin.addDirtyRenderMolecule(r);
        } else if (r.primaryMoleculeType == RenderMolecule.SEPARATE_DLIST_PER_RINFO_MOLECULE) {
            RenderAtomListInfo ra = r.primaryRenderAtomList;
            while (ra != null) {
                this.renderBin.addDlistPerRinfo.add(ra);
                ra = ra.next;
            }
        }
    }

    void decrActiveRenderMolecule() {
        --this.numEditingRenderMolecules;
        if (this.numEditingRenderMolecules == 0) {
            this.shaderBin.decrActiveTextureBin();
        }
    }

    void incrActiveRenderMolecule() {
        if (this.numEditingRenderMolecules == 0) {
            this.shaderBin.incrActiveTextureBin();
        }
        ++this.numEditingRenderMolecules;
    }
}

