/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.TextureAttributesRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Color4f;

public class TextureAttributes
extends NodeComponent {
    public static final int ALLOW_MODE_READ = 0;
    public static final int ALLOW_MODE_WRITE = 1;
    public static final int ALLOW_BLEND_COLOR_READ = 2;
    public static final int ALLOW_BLEND_COLOR_WRITE = 3;
    public static final int ALLOW_TRANSFORM_READ = 4;
    public static final int ALLOW_TRANSFORM_WRITE = 5;
    public static final int ALLOW_COLOR_TABLE_READ = 6;
    public static final int ALLOW_COLOR_TABLE_WRITE = 7;
    public static final int ALLOW_COMBINE_READ = 8;
    public static final int ALLOW_COMBINE_WRITE = 9;
    public static final int FASTEST = 0;
    public static final int NICEST = 1;
    public static final int MODULATE = 2;
    public static final int DECAL = 3;
    public static final int BLEND = 4;
    public static final int REPLACE = 5;
    public static final int COMBINE = 6;
    public static final int COMBINE_REPLACE = 0;
    public static final int COMBINE_MODULATE = 1;
    public static final int COMBINE_ADD = 2;
    public static final int COMBINE_ADD_SIGNED = 3;
    public static final int COMBINE_SUBTRACT = 4;
    public static final int COMBINE_INTERPOLATE = 5;
    public static final int COMBINE_DOT3 = 6;
    public static final int COMBINE_OBJECT_COLOR = 0;
    public static final int COMBINE_TEXTURE_COLOR = 1;
    public static final int COMBINE_CONSTANT_COLOR = 2;
    public static final int COMBINE_PREVIOUS_TEXTURE_UNIT_STATE = 3;
    public static final int COMBINE_SRC_COLOR = 0;
    public static final int COMBINE_ONE_MINUS_SRC_COLOR = 1;
    public static final int COMBINE_SRC_ALPHA = 2;
    public static final int COMBINE_ONE_MINUS_SRC_ALPHA = 3;
    private static final int[] readCapabilities = new int[]{2, 6, 8, 0, 4};

    public TextureAttributes() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public TextureAttributes(int textureMode, Transform3D transform, Color4f textureBlendColor, int perspCorrectionMode) {
        if (textureMode < 2 || textureMode > 6) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes10"));
        }
        if (perspCorrectionMode != 0 && perspCorrectionMode != 1) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes9"));
        }
        this.setDefaultReadCapabilities(readCapabilities);
        ((TextureAttributesRetained)this.retained).initTextureMode(textureMode);
        ((TextureAttributesRetained)this.retained).initTextureBlendColor(textureBlendColor);
        ((TextureAttributesRetained)this.retained).initTextureTransform(transform);
        ((TextureAttributesRetained)this.retained).initPerspectiveCorrectionMode(perspCorrectionMode);
    }

    public void setTextureMode(int textureMode) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes0"));
        }
        if (textureMode < 2 || textureMode > 6) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes10"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureMode(textureMode);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureMode(textureMode);
        }
    }

    public int getTextureMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes1"));
        }
        return ((TextureAttributesRetained)this.retained).getTextureMode();
    }

    public void setTextureBlendColor(Color4f textureBlendColor) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes2"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureBlendColor(textureBlendColor);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureBlendColor(textureBlendColor);
        }
    }

    public void setTextureBlendColor(float r, float g2, float b2, float a2) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes3"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureBlendColor(r, g2, b2, a2);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureBlendColor(r, g2, b2, a2);
        }
    }

    public void getTextureBlendColor(Color4f textureBlendColor) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes4"));
        }
        ((TextureAttributesRetained)this.retained).getTextureBlendColor(textureBlendColor);
    }

    public void setTextureTransform(Transform3D transform) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes5"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureTransform(transform);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureTransform(transform);
        }
    }

    public void getTextureTransform(Transform3D transform) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes6"));
        }
        ((TextureAttributesRetained)this.retained).getTextureTransform(transform);
    }

    public void setPerspectiveCorrectionMode(int mode) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes7"));
        }
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes9"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setPerspectiveCorrectionMode(mode);
        } else {
            ((TextureAttributesRetained)this.retained).initPerspectiveCorrectionMode(mode);
        }
    }

    public int getPerspectiveCorrectionMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes8"));
        }
        return ((TextureAttributesRetained)this.retained).getPerspectiveCorrectionMode();
    }

    public void setTextureColorTable(int[][] table) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes11"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureColorTable(table);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureColorTable(table);
        }
    }

    public void getTextureColorTable(int[][] table) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes12"));
        }
        ((TextureAttributesRetained)this.retained).getTextureColorTable(table);
    }

    public int getNumTextureColorTableComponents() {
        return ((TextureAttributesRetained)this.retained).getNumTextureColorTableComponents();
    }

    public int getTextureColorTableSize() {
        return ((TextureAttributesRetained)this.retained).getTextureColorTableSize();
    }

    public void setCombineRgbMode(int combineMode) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes16"));
        }
        if (combineMode < 0 || combineMode > 6) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes20"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineRgbMode(combineMode);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineRgbMode(combineMode);
        }
    }

    public void setCombineAlphaMode(int combineMode) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes18"));
        }
        if (combineMode < 0 || combineMode > 6) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes20"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineAlphaMode(combineMode);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineAlphaMode(combineMode);
        }
    }

    public int getCombineRgbMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes17"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineRgbMode();
    }

    public int getCombineAlphaMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes19"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineAlphaMode();
    }

    public void setCombineRgbSource(int index, int src) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes21"));
        }
        if (index < 0 || index > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        if (src < 0 || src > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes26"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineRgbSource(index, src);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineRgbSource(index, src);
        }
    }

    public void setCombineAlphaSource(int index, int src) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes23"));
        }
        if (index < 0 || index > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        if (src < 0 || src > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes26"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineAlphaSource(index, src);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineAlphaSource(index, src);
        }
    }

    public int getCombineRgbSource(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes22"));
        }
        if (index < 0 || index > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineRgbSource(index);
    }

    public int getCombineAlphaSource(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes24"));
        }
        if (index < 0 || index > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineAlphaSource(index);
    }

    public void setCombineRgbFunction(int index, int function) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes27"));
        }
        if (index < 0 || index > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        if (function < 0 || function > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes31"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineRgbFunction(index, function);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineRgbFunction(index, function);
        }
    }

    public void setCombineAlphaFunction(int index, int function) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes29"));
        }
        if (index < 0 || index > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        if (function < 2 || function > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes31"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineAlphaFunction(index, function);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineAlphaFunction(index, function);
        }
    }

    public int getCombineRgbFunction(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes28"));
        }
        if (index < 0 || index > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineRgbFunction(index);
    }

    public int getCombineAlphaFunction(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes30"));
        }
        if (index < 0 || index > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineAlphaFunction(index);
    }

    public void setCombineRgbScale(int scale) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes32"));
        }
        if (scale != 1 && scale != 2 && scale != 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes36"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineRgbScale(scale);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineRgbScale(scale);
        }
    }

    public void setCombineAlphaScale(int scale) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes34"));
        }
        if (scale != 1 && scale != 2 && scale != 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes36"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineAlphaScale(scale);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineAlphaScale(scale);
        }
    }

    public int getCombineRgbScale() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes33"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineRgbScale();
    }

    public int getCombineAlphaScale() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes35"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineAlphaScale();
    }

    @Override
    void createRetained() {
        this.retained = new TextureAttributesRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        TextureAttributes ta = new TextureAttributes();
        ta.duplicateNodeComponent(this);
        return ta;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        TextureAttributesRetained attr = (TextureAttributesRetained)originalNodeComponent.retained;
        TextureAttributesRetained rt = (TextureAttributesRetained)this.retained;
        Color4f c2 = new Color4f();
        attr.getTextureBlendColor(c2);
        Transform3D t = new Transform3D();
        attr.getTextureTransform(t);
        rt.initTextureMode(attr.getTextureMode());
        rt.initPerspectiveCorrectionMode(attr.getPerspectiveCorrectionMode());
        rt.initTextureBlendColor(c2);
        rt.initTextureTransform(t);
        if (attr.getNumTextureColorTableComponents() != 0 && attr.getTextureColorTableSize() != 0) {
            int[][] table = new int[attr.getNumTextureColorTableComponents()][attr.getTextureColorTableSize()];
            attr.getTextureColorTable(table);
            rt.initTextureColorTable(table);
        }
        rt.initCombineRgbMode(attr.getCombineRgbMode());
        rt.initCombineAlphaMode(attr.getCombineAlphaMode());
        rt.initCombineRgbScale(attr.getCombineRgbScale());
        rt.initCombineAlphaScale(attr.getCombineAlphaScale());
        if (attr.combineRgbSrc != null) {
            for (int i2 = 0; i2 < 3; ++i2) {
                rt.initCombineRgbSource(i2, attr.getCombineRgbSource(i2));
                rt.initCombineAlphaSource(i2, attr.getCombineAlphaSource(i2));
                rt.initCombineRgbFunction(i2, attr.getCombineRgbFunction(i2));
                rt.initCombineAlphaFunction(i2, attr.getCombineAlphaFunction(i2));
            }
        }
    }
}

