/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.CachedTargets;
import org.jogamp.java3d.NnuId;
import org.jogamp.java3d.NnuIdManager;

class Targets {
    static final int MAX_NODELIST = 7;
    static final int GEO_TARGETS = 0;
    static final int ENV_TARGETS = 1;
    static final int BEH_TARGETS = 2;
    static final int SND_TARGETS = 3;
    static final int VPF_TARGETS = 4;
    static final int BLN_TARGETS = 5;
    static final int GRP_TARGETS = 6;
    ArrayList<NnuId>[] targetList = new ArrayList[7];

    Targets() {
    }

    void addNode(NnuId node, int targetType) {
        if (this.targetList[targetType] == null) {
            this.targetList[targetType] = new ArrayList(1);
        }
        this.targetList[targetType].add(node);
    }

    void removeNode(int index, int targetType) {
        if (this.targetList[targetType] != null) {
            this.targetList[targetType].remove(index);
        }
    }

    void addNodes(ArrayList<NnuId> nodeList, int targetType) {
        if (this.targetList[targetType] == null) {
            this.targetList[targetType] = new ArrayList(1);
        }
        this.targetList[targetType].addAll(nodeList);
    }

    void clearNodes() {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetList[i2] == null) continue;
            this.targetList[i2].clear();
        }
    }

    CachedTargets snapShotInit() {
        CachedTargets cachedTargets = new CachedTargets();
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetList[i2] != null) {
                int size = this.targetList[i2].size();
                NnuId[] nArr = new NnuId[size];
                this.targetList[i2].toArray(nArr);
                cachedTargets.targetArr[i2] = nArr;
                NnuIdManager.sort(cachedTargets.targetArr[i2]);
                continue;
            }
            cachedTargets.targetArr[i2] = null;
        }
        this.clearNodes();
        return cachedTargets;
    }

    CachedTargets snapShotAdd(CachedTargets cachedTargets) {
        CachedTargets newCachedTargets = new CachedTargets();
        for (int i2 = 0; i2 < 7; ++i2) {
            int size;
            if (this.targetList[i2] != null && cachedTargets.targetArr[i2] == null) {
                size = this.targetList[i2].size();
                NnuId[] nArr = new NnuId[size];
                this.targetList[i2].toArray(nArr);
                newCachedTargets.targetArr[i2] = nArr;
                NnuIdManager.sort(newCachedTargets.targetArr[i2]);
                continue;
            }
            if (this.targetList[i2] != null && cachedTargets.targetArr[i2] != null) {
                size = this.targetList[i2].size();
                NnuId[] targetArr = new NnuId[size];
                this.targetList[i2].toArray(targetArr);
                NnuIdManager.sort(targetArr);
                newCachedTargets.targetArr[i2] = NnuIdManager.merge(cachedTargets.targetArr[i2], targetArr);
                continue;
            }
            if (this.targetList[i2] != null || cachedTargets.targetArr[i2] == null) continue;
            newCachedTargets.targetArr[i2] = cachedTargets.targetArr[i2];
        }
        this.clearNodes();
        return newCachedTargets;
    }

    CachedTargets snapShotRemove(CachedTargets cachedTargets) {
        CachedTargets newCachedTargets = new CachedTargets();
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetList[i2] != null && cachedTargets.targetArr[i2] != null) {
                int size = this.targetList[i2].size();
                NnuId[] targetArr = new NnuId[size];
                this.targetList[i2].toArray(targetArr);
                NnuIdManager.sort(targetArr);
                newCachedTargets.targetArr[i2] = NnuIdManager.delete(cachedTargets.targetArr[i2], targetArr);
                continue;
            }
            if (this.targetList[i2] == null && cachedTargets.targetArr[i2] != null) {
                newCachedTargets.targetArr[i2] = cachedTargets.targetArr[i2];
                continue;
            }
            if (this.targetList[i2] == null || cachedTargets.targetArr[i2] != null) continue;
            System.err.println("You can't remove something that isn't there");
        }
        this.clearNodes();
        return newCachedTargets;
    }

    boolean isEmpty() {
        boolean empty = true;
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetList[i2] == null) continue;
            empty = false;
            break;
        }
        return empty;
    }

    void dump() {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetList[i2] == null) continue;
            System.err.println("  " + CachedTargets.typeString[i2]);
            for (int j2 = 0; j2 < this.targetList[i2].size(); ++j2) {
                System.err.println("  " + this.targetList[i2].get(j2));
            }
        }
    }
}

