/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dNotification;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.Shader;
import org.jogamp.java3d.ShaderAttrLoc;
import org.jogamp.java3d.ShaderAttribute;
import org.jogamp.java3d.ShaderAttributeArrayRetained;
import org.jogamp.java3d.ShaderAttributeBindingRetained;
import org.jogamp.java3d.ShaderAttributeRetained;
import org.jogamp.java3d.ShaderAttributeSet;
import org.jogamp.java3d.ShaderAttributeSetRetained;
import org.jogamp.java3d.ShaderAttributeValueRetained;
import org.jogamp.java3d.ShaderError;
import org.jogamp.java3d.ShaderId;
import org.jogamp.java3d.ShaderProgram;
import org.jogamp.java3d.ShaderProgramId;
import org.jogamp.java3d.ShaderRetained;
import org.jogamp.java3d.SourceCodeShaderRetained;
import org.jogamp.java3d.VirtualUniverse;

abstract class ShaderProgramRetained
extends NodeComponentRetained {
    protected ShaderProgramData[] shaderProgramData;
    private boolean unsupportedErrorReported = false;
    private boolean linkErrorOccurred = false;
    protected ShaderRetained[] shaders;
    protected String[] vertexAttrNames;
    protected String[] shaderAttrNames;
    private HashSet<ShaderAttribute> shaderAttrErrorSet = null;
    Object resourceLock = new Object();

    ShaderProgramRetained() {
    }

    void setVertexAttrNames(String[] vertexAttrNames) {
        this.vertexAttrNames = vertexAttrNames == null ? null : (String[])vertexAttrNames.clone();
    }

    String[] getVertexAttrNames() {
        if (this.vertexAttrNames == null) {
            return null;
        }
        return (String[])this.vertexAttrNames.clone();
    }

    void setShaderAttrNames(String[] shaderAttrNames) {
        this.shaderAttrNames = shaderAttrNames == null ? null : (String[])shaderAttrNames.clone();
    }

    String[] getShaderAttrNames() {
        if (this.shaderAttrNames == null) {
            return null;
        }
        return (String[])this.shaderAttrNames.clone();
    }

    void setShaders(Shader[] shaders) {
        if (shaders == null) {
            this.shaders = null;
            return;
        }
        this.shaders = new ShaderRetained[shaders.length];
        for (int i2 = 0; i2 < shaders.length; ++i2) {
            this.shaders[i2] = (ShaderRetained)shaders[i2].retained;
        }
    }

    Shader[] getShaders() {
        if (this.shaders == null) {
            return null;
        }
        Shader[] shads = new Shader[this.shaders.length];
        for (int i2 = 0; i2 < this.shaders.length; ++i2) {
            shads[i2] = this.shaders[i2] != null ? (Shader)this.shaders[i2].source : null;
        }
        return shads;
    }

    abstract ShaderError createShader(Context var1, ShaderRetained var2, ShaderId[] var3);

    abstract ShaderError destroyShader(Context var1, ShaderId var2);

    abstract ShaderError compileShader(Context var1, ShaderId var2, String var3);

    abstract ShaderError createShaderProgram(Context var1, ShaderProgramId[] var2);

    abstract ShaderError destroyShaderProgram(Context var1, ShaderProgramId var2);

    abstract ShaderError linkShaderProgram(Context var1, ShaderProgramId var2, ShaderId[] var3);

    abstract ShaderError bindVertexAttrName(Context var1, ShaderProgramId var2, String var3, int var4);

    abstract void lookupShaderAttrNames(Context var1, ShaderProgramId var2, String[] var3, AttrNameInfo[] var4);

    abstract void lookupVertexAttrNames(Context var1, ShaderProgramId var2, String[] var3, boolean[] var4);

    abstract ShaderError enableShaderProgram(Context var1, ShaderProgramId var2);

    abstract ShaderError disableShaderProgram(Context var1);

    abstract ShaderError setUniform1i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4);

    abstract ShaderError setUniform1f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float var4);

    abstract ShaderError setUniform2i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setUniform2f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setUniform3i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setUniform3f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setUniform4i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setUniform4f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setUniformMatrix3f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setUniformMatrix4f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setUniform1iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setUniform1fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setUniform2iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setUniform2fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setUniform3iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setUniform3fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setUniform4iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setUniform4fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setUniformMatrix3fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setUniformMatrix4fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract boolean isSupported(Canvas3D var1);

    @Override
    void setLive(boolean backgroundGroup, int refCount) {
        if (this.shaders != null) {
            for (int i2 = 0; i2 < this.shaders.length; ++i2) {
                this.shaders[i2].setLive(backgroundGroup, refCount);
            }
        }
        super.doSetLive(backgroundGroup, refCount);
        super.markAsLive();
    }

    @Override
    void clearLive(int refCount) {
        super.clearLive(refCount);
        if (this.shaders != null) {
            for (int i2 = 0; i2 < this.shaders.length; ++i2) {
                this.shaders[i2].clearLive(refCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError enableShaderProgram(Canvas3D cv, int cvRdrIndex) {
        assert (cvRdrIndex >= 0);
        Object object = this.resourceLock;
        synchronized (object) {
            return this.enableShaderProgram(cv.ctx, this.shaderProgramData[cvRdrIndex].getShaderProgramId());
        }
    }

    private ShaderError disableShaderProgram(Canvas3D cv) {
        return this.disableShaderProgram(cv.ctx);
    }

    @Override
    synchronized void initMirrorObject() {
        if (this.shaders == null) {
            ((ShaderProgramRetained)this.mirror).shaders = null;
        } else {
            ((ShaderProgramRetained)this.mirror).shaders = new ShaderRetained[this.shaders.length];
            for (int i2 = 0; i2 < this.shaders.length; ++i2) {
                ((ShaderProgramRetained)this.mirror).shaders[i2] = (ShaderRetained)this.shaders[i2].mirror;
            }
        }
        ((ShaderProgramRetained)this.mirror).shaderProgramData = null;
        ((ShaderProgramRetained)this.mirror).vertexAttrNames = this.vertexAttrNames == null ? null : (String[])this.vertexAttrNames.clone();
        ((ShaderProgramRetained)this.mirror).shaderAttrNames = this.shaderAttrNames == null ? null : (String[])this.shaderAttrNames.clone();
        ((ShaderProgramRetained)this.mirror).shaderAttrErrorSet = null;
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        assert (false);
        System.err.println("ShaderProgramRetained : updateMirrorObject NOT IMPLEMENTED YET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createShaderProgramData(int cvRdrIndex, long ctxTimeStamp) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.shaderProgramData == null) {
                this.shaderProgramData = new ShaderProgramData[cvRdrIndex + 1];
            } else if (this.shaderProgramData.length <= cvRdrIndex) {
                ShaderProgramData[] tempSPData = new ShaderProgramData[cvRdrIndex + 1];
                System.arraycopy(this.shaderProgramData, 0, tempSPData, 0, this.shaderProgramData.length);
                this.shaderProgramData = tempSPData;
            }
            if (this.shaderProgramData[cvRdrIndex] == null) {
                this.shaderProgramData[cvRdrIndex] = new ShaderProgramData();
            } else if (this.shaderProgramData[cvRdrIndex].getCtxTimeStamp() != ctxTimeStamp) {
                this.shaderProgramData[cvRdrIndex].reset();
            }
            this.shaderProgramData[cvRdrIndex].setCtxTimeStamp(ctxTimeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError createShaderProgram(Canvas3D cv, int cvRdrIndex) {
        Object object = this.resourceLock;
        synchronized (object) {
            assert (this.shaderProgramData[cvRdrIndex].getShaderProgramId() == null);
            ShaderProgramId[] spIdArr = new ShaderProgramId[1];
            ShaderError err = this.createShaderProgram(cv.ctx, spIdArr);
            if (err != null) {
                return err;
            }
            this.shaderProgramData[cvRdrIndex].setShaderProgramId(spIdArr[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError linkShaderProgram(Canvas3D cv, int cvRdrIndex, ShaderRetained[] shaders) {
        Object object = this.resourceLock;
        synchronized (object) {
            ShaderId[] shaderIds = new ShaderId[shaders.length];
            for (int i2 = 0; i2 < shaders.length; ++i2) {
                ShaderRetained shaderRetained = shaders[i2];
                synchronized (shaderRetained) {
                    shaderIds[i2] = shaders[i2].shaderData[cvRdrIndex].getShaderId();
                    continue;
                }
            }
            ShaderError err = this.linkShaderProgram(cv.ctx, this.shaderProgramData[cvRdrIndex].getShaderProgramId(), shaderIds);
            if (err != null) {
                return err;
            }
            this.shaderProgramData[cvRdrIndex].setLinked(true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError bindVertexAttrName(Canvas3D cv, int cvRdrIndex, String attrName, int attrIndex) {
        assert (attrName != null);
        Object object = this.resourceLock;
        synchronized (object) {
            ShaderProgramId shaderProgramId = this.shaderProgramData[cvRdrIndex].getShaderProgramId();
            ShaderError err = this.bindVertexAttrName(cv.ctx, shaderProgramId, attrName, attrIndex);
            if (err != null) {
                return err;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupVertexAttrNames(Canvas3D cv, int cvRdrIndex, String[] attrNames) {
        Object object = this.resourceLock;
        synchronized (object) {
            ShaderProgramId shaderProgramId = this.shaderProgramData[cvRdrIndex].getShaderProgramId();
            boolean[] errArr = new boolean[attrNames.length];
            this.lookupVertexAttrNames(cv.ctx, shaderProgramId, attrNames, errArr);
            for (int i2 = 0; i2 < attrNames.length; ++i2) {
                if (!errArr[i2]) continue;
                String errMsg = "Vertex Attribute name lookup failed: " + attrNames[i2];
                ShaderError err = new ShaderError(3, errMsg);
                err.setShaderProgram((ShaderProgram)this.source);
                err.setCanvas3D(cv);
                this.notifyErrorListeners(cv, err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupShaderAttrNames(Canvas3D cv, int cvRdrIndex, String[] attrNames) {
        Object object = this.resourceLock;
        synchronized (object) {
            ShaderProgramId shaderProgramId = this.shaderProgramData[cvRdrIndex].getShaderProgramId();
            AttrNameInfo[] attrNameInfoArr = new AttrNameInfo[attrNames.length];
            this.lookupShaderAttrNames(cv.ctx, shaderProgramId, attrNames, attrNameInfoArr);
            for (int i2 = 0; i2 < attrNames.length; ++i2) {
                this.shaderProgramData[cvRdrIndex].setAttrNameInfo(attrNames[i2], attrNameInfoArr[i2]);
                if (attrNameInfoArr[i2].getLocation() != null) continue;
                String errMsg = "Attribute name lookup failed: " + attrNames[i2];
                ShaderError err = new ShaderError(4, errMsg);
                err.setShaderProgram((ShaderProgram)this.source);
                err.setCanvas3D(cv);
                this.notifyErrorListeners(cv, err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderProgramData getShaderProgramData(int cvRdrIndex) {
        Object object = this.resourceLock;
        synchronized (object) {
            return this.shaderProgramData[cvRdrIndex];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError createShader(Canvas3D cv, int cvRdrIndex, ShaderRetained shader) {
        Object object = shader.resourceLock;
        synchronized (object) {
            if (shader.shaderData[cvRdrIndex].getShaderId() != null) {
                return null;
            }
            ShaderId[] shaderIdArr = new ShaderId[1];
            ShaderError err = this.createShader(cv.ctx, shader, shaderIdArr);
            if (err != null) {
                return err;
            }
            shader.shaderData[cvRdrIndex].setShaderId(shaderIdArr[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError compileShader(Canvas3D cv, int cvRdrIndex, ShaderRetained shader) {
        Object object = shader.resourceLock;
        synchronized (object) {
            if (shader.shaderData[cvRdrIndex].isCompiled()) {
                return null;
            }
            String source = ((SourceCodeShaderRetained)shader).getShaderSource();
            ShaderError err = this.compileShader(cv.ctx, shader.shaderData[cvRdrIndex].getShaderId(), source);
            if (err != null) {
                return err;
            }
            shader.shaderData[cvRdrIndex].setCompiled(true);
        }
        return null;
    }

    void notifyErrorListeners(Canvas3D cv, ShaderError err) {
        J3dNotification notification = new J3dNotification();
        notification.type = 0;
        notification.universe = cv.view.universe;
        notification.args[0] = err;
        VirtualUniverse.mc.sendNotification(notification);
    }

    private boolean verifyShaderProgramSupported(Canvas3D cv) {
        boolean supported = this.isSupported(cv);
        if (!supported && !this.unsupportedErrorReported) {
            String errorMsg = J3dI18N.getString("ShaderProgramRetained0");
            ShaderError err = new ShaderError(7, errorMsg);
            err.setShaderProgram((ShaderProgram)this.source);
            err.setCanvas3D(cv);
            this.notifyErrorListeners(cv, err);
            this.unsupportedErrorReported = true;
        }
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyShader(Canvas3D cv, int cvRdrIndex, ShaderRetained shader) {
        if (!this.verifyShaderProgramSupported(cv)) {
            return;
        }
        Object object = shader.resourceLock;
        synchronized (object) {
            if (shader.shaderData == null || shader.shaderData.length <= cvRdrIndex || shader.shaderData[cvRdrIndex] == null) {
                return;
            }
            if (shader.shaderData[cvRdrIndex].getShaderId() == null) {
                return;
            }
            this.destroyShader(cv.ctx, shader.shaderData[cvRdrIndex].getShaderId());
            shader.shaderData[cvRdrIndex].reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyShaderProgram(Canvas3D cv, int cvRdrIndex) {
        if (!this.verifyShaderProgramSupported(cv)) {
            return;
        }
        Object object = this.resourceLock;
        synchronized (object) {
            assert (this.shaderProgramData != null && this.shaderProgramData.length > cvRdrIndex && this.shaderProgramData[cvRdrIndex] != null);
            ShaderProgramId shaderProgramId = this.shaderProgramData[cvRdrIndex].getShaderProgramId();
            if (shaderProgramId == null) {
                return;
            }
            this.destroyShaderProgram(cv.ctx, shaderProgramId);
            this.shaderProgramData[cvRdrIndex].reset();
        }
    }

    void updateNative(Canvas3D cv, boolean enable) {
        long ctxTimeStamp;
        int cvRdrIndex;
        boolean useSharedCtx;
        boolean bl = useSharedCtx = cv.useSharedCtx && cv.screen.renderer.sharedCtx != null;
        if (useSharedCtx) {
            cvRdrIndex = cv.screen.renderer.rendererId;
            ctxTimeStamp = cv.screen.renderer.sharedCtxTimeStamp;
        } else {
            cvRdrIndex = cv.canvasId;
            ctxTimeStamp = cv.ctxTimeStamp;
        }
        this.createShaderProgramData(cvRdrIndex, ctxTimeStamp);
        if (!this.verifyShaderProgramSupported(cv)) {
            return;
        }
        if (!enable) {
            this.disableShaderProgram(cv);
            return;
        }
        if (this.shaders == null || this.shaders.length == 0 || this.linkErrorOccurred) {
            this.disableShaderProgram(cv);
            return;
        }
        boolean loadShaderProgram = false;
        if (this.getShaderProgramData(cvRdrIndex).getShaderProgramId() == null) {
            loadShaderProgram = true;
        }
        ShaderError err = null;
        boolean errorOccurred = false;
        if (loadShaderProgram) {
            boolean linked;
            if (useSharedCtx) {
                cv.makeCtxCurrent(cv.screen.renderer.sharedCtx);
            }
            for (int i2 = 0; i2 < this.shaders.length; ++i2) {
                this.shaders[i2].createShaderData(cvRdrIndex, ctxTimeStamp);
                if (this.shaders[i2].compileErrorOccurred) {
                    errorOccurred = true;
                    continue;
                }
                err = this.createShader(cv, cvRdrIndex, this.shaders[i2]);
                if (err != null) {
                    err.setShaderProgram((ShaderProgram)this.source);
                    err.setShader((Shader)this.shaders[i2].source);
                    err.setCanvas3D(cv);
                    this.notifyErrorListeners(cv, err);
                    errorOccurred = true;
                    continue;
                }
                err = this.compileShader(cv, cvRdrIndex, this.shaders[i2]);
                if (err == null) continue;
                err.setShaderProgram((ShaderProgram)this.source);
                err.setShader((Shader)this.shaders[i2].source);
                err.setCanvas3D(cv);
                this.notifyErrorListeners(cv, err);
                this.destroyShader(cv, cvRdrIndex, this.shaders[i2]);
                this.shaders[i2].compileErrorOccurred = true;
                errorOccurred = true;
            }
            if (!errorOccurred && (err = this.createShaderProgram(cv, cvRdrIndex)) != null) {
                err.setShaderProgram((ShaderProgram)this.source);
                err.setCanvas3D(cv);
                this.notifyErrorListeners(cv, err);
                errorOccurred = true;
            }
            if (!(linked = this.getShaderProgramData(cvRdrIndex).isLinked())) {
                if (!errorOccurred && this.vertexAttrNames != null) {
                    for (int i3 = 0; i3 < this.vertexAttrNames.length; ++i3) {
                        err = this.bindVertexAttrName(cv, cvRdrIndex, this.vertexAttrNames[i3], i3);
                        if (err == null) continue;
                        err.setShaderProgram((ShaderProgram)this.source);
                        err.setCanvas3D(cv);
                        this.notifyErrorListeners(cv, err);
                    }
                }
                if (!errorOccurred && (err = this.linkShaderProgram(cv, cvRdrIndex, this.shaders)) != null) {
                    err.setShaderProgram((ShaderProgram)this.source);
                    err.setCanvas3D(cv);
                    this.notifyErrorListeners(cv, err);
                    this.destroyShaderProgram(cv, cvRdrIndex);
                    this.linkErrorOccurred = true;
                    errorOccurred = true;
                }
                if (!errorOccurred && this.vertexAttrNames != null) {
                    this.lookupVertexAttrNames(cv, cvRdrIndex, this.vertexAttrNames);
                }
                if (!errorOccurred && this.shaderAttrNames != null) {
                    this.lookupShaderAttrNames(cv, cvRdrIndex, this.shaderAttrNames);
                }
            }
            if (useSharedCtx) {
                cv.makeCtxCurrent(cv.ctx);
            }
            if (errorOccurred) {
                this.disableShaderProgram(cv);
                return;
            }
        }
        this.enableShaderProgram(cv, cvRdrIndex);
    }

    ShaderError setUniformAttrValue(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc loc, ShaderAttributeValueRetained sav) {
        switch (sav.getClassType()) {
            case 0: {
                return this.setUniform1i(ctx, shaderProgramId, loc, ((int[])sav.attrWrapper.getRef())[0]);
            }
            case 1: {
                return this.setUniform1f(ctx, shaderProgramId, loc, ((float[])sav.attrWrapper.getRef())[0]);
            }
            case 2: {
                return this.setUniform2i(ctx, shaderProgramId, loc, (int[])sav.attrWrapper.getRef());
            }
            case 3: {
                return this.setUniform2f(ctx, shaderProgramId, loc, (float[])sav.attrWrapper.getRef());
            }
            case 4: {
                return this.setUniform3i(ctx, shaderProgramId, loc, (int[])sav.attrWrapper.getRef());
            }
            case 5: {
                return this.setUniform3f(ctx, shaderProgramId, loc, (float[])sav.attrWrapper.getRef());
            }
            case 6: {
                return this.setUniform4i(ctx, shaderProgramId, loc, (int[])sav.attrWrapper.getRef());
            }
            case 7: {
                return this.setUniform4f(ctx, shaderProgramId, loc, (float[])sav.attrWrapper.getRef());
            }
            case 8: {
                return this.setUniformMatrix3f(ctx, shaderProgramId, loc, (float[])sav.attrWrapper.getRef());
            }
            case 9: {
                return this.setUniformMatrix4f(ctx, shaderProgramId, loc, (float[])sav.attrWrapper.getRef());
            }
        }
        assert (false) : "Unrecognized ShaderAttributeValue classType";
        return null;
    }

    ShaderError setUniformAttrArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc loc, ShaderAttributeArrayRetained saa) {
        switch (saa.getClassType()) {
            case 0: {
                return this.setUniform1iArray(ctx, shaderProgramId, loc, saa.length(), (int[])saa.attrWrapper.getRef());
            }
            case 1: {
                return this.setUniform1fArray(ctx, shaderProgramId, loc, saa.length(), (float[])saa.attrWrapper.getRef());
            }
            case 2: {
                return this.setUniform2iArray(ctx, shaderProgramId, loc, saa.length(), (int[])saa.attrWrapper.getRef());
            }
            case 3: {
                return this.setUniform2fArray(ctx, shaderProgramId, loc, saa.length(), (float[])saa.attrWrapper.getRef());
            }
            case 4: {
                return this.setUniform3iArray(ctx, shaderProgramId, loc, saa.length(), (int[])saa.attrWrapper.getRef());
            }
            case 5: {
                return this.setUniform3fArray(ctx, shaderProgramId, loc, saa.length(), (float[])saa.attrWrapper.getRef());
            }
            case 6: {
                return this.setUniform4iArray(ctx, shaderProgramId, loc, saa.length(), (int[])saa.attrWrapper.getRef());
            }
            case 7: {
                return this.setUniform4fArray(ctx, shaderProgramId, loc, saa.length(), (float[])saa.attrWrapper.getRef());
            }
            case 8: {
                return this.setUniformMatrix3fArray(ctx, shaderProgramId, loc, saa.length(), (float[])saa.attrWrapper.getRef());
            }
            case 9: {
                return this.setUniformMatrix4fArray(ctx, shaderProgramId, loc, saa.length(), (float[])saa.attrWrapper.getRef());
            }
        }
        assert (false) : "Unrecognized ShaderAttributeArray classType";
        return null;
    }

    void setShaderAttributes(Canvas3D cv, ShaderAttributeSetRetained attributeSet) {
        boolean useSharedCtx = cv.useSharedCtx && cv.screen.renderer.sharedCtx != null;
        int cvRdrIndex = useSharedCtx ? cv.screen.renderer.rendererId : cv.canvasId;
        ShaderProgramData spData = this.getShaderProgramData(cvRdrIndex);
        if (!spData.isLinked()) {
            return;
        }
        ShaderProgramId shaderProgramId = spData.getShaderProgramId();
        List<ShaderAttributeRetained> attributes = attributeSet.getAttrValues();
        for (int i2 = 0; i2 < attributes.size(); ++i2) {
            ShaderAttributeRetained saRetained = attributes.get(i2);
            ShaderError err = null;
            AttrNameInfo attrNameInfo = spData.getAttrNameInfo(saRetained.getAttributeName());
            if (attrNameInfo == null) {
                String errMsg = "Attribute name not set in ShaderProgram: " + saRetained.getAttributeName();
                err = new ShaderError(5, errMsg);
            } else {
                ShaderAttrLoc loc = attrNameInfo.getLocation();
                if (loc != null) {
                    String errMsg;
                    if (saRetained instanceof ShaderAttributeValueRetained) {
                        ShaderAttributeValueRetained savRetained = (ShaderAttributeValueRetained)saRetained;
                        if (attrNameInfo.getType() != -1) {
                            if (attrNameInfo.isArray() || savRetained.getClassType() != attrNameInfo.getType()) {
                                errMsg = "Attribute type mismatch: " + savRetained.getAttributeName() + " attrNameInfo.isArray() " + attrNameInfo.isArray() + " " + savRetained.getClassType() + " != " + attrNameInfo.getType();
                                err = new ShaderError(6, errMsg);
                            } else {
                                err = this.setUniformAttrValue(cv.ctx, shaderProgramId, loc, savRetained);
                            }
                        } else if (!attrNameInfo.compiledAwayWarningGiven) {
                            System.out.println("" + this.source + " Attr: " + savRetained.getAttributeName() + " compiled away");
                            attrNameInfo.compiledAwayWarningGiven = true;
                        }
                    } else if (saRetained instanceof ShaderAttributeArrayRetained) {
                        ShaderAttributeArrayRetained saaRetained = (ShaderAttributeArrayRetained)saRetained;
                        if (attrNameInfo.getType() != -1) {
                            if (!attrNameInfo.isArray() || saaRetained.getClassType() != attrNameInfo.getType()) {
                                errMsg = "Attribute type mismatch: " + saaRetained.getAttributeName() + " attrNameInfo.isArray() " + attrNameInfo.isArray() + " " + saaRetained.getClassType() + " != " + attrNameInfo.getType();
                                err = new ShaderError(6, errMsg);
                            } else {
                                err = this.setUniformAttrArray(cv.ctx, shaderProgramId, loc, saaRetained);
                            }
                        } else if (!attrNameInfo.compiledAwayWarningGiven) {
                            System.out.println("" + this.source + " Attr: " + saaRetained.getAttributeName() + " compiled away");
                            attrNameInfo.compiledAwayWarningGiven = true;
                        }
                    } else {
                        if (saRetained instanceof ShaderAttributeBindingRetained) {
                            assert (false);
                            throw new RuntimeException("not implemented");
                        }
                        assert (false);
                    }
                }
            }
            if (err == null) continue;
            if (this.shaderAttrErrorSet == null) {
                this.shaderAttrErrorSet = new HashSet();
            }
            if (!this.shaderAttrErrorSet.add((ShaderAttribute)saRetained.source)) continue;
            err.setShaderProgram((ShaderProgram)this.source);
            err.setShaderAttributeSet((ShaderAttributeSet)attributeSet.source);
            err.setShaderAttribute((ShaderAttribute)saRetained.source);
            err.setCanvas3D(cv);
            this.notifyErrorListeners(cv, err);
        }
    }

    class AttrNameInfo {
        private ShaderAttrLoc loc;
        private boolean isArray;
        private int type;
        public boolean compiledAwayWarningGiven = false;

        AttrNameInfo() {
        }

        void setLocation(ShaderAttrLoc loc) {
            this.loc = loc;
        }

        ShaderAttrLoc getLocation() {
            return this.loc;
        }

        void setType(int type) {
            this.type = type;
        }

        int getType() {
            return this.type;
        }

        boolean isArray() {
            return this.isArray;
        }

        void setArray(boolean isArray) {
            this.isArray = isArray;
        }
    }

    class ShaderProgramData {
        private long ctxTimeStamp;
        private ShaderProgramId shaderProgramId = null;
        private boolean linked = false;
        private HashMap<String, AttrNameInfo> attrNameInfoMap = new HashMap();

        ShaderProgramData() {
        }

        void reset() {
            this.ctxTimeStamp = 0L;
            this.shaderProgramId = null;
            this.linked = false;
            this.attrNameInfoMap.clear();
        }

        long getCtxTimeStamp() {
            return this.ctxTimeStamp;
        }

        void setCtxTimeStamp(long ctxTimeStamp) {
            this.ctxTimeStamp = ctxTimeStamp;
        }

        void setShaderProgramId(ShaderProgramId shaderProgramId) {
            this.shaderProgramId = shaderProgramId;
        }

        ShaderProgramId getShaderProgramId() {
            return this.shaderProgramId;
        }

        void setLinked(boolean linked) {
            this.linked = linked;
        }

        boolean isLinked() {
            return this.linked;
        }

        void setAttrNameInfo(String shaderAttribute, AttrNameInfo attrNameInfo) {
            assert (shaderAttribute != null);
            this.attrNameInfoMap.put(shaderAttribute, attrNameInfo);
        }

        AttrNameInfo getAttrNameInfo(String shaderAttribute) {
            return this.attrNameInfoMap.get(shaderAttribute);
        }
    }
}

