/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import org.jogamp.java3d.BadTransformException;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.Renderer;
import org.jogamp.java3d.ScreenViewCache;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.VirtualUniverse;

public class Screen3D {
    private static final boolean debug = false;
    private static final double METERS_PER_PIXEL = 2.8222222222222223E-4;
    GraphicsDevice graphicsDevice;
    boolean offScreen;
    int screen;
    double physicalScreenWidth;
    double physicalScreenHeight;
    Dimension screenSize = new Dimension(0, 0);
    Transform3D trackerBaseToImagePlate = new Transform3D();
    Transform3D headTrackerToLeftImagePlate = new Transform3D();
    Transform3D headTrackerToRightImagePlate = new Transform3D();
    static final int PHYSICAL_SCREEN_SIZE_DIRTY = 1;
    static final int SCREEN_SIZE_DIRTY_DIRTY = 2;
    static final int TRACKER_BASE_TO_IMAGE_PLATE_DIRTY = 4;
    static final int HEAD_TRACKER_TO_IMAGE_PLATE_DIRTY = 8;
    int scrDirtyMask = 15;
    ScreenViewCache screenViewCache = null;
    Renderer renderer = null;
    static Hashtable<GraphicsDevice, Renderer> deviceRendererMap = new Hashtable();
    int canvasCount = 0;
    private final ArrayList<Canvas3D> users = new ArrayList();

    synchronized void removeUser(Canvas3D c2) {
        this.users.remove(c2);
    }

    synchronized void addUser(Canvas3D c2) {
        if (!this.users.contains(c2)) {
            this.users.add(c2);
        }
    }

    synchronized void notifyUsers() {
        for (int i2 = 0; i2 < this.users.size(); ++i2) {
            this.users.get(i2).redraw();
        }
    }

    public Dimension getSize() {
        return new Dimension(this.screenSize);
    }

    public Dimension getSize(Dimension rv) {
        if (rv == null) {
            return new Dimension(this.screenSize);
        }
        rv.setSize(this.screenSize);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int width, int height) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Screen3D1"));
        }
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.screenSize.width = width;
            this.screenSize.height = height;
            this.scrDirtyMask |= 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(Dimension d2) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Screen3D1"));
        }
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.screenSize.width = d2.width;
            this.screenSize.height = d2.height;
            this.scrDirtyMask |= 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalScreenWidth(double width) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.physicalScreenWidth = width;
            this.scrDirtyMask |= 1;
        }
        this.notifyUsers();
    }

    public double getPhysicalScreenWidth() {
        return this.physicalScreenWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalScreenHeight(double height) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.physicalScreenHeight = height;
            this.scrDirtyMask |= 1;
        }
        this.notifyUsers();
    }

    public double getPhysicalScreenHeight() {
        return this.physicalScreenHeight;
    }

    public String toString() {
        return "Screen3D: size = (" + this.getSize().width + " x " + this.getSize().height + ")" + ", physical size = " + "(" + this.getPhysicalScreenWidth() + "m x " + this.getPhysicalScreenHeight() + "m)";
    }

    Screen3D(GraphicsConfiguration graphicsConfiguration, boolean offScreen) {
        this.offScreen = offScreen;
        this.graphicsDevice = graphicsConfiguration.getDevice();
        this.screenViewCache = new ScreenViewCache(this);
        this.screen = Pipeline.getPipeline().getScreen(this.graphicsDevice);
        if (!offScreen) {
            Rectangle bounds = graphicsConfiguration.getBounds();
            this.screenSize.width = bounds.width;
            this.screenSize.height = bounds.height;
        }
        this.physicalScreenWidth = (double)this.screenSize.width * 2.8222222222222223E-4;
        this.physicalScreenHeight = (double)this.screenSize.height * 2.8222222222222223E-4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackerBaseToImagePlate(Transform3D t) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            if (!t.isRigid()) {
                throw new BadTransformException(J3dI18N.getString("Screen3D0"));
            }
            this.trackerBaseToImagePlate.setWithLock(t);
            this.scrDirtyMask |= 4;
        }
        this.notifyUsers();
    }

    public void getTrackerBaseToImagePlate(Transform3D t) {
        t.set(this.trackerBaseToImagePlate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeadTrackerToLeftImagePlate(Transform3D t) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            if (!t.isRigid()) {
                throw new BadTransformException(J3dI18N.getString("Screen3D0"));
            }
            this.headTrackerToLeftImagePlate.setWithLock(t);
            this.scrDirtyMask |= 8;
        }
        this.notifyUsers();
    }

    public void getHeadTrackerToLeftImagePlate(Transform3D t) {
        t.set(this.headTrackerToLeftImagePlate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeadTrackerToRightImagePlate(Transform3D t) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            if (!t.isRigid()) {
                throw new BadTransformException(J3dI18N.getString("Screen3D0"));
            }
            this.headTrackerToRightImagePlate.setWithLock(t);
            this.scrDirtyMask |= 8;
        }
        this.notifyUsers();
    }

    public void getHeadTrackerToRightImagePlate(Transform3D t) {
        t.set(this.headTrackerToRightImagePlate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateViewCache() {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.screenViewCache.snapshot();
        }
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

