/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingPolytope;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickCone;
import org.jogamp.java3d.PickCylinder;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

class QuadArrayRetained
extends GeometryArrayRetained {
    QuadArrayRetained() {
        this.geoType = 1;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Point3d[] pnts = new Point3d[4];
        double[] sdist = new double[1];
        double minDist = Double.MAX_VALUE;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int[] vtxIndexArr = new int[4];
        int i2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        pnts[2] = new Point3d();
        pnts[3] = new Point3d();
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (i2 < this.validVertexCount) {
                    for (int j2 = 0; j2 < 4; ++j2) {
                        vtxIndexArr[j2] = i2;
                        this.getVertexData(i2++, pnts[j2]);
                    }
                    if (!this.intersectRay(pnts, pickRay, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                while (i2 < this.validVertexCount) {
                    for (int j3 = 0; j3 < 4; ++j3) {
                        vtxIndexArr[j3] = i2;
                        this.getVertexData(i2++, pnts[j3]);
                    }
                    if (!this.intersectSegment(pnts, pickSegment.start, pickSegment.end, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 6: {
                BoundingBox bbox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (i2 < this.validVertexCount) {
                    for (int j4 = 0; j4 < 4; ++j4) {
                        vtxIndexArr[j4] = i2;
                        this.getVertexData(i2++, pnts[j4]);
                    }
                    if (!this.intersectBoundingBox(pnts, bbox, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (i2 < this.validVertexCount) {
                    for (int j5 = 0; j5 < 4; ++j5) {
                        vtxIndexArr[j5] = i2;
                        this.getVertexData(i2++, pnts[j5]);
                    }
                    if (!this.intersectBoundingSphere(pnts, bsphere, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (i2 < this.validVertexCount) {
                    for (int j6 = 0; j6 < 4; ++j6) {
                        vtxIndexArr[j6] = i2;
                        this.getVertexData(i2++, pnts[j6]);
                    }
                    if (!this.intersectBoundingPolytope(pnts, bpolytope, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (i2 < this.validVertexCount) {
                    for (int j7 = 0; j7 < 4; ++j7) {
                        vtxIndexArr[j7] = i2;
                        this.getVertexData(i2++, pnts[j7]);
                    }
                    if (!this.intersectCylinder(pnts, pickCylinder, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (i2 < this.validVertexCount) {
                    for (int j8 = 0; j8 < 4; ++j8) {
                        vtxIndexArr[j8] = i2;
                        this.getVertexData(i2++, pnts[j8]);
                    }
                    if (!this.intersectCone(pnts, pickCone, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("QuadArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection ");
            }
        }
        if (minDist < Double.MAX_VALUE) {
            iPnt.x = x;
            iPnt.y = y;
            iPnt.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Point3d[] points = new Point3d[4];
        double[] dist = new double[1];
        int i2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        points[0] = new Point3d();
        points[1] = new Point3d();
        points[2] = new Point3d();
        points[3] = new Point3d();
        switch (pnts.length) {
            case 3: {
                while (i2 < this.validVertexCount) {
                    this.getVertexData(i2++, points[0]);
                    this.getVertexData(i2++, points[1]);
                    this.getVertexData(i2++, points[2]);
                    this.getVertexData(i2++, points[3]);
                    if (!this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[1], pnts[2]) && !this.intersectTriTri(points[0], points[2], points[3], pnts[0], pnts[1], pnts[2])) continue;
                    return true;
                }
                break;
            }
            case 4: {
                while (i2 < this.validVertexCount) {
                    this.getVertexData(i2++, points[0]);
                    this.getVertexData(i2++, points[1]);
                    this.getVertexData(i2++, points[2]);
                    this.getVertexData(i2++, points[3]);
                    if (!this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[1], pnts[2]) && !this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[2], pnts[3]) && !this.intersectTriTri(points[0], points[2], points[3], pnts[0], pnts[1], pnts[2]) && !this.intersectTriTri(points[0], points[2], points[3], pnts[0], pnts[2], pnts[3])) continue;
                    return true;
                }
                break;
            }
            case 2: {
                while (i2 < this.validVertexCount) {
                    this.getVertexData(i2++, points[0]);
                    this.getVertexData(i2++, points[1]);
                    this.getVertexData(i2++, points[2]);
                    this.getVertexData(i2++, points[3]);
                    if (!this.intersectSegment(points, pnts[0], pnts[1], dist, null)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                while (i2 < this.validVertexCount) {
                    this.getVertexData(i2++, points[0]);
                    this.getVertexData(i2++, points[1]);
                    this.getVertexData(i2++, points[2]);
                    this.getVertexData(i2++, points[3]);
                    if (!this.intersectTriPnt(points[0], points[1], points[2], pnts[0]) && !this.intersectTriPnt(points[0], points[2], points[3], pnts[0])) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        Point3d[] points = new Point3d[4];
        int i2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        points[0] = new Point3d();
        points[1] = new Point3d();
        points[2] = new Point3d();
        points[3] = new Point3d();
        while (i2 < this.validVertexCount) {
            this.getVertexData(i2++, points[0]);
            this.getVertexData(i2++, points[1]);
            this.getVertexData(i2++, points[2]);
            this.getVertexData(i2++, points[3]);
            thisToOtherVworld.transform(points[0]);
            thisToOtherVworld.transform(points[1]);
            thisToOtherVworld.transform(points[2]);
            thisToOtherVworld.transform(points[3]);
            if (!geom.intersect(points)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        Point3d[] points = new Point3d[4];
        int i2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        points[0] = new Point3d();
        points[1] = new Point3d();
        points[2] = new Point3d();
        points[3] = new Point3d();
        switch (targetBound.getPickType()) {
            case 6: {
                BoundingBox box = (BoundingBox)targetBound;
                while (i2 < this.validVertexCount) {
                    this.getVertexData(i2++, points[0]);
                    this.getVertexData(i2++, points[1]);
                    this.getVertexData(i2++, points[2]);
                    this.getVertexData(i2++, points[3]);
                    if (!this.intersectBoundingBox(points, box, null, null)) continue;
                    return true;
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)targetBound;
                while (i2 < this.validVertexCount) {
                    this.getVertexData(i2++, points[0]);
                    this.getVertexData(i2++, points[1]);
                    this.getVertexData(i2++, points[2]);
                    this.getVertexData(i2++, points[3]);
                    if (!this.intersectBoundingSphere(points, bsphere, null, null)) continue;
                    return true;
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)targetBound;
                while (i2 < this.validVertexCount) {
                    this.getVertexData(i2++, points[0]);
                    this.getVertexData(i2++, points[1]);
                    this.getVertexData(i2++, points[2]);
                    this.getVertexData(i2++, points[3]);
                    if (!this.intersectBoundingPolytope(points, bpolytope, null, null)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + targetBound);
            }
        }
        return false;
    }

    @Override
    void computeCentroid() {
        double area;
        int i2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        Point3d pnt0 = new Point3d();
        Point3d pnt1 = new Point3d();
        Point3d pnt2 = new Point3d();
        Point3d pnt3 = new Point3d();
        Vector3d vec = new Vector3d();
        Vector3d normal = new Vector3d();
        Vector3d tmpvec = new Vector3d();
        double totalarea = 0.0;
        this.centroid.x = 0.0;
        this.centroid.y = 0.0;
        this.centroid.z = 0.0;
        while (i2 < this.validVertexCount) {
            this.getVertexData(i2++, pnt0);
            this.getVertexData(i2++, pnt1);
            this.getVertexData(i2++, pnt2);
            this.getVertexData(i2++, pnt3);
            tmpvec.sub(pnt0, pnt1);
            vec.sub(pnt1, pnt2);
            normal.cross(tmpvec, vec);
            normal.normalize();
            if (Double.isNaN(normal.x + normal.y + normal.z)) continue;
            tmpvec.set(0.0, 0.0, 0.0);
            this.getCrossValue(pnt0, pnt1, tmpvec);
            this.getCrossValue(pnt1, pnt2, tmpvec);
            this.getCrossValue(pnt2, pnt0, tmpvec);
            area = normal.dot(tmpvec);
            totalarea += area;
            this.centroid.x += (pnt0.x + pnt1.x + pnt2.x) * area;
            this.centroid.y += (pnt0.y + pnt1.y + pnt2.y) * area;
            this.centroid.z += (pnt0.z + pnt1.z + pnt2.z) * area;
            tmpvec.set(0.0, 0.0, 0.0);
            this.getCrossValue(pnt0, pnt2, tmpvec);
            this.getCrossValue(pnt2, pnt3, tmpvec);
            this.getCrossValue(pnt3, pnt0, tmpvec);
            area = normal.dot(tmpvec);
            totalarea += area;
            this.centroid.x += (pnt3.x + pnt0.x + pnt2.x) * area;
            this.centroid.y += (pnt3.y + pnt0.y + pnt2.y) * area;
            this.centroid.z += (pnt3.z + pnt0.z + pnt2.z) * area;
        }
        if (totalarea != 0.0) {
            area = 1.0 / (3.0 * totalarea);
            this.centroid.x *= area;
            this.centroid.y *= area;
            this.centroid.z *= area;
        }
    }

    @Override
    int getClassType() {
        return 4;
    }
}

