/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Vector;
import org.jogamp.java3d.BranchGroupRetained;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.CompressedGeometry;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.Morph;
import org.jogamp.java3d.MorphRetained;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Shape3DCompileRetained;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.SharedGroupRetained;
import org.jogamp.java3d.Text3DRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point4d;

public class PickInfo {
    static final int PICK_ALL = 1;
    static final int PICK_ANY = 2;
    private SceneGraphPath sgp;
    private Node node;
    private Transform3D l2vw;
    private Point3d closestIntersectionPoint;
    private double closestDistance;
    private IntersectionInfo[] intersectionInfoArr;
    private ArrayList<IntersectionInfo> intersectionInfoList = new ArrayList();
    private boolean intersectionInfoListSorted = false;
    private Transform3D l2vwRef;
    private Node nodeRef;
    public static final int PICK_BOUNDS = 1;
    public static final int PICK_GEOMETRY = 2;
    public static final int SCENEGRAPHPATH = 1;
    public static final int NODE = 2;
    public static final int LOCAL_TO_VWORLD = 4;
    public static final int CLOSEST_INTERSECTION_POINT = 8;
    public static final int CLOSEST_DISTANCE = 16;
    public static final int CLOSEST_GEOM_INFO = 32;
    public static final int ALL_GEOM_INFO = 64;

    PickInfo() {
    }

    void setSceneGraphPath(SceneGraphPath sgp) {
        this.sgp = sgp;
    }

    void setNode(Node node) {
        this.node = node;
    }

    void setLocalToVWorld(Transform3D l2vw) {
        this.l2vw = l2vw;
    }

    void setClosestIntersectionPoint(Point3d cIPt) {
        this.closestIntersectionPoint = cIPt;
    }

    void setClosestDistance(double cDist) {
        this.closestDistance = cDist;
    }

    void setLocalToVWorldRef(Transform3D l2vwRef) {
        this.l2vwRef = l2vwRef;
    }

    void setNodeRef(Node nodeRef) {
        this.nodeRef = nodeRef;
    }

    IntersectionInfo createIntersectionInfo() {
        return new IntersectionInfo();
    }

    void insertIntersectionInfo(IntersectionInfo iInfo) {
        this.intersectionInfoList.add(iInfo);
        this.intersectionInfoListSorted = false;
    }

    void sortIntersectionInfoArray(IntersectionInfo[] iInfoArr) {
        class Sort {
            IntersectionInfo[] iInfoArr;

            Sort(IntersectionInfo[] iInfoArr) {
                this.iInfoArr = iInfoArr;
            }

            void sorting() {
                if (this.iInfoArr.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.iInfoArr.length - 1);
                }
            }

            final void insertSort() {
                for (int i2 = 0; i2 < this.iInfoArr.length; ++i2) {
                    for (int j2 = i2; j2 > 0 && this.iInfoArr[j2 - 1].distance > this.iInfoArr[j2].distance; --j2) {
                        IntersectionInfo iInfo = this.iInfoArr[j2];
                        this.iInfoArr[j2] = this.iInfoArr[j2 - 1];
                        this.iInfoArr[j2 - 1] = iInfo;
                    }
                }
            }

            final void quicksort(int l2, int r) {
                int i2 = l2;
                int j2 = r;
                double k2 = this.iInfoArr[(l2 + r) / 2].distance;
                while (true) {
                    if (this.iInfoArr[i2].distance < k2) {
                        ++i2;
                        continue;
                    }
                    while (k2 < this.iInfoArr[j2].distance) {
                        --j2;
                    }
                    if (i2 <= j2) {
                        IntersectionInfo iInfo = this.iInfoArr[i2];
                        this.iInfoArr[i2] = this.iInfoArr[j2];
                        this.iInfoArr[j2] = iInfo;
                        ++i2;
                        --j2;
                    }
                    if (i2 > j2) break;
                }
                if (l2 < j2) {
                    this.quicksort(l2, j2);
                }
                if (l2 < r) {
                    this.quicksort(i2, r);
                }
            }
        }
        new Sort(iInfoArr).sorting();
        this.intersectionInfoListSorted = true;
    }

    static void sortPickInfoArray(PickInfo[] pickInfoArr) {
        class Sort {
            PickInfo[] pIArr;

            Sort(PickInfo[] pIArr) {
                this.pIArr = pIArr;
            }

            void sorting() {
                if (this.pIArr.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.pIArr.length - 1);
                }
            }

            final void insertSort() {
                for (int i2 = 0; i2 < this.pIArr.length; ++i2) {
                    for (int j2 = i2; j2 > 0 && this.pIArr[j2 - 1].closestDistance > this.pIArr[j2].closestDistance; --j2) {
                        PickInfo pI = this.pIArr[j2];
                        this.pIArr[j2] = this.pIArr[j2 - 1];
                        this.pIArr[j2 - 1] = pI;
                    }
                }
            }

            final void quicksort(int l2, int r) {
                int i2 = l2;
                int j2 = r;
                double k2 = this.pIArr[(l2 + r) / 2].closestDistance;
                while (true) {
                    if (this.pIArr[i2].closestDistance < k2) {
                        ++i2;
                        continue;
                    }
                    while (k2 < this.pIArr[j2].closestDistance) {
                        --j2;
                    }
                    if (i2 <= j2) {
                        PickInfo pI = this.pIArr[i2];
                        this.pIArr[i2] = this.pIArr[j2];
                        this.pIArr[j2] = pI;
                        ++i2;
                        --j2;
                    }
                    if (i2 > j2) break;
                }
                if (l2 < j2) {
                    this.quicksort(l2, j2);
                }
                if (l2 < r) {
                    this.quicksort(i2, r);
                }
            }
        }
        new Sort(pickInfoArr).sorting();
    }

    public SceneGraphPath getSceneGraphPath() {
        return this.sgp;
    }

    public Node getNode() {
        return this.node;
    }

    public Transform3D getLocalToVWorld() {
        return this.l2vw;
    }

    public Point3d getClosestIntersectionPoint() {
        return this.closestIntersectionPoint;
    }

    public double getClosestDistance() {
        return this.closestDistance;
    }

    Transform3D getLocalToVWorldRef() {
        return this.l2vwRef;
    }

    Node getNodeRef() {
        return this.nodeRef;
    }

    public IntersectionInfo[] getIntersectionInfos() {
        if (!this.intersectionInfoListSorted) {
            this.intersectionInfoArr = new IntersectionInfo[this.intersectionInfoList.size()];
            this.intersectionInfoArr = this.intersectionInfoList.toArray(this.intersectionInfoArr);
            this.sortIntersectionInfoArray(this.intersectionInfoArr);
        }
        return this.intersectionInfoArr;
    }

    static ArrayList<NodeRetained> initSceneGraphPath(NodeRetained nodeR) {
        ArrayList<NodeRetained> path = new ArrayList<NodeRetained>(5);
        do {
            if (!nodeR.source.getCapability(1)) continue;
            path.add(nodeR);
        } while ((nodeR = nodeR.parent) != null);
        return path;
    }

    private static Node[] createPath(NodeRetained srcNode, BranchGroupRetained bgRetained, GeometryAtom geomAtom, ArrayList<NodeRetained> initpath) {
        ArrayList<NodeRetained> path = PickInfo.retrievePath(srcNode, bgRetained, geomAtom.source.key);
        assert (path != null);
        return PickInfo.mergePath(path, initpath);
    }

    private static boolean inside(BranchGroupRetained[] bgArr, BranchGroupRetained bg) {
        if (bg == null || bgArr == null) {
            return true;
        }
        for (int i2 = 0; i2 < bgArr.length; ++i2) {
            if (bgArr[i2] != bg) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<NodeRetained> retrievePath(NodeRetained startNode, NodeRetained endNode, HashKey key) {
        ArrayList<NodeRetained> path = new ArrayList<NodeRetained>(5);
        NodeRetained nodeR = startNode;
        if (nodeR.inSharedGroup) {
            key = new HashKey(key);
        }
        do {
            if (nodeR == endNode) {
                return path;
            }
            if (nodeR.source.getCapability(1)) {
                path.add(nodeR);
            }
            if (!(nodeR instanceof SharedGroupRetained)) continue;
            String nodeId = key.getLastNodeId();
            Vector<NodeRetained> parents = ((SharedGroupRetained)nodeR).parents;
            int sz = parents.size();
            NodeRetained prevNodeR = nodeR;
            for (int i2 = 0; i2 < sz; ++i2) {
                NodeRetained linkR = parents.get(i2);
                if (!linkR.nodeId.equals(nodeId)) continue;
                nodeR = linkR;
                path.add(nodeR);
                break;
            }
            if (nodeR != prevNodeR) continue;
            return null;
        } while ((nodeR = nodeR.parent) != null);
        if (endNode == null) {
            return path;
        }
        return null;
    }

    private static Node[] mergePath(ArrayList<NodeRetained> p1, ArrayList<NodeRetained> p2) {
        int i2;
        int s = p1.size();
        int len = p2 == null ? s : s + p2.size();
        Node[] nodes = new Node[len];
        int l2 = len - 1;
        for (i2 = 0; i2 < s; ++i2) {
            nodes[l2 - i2] = (Node)p1.get((int)i2).source;
        }
        int j2 = 0;
        while (i2 < len) {
            nodes[l2 - i2] = (Node)p2.get((int)j2).source;
            ++i2;
            ++j2;
        }
        return nodes;
    }

    static void sortGeomAtoms(GeometryAtom[] geomAtoms, PickShape shape) {
        double[] distance = new double[geomAtoms.length];
        Point4d pickPos = new Point4d();
        for (int i2 = 0; i2 < geomAtoms.length; ++i2) {
            shape.intersect(geomAtoms[i2].source.vwcBounds, pickPos);
            distance[i2] = pickPos.w;
        }
        class Sort {
            GeometryAtom[] atoms;
            final /* synthetic */ double[] val$distance;

            Sort(GeometryAtom[] geometryAtomArray) {
                this.val$distance = (double[])geometryAtomArray;
                this.atoms = atoms;
            }

            void sorting() {
                if (this.atoms.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.atoms.length - 1);
                }
            }

            final void insertSort() {
                for (int i2 = 0; i2 < this.atoms.length; ++i2) {
                    for (int j2 = i2; j2 > 0 && this.val$distance[j2 - 1] > this.val$distance[j2]; --j2) {
                        double t = this.val$distance[j2];
                        this.val$distance[j2] = this.val$distance[j2 - 1];
                        this.val$distance[j2 - 1] = t;
                        GeometryAtom p = this.atoms[j2];
                        this.atoms[j2] = this.atoms[j2 - 1];
                        this.atoms[j2 - 1] = p;
                    }
                }
            }

            final void quicksort(int l2, int r) {
                int i2 = l2;
                int j2 = r;
                double k2 = this.val$distance[(l2 + r) / 2];
                while (true) {
                    if (this.val$distance[i2] < k2) {
                        ++i2;
                        continue;
                    }
                    while (k2 < this.val$distance[j2]) {
                        --j2;
                    }
                    if (i2 <= j2) {
                        double tmp = this.val$distance[i2];
                        this.val$distance[i2] = this.val$distance[j2];
                        this.val$distance[j2] = tmp;
                        GeometryAtom p = this.atoms[i2];
                        this.atoms[i2] = this.atoms[j2];
                        this.atoms[j2] = p;
                        ++i2;
                        --j2;
                    }
                    if (i2 > j2) break;
                }
                if (l2 < j2) {
                    this.quicksort(l2, j2);
                }
                if (l2 < r) {
                    this.quicksort(i2, r);
                }
            }
        }
        new Sort(geomAtoms, distance).sorting();
    }

    static ArrayList<PickInfo> getPickInfos(ArrayList<NodeRetained> initpath, BranchGroupRetained bgRetained, GeometryAtom[] geomAtoms, Locale locale, int flags, int pickType) {
        ArrayList<PickInfo> pickInfoList = new ArrayList<PickInfo>(5);
        ArrayList<NodeRetained> text3dList = null;
        if (geomAtoms == null || geomAtoms.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < geomAtoms.length; ++i2) {
            Transform3D l2vw;
            assert (geomAtoms[i2] != null && geomAtoms[i2].source != null);
            PickInfo pickInfo = null;
            Shape3DRetained shape = geomAtoms[i2].source;
            NodeRetained srcNode = shape.sourceNode;
            if (!PickInfo.inside(shape.branchGroupPath, bgRetained) || srcNode == null) continue;
            if (srcNode instanceof Shape3DRetained) {
                Shape3DRetained s3dR = (Shape3DRetained)srcNode;
                GeometryRetained geomR = null;
                for (int cnt = 0; cnt < s3dR.geometryList.size() && (geomR = s3dR.geometryList.get(cnt)) == null; ++cnt) {
                }
                if (geomR == null) continue;
                if (geomR instanceof Text3DRetained) {
                    if (text3dList == null) {
                        text3dList = new ArrayList<NodeRetained>(3);
                    } else {
                        int size = text3dList.size();
                        boolean found = false;
                        for (int j2 = 0; j2 < size; ++j2) {
                            if (text3dList.get(j2) != srcNode) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                    }
                    text3dList.add(srcNode);
                }
            }
            if (srcNode instanceof Shape3DCompileRetained) {
                Shape3DCompileRetained s3dCR = (Shape3DCompileRetained)srcNode;
                Node[] mpath = null;
                boolean first = true;
                for (int n2 = 0; n2 < s3dCR.srcList.length; ++n2) {
                    pickInfo = null;
                    if ((flags & 1) != 0) {
                        if (first) {
                            mpath = PickInfo.createPath(srcNode, bgRetained, geomAtoms[i2], initpath);
                            first = false;
                        }
                        if (mpath != null) {
                            SceneGraphPath sgpath = new SceneGraphPath(locale, mpath, (Node)s3dCR.srcList[n2]);
                            sgpath.setTransform(shape.getCurrentLocalToVworld(0));
                            if (pickInfo == null) {
                                pickInfo = new PickInfo();
                            }
                            pickInfo.setSceneGraphPath(sgpath);
                        }
                    }
                    if ((flags & 2) != 0) {
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setNode((Node)s3dCR.srcList[n2]);
                    }
                    if ((flags & 4) != 0) {
                        Transform3D l2vw2 = geomAtoms[i2].source.getCurrentLocalToVworld();
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setLocalToVWorld(new Transform3D(l2vw2));
                    }
                    if ((flags & 0x10) != 0 || (flags & 0x20) != 0 || (flags & 8) != 0 || (flags & 0x40) != 0) {
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setNodeRef((Node)s3dCR.srcList[n2]);
                        Transform3D l2vw3 = geomAtoms[i2].source.getCurrentLocalToVworld();
                        pickInfo.setLocalToVWorldRef(l2vw3);
                    }
                    if (pickInfo != null) {
                        pickInfoList.add(pickInfo);
                    }
                    if (pickType != 2) continue;
                    return pickInfoList;
                }
                continue;
            }
            Node[] mpath = null;
            if ((flags & 1) != 0 && (mpath = PickInfo.createPath(srcNode, bgRetained, geomAtoms[i2], initpath)) != null) {
                SceneGraphPath sgpath = new SceneGraphPath(locale, mpath, (Node)srcNode.source);
                sgpath.setTransform(shape.getCurrentLocalToVworld(0));
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setSceneGraphPath(sgpath);
            }
            if ((flags & 2) != 0) {
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setNode((Node)srcNode.source);
            }
            if ((flags & 4) != 0) {
                l2vw = geomAtoms[i2].source.getCurrentLocalToVworld();
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setLocalToVWorld(new Transform3D(l2vw));
            }
            if ((flags & 0x10) != 0 || (flags & 0x20) != 0 || (flags & 8) != 0 || (flags & 0x40) != 0) {
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setNodeRef((Node)srcNode.source);
                l2vw = geomAtoms[i2].source.getCurrentLocalToVworld();
                pickInfo.setLocalToVWorldRef(l2vw);
            }
            if (pickInfo != null) {
                pickInfoList.add(pickInfo);
            }
            if (pickType != 2) continue;
            return pickInfoList;
        }
        return pickInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PickInfo[] pick(Object node, GeometryAtom[] geomAtoms, int mode, int flags, PickShape pickShape, int pickType) {
        int pickInfoListSize;
        PickInfo[] pickInfoArr = null;
        Locale locale = null;
        BranchGroupRetained bgRetained = null;
        ArrayList<PickInfo> pickInfoList = null;
        if (node instanceof Locale) {
            locale = (Locale)node;
        } else if (node instanceof BranchGroupRetained) {
            bgRetained = (BranchGroupRetained)node;
            locale = bgRetained.locale;
        }
        Object object = locale.universe.sceneGraphLock;
        synchronized (object) {
            ArrayList<NodeRetained> initPath = null;
            if (bgRetained != null) {
                initPath = PickInfo.initSceneGraphPath(bgRetained);
            }
            pickInfoList = PickInfo.getPickInfos(initPath, bgRetained, geomAtoms, locale, flags, pickType);
        }
        if (mode == 2 && pickInfoList != null && (pickInfoListSize = pickInfoList.size()) > 0) {
            Node pickNode = null;
            for (int i2 = pickInfoListSize - 1; i2 >= 0; --i2) {
                PickInfo pickInfo = pickInfoList.get(i2);
                pickNode = pickInfo.getNode();
                if (pickNode == null) {
                    pickNode = pickInfo.getNodeRef();
                }
                if (pickNode instanceof Shape3D) {
                    if (!pickNode.getCapability(12)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo0"));
                    }
                    for (int j2 = 0; j2 < ((Shape3D)pickNode).numGeometries(); ++j2) {
                        Geometry geo = ((Shape3D)pickNode).getGeometry(j2);
                        if (geo == null) continue;
                        if (!geo.getCapability(18)) {
                            throw new CapabilityNotSetException(J3dI18N.getString("PickInfo1"));
                        }
                        if (geo instanceof GeometryArray) {
                            if (!geo.getCapability(0)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo2"));
                            }
                            if (!geo.getCapability(8)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo3"));
                            }
                            if (!geo.getCapability(17)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo4"));
                            }
                            if (!(geo instanceof IndexedGeometryArray) || geo.getCapability(9)) continue;
                            throw new CapabilityNotSetException(J3dI18N.getString("PickInfo5"));
                        }
                        if (!(geo instanceof CompressedGeometry) || geo.getCapability(2)) continue;
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo0"));
                    }
                    if (!((Shape3DRetained)pickNode.retained).intersect(pickInfo, pickShape, flags)) {
                        pickInfoList.remove(i2);
                        continue;
                    }
                    if (pickType != 2) continue;
                    pickInfoArr = new PickInfo[]{pickInfo};
                    return pickInfoArr;
                }
                if (!(pickNode instanceof Morph)) continue;
                if (!pickNode.getCapability(12)) {
                    throw new CapabilityNotSetException(J3dI18N.getString("PickInfo6"));
                }
                int numGeo = ((MorphRetained)pickNode.retained).getNumGeometryArrays();
                for (int j3 = 0; j3 < numGeo; ++j3) {
                    GeometryArray geo = ((Morph)pickNode).getGeometryArray(j3);
                    if (geo == null) continue;
                    if (!geo.getCapability(18)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo1"));
                    }
                    if (!geo.getCapability(0)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo2"));
                    }
                    if (!geo.getCapability(8)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo3"));
                    }
                    if (!geo.getCapability(17)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo4"));
                    }
                    if (!(geo instanceof IndexedGeometryArray) || geo.getCapability(9)) continue;
                    throw new CapabilityNotSetException(J3dI18N.getString("PickInfo5"));
                }
                if (!((MorphRetained)pickNode.retained).intersect(pickInfo, pickShape, flags)) {
                    pickInfoList.remove(i2);
                    continue;
                }
                if (pickType != 2) continue;
                pickInfoArr = new PickInfo[]{pickInfo};
                return pickInfoArr;
            }
        }
        if (pickInfoList != null && pickInfoList.size() > 0) {
            pickInfoArr = new PickInfo[pickInfoList.size()];
            return pickInfoList.toArray(pickInfoArr);
        }
        return null;
    }

    public class IntersectionInfo {
        private int geomIndex;
        private Geometry geom;
        private Point3d intersectionPoint;
        private double distance;
        private int[] vertexIndices;

        IntersectionInfo() {
        }

        void setGeometryIndex(int geomIndex) {
            this.geomIndex = geomIndex;
        }

        void setGeometry(Geometry geom) {
            this.geom = geom;
        }

        void setIntersectionPoint(Point3d intersectionPoint) {
            assert (intersectionPoint != null);
            this.intersectionPoint = new Point3d(intersectionPoint);
        }

        void setDistance(double distance) {
            this.distance = distance;
        }

        void setVertexIndices(int[] vertexIndices) {
            assert (vertexIndices != null);
            this.vertexIndices = new int[vertexIndices.length];
            for (int i2 = 0; i2 < vertexIndices.length; ++i2) {
                this.vertexIndices[i2] = vertexIndices[i2];
            }
        }

        public int getGeometryIndex() {
            return this.geomIndex;
        }

        public Geometry getGeometry() {
            return this.geom;
        }

        public Point3d getIntersectionPoint() {
            return this.intersectionPoint;
        }

        public double getDistance() {
            return this.distance;
        }

        public int[] getVertexIndices() {
            return this.vertexIndices;
        }
    }
}

