/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.AudioDevice;
import org.jogamp.java3d.BadTransformException;
import org.jogamp.java3d.InputDevice;
import org.jogamp.java3d.InputDeviceScheduler;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Sensor;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;

public class PhysicalEnvironment {
    int HeadIndex = 0;
    int RightHandIndex = 1;
    int LeftHandIndex = 2;
    int DominantHandIndex = 1;
    int NonDominantHandIndex = 2;
    Transform3D coexistenceToTrackerBase = new Transform3D();
    boolean trackingAvailable = false;
    int coexistenceCenterInPworldPolicy = 2;
    int peDirtyMask = 0x700000;
    int sensorCount;
    Sensor[] sensors;
    AudioDevice audioDevice = null;
    boolean sensorListChanged = false;
    Sensor[] sensorList = null;
    ArrayList<View> users = new ArrayList();
    InputDeviceScheduler inputsched;
    Vector<InputDevice> devices = new Vector(1);
    int activeViewRef = 0;
    static final Hashtable<PhysicalEnvironment, InputDeviceScheduler> physicalEnvMap = new Hashtable();

    public PhysicalEnvironment() {
        this(3);
    }

    synchronized void removeUser(View view) {
        this.users.remove(view);
    }

    synchronized void addUser(View view) {
        if (!this.users.contains(view)) {
            this.users.add(view);
        }
    }

    synchronized void notifyUsers() {
        for (int i2 = this.users.size() - 1; i2 >= 0; --i2) {
            this.users.get(i2).repaint();
        }
    }

    public PhysicalEnvironment(int sensorCount) {
        this.sensorCount = sensorCount;
        this.sensors = new Sensor[sensorCount];
        for (int i2 = sensorCount - 1; i2 >= 0; --i2) {
            this.sensors[i2] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Sensor[] getSensorList() {
        Sensor[] sensorArray = this.sensors;
        synchronized (this.sensors) {
            if (this.sensorListChanged) {
                this.sensorList = new Sensor[this.sensors.length];
                for (int i2 = 0; i2 < this.sensors.length; ++i2) {
                    this.sensorList[i2] = this.sensors[i2];
                }
                this.sensorListChanged = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sensorList;
        }
    }

    public void setAudioDevice(AudioDevice device) {
        this.audioDevice = device;
    }

    public AudioDevice getAudioDevice() {
        return this.audioDevice;
    }

    public Iterator<InputDevice> getAllInputDevices() {
        return this.devices.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInputDevice(InputDevice device) {
        int driver_type = device.getProcessingMode();
        if (driver_type == 3 || driver_type == 4 || driver_type == 5) {
            Vector<InputDevice> vector = this.devices;
            synchronized (vector) {
                this.devices.add(device);
                if (this.inputsched != null) {
                    this.inputsched.addInputDevice(device);
                }
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("PhysicalEnvironment0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInputDevice(InputDevice device) {
        Vector<InputDevice> vector = this.devices;
        synchronized (vector) {
            this.devices.remove(device);
            if (this.inputsched != null) {
                this.inputsched.removeInputDevice(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeadIndex(int index) {
        this.HeadIndex = index;
        PhysicalEnvironment physicalEnvironment = this;
        synchronized (physicalEnvironment) {
            this.computeTrackingAvailable();
            this.peDirtyMask |= 0x200000;
        }
        this.notifyUsers();
    }

    public int getHeadIndex() {
        return this.HeadIndex;
    }

    public void setRightHandIndex(int index) {
        this.RightHandIndex = index;
        this.notifyUsers();
    }

    public int getRightHandIndex() {
        return this.RightHandIndex;
    }

    public void setLeftHandIndex(int index) {
        this.LeftHandIndex = index;
        this.notifyUsers();
    }

    public int getLeftHandIndex() {
        return this.LeftHandIndex;
    }

    public void setDominantHandIndex(int index) {
        this.DominantHandIndex = index;
        this.notifyUsers();
    }

    public int getDominantHandIndex() {
        return this.DominantHandIndex;
    }

    public void setNonDominantHandIndex(int index) {
        this.NonDominantHandIndex = index;
        this.notifyUsers();
    }

    public int getNonDominantHandIndex() {
        return this.NonDominantHandIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSensor(int index, Sensor sensor) {
        Object object = this.sensors;
        synchronized (this.sensors) {
            this.sensors[index] = sensor;
            this.sensorListChanged = true;
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            object = this;
            synchronized (object) {
                this.computeTrackingAvailable();
                this.peDirtyMask |= 0x200000;
            }
            this.notifyUsers();
            return;
        }
    }

    public Sensor getSensor(int index) {
        return this.sensors[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoexistenceToTrackerBase(Transform3D t) {
        if (!t.isRigid()) {
            throw new BadTransformException(J3dI18N.getString("PhysicalEnvironment1"));
        }
        PhysicalEnvironment physicalEnvironment = this;
        synchronized (physicalEnvironment) {
            this.coexistenceToTrackerBase.setWithLock(t);
            this.peDirtyMask |= 0x100000;
        }
        this.notifyUsers();
    }

    public void getCoexistenceToTrackerBase(Transform3D t) {
        t.set(this.coexistenceToTrackerBase);
    }

    public boolean getTrackingAvailable() {
        return this.trackingAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoexistenceCenterInPworldPolicy(int policy) {
        switch (policy) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("PhysicalEnvironment2"));
            }
        }
        PhysicalEnvironment physicalEnvironment = this;
        synchronized (physicalEnvironment) {
            this.coexistenceCenterInPworldPolicy = policy;
            this.peDirtyMask |= 0x400000;
        }
        this.notifyUsers();
    }

    public int getCoexistenceCenterInPworldPolicy() {
        return this.coexistenceCenterInPworldPolicy;
    }

    public int getSensorCount() {
        return this.sensorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSensorCount(int count) {
        Sensor[] tmp = new Sensor[count];
        int i2 = 0;
        Sensor[] sensorArray = this.sensors;
        synchronized (this.sensors) {
            int min = Math.min(count, this.sensorCount);
            while (i2 < min) {
                tmp[i2] = this.sensors[i2++];
            }
            while (i2 < count) {
                tmp[i2++] = null;
            }
            this.sensorCount = count;
            this.sensorListChanged = true;
            this.sensors = tmp;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.notifyUsers();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTrackingAvailable() {
        Sensor[] sensorArray = this.sensors;
        synchronized (this.sensors) {
            this.trackingAvailable = this.HeadIndex < this.sensors.length && this.sensors[this.HeadIndex] != null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

