/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.BadTransformException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class PhysicalBody {
    private static final double HALF_IPD = 0.033;
    private static final double EAR_X = 0.08;
    private static final double EAR_Y = -0.03;
    private static final double EAR_Z = 0.095;
    Point3d leftEyePosition = new Point3d(-0.033, 0.0, 0.0);
    Point3d rightEyePosition = new Point3d(0.033, 0.0, 0.0);
    Point3d leftEarPosition = new Point3d(-0.08, -0.03, 0.095);
    Point3d rightEarPosition = new Point3d(0.08, -0.03, 0.095);
    double nominalEyeHeightFromGround = 1.68;
    double nominalEyeOffsetFromNominalScreen = 0.4572;
    Transform3D headToHeadTracker = new Transform3D();
    ArrayList<View> users = new ArrayList();
    int pbDirtyMask = 0xF000000;

    public PhysicalBody() {
        this.initHeadToHeadTracker();
    }

    synchronized void removeUser(View view) {
        this.users.remove(view);
    }

    synchronized void addUser(View view) {
        if (!this.users.contains(view)) {
            this.users.add(view);
        }
    }

    synchronized void notifyUsers() {
        for (int i2 = this.users.size() - 1; i2 >= 0; --i2) {
            View view = this.users.get(i2);
            if (view.soundScheduler != null) {
                view.soundScheduler.setListenerFlag(3);
            }
            view.repaint();
        }
    }

    public PhysicalBody(Point3d leftEyePosition, Point3d rightEyePosition) {
        this.leftEyePosition.set(leftEyePosition);
        this.rightEyePosition.set(rightEyePosition);
        this.initHeadToHeadTracker();
    }

    public PhysicalBody(Point3d leftEyePosition, Point3d rightEyePosition, Point3d leftEarPosition, Point3d rightEarPosition) {
        this.leftEyePosition.set(leftEyePosition);
        this.rightEyePosition.set(rightEyePosition);
        this.leftEarPosition.set(leftEarPosition);
        this.rightEarPosition.set(rightEarPosition);
        this.initHeadToHeadTracker();
    }

    public String toString() {
        return "eyePosition = (" + this.leftEyePosition + ", " + this.rightEyePosition + ")\n" + "earPosition = (" + this.leftEarPosition + ", " + this.rightEarPosition + ")";
    }

    public void getLeftEyePosition(Point3d position) {
        position.set(this.leftEyePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftEyePosition(Point3d position) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.leftEyePosition.set(position);
            this.pbDirtyMask |= 0x1000000;
        }
        this.notifyUsers();
    }

    public void getRightEyePosition(Point3d position) {
        position.set(this.rightEyePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightEyePosition(Point3d position) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.rightEyePosition.set(position);
            this.pbDirtyMask |= 0x1000000;
        }
        this.notifyUsers();
    }

    public void getLeftEarPosition(Point3d position) {
        position.set(this.leftEarPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftEarPosition(Point3d position) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.leftEarPosition.set(position);
            this.pbDirtyMask |= 0x2000000;
        }
        this.notifyUsers();
    }

    public void getRightEarPosition(Point3d position) {
        position.set(this.rightEarPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightEarPosition(Point3d position) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.rightEarPosition.set(position);
            this.pbDirtyMask |= 0x2000000;
        }
        this.notifyUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNominalEyeHeightFromGround(double height) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.nominalEyeHeightFromGround = height;
            this.pbDirtyMask |= 0x4000000;
        }
        this.notifyUsers();
    }

    public double getNominalEyeHeightFromGround() {
        return this.nominalEyeHeightFromGround;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNominalEyeOffsetFromNominalScreen(double offset) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.nominalEyeOffsetFromNominalScreen = offset;
            this.pbDirtyMask |= 0x8000000;
        }
        this.notifyUsers();
    }

    public double getNominalEyeOffsetFromNominalScreen() {
        return this.nominalEyeOffsetFromNominalScreen;
    }

    public void setHeadToHeadTracker(Transform3D t) {
        if (!t.isRigid()) {
            throw new BadTransformException(J3dI18N.getString("PhysicalBody0"));
        }
        this.headToHeadTracker.setWithLock(t);
        this.notifyUsers();
    }

    public void getHeadToHeadTracker(Transform3D t) {
        t.set(this.headToHeadTracker);
    }

    private void initHeadToHeadTracker() {
        Vector3d v = new Vector3d(0.0, 0.02, 0.035);
        this.headToHeadTracker.set(v);
    }
}

