/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Hashtable;
import org.jogamp.java3d.IllegalSharingException;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.ImageComponentRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.RestrictedAccessException;
import org.jogamp.java3d.SceneGraphObject;

public abstract class NodeComponent
extends SceneGraphObject {
    boolean forceDuplicate = false;

    public void setDuplicateOnCloneTree(boolean duplicate) {
        ((NodeComponentRetained)this.retained).setDuplicateOnCloneTree(duplicate);
    }

    public boolean getDuplicateOnCloneTree() {
        return ((NodeComponentRetained)this.retained).getDuplicateOnCloneTree();
    }

    public NodeComponent cloneNodeComponent() {
        throw new RuntimeException(J3dI18N.getString("NodeComponent0"));
    }

    public void duplicateNodeComponent(NodeComponent originalNodeComponent) {
        this.duplicateAttributes(originalNodeComponent, originalNodeComponent.forceDuplicate);
    }

    final void checkDuplicateNodeComponent(NodeComponent originalNodeComponent) {
        if (originalNodeComponent.nodeHashtable != null) {
            this.duplicateAttributes(originalNodeComponent, originalNodeComponent.forceDuplicate);
        } else {
            originalNodeComponent.nodeHashtable = new Hashtable();
            this.duplicateAttributes(originalNodeComponent, originalNodeComponent.forceDuplicate);
            originalNodeComponent.nodeHashtable = null;
        }
    }

    public void duplicateNodeComponent(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        originalNodeComponent.forceDuplicate = forceDuplicate;
        try {
            this.duplicateNodeComponent(originalNodeComponent);
        }
        catch (RuntimeException e2) {
            originalNodeComponent.forceDuplicate = false;
            throw e2;
        }
        originalNodeComponent.forceDuplicate = false;
    }

    public NodeComponent cloneNodeComponent(boolean forceDuplicate) {
        NodeComponent nc;
        this.forceDuplicate = forceDuplicate;
        try {
            nc = this.cloneNodeComponent();
        }
        catch (RuntimeException e2) {
            this.forceDuplicate = false;
            throw e2;
        }
        this.forceDuplicate = false;
        return nc;
    }

    void duplicateAttributes(NodeComponent originalNode, boolean forceDuplicate) {
        if (forceDuplicate && originalNode.isCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("NodeComponent1"));
        }
        super.duplicateSceneGraphObject(originalNode);
        this.setDuplicateOnCloneTree(originalNode.getDuplicateOnCloneTree());
    }

    @Override
    void createRetained() {
        this.retained = new NodeComponentRetained();
        this.retained.setSource(this);
    }

    boolean duplicateChild() {
        return this.getDuplicateOnCloneTree();
    }

    void validateImageIllegalSharing(ImageComponent image) {
        if (image != null) {
            ImageComponentRetained imageRetained = (ImageComponentRetained)image.retained;
            NodeComponentRetained ncRetained = (NodeComponentRetained)this.retained;
            if (imageRetained.getUsedByOffScreen()) {
                if (this.isLive()) {
                    throw new IllegalSharingException(J3dI18N.getString("NodeComponent2"));
                }
                if (ncRetained.getInImmCtx()) {
                    throw new IllegalSharingException(J3dI18N.getString("NodeComponent3"));
                }
            }
        }
    }
}

