/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.AlternateAppearanceRetained;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.AppearanceRetained;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroupRetained;
import org.jogamp.java3d.CompileState;
import org.jogamp.java3d.FogRetained;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.GeometryStripArrayRetained;
import org.jogamp.java3d.GeometryUpdater;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.IndexedGeometryArrayRetained;
import org.jogamp.java3d.IndexedGeometryStripArrayRetained;
import org.jogamp.java3d.IndexedLineArray;
import org.jogamp.java3d.IndexedLineStripArray;
import org.jogamp.java3d.IndexedLineStripArrayRetained;
import org.jogamp.java3d.IndexedPointArray;
import org.jogamp.java3d.IndexedQuadArray;
import org.jogamp.java3d.IndexedTriangleArray;
import org.jogamp.java3d.IndexedTriangleFanArray;
import org.jogamp.java3d.IndexedTriangleFanArrayRetained;
import org.jogamp.java3d.IndexedTriangleStripArray;
import org.jogamp.java3d.IndexedTriangleStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LeafRetained;
import org.jogamp.java3d.LightRetained;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.LineStripArray;
import org.jogamp.java3d.LineStripArrayRetained;
import org.jogamp.java3d.ModelClipRetained;
import org.jogamp.java3d.Morph;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.PointArray;
import org.jogamp.java3d.QuadArray;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.SwitchRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.TriangleFanArray;
import org.jogamp.java3d.TriangleFanArrayRetained;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.java3d.TriangleStripArrayRetained;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Color3b;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4b;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.TexCoord3f;
import org.jogamp.vecmath.Vector3f;

@Deprecated
class MorphRetained
extends LeafRetained
implements GeometryUpdater {
    static final int GEOMETRY_CHANGED = 1;
    static final int APPEARANCE_CHANGED = 2;
    static final int COLLISION_CHANGED = 4;
    static final int BOUNDS_CHANGED = 8;
    static final int APPEARANCEOVERRIDE_CHANGED = 16;
    static final int UPDATE_MORPH = 32;
    private static final double TOLERANCE = 1.0E-4;
    ArrayList mirrorShape3D = new ArrayList();
    static final int targetThreads = 192;
    AppearanceRetained appearance = null;
    GeometryArrayRetained[] geometryArrays;
    private int numGeometryArrays = 0;
    double[] weights;
    BranchGroupRetained[] branchGroupPath;
    boolean isPickable = true;
    boolean isCollidable = true;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    boolean visible = true;
    Bounds bounds = null;
    BoundingBox vwcBounds = new BoundingBox();
    Bounds collisionBound = null;
    Bounds collisionVwcBound = null;
    GeometryArray morphedGeometryArray = null;
    float[] Mcoord = null;
    float[] Mcolor = null;
    float[] Mnormal = null;
    float[][] MtexCoord = null;
    boolean appearanceOverrideEnable = false;
    int changedFrequent = 0;

    MorphRetained() {
        this.nodeType = 10;
        this.localBounds = new BoundingBox((Bounds)null);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds != null ? (Bounds)bounds.clone() : null;
        if (this.source.isLive()) {
            J3dMessage message = new J3dMessage();
            message.type = 34;
            message.threads = 8192;
            message.universe = this.universe;
            message.args[1] = this.collisionBound;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    @Override
    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute) {
            J3dMessage message = new J3dMessage();
            message.type = 35;
            message.threads = 8384;
            message.universe = this.universe;
            message.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            message.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    void setGeometryArrays(GeometryArray[] geometryArrays) {
        GeometryArrayRetained geo;
        int i2;
        if ((geometryArrays == null || geometryArrays.length == 0) && this.numGeometryArrays == 0) {
            return;
        }
        if (this.numGeometryArrays != 0 && (geometryArrays == null || this.numGeometryArrays != geometryArrays.length)) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained0"));
        }
        for (i2 = 1; i2 < geometryArrays.length; ++i2) {
            if (geometryArrays[i2] == null || geometryArrays[i2 - 1] == null) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            geo = (GeometryArrayRetained)geometryArrays[i2].retained;
            GeometryArrayRetained prevGeo = (GeometryArrayRetained)geometryArrays[i2 - 1].retained;
            if (prevGeo == null || geo == null) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            this.doErrorCheck(prevGeo, geo);
        }
        geo = (GeometryArrayRetained)geometryArrays[0].retained;
        if ((geo.vertexFormat & 0x1000) != 0) {
            throw new UnsupportedOperationException(J3dI18N.getString("MorphRetained9"));
        }
        if (geometryArrays[0] != null) {
            geo = (GeometryArrayRetained)geometryArrays[0].retained;
        }
        if (this.numGeometryArrays == 0) {
            this.geometryArrays = new GeometryArrayRetained[geometryArrays.length];
            this.numGeometryArrays = geometryArrays.length;
        }
        for (i2 = 0; i2 < this.numGeometryArrays; ++i2) {
            geo = (GeometryArrayRetained)geometryArrays[i2].retained;
            if (((Morph)this.source).isLive()) {
                if (this.geometryArrays[i2] != null) {
                    this.geometryArrays[i2].clearLive(this.refCount);
                    this.geometryArrays[i2].removeMorphUser(this);
                }
                if (geo != null) {
                    geo.setLive(this.inBackgroundGroup, this.refCount);
                    geo.addMorphUser(this);
                }
            }
            this.geometryArrays[i2] = geo;
        }
        if (this.geometryArrays[0] == null) {
            return;
        }
        if (this.weights == null) {
            int k2;
            this.weights = new double[this.numGeometryArrays];
            this.weights[0] = 1.0;
            int vFormat = this.geometryArrays[0].vertexFormat;
            int texCoordSetCount = this.geometryArrays[0].getTexCoordSetCount();
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                this.Mcoord = new float[this.geometryArrays[0].getNumCoordCount() * 3];
                if ((vFormat & 0xC) == 4) {
                    this.Mcolor = new float[this.geometryArrays[0].getNumColorCount() * 3];
                } else if ((vFormat & 0xC) == 12) {
                    this.Mcolor = new float[this.geometryArrays[0].getNumColorCount() * 4];
                }
                this.MtexCoord = new float[texCoordSetCount][];
                if ((vFormat & 2) != 0) {
                    this.Mnormal = new float[this.geometryArrays[0].getNumNormalCount() * 3];
                }
                for (k2 = 0; k2 < texCoordSetCount; ++k2) {
                    if ((vFormat & 0x20) != 0) {
                        this.MtexCoord[k2] = new float[this.geometryArrays[0].getNumTexCoordCount(k2) * 2];
                        continue;
                    }
                    if ((vFormat & 0x40) != 0) {
                        this.MtexCoord[k2] = new float[this.geometryArrays[0].getNumTexCoordCount(k2) * 3];
                        continue;
                    }
                    if ((vFormat & 0x400) == 0) continue;
                    this.MtexCoord[k2] = new float[this.geometryArrays[0].getNumTexCoordCount(k2) * 4];
                }
            } else {
                this.Mcoord = new float[this.geometryArrays[0].validVertexCount * 3];
                if ((vFormat & 0xC) == 4) {
                    this.Mcolor = new float[this.geometryArrays[0].validVertexCount * 3];
                } else if ((vFormat & 0xC) == 12) {
                    this.Mcolor = new float[this.geometryArrays[0].validVertexCount * 4];
                }
                this.MtexCoord = new float[texCoordSetCount][];
                if ((vFormat & 2) != 0) {
                    this.Mnormal = new float[this.geometryArrays[0].validVertexCount * 3];
                }
                for (k2 = 0; k2 < texCoordSetCount; ++k2) {
                    if ((vFormat & 0x20) != 0) {
                        this.MtexCoord[k2] = new float[this.geometryArrays[0].validVertexCount * 2];
                        continue;
                    }
                    if ((vFormat & 0x40) != 0) {
                        this.MtexCoord[k2] = new float[this.geometryArrays[0].validVertexCount * 3];
                        continue;
                    }
                    if ((vFormat & 0x400) == 0) continue;
                    this.MtexCoord[k2] = new float[this.geometryArrays[0].validVertexCount * 4];
                }
            }
        }
        this.initMorphedGeometry();
        if (this.source.isLive()) {
            Shape3DRetained shape = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape.setMorphGeometry(this.morphedGeometryArray, this.mirrorShape3D);
            J3dMessage mChangeMessage = null;
            mChangeMessage = new J3dMessage();
            mChangeMessage.type = 16;
            mChangeMessage.threads = 8256;
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                mChangeMessage.threads |= 0x400;
            }
            mChangeMessage.args[0] = this;
            mChangeMessage.args[1] = new Integer(1);
            mChangeMessage.args[3] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            mChangeMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(mChangeMessage);
            if (this.boundsAutoCompute) {
                GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
                mga.incrComputeGeoBounds();
                mga.decrComputeGeoBounds();
            }
        }
    }

    GeometryArray getGeometryArray(int index) {
        return (GeometryArray)this.geometryArrays[index].source;
    }

    void setAppearance(Appearance newAppearance) {
        boolean visibleIsDirty = false;
        if (((Morph)this.source).isLive()) {
            int size;
            if (this.appearance != null) {
                this.appearance.clearLive(this.refCount);
                for (int i2 = this.mirrorShape3D.size() - 1; i2 >= 0; --i2) {
                    this.appearance.removeAMirrorUser((Shape3DRetained)this.mirrorShape3D.get(i2));
                }
            }
            if (newAppearance != null) {
                ((AppearanceRetained)newAppearance.retained).setLive(this.inBackgroundGroup, this.refCount);
                this.appearance = (AppearanceRetained)newAppearance.retained;
                size = this.mirrorShape3D.size();
                for (int i3 = 0; i3 < size; ++i3) {
                    this.appearance.addAMirrorUser((Shape3DRetained)this.mirrorShape3D.get(i3));
                }
                if (this.appearance.renderingAttributes != null && this.visible != this.appearance.renderingAttributes.visible) {
                    this.visible = this.appearance.renderingAttributes.visible;
                    visibleIsDirty = true;
                }
            } else if (!this.visible) {
                this.visible = true;
                visibleIsDirty = true;
            }
            size = 0;
            size = visibleIsDirty ? 2 : 1;
            J3dMessage[] createMessage = new J3dMessage[size];
            createMessage[0] = new J3dMessage();
            createMessage[0].threads = 4224;
            createMessage[0].type = 16;
            createMessage[0].universe = this.universe;
            createMessage[0].args[0] = this;
            createMessage[0].args[1] = new Integer(2);
            Shape3DRetained[] s3dArr = new Shape3DRetained[this.mirrorShape3D.size()];
            this.mirrorShape3D.toArray(s3dArr);
            createMessage[0].args[2] = s3dArr;
            Object[] obj = new Object[]{newAppearance == null ? null : this.appearance.mirror, new Integer(this.changedFrequent)};
            createMessage[0].args[3] = obj;
            createMessage[0].args[4] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            if (visibleIsDirty) {
                createMessage[1] = new J3dMessage();
                createMessage[1].threads = 64;
                createMessage[1].type = 24;
                createMessage[1].universe = this.universe;
                createMessage[1].args[0] = this;
                createMessage[1].args[1] = new Integer(2);
                createMessage[1].args[2] = this.visible ? Boolean.TRUE : Boolean.FALSE;
                createMessage[1].args[3] = createMessage[0].args[4];
            }
            VirtualUniverse.mc.processMessage(createMessage);
        } else {
            this.appearance = newAppearance == null ? null : (AppearanceRetained)newAppearance.retained;
        }
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    void setAppearanceOverrideEnable(boolean flag) {
        if (((Morph)this.source).isLive()) {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 4224;
            createMessage.type = 16;
            createMessage.universe = this.universe;
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(16);
            Shape3DRetained[] s3dArr = new Shape3DRetained[this.mirrorShape3D.size()];
            this.mirrorShape3D.toArray(s3dArr);
            createMessage.args[2] = s3dArr;
            Object[] obj = new Object[]{flag ? Boolean.TRUE : Boolean.FALSE, new Integer(this.changedFrequent)};
            createMessage.args[3] = obj;
            createMessage.args[4] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(createMessage);
        }
        this.appearanceOverrideEnable = flag;
    }

    boolean getAppearanceOverrideEnable() {
        return this.appearanceOverrideEnable;
    }

    boolean intersect(PickInfo pickInfo, PickShape pickShape, int flags) {
        Transform3D localToVworld = pickInfo.getLocalToVWorldRef();
        Transform3D vworldToLocal = new Transform3D();
        vworldToLocal.invert(localToVworld);
        PickShape newPS = pickShape.transform(vworldToLocal);
        GeometryRetained geo = (GeometryRetained)this.morphedGeometryArray.retained;
        if (geo.mirrorGeometry != null) {
            geo = geo.mirrorGeometry;
        }
        if ((flags & 8) == 0 && (flags & 0x10) == 0 && (flags & 0x20) == 0 && (flags & 0x40) == 0) {
            return geo.intersect(newPS, null, 0, null, null, 0);
        }
        Point3d closestIPnt = new Point3d();
        Point3d iPnt = new Point3d();
        Point3d iPntVW = new Point3d();
        if (geo.intersect(newPS, pickInfo, flags, iPnt, geo, 0)) {
            iPntVW.set(iPnt);
            localToVworld.transform(iPntVW);
            double distance = pickShape.distance(iPntVW);
            if ((flags & 0x10) != 0) {
                pickInfo.setClosestDistance(distance);
            }
            if ((flags & 8) != 0) {
                pickInfo.setClosestIntersectionPoint(iPnt);
            }
            return true;
        }
        return false;
    }

    boolean intersect(SceneGraphPath path, PickShape pickShape, double[] dist) {
        PickInfo pickInfo = new PickInfo();
        Transform3D localToVworld = path.getTransform();
        if (localToVworld == null) {
            throw new RuntimeException(J3dI18N.getString("MorphRetained5"));
        }
        pickInfo.setLocalToVWorldRef(localToVworld);
        if (dist == null) {
            return this.intersect(pickInfo, pickShape, 0);
        }
        int flags = 16;
        if (this.intersect(pickInfo, pickShape, flags)) {
            dist[0] = pickInfo.getClosestDistance();
            return true;
        }
        return false;
    }

    void setWeights(double[] weights) {
        int i2;
        double sum = 0.0;
        if (weights.length != this.numGeometryArrays) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained7"));
        }
        for (i2 = weights.length - 1; i2 >= 0; --i2) {
            sum += weights[i2];
        }
        if (Math.abs(sum - 1.0) > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained8"));
        }
        for (i2 = this.numGeometryArrays - 1; i2 >= 0; --i2) {
            this.weights[i2] = weights[i2];
        }
        if (this.source.isLive()) {
            ((GeometryArrayRetained)this.morphedGeometryArray.retained).updateData(this);
            J3dMessage mChangeMessage = null;
            mChangeMessage = new J3dMessage();
            mChangeMessage.type = 16;
            mChangeMessage.threads = 8256;
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                mChangeMessage.threads |= 0x400;
            }
            mChangeMessage.args[0] = this;
            mChangeMessage.args[1] = new Integer(1);
            mChangeMessage.args[3] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            mChangeMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(mChangeMessage);
        }
    }

    double[] getWeights() {
        return (double[])this.weights.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            if (mga != null) {
                BoundingBox boundingBox = mga.geoBounds;
                synchronized (boundingBox) {
                    return (Bounds)mga.geoBounds.clone();
                }
            }
            return null;
        }
        return super.getBounds();
    }

    @Override
    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void computeCombineBounds(Bounds bounds) {
        if (this.boundsAutoCompute) {
            GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            if (mga != null) {
                BoundingBox boundingBox = mga.geoBounds;
                synchronized (boundingBox) {
                    bounds.combine(mga.geoBounds);
                }
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    int getNumGeometryArrays() {
        return this.numGeometryArrays;
    }

    void updateMorphedGeometryArray(GeometryArrayRetained geo, boolean coordinatesChanged) {
        if (this.numGeometryArrays > 0) {
            if (this.geometryArrays[0] != geo) {
                this.doErrorCheck(geo, this.geometryArrays[0]);
            } else if (this.numGeometryArrays > 1) {
                this.doErrorCheck(geo, this.geometryArrays[1]);
            }
        }
        ((GeometryArrayRetained)this.morphedGeometryArray.retained).updateData(this);
        if (this.boundsAutoCompute && coordinatesChanged) {
            GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            mga.incrComputeGeoBounds();
            mga.decrComputeGeoBounds();
        }
    }

    @Override
    public void updateData(Geometry mga) {
        int j2;
        int k2;
        int i2;
        boolean iCount = false;
        boolean numStrips = false;
        int texCoordSetCount = 0;
        float[] coord = new float[3];
        float[] color = new float[4];
        float[] normal = new float[3];
        float[] texCoord = new float[3];
        int vFormat = this.geometryArrays[0].vertexFormat;
        int geoType = this.geometryArrays[0].geoType;
        texCoordSetCount = this.geometryArrays[0].getTexCoordSetCount();
        int vc = 0;
        int nc = 0;
        int cc = 0;
        boolean n2 = false;
        int count = 0;
        count = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumCoordCount() : this.geometryArrays[0].validVertexCount;
        for (i2 = 0; i2 < count; ++i2) {
            int n3 = vc++;
            int n4 = vc++;
            this.Mcoord[vc++] = 0.0f;
            this.Mcoord[n4] = 0.0f;
            this.Mcoord[n3] = 0.0f;
        }
        if ((vFormat & 4) != 0) {
            count = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumColorCount() : this.geometryArrays[0].validVertexCount;
            for (i2 = 0; i2 < count; ++i2) {
                if ((vFormat & 0xC) == 4) {
                    int n5 = cc++;
                    int n6 = cc++;
                    this.Mcolor[cc++] = 0.0f;
                    this.Mcolor[n6] = 0.0f;
                    this.Mcolor[n5] = 0.0f;
                    continue;
                }
                if ((vFormat & 0xC) != 12) continue;
                int n7 = cc++;
                int n8 = cc++;
                int n9 = cc++;
                this.Mcolor[cc++] = 0.0f;
                this.Mcolor[n9] = 0.0f;
                this.Mcolor[n8] = 0.0f;
                this.Mcolor[n7] = 0.0f;
            }
        }
        if ((vFormat & 2) != 0) {
            count = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumNormalCount() : this.geometryArrays[0].validVertexCount;
            for (i2 = 0; i2 < count; ++i2) {
                int n10 = nc++;
                int n11 = nc++;
                this.Mnormal[nc++] = 0.0f;
                this.Mnormal[n11] = 0.0f;
                this.Mnormal[n10] = 0.0f;
            }
        }
        if ((vFormat & 0x460) != 0) {
            for (k2 = 0; k2 < texCoordSetCount; ++k2) {
                count = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumTexCoordCount(k2) : this.geometryArrays[0].validVertexCount;
                int tcount = 0;
                for (i2 = 0; i2 < count; ++i2) {
                    int n12 = tcount++;
                    this.MtexCoord[k2][tcount++] = 0.0f;
                    this.MtexCoord[k2][n12] = 0.0f;
                    if ((vFormat & 0x40) != 0) {
                        this.MtexCoord[k2][tcount++] = 0.0f;
                        continue;
                    }
                    if ((vFormat & 0x400) == 0) continue;
                    this.MtexCoord[k2][tcount++] = 0.0f;
                    this.MtexCoord[k2][tcount++] = 0.0f;
                }
            }
        }
        if ((vFormat & 0x80) == 0) {
            count = 0;
            for (j2 = 0; j2 < this.numGeometryArrays; ++j2) {
                double w = this.weights[j2];
                if (w == 0.0) continue;
                vc = 0;
                nc = 0;
                cc = 0;
                int initialVertex = 0;
                if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                    initialVertex = 0;
                    count = this.geometryArrays[j2].getNumCoordCount();
                } else {
                    initialVertex = this.geometryArrays[j2].getInitialVertexIndex();
                    count = this.geometryArrays[j2].validVertexCount;
                }
                int endVertex = initialVertex + count;
                for (i2 = initialVertex; i2 < endVertex; ++i2) {
                    this.geometryArrays[j2].getCoordinate(i2, coord);
                    int n13 = vc++;
                    this.Mcoord[n13] = (float)((double)this.Mcoord[n13] + (double)coord[0] * w);
                    int n14 = vc++;
                    this.Mcoord[n14] = (float)((double)this.Mcoord[n14] + (double)coord[1] * w);
                    int n15 = vc++;
                    this.Mcoord[n15] = (float)((double)this.Mcoord[n15] + (double)coord[2] * w);
                }
                if ((vFormat & 4) != 0) {
                    if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                        count = this.geometryArrays[j2].getNumColorCount();
                    }
                    endVertex = initialVertex + count;
                    for (i2 = initialVertex; i2 < endVertex; ++i2) {
                        this.geometryArrays[j2].getColor(i2, color);
                        int n16 = cc++;
                        this.Mcolor[n16] = (float)((double)this.Mcolor[n16] + (double)color[0] * w);
                        int n17 = cc++;
                        this.Mcolor[n17] = (float)((double)this.Mcolor[n17] + (double)color[1] * w);
                        int n18 = cc++;
                        this.Mcolor[n18] = (float)((double)this.Mcolor[n18] + (double)color[2] * w);
                        if ((vFormat & 8) == 0) continue;
                        int n19 = cc++;
                        this.Mcolor[n19] = (float)((double)this.Mcolor[n19] + (double)color[3] * w);
                    }
                }
                if ((vFormat & 2) != 0) {
                    if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                        count = this.geometryArrays[j2].getNumNormalCount();
                    }
                    endVertex = initialVertex + count;
                    for (i2 = initialVertex; i2 < endVertex; ++i2) {
                        this.geometryArrays[j2].getNormal(i2, normal);
                        int n20 = nc++;
                        this.Mnormal[n20] = (float)((double)this.Mnormal[n20] + (double)normal[0] * w);
                        int n21 = nc++;
                        this.Mnormal[n21] = (float)((double)this.Mnormal[n21] + (double)normal[1] * w);
                        int n22 = nc++;
                        this.Mnormal[n22] = (float)((double)this.Mnormal[n22] + (double)normal[2] * w);
                    }
                }
                if ((vFormat & 0x460) == 0) continue;
                for (k2 = 0; k2 < texCoordSetCount; ++k2) {
                    int tcount = 0;
                    if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                        count = this.geometryArrays[j2].getNumTexCoordCount(i2);
                    }
                    endVertex = initialVertex + count;
                    for (i2 = initialVertex; i2 < endVertex; ++i2) {
                        this.geometryArrays[j2].getTextureCoordinate(k2, i2, texCoord);
                        float[] fArray = this.MtexCoord[k2];
                        int n23 = tcount++;
                        fArray[n23] = (float)((double)fArray[n23] + (double)texCoord[0] * w);
                        float[] fArray2 = this.MtexCoord[k2];
                        int n24 = tcount++;
                        fArray2[n24] = (float)((double)fArray2[n24] + (double)texCoord[1] * w);
                        if ((vFormat & 0x40) != 0) {
                            float[] fArray3 = this.MtexCoord[k2];
                            int n25 = tcount++;
                            fArray3[n25] = (float)((double)fArray3[n25] + (double)texCoord[2] * w);
                            continue;
                        }
                        if ((vFormat & 0x400) == 0) continue;
                        float[] fArray4 = this.MtexCoord[k2];
                        int n26 = tcount++;
                        fArray4[n26] = (float)((double)fArray4[n26] + (double)texCoord[2] * w);
                        float[] fArray5 = this.MtexCoord[k2];
                        int n27 = tcount++;
                        fArray5[n27] = (float)((double)fArray5[n27] + (double)texCoord[3] * w);
                    }
                }
            }
        } else {
            int vIndex;
            int nIndex;
            int cIndex;
            int tIndex;
            int tstride = 0;
            int cstride = 0;
            if ((vFormat & 0x460) != 0) {
                tstride = (vFormat & 0x20) != 0 ? 2 : ((vFormat & 0x40) != 0 ? 3 : 4);
            }
            if ((vFormat & 4) != 0) {
                cstride = 3;
                if ((vFormat & 8) != 0) {
                    cstride = 4;
                }
            }
            if ((vFormat & 0x100) != 0) {
                int stride = this.geometryArrays[0].stride();
                int coffset = this.geometryArrays[0].colorOffset();
                int noffset = this.geometryArrays[0].normalOffset();
                int voffset = this.geometryArrays[0].coordinateOffset();
                int offset = 0;
                boolean initialVertex = false;
                for (j2 = 0; j2 < this.numGeometryArrays; ++j2) {
                    double w = this.weights[j2];
                    if (w == 0.0) continue;
                    vc = 0;
                    nc = 0;
                    cc = 0;
                    n2 = false;
                    float[] vdata = this.geometryArrays[j2].getInterleavedVertices();
                    if ((vFormat & 0x460) != 0) {
                        for (k2 = 0; k2 < texCoordSetCount; ++k2) {
                            if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                                tIndex = 0;
                                count = this.geometryArrays[j2].getNumCoordCount();
                            } else {
                                tIndex = this.geometryArrays[j2].getInitialVertexIndex();
                                count = this.geometryArrays[j2].validVertexCount;
                            }
                            offset = tIndex * stride + k2 * tstride;
                            int tcount = 0;
                            i2 = 0;
                            while (i2 < count) {
                                float[] fArray = this.MtexCoord[k2];
                                int n28 = tcount++;
                                fArray[n28] = (float)((double)fArray[n28] + (double)vdata[offset] * w);
                                float[] fArray6 = this.MtexCoord[k2];
                                int n29 = tcount++;
                                fArray6[n29] = (float)((double)fArray6[n29] + (double)vdata[offset + 1] * w);
                                if ((vFormat & 0x40) != 0) {
                                    float[] fArray7 = this.MtexCoord[k2];
                                    int n30 = tcount++;
                                    fArray7[n30] = (float)((double)fArray7[n30] + (double)vdata[offset + 2] * w);
                                } else if ((vFormat & 0x400) != 0) {
                                    float[] fArray8 = this.MtexCoord[k2];
                                    int n31 = tcount++;
                                    fArray8[n31] = (float)((double)fArray8[n31] + (double)vdata[offset + 2] * w);
                                    float[] fArray9 = this.MtexCoord[k2];
                                    int n32 = tcount++;
                                    fArray9[n32] = (float)((double)fArray9[n32] + (double)vdata[offset + 3] * w);
                                }
                                ++i2;
                                offset += stride;
                            }
                        }
                    }
                    if ((vFormat & 4) != 0) {
                        if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                            cIndex = 0;
                            count = this.geometryArrays[j2].getNumCoordCount();
                        } else {
                            cIndex = this.geometryArrays[j2].getInitialVertexIndex();
                            count = this.geometryArrays[j2].validVertexCount;
                        }
                        offset = cIndex * stride + coffset;
                        i2 = 0;
                        while (i2 < count) {
                            int n33 = cc++;
                            this.Mcolor[n33] = (float)((double)this.Mcolor[n33] + (double)vdata[offset] * w);
                            int n34 = cc++;
                            this.Mcolor[n34] = (float)((double)this.Mcolor[n34] + (double)vdata[offset + 1] * w);
                            int n35 = cc++;
                            this.Mcolor[n35] = (float)((double)this.Mcolor[n35] + (double)vdata[offset + 2] * w);
                            if ((vFormat & 8) != 0) {
                                int n36 = cc++;
                                this.Mcolor[n36] = (float)((double)this.Mcolor[n36] + (double)vdata[offset + 3] * w);
                            }
                            ++i2;
                            offset += stride;
                        }
                    }
                    if ((vFormat & 2) != 0) {
                        if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                            nIndex = 0;
                            count = this.geometryArrays[j2].getNumCoordCount();
                        } else {
                            nIndex = this.geometryArrays[j2].getInitialVertexIndex();
                            count = this.geometryArrays[j2].validVertexCount;
                        }
                        offset = nIndex * stride + noffset;
                        i2 = 0;
                        while (i2 < count) {
                            int n37 = nc++;
                            this.Mnormal[n37] = (float)((double)this.Mnormal[n37] + (double)vdata[offset] * w);
                            int n38 = nc++;
                            this.Mnormal[n38] = (float)((double)this.Mnormal[n38] + (double)vdata[offset + 1] * w);
                            int n39 = nc++;
                            this.Mnormal[n39] = (float)((double)this.Mnormal[n39] + (double)vdata[offset + 2] * w);
                            ++i2;
                            offset += stride;
                        }
                    }
                    if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                        vIndex = 0;
                        count = this.geometryArrays[j2].getNumCoordCount();
                    } else {
                        vIndex = this.geometryArrays[j2].getInitialVertexIndex();
                        count = this.geometryArrays[j2].validVertexCount;
                    }
                    offset = vIndex * stride + voffset;
                    i2 = 0;
                    while (i2 < count) {
                        int n40 = vc++;
                        this.Mcoord[n40] = (float)((double)this.Mcoord[n40] + (double)vdata[offset] * w);
                        int n41 = vc++;
                        this.Mcoord[n41] = (float)((double)this.Mcoord[n41] + (double)vdata[offset + 1] * w);
                        int n42 = vc++;
                        this.Mcoord[n42] = (float)((double)this.Mcoord[n42] + (double)vdata[offset + 2] * w);
                        ++i2;
                        offset += stride;
                    }
                }
            } else {
                float byteToFloatScale = 0.003921569f;
                block40: for (j2 = 0; j2 < this.numGeometryArrays; ++j2) {
                    double w = this.weights[j2];
                    if (w == 0.0) continue;
                    if ((vFormat & 0x460) != 0) {
                        switch (this.geometryArrays[j2].vertexType & 0x7000) {
                            case 4096: {
                                for (k2 = 0; k2 < texCoordSetCount; ++k2) {
                                    float[] tf = this.geometryArrays[j2].getTexCoordRefFloat(k2);
                                    if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                                        tIndex = 0;
                                        count = this.geometryArrays[j2].getNumTexCoordCount(k2);
                                    } else {
                                        tIndex = this.geometryArrays[j2].getInitialTexCoordIndex(k2);
                                        count = this.geometryArrays[j2].validVertexCount;
                                    }
                                    tIndex *= tstride;
                                    int tcount = 0;
                                    for (i2 = 0; i2 < count; ++i2) {
                                        float[] fArray = this.MtexCoord[k2];
                                        int n43 = tcount++;
                                        fArray[n43] = (float)((double)fArray[n43] + (double)tf[tIndex++] * w);
                                        float[] fArray10 = this.MtexCoord[k2];
                                        int n44 = tcount++;
                                        fArray10[n44] = (float)((double)fArray10[n44] + (double)tf[tIndex++] * w);
                                        if ((vFormat & 0x40) == 0) continue;
                                        float[] fArray11 = this.MtexCoord[k2];
                                        int n45 = tcount++;
                                        fArray11[n45] = (float)((double)fArray11[n45] + (double)tf[tIndex++] * w);
                                    }
                                }
                                break;
                            }
                            case 8192: {
                                for (k2 = 0; k2 < texCoordSetCount; ++k2) {
                                    int tcount = 0;
                                    float[] tf = this.geometryArrays[j2].getTexCoordRefFloat(k2);
                                    if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                                        tIndex = 0;
                                        count = this.geometryArrays[j2].getNumTexCoordCount(k2);
                                    } else {
                                        tIndex = this.geometryArrays[j2].getInitialTexCoordIndex(k2);
                                        count = this.geometryArrays[j2].validVertexCount;
                                    }
                                    TexCoord2f[] t2f = this.geometryArrays[j2].getTexCoordRef2f(k2);
                                    i2 = 0;
                                    while (i2 < count) {
                                        float[] fArray = this.MtexCoord[k2];
                                        int n46 = tcount++;
                                        fArray[n46] = (float)((double)fArray[n46] + (double)t2f[tIndex].x * w);
                                        float[] fArray12 = this.MtexCoord[k2];
                                        int n47 = tcount++;
                                        fArray12[n47] = (float)((double)fArray12[n47] + (double)t2f[tIndex].y * w);
                                        ++i2;
                                        ++tIndex;
                                    }
                                }
                                break;
                            }
                            case 16384: {
                                for (k2 = 0; k2 < texCoordSetCount; ++k2) {
                                    int tcount = 0;
                                    TexCoord3f[] t3f = this.geometryArrays[j2].getTexCoordRef3f(k2);
                                    if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                                        tIndex = 0;
                                        count = this.geometryArrays[j2].getNumTexCoordCount(k2);
                                    } else {
                                        tIndex = this.geometryArrays[j2].getInitialTexCoordIndex(k2);
                                        count = this.geometryArrays[j2].validVertexCount;
                                    }
                                    i2 = 0;
                                    while (i2 < count) {
                                        float[] fArray = this.MtexCoord[k2];
                                        int n48 = tcount++;
                                        fArray[n48] = (float)((double)fArray[n48] + (double)t3f[tIndex].x * w);
                                        float[] fArray13 = this.MtexCoord[k2];
                                        int n49 = tcount++;
                                        fArray13[n49] = (float)((double)fArray13[n49] + (double)t3f[tIndex].y * w);
                                        float[] fArray14 = this.MtexCoord[k2];
                                        int n50 = tcount++;
                                        fArray14[n50] = (float)((double)fArray14[n50] + (double)t3f[tIndex].z * w);
                                        ++i2;
                                        ++tIndex;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    if ((vFormat & 4) != 0) {
                        double val = (double)byteToFloatScale * w;
                        if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                            cIndex = 0;
                            count = this.geometryArrays[j2].getNumColorCount();
                        } else {
                            cIndex = this.geometryArrays[j2].getInitialColorIndex();
                            count = this.geometryArrays[j2].validVertexCount;
                        }
                        switch (this.geometryArrays[j2].vertexType & 0x3F0) {
                            case 16: {
                                float[] cf = this.geometryArrays[j2].getColorRefFloat();
                                cc = 0;
                                cIndex *= cstride;
                                for (i2 = 0; i2 < count; ++i2) {
                                    int n51 = cc++;
                                    this.Mcolor[n51] = (float)((double)this.Mcolor[n51] + (double)cf[cIndex++] * w);
                                    int n52 = cc++;
                                    this.Mcolor[n52] = (float)((double)this.Mcolor[n52] + (double)cf[cIndex++] * w);
                                    int n53 = cc++;
                                    this.Mcolor[n53] = (float)((double)this.Mcolor[n53] + (double)cf[cIndex++] * w);
                                    if ((vFormat & 8) == 0) continue;
                                    int n54 = cc++;
                                    this.Mcolor[n54] = (float)((double)this.Mcolor[n54] + (double)cf[cIndex++] * w);
                                }
                                break;
                            }
                            case 32: {
                                byte[] cub = this.geometryArrays[j2].getColorRefByte();
                                cc = 0;
                                cIndex *= cstride;
                                for (i2 = 0; i2 < count; ++i2) {
                                    int n55 = cc++;
                                    this.Mcolor[n55] = (float)((double)this.Mcolor[n55] + (double)(cub[cIndex++] & 0xFF) * val);
                                    int n56 = cc++;
                                    this.Mcolor[n56] = (float)((double)this.Mcolor[n56] + (double)(cub[cIndex++] & 0xFF) * val);
                                    int n57 = cc++;
                                    this.Mcolor[n57] = (float)((double)this.Mcolor[n57] + (double)(cub[cIndex++] & 0xFF) * val);
                                    if ((vFormat & 8) == 0) continue;
                                    int n58 = cc++;
                                    this.Mcolor[n58] = (float)((double)this.Mcolor[n58] + (double)(cub[cIndex++] & 0xFF) * val);
                                }
                                break;
                            }
                            case 64: {
                                Color3f[] c3f = this.geometryArrays[j2].getColorRef3f();
                                cc = 0;
                                i2 = 0;
                                while (i2 < count) {
                                    int n59 = cc++;
                                    this.Mcolor[n59] = (float)((double)this.Mcolor[n59] + (double)c3f[cIndex].x * w);
                                    int n60 = cc++;
                                    this.Mcolor[n60] = (float)((double)this.Mcolor[n60] + (double)c3f[cIndex].y * w);
                                    int n61 = cc++;
                                    this.Mcolor[n61] = (float)((double)this.Mcolor[n61] + (double)c3f[cIndex].z * w);
                                    ++i2;
                                    ++cIndex;
                                }
                                break;
                            }
                            case 128: {
                                Color4f[] c4f = this.geometryArrays[j2].getColorRef4f();
                                cc = 0;
                                i2 = 0;
                                while (i2 < count) {
                                    int n62 = cc++;
                                    this.Mcolor[n62] = (float)((double)this.Mcolor[n62] + (double)c4f[cIndex].x * w);
                                    int n63 = cc++;
                                    this.Mcolor[n63] = (float)((double)this.Mcolor[n63] + (double)c4f[cIndex].y * w);
                                    int n64 = cc++;
                                    this.Mcolor[n64] = (float)((double)this.Mcolor[n64] + (double)c4f[cIndex].z * w);
                                    int n65 = cc++;
                                    this.Mcolor[n65] = (float)((double)this.Mcolor[n65] + (double)c4f[cIndex].w * w);
                                    ++i2;
                                    ++cIndex;
                                }
                                break;
                            }
                            case 256: {
                                Color3b[] c3b = this.geometryArrays[j2].getColorRef3b();
                                cc = 0;
                                i2 = 0;
                                while (i2 < count) {
                                    int n66 = cc++;
                                    this.Mcolor[n66] = (float)((double)this.Mcolor[n66] + (double)(c3b[cIndex].x & 0xFF) * val);
                                    int n67 = cc++;
                                    this.Mcolor[n67] = (float)((double)this.Mcolor[n67] + (double)(c3b[cIndex].y & 0xFF) * val);
                                    int n68 = cc++;
                                    this.Mcolor[n68] = (float)((double)this.Mcolor[n68] + (double)(c3b[cIndex].z & 0xFF) * val);
                                    ++i2;
                                    ++cIndex;
                                }
                                break;
                            }
                            case 512: {
                                Color4b[] c4b = this.geometryArrays[j2].getColorRef4b();
                                cc = 0;
                                i2 = 0;
                                while (i2 < count) {
                                    int n69 = cc++;
                                    this.Mcolor[n69] = (float)((double)this.Mcolor[n69] + (double)(c4b[cIndex].x & 0xFF) * val);
                                    int n70 = cc++;
                                    this.Mcolor[n70] = (float)((double)this.Mcolor[n70] + (double)(c4b[cIndex].y & 0xFF) * val);
                                    int n71 = cc++;
                                    this.Mcolor[n71] = (float)((double)this.Mcolor[n71] + (double)(c4b[cIndex].z & 0xFF) * val);
                                    int n72 = cc++;
                                    this.Mcolor[n72] = (float)((double)this.Mcolor[n72] + (double)(c4b[cIndex].w & 0xFF) * val);
                                    ++i2;
                                    ++cIndex;
                                }
                                break;
                            }
                        }
                    }
                    if ((vFormat & 2) != 0) {
                        nc = 0;
                        if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                            nIndex = 0;
                            count = this.geometryArrays[j2].getNumNormalCount();
                        } else {
                            nIndex = this.geometryArrays[j2].getInitialNormalIndex();
                            count = this.geometryArrays[j2].validVertexCount;
                        }
                        switch (this.geometryArrays[j2].vertexType & 0xC00) {
                            case 1024: {
                                float[] nf = this.geometryArrays[j2].getNormalRefFloat();
                                nIndex *= 3;
                                for (i2 = 0; i2 < count; ++i2) {
                                    int n73 = nc++;
                                    this.Mnormal[n73] = (float)((double)this.Mnormal[n73] + (double)nf[nIndex++] * w);
                                    int n74 = nc++;
                                    this.Mnormal[n74] = (float)((double)this.Mnormal[n74] + (double)nf[nIndex++] * w);
                                    int n75 = nc++;
                                    this.Mnormal[n75] = (float)((double)this.Mnormal[n75] + (double)nf[nIndex++] * w);
                                }
                                break;
                            }
                            case 2048: {
                                Vector3f[] n3f = this.geometryArrays[j2].getNormalRef3f();
                                i2 = 0;
                                while (i2 < count) {
                                    int n76 = nc++;
                                    this.Mnormal[n76] = (float)((double)this.Mnormal[n76] + (double)n3f[nIndex].x * w);
                                    int n77 = nc++;
                                    this.Mnormal[n77] = (float)((double)this.Mnormal[n77] + (double)n3f[nIndex].y * w);
                                    int n78 = nc++;
                                    this.Mnormal[n78] = (float)((double)this.Mnormal[n78] + (double)n3f[nIndex].z * w);
                                    ++i2;
                                    ++nIndex;
                                }
                                break;
                            }
                        }
                    }
                    vc = 0;
                    if (this.geometryArrays[j2] instanceof IndexedGeometryArrayRetained) {
                        vIndex = 0;
                        count = this.geometryArrays[j2].getNumCoordCount();
                    } else {
                        vIndex = this.geometryArrays[j2].getInitialCoordIndex();
                        count = this.geometryArrays[j2].validVertexCount;
                    }
                    switch (this.geometryArrays[j2].vertexType & 0xF) {
                        case 1: {
                            float[] pf = this.geometryArrays[j2].getCoordRefFloat();
                            vIndex *= 3;
                            for (i2 = 0; i2 < count; ++i2) {
                                int n79 = vc++;
                                this.Mcoord[n79] = (float)((double)this.Mcoord[n79] + (double)pf[vIndex++] * w);
                                int n80 = vc++;
                                this.Mcoord[n80] = (float)((double)this.Mcoord[n80] + (double)pf[vIndex++] * w);
                                int n81 = vc++;
                                this.Mcoord[n81] = (float)((double)this.Mcoord[n81] + (double)pf[vIndex++] * w);
                            }
                            continue block40;
                        }
                        case 2: {
                            double[] pd = this.geometryArrays[j2].getCoordRefDouble();
                            vIndex *= 3;
                            for (i2 = 0; i2 < count; ++i2) {
                                int n82 = vc++;
                                this.Mcoord[n82] = (float)((double)this.Mcoord[n82] + (double)((float)pd[vIndex++]) * w);
                                int n83 = vc++;
                                this.Mcoord[n83] = (float)((double)this.Mcoord[n83] + (double)((float)pd[vIndex++]) * w);
                                int n84 = vc++;
                                this.Mcoord[n84] = (float)((double)this.Mcoord[n84] + (double)((float)pd[vIndex++]) * w);
                            }
                            continue block40;
                        }
                        case 4: {
                            Point3f[] p3f = this.geometryArrays[j2].getCoordRef3f();
                            i2 = 0;
                            while (i2 < count) {
                                int n85 = vc++;
                                this.Mcoord[n85] = (float)((double)this.Mcoord[n85] + (double)p3f[vIndex].x * w);
                                int n86 = vc++;
                                this.Mcoord[n86] = (float)((double)this.Mcoord[n86] + (double)p3f[vIndex].y * w);
                                int n87 = vc++;
                                this.Mcoord[n87] = (float)((double)this.Mcoord[n87] + (double)p3f[vIndex].z * w);
                                ++i2;
                                ++vIndex;
                            }
                            continue block40;
                        }
                        case 8: {
                            Point3d[] p3d = this.geometryArrays[j2].getCoordRef3d();
                            i2 = 0;
                            while (i2 < count) {
                                int n88 = vc++;
                                this.Mcoord[n88] = (float)((double)this.Mcoord[n88] + (double)((float)p3d[vIndex].x) * w);
                                int n89 = vc++;
                                this.Mcoord[n89] = (float)((double)this.Mcoord[n89] + (double)((float)p3d[vIndex].y) * w);
                                int n90 = vc++;
                                this.Mcoord[n90] = (float)((double)this.Mcoord[n90] + (double)((float)p3d[vIndex].z) * w);
                                ++i2;
                                ++vIndex;
                            }
                            continue block40;
                        }
                    }
                }
            }
        }
        GeometryArrayRetained mgaR = (GeometryArrayRetained)mga.retained;
        mgaR.setCoordRefFloat(this.Mcoord);
        if ((vFormat & 4) != 0) {
            mgaR.setColorRefFloat(this.Mcolor);
        }
        if ((vFormat & 2) != 0) {
            mgaR.setNormalRefFloat(this.Mnormal);
        }
        if ((vFormat & 0x460) != 0) {
            for (k2 = 0; k2 < texCoordSetCount; ++k2) {
                mgaR.setTexCoordRefFloat(k2, this.MtexCoord[k2]);
            }
        }
    }

    void updateImmediateMirrorObject(Object[] objs) {
        int i2;
        int val;
        Object[] arg;
        int component = (Integer)objs[1];
        Shape3DRetained[] msArr = (Shape3DRetained[])objs[2];
        if ((component & 2) != 0) {
            arg = (Object[])objs[3];
            val = (Integer)arg[1];
            for (i2 = msArr.length - 1; i2 >= 0; --i2) {
                msArr[i2].appearance = (AppearanceRetained)arg[0];
                msArr[i2].changedFrequent = val;
            }
        }
        if ((component & 0x10) != 0) {
            arg = (Object[])objs[3];
            val = (Integer)arg[1];
            System.err.println("ChangedFrequent = " + this.changedFrequent);
            for (i2 = msArr.length - 1; i2 >= 0; --i2) {
                msArr[i2].appearanceOverrideEnable = (Boolean)arg[0];
                msArr[i2].changedFrequent = val;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setLive(SetLiveState s) {
        GeometryAtom ga;
        int m2;
        ArrayList<LeafRetained> l2;
        Shape3DRetained shape;
        int i2;
        ArrayList<Shape3DRetained> msList = new ArrayList<Shape3DRetained>();
        int oldrefCount = this.refCount;
        super.doSetLive(s);
        this.nodeId = this.universe.getNodeId();
        for (i2 = 0; i2 < this.numGeometryArrays; ++i2) {
            Object object = this.geometryArrays[i2].liveStateLock;
            synchronized (object) {
                this.geometryArrays[i2].setLive(this.inBackgroundGroup, s.refCount);
                if (oldrefCount <= 0) {
                    this.geometryArrays[i2].addMorphUser(this);
                }
                continue;
            }
        }
        if (this.morphedGeometryArray == null) {
            this.initMorphedGeometry();
        }
        ((GeometryArrayRetained)this.morphedGeometryArray.retained).setLive(this.inBackgroundGroup, s.refCount);
        if (this.boundsAutoCompute) {
            GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            mga.incrComputeGeoBounds();
            mga.decrComputeGeoBounds();
            this.localBounds.setWithLock(mga.geoBounds);
        }
        if (this.inSharedGroup) {
            for (i2 = 0; i2 < s.keys.length; ++i2) {
                shape = new Shape3DRetained();
                shape.key = s.keys[i2];
                shape.localToVworld = new Transform3D[1][];
                shape.localToVworldIndex = new int[1][];
                int j2 = s.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (j2 < 0) {
                    System.err.println("MorphRetained : Can't find hashKey");
                }
                shape.localToVworld[0] = this.localToVworld[j2];
                shape.localToVworldIndex[0] = this.localToVworldIndex[j2];
                shape.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(j2);
                shape.isPickable = s.pickable[i2];
                shape.isCollidable = s.collidable[i2];
                shape.initMirrorShape3D(s, this, j2);
                this.mirrorShape3D.add(j2, shape);
                msList.add(shape);
                if (s.lights != null && (l2 = s.lights.get(j2)) != null) {
                    for (m2 = 0; m2 < l2.size(); ++m2) {
                        shape.addLight((LightRetained)l2.get(m2));
                    }
                }
                if (s.fogs != null && (l2 = s.fogs.get(j2)) != null) {
                    for (m2 = 0; m2 < l2.size(); ++m2) {
                        shape.addFog((FogRetained)l2.get(m2));
                    }
                }
                if (s.modelClips != null && (l2 = s.modelClips.get(j2)) != null) {
                    for (m2 = 0; m2 < l2.size(); ++m2) {
                        shape.addModelClip((ModelClipRetained)l2.get(m2));
                    }
                }
                if (s.altAppearances != null && (l2 = s.altAppearances.get(j2)) != null) {
                    for (m2 = 0; m2 < l2.size(); ++m2) {
                        shape.addAltApp((AlternateAppearanceRetained)l2.get(m2));
                    }
                }
                shape.viewList = s.viewLists != null ? s.viewLists.get(i2) : null;
                ga = Shape3DRetained.getGeomAtom(shape);
                s.nodeList.add(ga);
                if (s.transformTargets != null && s.transformTargets[i2] != null) {
                    s.transformTargets[i2].addNode(ga, 0);
                }
                if (s.switchTargets != null && s.switchTargets[i2] != null) {
                    s.switchTargets[i2].addNode(shape, 0);
                    shape.closestSwitchParent = s.closestSwitchParents[i2];
                    shape.closestSwitchIndex = s.closestSwitchIndices[i2];
                }
                shape.switchState = s.switchStates.get(j2);
            }
        } else {
            shape = new Shape3DRetained();
            shape.localToVworld = new Transform3D[1][];
            shape.localToVworldIndex = new int[1][];
            shape.localToVworld[0] = this.localToVworld[0];
            shape.localToVworldIndex[0] = this.localToVworldIndex[0];
            shape.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(0);
            shape.isPickable = s.pickable[0];
            shape.isCollidable = s.collidable[0];
            shape.initMirrorShape3D(s, this, 0);
            this.mirrorShape3D.add(shape);
            msList.add(shape);
            if (s.lights != null && (l2 = s.lights.get(0)) != null) {
                for (m2 = 0; m2 < l2.size(); ++m2) {
                    shape.addLight((LightRetained)l2.get(m2));
                }
            }
            if (s.fogs != null && (l2 = s.fogs.get(0)) != null) {
                for (m2 = 0; m2 < l2.size(); ++m2) {
                    shape.addFog((FogRetained)l2.get(m2));
                }
            }
            if (s.modelClips != null && (l2 = s.modelClips.get(0)) != null) {
                for (m2 = 0; m2 < l2.size(); ++m2) {
                    shape.addModelClip((ModelClipRetained)l2.get(m2));
                }
            }
            if (s.altAppearances != null && (l2 = s.altAppearances.get(0)) != null) {
                for (m2 = 0; m2 < l2.size(); ++m2) {
                    shape.addAltApp((AlternateAppearanceRetained)l2.get(m2));
                }
            }
            shape.viewList = s.viewLists != null ? s.viewLists.get(0) : null;
            ga = Shape3DRetained.getGeomAtom(shape);
            s.nodeList.add(ga);
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(ga, 0);
            }
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(shape, 0);
                shape.closestSwitchParent = s.closestSwitchParents[0];
                shape.closestSwitchIndex = s.closestSwitchIndices[0];
            }
            shape.switchState = s.switchStates.get(0);
        }
        if (this.appearance != null) {
            l2 = this.appearance.liveStateLock;
            synchronized (l2) {
                this.appearance.setLive(this.inBackgroundGroup, s.refCount);
                this.appearance.initMirrorObject();
                if (this.appearance.renderingAttributes != null) {
                    this.visible = this.appearance.renderingAttributes.visible;
                }
                for (int k2 = 0; k2 < msList.size(); ++k2) {
                    Shape3DRetained sh = (Shape3DRetained)msList.get(k2);
                    sh.appearance = (AppearanceRetained)this.appearance.mirror;
                    this.appearance.addAMirrorUser(sh);
                }
            }
        } else {
            for (int k3 = 0; k3 < msList.size(); ++k3) {
                Shape3DRetained sh = (Shape3DRetained)msList.get(k3);
                sh.appearance = null;
            }
        }
        s.notifyThreads |= 0x24C0;
        if (this.refCount == 1 && this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
            J3dMessage mChangeMessage = new J3dMessage();
            mChangeMessage.type = 16;
            mChangeMessage.threads = 1024;
            mChangeMessage.args[0] = this;
            mChangeMessage.args[1] = new Integer(1);
            mChangeMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(mChangeMessage);
        }
        super.markAsLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearLive(SetLiveState s) {
        GeometryAtom ga;
        Shape3DRetained shape;
        int i2;
        ArrayList<Shape3DRetained> appList = new ArrayList<Shape3DRetained>();
        super.clearLive(s);
        for (i2 = 0; i2 < this.numGeometryArrays; ++i2) {
            Object object = this.geometryArrays[i2].liveStateLock;
            synchronized (object) {
                this.geometryArrays[i2].clearLive(s.refCount);
                if (this.refCount <= 0) {
                    this.geometryArrays[i2].removeMorphUser(this);
                }
                continue;
            }
        }
        GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
        mga.clearLive(s.refCount);
        if (this.inSharedGroup) {
            Object[] shapes = this.mirrorShape3D.toArray();
            for (i2 = 0; i2 < s.keys.length; ++i2) {
                for (int j2 = 0; j2 < shapes.length; ++j2) {
                    shape = (Shape3DRetained)shapes[j2];
                    if (!shape.key.equals((Object)s.keys[i2])) continue;
                    this.mirrorShape3D.remove(j2);
                    if (s.switchTargets != null && s.switchTargets[i2] != null) {
                        s.switchTargets[i2].addNode(shape, 0);
                    }
                    if (this.appearance != null) {
                        appList.add(shape);
                    }
                    ga = Shape3DRetained.getGeomAtom(shape);
                    s.nodeList.add(ga);
                    if (s.transformTargets == null || s.transformTargets[i2] == null) continue;
                    s.transformTargets[i2].addNode(ga, 0);
                }
            }
        } else {
            shape = (Shape3DRetained)this.mirrorShape3D.get(0);
            this.mirrorShape3D.remove(0);
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(shape, 0);
            }
            if (this.appearance != null) {
                appList.add(shape);
            }
            ga = Shape3DRetained.getGeomAtom(shape);
            s.nodeList.add(ga);
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(ga, 0);
            }
        }
        if (this.appearance != null) {
            Object object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.clearLive(s.refCount);
                for (int k2 = 0; k2 < appList.size(); ++k2) {
                    this.appearance.removeAMirrorUser((Shape3DRetained)appList.get(k2));
                }
            }
        }
        s.notifyThreads |= 0x30C0;
    }

    @Override
    void updatePickable(HashKey[] keys, boolean[] pick) {
        super.updatePickable(keys, pick);
        if (!this.inSharedGroup) {
            Shape3DRetained shape = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape.isPickable = pick[0];
        } else {
            int size = this.mirrorShape3D.size();
            block0: for (int j2 = 0; j2 < keys.length; ++j2) {
                for (int i2 = 0; i2 < size; ++i2) {
                    Shape3DRetained shape = (Shape3DRetained)this.mirrorShape3D.get(i2);
                    if (!keys[j2].equals((Object)shape.key)) continue;
                    shape.isPickable = pick[j2];
                    continue block0;
                }
            }
        }
    }

    @Override
    void updateCollidable(HashKey[] keys, boolean[] collide) {
        super.updateCollidable(keys, collide);
        if (!this.inSharedGroup) {
            Shape3DRetained shape = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape.isCollidable = collide[0];
        } else {
            int size = this.mirrorShape3D.size();
            block0: for (int j2 = 0; j2 < keys.length; ++j2) {
                for (int i2 = 0; i2 < size; ++i2) {
                    Shape3DRetained shape = (Shape3DRetained)this.mirrorShape3D.get(i2);
                    if (!keys[j2].equals((Object)shape.key)) continue;
                    shape.isCollidable = collide[j2];
                    continue block0;
                }
            }
        }
    }

    Shape3DRetained getMirrorShape(SceneGraphPath path) {
        if (!this.inSharedGroup) {
            return (Shape3DRetained)this.mirrorShape3D.get(0);
        }
        HashKey key = new HashKey("");
        path.getHashKey(key);
        return this.getMirrorShape(key);
    }

    Shape3DRetained getMirrorShape(HashKey key) {
        int i2 = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (i2 >= 0) {
            return (Shape3DRetained)this.mirrorShape3D.get(i2);
        }
        throw new RuntimeException("Shape3DRetained: MirrorShape Not found!");
    }

    @Override
    void getMirrorObjects(ArrayList leafList, HashKey key) {
        Shape3DRetained ms = this.inSharedGroup ? this.getMirrorShape(key) : (Shape3DRetained)this.mirrorShape3D.get(0);
        GeometryAtom ga = Shape3DRetained.getGeomAtom(ms);
        leafList.add(ga);
    }

    @Override
    void setBoundsAutoCompute(boolean autoCompute) {
        if (autoCompute != this.boundsAutoCompute) {
            if (autoCompute) {
                this.localBounds = new BoundingBox();
                if (this.source.isLive() && this.morphedGeometryArray != null) {
                    GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
                    mga.incrComputeGeoBounds();
                    mga.decrComputeGeoBounds();
                }
            }
            this.localBounds = this.getBounds();
            super.setBoundsAutoCompute(autoCompute);
            if (this.source.isLive()) {
                J3dMessage message = new J3dMessage();
                message.type = 37;
                message.threads = 8384;
                message.universe = this.universe;
                message.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
                message.args[1] = this.localBounds;
                VirtualUniverse.mc.processMessage(message);
            }
        }
    }

    @Override
    void updateBounds() {
        this.localBounds = this.getEffectiveBounds();
        if (this.source.isLive()) {
            J3dMessage message = new J3dMessage();
            message.type = 37;
            message.threads = 8384;
            message.universe = this.universe;
            message.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            message.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    void initMorphedGeometry() {
        int iCount = 0;
        int numStrips = 0;
        int texCoordSetCount = 0;
        int texCoordSetMapLen = 0;
        int[] texCoordSetMap = null;
        GeometryArrayRetained geo = this.geometryArrays[0];
        int vFormat = (geo.getVertexFormat() | 0x80) & 0xFFFFFEFF;
        texCoordSetCount = geo.getTexCoordSetCount();
        texCoordSetMapLen = geo.getTexCoordSetMapLength();
        if (texCoordSetMapLen > 0) {
            texCoordSetMap = new int[texCoordSetMapLen];
            geo.getTexCoordSetMap(texCoordSetMap);
        }
        int geoType = geo.geoType;
        switch (geoType) {
            case 1: {
                this.morphedGeometryArray = new QuadArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap);
                break;
            }
            case 2: {
                this.morphedGeometryArray = new TriangleArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap);
                break;
            }
            case 3: {
                this.morphedGeometryArray = new PointArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap);
                break;
            }
            case 4: {
                this.morphedGeometryArray = new LineArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap);
                break;
            }
            case 5: {
                numStrips = ((TriangleStripArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((TriangleStripArrayRetained)geo).getStripVertexCounts(stripVCount);
                this.morphedGeometryArray = new TriangleStripArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap, stripVCount);
                break;
            }
            case 6: {
                numStrips = ((TriangleFanArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((TriangleFanArrayRetained)geo).getStripVertexCounts(stripVCount);
                this.morphedGeometryArray = new TriangleFanArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap, stripVCount);
                break;
            }
            case 7: {
                numStrips = ((LineStripArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((LineStripArrayRetained)geo).getStripVertexCounts(stripVCount);
                this.morphedGeometryArray = new LineStripArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap, stripVCount);
                break;
            }
            case 8: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                this.morphedGeometryArray = new IndexedQuadArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount);
                break;
            }
            case 9: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                this.morphedGeometryArray = new IndexedTriangleArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount);
                break;
            }
            case 10: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                this.morphedGeometryArray = new IndexedPointArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount);
                break;
            }
            case 11: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                this.morphedGeometryArray = new IndexedLineArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount);
                break;
            }
            case 12: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                numStrips = ((IndexedTriangleStripArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((IndexedTriangleStripArrayRetained)geo).getStripIndexCounts(stripVCount);
                this.morphedGeometryArray = new IndexedTriangleStripArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount, stripVCount);
                break;
            }
            case 13: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                numStrips = ((IndexedTriangleFanArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((IndexedTriangleFanArrayRetained)geo).getStripIndexCounts(stripVCount);
                this.morphedGeometryArray = new IndexedTriangleFanArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount, stripVCount);
                break;
            }
            case 14: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                numStrips = ((IndexedLineStripArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((IndexedLineStripArrayRetained)geo).getStripIndexCounts(stripVCount);
                this.morphedGeometryArray = new IndexedLineStripArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount, stripVCount);
            }
        }
        if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
            IndexedGeometryArrayRetained igeo = (IndexedGeometryArrayRetained)this.geometryArrays[0];
            IndexedGeometryArray morphedGeo = (IndexedGeometryArray)this.morphedGeometryArray;
            if ((vFormat & 1) != 0) {
                morphedGeo.setCoordinateIndices(0, igeo.indexCoord);
            }
            if ((vFormat & 0x200) == 0) {
                if ((vFormat & 2) != 0) {
                    morphedGeo.setNormalIndices(0, igeo.indexNormal);
                }
                if ((vFormat & 4) != 0) {
                    morphedGeo.setColorIndices(0, igeo.indexColor);
                }
                if ((vFormat & 0x460) != 0) {
                    for (int k2 = 0; k2 < texCoordSetCount; ++k2) {
                        morphedGeo.setTextureCoordinateIndices(k2, 0, igeo.indexTexCoord[k2]);
                    }
                }
            }
        }
        this.morphedGeometryArray.setCapability(19);
        GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
        mga.updateData(this);
    }

    void getMirrorShape3D(ArrayList list, HashKey k2) {
        Shape3DRetained ms = this.inSharedGroup ? this.getMirrorShape(k2) : (Shape3DRetained)this.mirrorShape3D.get(0);
        list.add(ms);
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        compState.keepTG = true;
    }

    void doErrorCheck(GeometryArrayRetained prevGeo, GeometryArrayRetained geo) {
        block12: {
            int k2;
            int[] svc;
            int[] prevSvc;
            block11: {
                int k3;
                if (prevGeo.vertexFormat != geo.vertexFormat || prevGeo.validVertexCount != geo.validVertexCount || prevGeo.geoType != geo.geoType || prevGeo.texCoordSetCount != geo.texCoordSetCount) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                if (geo.getTexCoordSetMapLength() != prevGeo.getTexCoordSetMapLength()) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                int texCoordSetMapLen = geo.getTexCoordSetMapLength();
                prevSvc = prevGeo.texCoordSetMap;
                svc = geo.texCoordSetMap;
                for (k3 = 0; k3 < texCoordSetMapLen; ++k3) {
                    if (prevSvc[k3] == svc[k3]) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                if (!(geo instanceof GeometryStripArrayRetained)) break block11;
                prevSvc = ((GeometryStripArrayRetained)prevGeo).stripVertexCounts;
                svc = ((GeometryStripArrayRetained)geo).stripVertexCounts;
                if (prevSvc.length != svc.length) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                for (k3 = 0; k3 < prevSvc.length; ++k3) {
                    if (prevSvc[k3] == svc[k3]) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                break block12;
            }
            if (!(geo instanceof IndexedGeometryArrayRetained)) break block12;
            if (((IndexedGeometryArrayRetained)prevGeo).validIndexCount != ((IndexedGeometryArrayRetained)geo).validIndexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            if (geo.getNumCoordCount() != prevGeo.getNumCoordCount() || geo.getNumColorCount() != prevGeo.getNumColorCount() || geo.getNumNormalCount() != prevGeo.getNumNormalCount()) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            int texCoordSetCount = geo.getTexCoordSetCount();
            for (k2 = 0; k2 < texCoordSetCount; ++k2) {
                if (geo.getNumTexCoordCount(k2) == prevGeo.getNumTexCoordCount(k2)) continue;
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            if (geo instanceof IndexedGeometryStripArrayRetained) {
                prevSvc = ((IndexedGeometryStripArrayRetained)prevGeo).stripIndexCounts;
                svc = ((IndexedGeometryStripArrayRetained)geo).stripIndexCounts;
                if (prevSvc.length != svc.length) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                for (k2 = 0; k2 < prevSvc.length; ++k2) {
                    if (prevSvc[k2] == svc[k2]) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
            }
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        int mask = 0;
        if (bit == 13) {
            mask = 1;
        } else if (bit == 15) {
            mask = 2;
        } else if (bit == 21) {
            mask = 16;
        }
        if (mask != 0) {
            if (this.source.getCapabilityIsFrequent(bit)) {
                this.changedFrequent |= mask;
            } else if (!this.source.isLive()) {
                this.changedFrequent &= ~mask;
            }
        }
    }

    @Override
    void searchGeometryAtoms(UnorderList list) {
        list.add(Shape3DRetained.getGeomAtom((Shape3DRetained)this.mirrorShape3D.get(0)));
    }
}

