/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Hashtable;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Leaf;
import org.jogamp.java3d.MorphRetained;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PickPoint;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.SceneGraphPath;

public class Morph
extends Leaf {
    public static final int ALLOW_GEOMETRY_ARRAY_READ = 12;
    public static final int ALLOW_GEOMETRY_ARRAY_WRITE = 13;
    public static final int ALLOW_APPEARANCE_READ = 14;
    public static final int ALLOW_APPEARANCE_WRITE = 15;
    public static final int ALLOW_WEIGHTS_READ = 16;
    public static final int ALLOW_WEIGHTS_WRITE = 17;
    public static final int ALLOW_COLLISION_BOUNDS_READ = 18;
    public static final int ALLOW_COLLISION_BOUNDS_WRITE = 19;
    public static final int ALLOW_APPEARANCE_OVERRIDE_READ = 20;
    public static final int ALLOW_APPEARANCE_OVERRIDE_WRITE = 21;
    private static final int[] readCapabilities = new int[]{12, 14, 16, 18, 20};

    Morph() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Morph(GeometryArray[] geometryArrays) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((MorphRetained)this.retained).setGeometryArrays(geometryArrays);
    }

    public Morph(GeometryArray[] geometryArrays, Appearance appearance) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((MorphRetained)this.retained).setGeometryArrays(geometryArrays);
        ((MorphRetained)this.retained).setAppearance(appearance);
    }

    @Override
    void createRetained() {
        this.retained = new MorphRetained();
        this.retained.setSource(this);
    }

    public void setCollisionBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph0"));
        }
        ((MorphRetained)this.retained).setCollisionBounds(bounds);
    }

    public Bounds getCollisionBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph1"));
        }
        return ((MorphRetained)this.retained).getCollisionBounds();
    }

    public void setGeometryArrays(GeometryArray[] geometryArrays) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph2"));
        }
        ((MorphRetained)this.retained).setGeometryArrays(geometryArrays);
    }

    public GeometryArray getGeometryArray(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph3"));
        }
        return ((MorphRetained)this.retained).getGeometryArray(index);
    }

    public void setAppearance(Appearance appearance) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph4"));
        }
        ((MorphRetained)this.retained).setAppearance(appearance);
    }

    public Appearance getAppearance() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph5"));
        }
        return ((MorphRetained)this.retained).getAppearance();
    }

    public boolean intersect(SceneGraphPath path, PickShape pickShape) {
        return this.intersect(path, pickShape, null);
    }

    public boolean intersect(SceneGraphPath path, PickRay pickRay, double[] dist) {
        if (this.isLiveOrCompiled()) {
            this.checkForAllowIntersect();
        }
        return ((MorphRetained)this.retained).intersect(path, (PickShape)pickRay, dist);
    }

    public boolean intersect(SceneGraphPath path, PickShape pickShape, double[] dist) {
        if (this.isLiveOrCompiled()) {
            this.checkForAllowIntersect();
        }
        if (pickShape instanceof PickPoint) {
            throw new IllegalArgumentException(J3dI18N.getString("Morph10"));
        }
        return ((MorphRetained)this.retained).intersect(path, pickShape, dist);
    }

    public void setWeights(double[] weights) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph8"));
        }
        ((MorphRetained)this.retained).setWeights(weights);
    }

    public double[] getWeights() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph9"));
        }
        return ((MorphRetained)this.retained).getWeights();
    }

    public void setAppearanceOverrideEnable(boolean flag) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph11"));
        }
        ((MorphRetained)this.retained).setAppearanceOverrideEnable(flag);
    }

    public boolean getAppearanceOverrideEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph12"));
        }
        return ((MorphRetained)this.retained).getAppearanceOverrideEnable();
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Morph m2 = new Morph();
        m2.duplicateNode(this, forceDuplicate);
        return m2;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        this.checkDuplicateNode(originalNode, forceDuplicate);
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        MorphRetained attr = (MorphRetained)originalNode.retained;
        MorphRetained rt = (MorphRetained)this.retained;
        Hashtable hashtable = originalNode.nodeHashtable;
        double[] weights = attr.getWeights();
        rt.setCollisionBounds(attr.getCollisionBounds());
        rt.setAppearance((Appearance)this.getNodeComponent(attr.getAppearance(), forceDuplicate, hashtable));
        GeometryArray[] ga = new GeometryArray[weights.length];
        for (int i2 = weights.length - 1; i2 >= 0; --i2) {
            ga[i2] = (GeometryArray)this.getNodeComponent(attr.getGeometryArray(i2), forceDuplicate, hashtable);
        }
        rt.setGeometryArrays(ga);
        rt.setWeights(weights);
    }

    private void checkForAllowIntersect() {
        MorphRetained morphR = (MorphRetained)this.retained;
        int numGeometryArrays = morphR.getNumGeometryArrays();
        for (int i2 = 0; i2 < numGeometryArrays; ++i2) {
            if (morphR.geometryArrays[i2].source.getCapability(18)) continue;
            throw new CapabilityNotSetException(J3dI18N.getString("Morph6"));
        }
    }
}

