/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Color3f;

class MaterialRetained
extends NodeComponentRetained {
    Color3f ambientColor = new Color3f(0.2f, 0.2f, 0.2f);
    Color3f emissiveColor = new Color3f(0.0f, 0.0f, 0.0f);
    Color3f diffuseColor = new Color3f(1.0f, 1.0f, 1.0f);
    Color3f specularColor = new Color3f(1.0f, 1.0f, 1.0f);
    float shininess = 64.0f;
    int colorTarget = 2;
    boolean lightingEnable = true;
    static final int AMBIENT_COLOR_CHANGED = 1;
    static final int EMISSIVE_COLOR_CHANGED = 2;
    static final int DIFFUSE_COLOR_CHANGED = 4;
    static final int SPECULAR_COLOR_CHANGED = 8;
    static final int SHININESS_CHANGED = 16;
    static final int ENABLE_CHANGED = 32;
    static final int COLORTARGET_CHANGED = 64;

    MaterialRetained() {
    }

    void createMaterial(Color3f aColor, Color3f eColor, Color3f dColor, Color3f sColor, float shine) {
        this.ambientColor.set(aColor);
        this.emissiveColor.set(eColor);
        this.diffuseColor.set(dColor);
        this.specularColor.set(sColor);
        this.shininess = shine;
    }

    final void initAmbientColor(Color3f color) {
        this.ambientColor.set(color);
    }

    final void setAmbientColor(Color3f color) {
        this.initAmbientColor(color);
        this.sendMessage(1, new Color3f(color));
    }

    final void initAmbientColor(float r, float g2, float b2) {
        this.ambientColor.set(r, g2, b2);
    }

    final void setAmbientColor(float r, float g2, float b2) {
        this.initAmbientColor(r, g2, b2);
        this.sendMessage(1, new Color3f(r, g2, b2));
    }

    final void getAmbientColor(Color3f color) {
        color.set(this.ambientColor);
    }

    final void initEmissiveColor(Color3f color) {
        this.emissiveColor.set(color);
    }

    final void setEmissiveColor(Color3f color) {
        this.initEmissiveColor(color);
        this.sendMessage(2, new Color3f(color));
    }

    final void initEmissiveColor(float r, float g2, float b2) {
        this.emissiveColor.set(r, g2, b2);
    }

    final void setEmissiveColor(float r, float g2, float b2) {
        this.initEmissiveColor(r, g2, b2);
        this.sendMessage(2, new Color3f(r, g2, b2));
    }

    final void getEmissiveColor(Color3f color) {
        color.set(this.emissiveColor);
    }

    final void initDiffuseColor(Color3f color) {
        this.diffuseColor.set(color);
    }

    final void setDiffuseColor(Color3f color) {
        this.initDiffuseColor(color);
        this.sendMessage(4, new Color3f(color));
    }

    final void initDiffuseColor(float r, float g2, float b2) {
        this.diffuseColor.set(r, g2, b2);
    }

    final void setDiffuseColor(float r, float g2, float b2) {
        this.initDiffuseColor(r, g2, b2);
        this.sendMessage(4, new Color3f(r, g2, b2));
    }

    final void initDiffuseColor(float r, float g2, float b2, float a2) {
        this.diffuseColor.set(r, g2, b2);
    }

    final void setDiffuseColor(float r, float g2, float b2, float a2) {
        this.initDiffuseColor(r, g2, b2);
        this.sendMessage(4, new Color3f(r, g2, b2));
    }

    final void getDiffuseColor(Color3f color) {
        color.set(this.diffuseColor);
    }

    final void initSpecularColor(Color3f color) {
        this.specularColor.set(color);
    }

    final void setSpecularColor(Color3f color) {
        this.initSpecularColor(color);
        this.sendMessage(8, new Color3f(color));
    }

    final void initSpecularColor(float r, float g2, float b2) {
        this.specularColor.set(r, g2, b2);
    }

    final void setSpecularColor(float r, float g2, float b2) {
        this.initSpecularColor(r, g2, b2);
        this.sendMessage(8, new Color3f(r, g2, b2));
    }

    final void getSpecularColor(Color3f color) {
        color.set(this.specularColor);
    }

    final void initShininess(float shininess) {
        this.shininess = shininess < 1.0f ? 1.0f : (shininess > 128.0f ? 128.0f : shininess);
    }

    final void setShininess(float shininess) {
        this.initShininess(shininess);
        this.sendMessage(16, new Float(this.shininess));
    }

    final float getShininess() {
        return this.shininess;
    }

    void initLightingEnable(boolean state) {
        this.lightingEnable = state;
    }

    void setLightingEnable(boolean state) {
        this.initLightingEnable(state);
        this.sendMessage(32, state ? Boolean.TRUE : Boolean.FALSE);
    }

    boolean getLightingEnable() {
        return this.lightingEnable;
    }

    void initColorTarget(int colorTarget) {
        this.colorTarget = colorTarget;
    }

    final void setColorTarget(int colorTarget) {
        this.initColorTarget(colorTarget);
        this.sendMessage(64, new Integer(colorTarget));
    }

    final int getColorTarget() {
        return this.colorTarget;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                MaterialRetained mirrorMat = new MaterialRetained();
                mirrorMat.set(this);
                mirrorMat.source = this.source;
                this.mirror = mirrorMat;
            }
        } else {
            ((MaterialRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context ctx, float red, float green, float blue, float alpha, boolean enableLighting) {
        Pipeline.getPipeline().updateMaterial(ctx, red, green, blue, alpha, this.ambientColor.x, this.ambientColor.y, this.ambientColor.z, this.emissiveColor.x, this.emissiveColor.y, this.emissiveColor.z, this.diffuseColor.x, this.diffuseColor.y, this.diffuseColor.z, this.specularColor.x, this.specularColor.y, this.specularColor.z, this.shininess, this.colorTarget, enableLighting);
    }

    @Override
    synchronized void initMirrorObject() {
        MaterialRetained mirrorMaterial = (MaterialRetained)this.mirror;
        mirrorMaterial.set(this);
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        MaterialRetained mirrorMaterial = (MaterialRetained)this.mirror;
        if ((component & 1) != 0) {
            mirrorMaterial.ambientColor = (Color3f)value;
        } else if ((component & 2) != 0) {
            mirrorMaterial.emissiveColor = (Color3f)value;
        } else if ((component & 4) != 0) {
            mirrorMaterial.diffuseColor = (Color3f)value;
        } else if ((component & 8) != 0) {
            mirrorMaterial.specularColor = (Color3f)value;
        } else if ((component & 0x10) != 0) {
            mirrorMaterial.shininess = ((Float)value).floatValue();
        } else if ((component & 0x20) != 0) {
            mirrorMaterial.lightingEnable = (Boolean)value;
        } else if ((component & 0x40) != 0) {
            mirrorMaterial.colorTarget = (Integer)value;
        }
    }

    boolean equivalent(MaterialRetained m2) {
        return m2 != null && this.lightingEnable == m2.lightingEnable && this.diffuseColor.equals(m2.diffuseColor) && this.emissiveColor.equals(m2.emissiveColor) && this.specularColor.equals(m2.specularColor) && this.ambientColor.equals(m2.ambientColor) && this.colorTarget == m2.colorTarget && this.shininess == m2.shininess;
    }

    @Override
    protected Object clone() {
        MaterialRetained mr = (MaterialRetained)super.clone();
        mr.ambientColor = new Color3f(this.ambientColor);
        mr.emissiveColor = new Color3f(this.emissiveColor);
        mr.diffuseColor = new Color3f(this.diffuseColor);
        mr.specularColor = new Color3f(this.specularColor);
        return mr;
    }

    protected void set(MaterialRetained mat) {
        super.set(mat);
        this.ambientColor.set(mat.ambientColor);
        this.emissiveColor.set(mat.emissiveColor);
        this.diffuseColor.set(mat.diffuseColor);
        this.specularColor.set(mat.specularColor);
        this.shininess = mat.shininess;
        this.lightingEnable = mat.lightingEnable;
        this.colorTarget = mat.colorTarget;
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 13;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        int size = univList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 13;
            createMessage.universe = univList.get(i2);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i2);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 1) {
            this.setFrequencyChangeMask(1, 1);
        }
    }
}

