/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.GeometryStripArray;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.LineStripArrayRetained;
import org.jogamp.java3d.NodeComponent;

public class LineStripArray
extends GeometryStripArray {
    LineStripArray() {
    }

    public LineStripArray(int vertexCount, int vertexFormat, int[] stripVertexCounts) {
        super(vertexCount, vertexFormat, stripVertexCounts);
        if (vertexCount < 2) {
            throw new IllegalArgumentException(J3dI18N.getString("LineStripArray0"));
        }
    }

    public LineStripArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int[] stripVertexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, stripVertexCounts);
        if (vertexCount < 2) {
            throw new IllegalArgumentException(J3dI18N.getString("LineStripArray0"));
        }
    }

    public LineStripArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int[] stripVertexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes, stripVertexCounts);
        if (vertexCount < 2) {
            throw new IllegalArgumentException(J3dI18N.getString("LineStripArray0"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new LineStripArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        LineStripArrayRetained rt = (LineStripArrayRetained)this.retained;
        int[] stripcounts = new int[rt.getNumStrips()];
        rt.getStripVertexCounts(stripcounts);
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        LineStripArray l2 = new LineStripArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes, stripcounts);
        l2.duplicateNodeComponent(this);
        return l2;
    }
}

