/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeReferenceTable;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.WakeupOnElapsedFrames;

public abstract class LOD
extends Behavior {
    WakeupOnElapsedFrames wakeupFrame = new WakeupOnElapsedFrames(0, true);
    Vector<Switch> switches = new Vector(5);

    public void addSwitch(Switch switchNode) {
        this.switches.addElement(switchNode);
    }

    public void setSwitch(Switch switchNode, int index) {
        Switch sw = this.getSwitch(index);
        this.switches.setElementAt(switchNode, index);
    }

    public void insertSwitch(Switch switchNode, int index) {
        this.switches.insertElementAt(switchNode, index);
    }

    public void removeSwitch(int index) {
        Switch sw = this.getSwitch(index);
        this.switches.removeElementAt(index);
    }

    public Switch getSwitch(int index) {
        return this.switches.elementAt(index);
    }

    public Iterator<Switch> getAllSwitches() {
        return this.switches.iterator();
    }

    public int numSwitches() {
        return this.switches.size();
    }

    public int indexOfSwitch(Switch switchNode) {
        return this.switches.indexOf(switchNode);
    }

    public void removeSwitch(Switch switchNode) {
        int index = this.switches.indexOf(switchNode);
        if (index >= 0) {
            this.removeSwitch(index);
        }
    }

    public void removeAllSwitches() {
        int numSwitches = this.switches.size();
        for (int index = numSwitches - 1; index >= 0; --index) {
            this.removeSwitch(index);
        }
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        LOD lod = (LOD)originalNode;
        int numSwitch = lod.numSwitches();
        for (int i2 = 0; i2 < numSwitch; ++i2) {
            this.addSwitch(lod.getSwitch(i2));
        }
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        int numSwitch = this.numSwitches();
        for (int i2 = 0; i2 < numSwitch; ++i2) {
            Switch curSwitch = this.getSwitch(i2);
            if (curSwitch == null) continue;
            this.setSwitch((Switch)referenceTable.getNewObjectReference(curSwitch), i2);
        }
    }
}

