/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.SingularMatrixException;
import org.jogamp.vecmath.Tuple4f;
import org.jogamp.vecmath.Vector4f;

class Jogl2es2MatrixUtil {
    double[] result3 = new double[9];
    int[] row_perm3 = new int[3];
    double[] tmp3 = new double[9];
    double[] row_scale3 = new double[3];
    double[] result4 = new double[16];
    int[] row_perm4 = new int[4];
    double[] tmp4 = new double[16];
    double[] row_scale4 = new double[4];
    public double[] deburnV2 = null;
    public Matrix4d deburnV = new Matrix4d();
    public Matrix4d deburnM = new Matrix4d();
    public float[] tempMat9 = new float[9];
    public float[] tempMat12 = new float[12];
    public float[] tempMat16 = new float[16];
    public double[] tempMatD9 = new double[9];
    private Vector4f tmpV4f = new Vector4f();
    private FloatBuffer matFB4x4;
    private FloatBuffer matFB3x3;

    Jogl2es2MatrixUtil() {
    }

    public static void transposeInvert(Matrix3d m2, Matrix3d out) {
        double determinant = m2.determinant();
        if (determinant > 0.0) {
            double invdet = 1.0 / determinant;
            out.m00 = (m2.m11 * m2.m22 - m2.m21 * m2.m12) * invdet;
            out.m10 = -(m2.m01 * m2.m22 - m2.m02 * m2.m21) * invdet;
            out.m20 = (m2.m01 * m2.m12 - m2.m02 * m2.m11) * invdet;
            out.m01 = -(m2.m10 * m2.m22 - m2.m12 * m2.m20) * invdet;
            out.m11 = (m2.m00 * m2.m22 - m2.m02 * m2.m20) * invdet;
            out.m21 = -(m2.m00 * m2.m12 - m2.m10 * m2.m02) * invdet;
            out.m02 = (m2.m10 * m2.m21 - m2.m20 * m2.m11) * invdet;
            out.m12 = -(m2.m00 * m2.m21 - m2.m20 * m2.m01) * invdet;
            out.m22 = (m2.m00 * m2.m11 - m2.m10 * m2.m01) * invdet;
        } else {
            out.setIdentity();
        }
    }

    public static void transposeInvert(Matrix4d m2, Matrix3d out) {
        double determinant = m2.determinant();
        if (determinant > 0.0) {
            double invdet = 1.0 / determinant;
            out.m00 = (m2.m11 * m2.m22 - m2.m21 * m2.m12) * invdet;
            out.m10 = -(m2.m01 * m2.m22 - m2.m02 * m2.m21) * invdet;
            out.m20 = (m2.m01 * m2.m12 - m2.m02 * m2.m11) * invdet;
            out.m01 = -(m2.m10 * m2.m22 - m2.m12 * m2.m20) * invdet;
            out.m11 = (m2.m00 * m2.m22 - m2.m02 * m2.m20) * invdet;
            out.m21 = -(m2.m00 * m2.m12 - m2.m10 * m2.m02) * invdet;
            out.m02 = (m2.m10 * m2.m21 - m2.m20 * m2.m11) * invdet;
            out.m12 = -(m2.m00 * m2.m21 - m2.m20 * m2.m01) * invdet;
            out.m22 = (m2.m00 * m2.m11 - m2.m10 * m2.m01) * invdet;
        } else {
            out.setIdentity();
        }
    }

    final void invertGeneral3(Matrix3d thisM, Matrix3d m1) {
        int i2;
        for (i2 = 0; i2 < 3; ++i2) {
            this.row_perm3[i2] = 0;
        }
        for (i2 = 0; i2 < 9; ++i2) {
            this.result3[i2] = 0.0;
        }
        this.tmp3[0] = m1.m00;
        this.tmp3[1] = m1.m01;
        this.tmp3[2] = m1.m02;
        this.tmp3[3] = m1.m10;
        this.tmp3[4] = m1.m11;
        this.tmp3[5] = m1.m12;
        this.tmp3[6] = m1.m20;
        this.tmp3[7] = m1.m21;
        this.tmp3[8] = m1.m22;
        if (!this.luDecomposition3(this.tmp3, this.row_perm3)) {
            throw new SingularMatrixException("!luDecomposition(tmp, row_perm)");
        }
        this.result3[0] = 1.0;
        this.result3[4] = 1.0;
        this.result3[8] = 1.0;
        this.luBacksubstitution3(this.tmp3, this.row_perm3, this.result3);
        thisM.m00 = this.result3[0];
        thisM.m01 = this.result3[1];
        thisM.m02 = this.result3[2];
        thisM.m10 = this.result3[3];
        thisM.m11 = this.result3[4];
        thisM.m12 = this.result3[5];
        thisM.m20 = this.result3[6];
        thisM.m21 = this.result3[7];
        thisM.m22 = this.result3[8];
    }

    boolean luDecomposition3(double[] matrix0, int[] row_perm) {
        int i2;
        for (i2 = 0; i2 < 3; ++i2) {
            this.row_scale3[i2] = 0.0;
        }
        int ptr = 0;
        int rs = 0;
        i2 = 3;
        while (i2-- != 0) {
            double big = 0.0;
            int j2 = 3;
            while (j2-- != 0) {
                double temp = matrix0[ptr++];
                if (!((temp = Math.abs(temp)) > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                return false;
            }
            this.row_scale4[rs++] = 1.0 / big;
        }
        int mtx = 0;
        for (int j3 = 0; j3 < 3; ++j3) {
            double temp;
            int p1;
            int k2;
            int p2;
            double sum;
            int target;
            int i3;
            for (i3 = 0; i3 < j3; ++i3) {
                target = mtx + 3 * i3 + j3;
                sum = matrix0[target];
                int k3 = i3;
                int p12 = mtx + 3 * i3;
                p2 = mtx + j3;
                while (k3-- != 0) {
                    sum -= matrix0[p12] * matrix0[p2];
                    ++p12;
                    p2 += 3;
                }
                matrix0[target] = sum;
            }
            double big = 0.0;
            int imax = -1;
            for (i3 = j3; i3 < 3; ++i3) {
                double d2;
                target = mtx + 3 * i3 + j3;
                sum = matrix0[target];
                k2 = j3;
                p1 = mtx + 3 * i3;
                p2 = mtx + j3;
                while (k2-- != 0) {
                    sum -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += 3;
                }
                matrix0[target] = sum;
                temp = this.row_scale3[i3] * Math.abs(sum);
                if (!(d2 >= big)) continue;
                big = temp;
                imax = i3;
            }
            if (imax < 0) {
                throw new RuntimeException("imax < 0");
            }
            if (j3 != imax) {
                k2 = 3;
                p1 = mtx + 3 * imax;
                p2 = mtx + 3 * j3;
                while (k2-- != 0) {
                    temp = matrix0[p1];
                    matrix0[p1++] = matrix0[p2];
                    matrix0[p2++] = temp;
                }
                this.row_scale3[imax] = this.row_scale3[j3];
            }
            row_perm[j3] = imax;
            if (matrix0[mtx + 3 * j3 + j3] == 0.0) {
                return false;
            }
            if (j3 == 2) continue;
            temp = 1.0 / matrix0[mtx + 3 * j3 + j3];
            target = mtx + 3 * (j3 + 1) + j3;
            i3 = 2 - j3;
            while (i3-- != 0) {
                int n2 = target;
                matrix0[n2] = matrix0[n2] * temp;
                target += 3;
            }
        }
        return true;
    }

    void luBacksubstitution3(double[] matrix1, int[] row_perm, double[] matrix2) {
        int rp = 0;
        for (int k2 = 0; k2 < 3; ++k2) {
            int rv;
            int cv = k2;
            int ii = -1;
            for (int i2 = 0; i2 < 3; ++i2) {
                int ip = row_perm[rp + i2];
                double sum = matrix2[cv + 3 * ip];
                matrix2[cv + 3 * ip] = matrix2[cv + 3 * i2];
                if (ii >= 0) {
                    rv = i2 * 3;
                    for (int j2 = ii; j2 <= i2 - 1; ++j2) {
                        sum -= matrix1[rv + j2] * matrix2[cv + 3 * j2];
                    }
                } else if (sum != 0.0) {
                    ii = i2;
                }
                matrix2[cv + 3 * i2] = sum;
            }
            rv = 6;
            int n2 = cv + 6;
            matrix2[n2] = matrix2[n2] / matrix1[rv + 2];
            matrix2[cv + 3] = (matrix2[cv + 3] - matrix1[(rv -= 3) + 2] * matrix2[cv + 6]) / matrix1[rv + 1];
            matrix2[cv + 0] = (matrix2[cv + 0] - matrix1[(rv -= 3) + 1] * matrix2[cv + 3] - matrix1[rv + 2] * matrix2[cv + 6]) / matrix1[rv + 0];
        }
    }

    final void invertGeneral4(Matrix4d thisM, Matrix4d m1) {
        int i2;
        for (i2 = 0; i2 < 4; ++i2) {
            this.row_perm4[i2] = 0;
        }
        for (i2 = 0; i2 < 16; ++i2) {
            this.result4[i2] = 0.0;
        }
        this.tmp4[0] = m1.m00;
        this.tmp4[1] = m1.m01;
        this.tmp4[2] = m1.m02;
        this.tmp4[3] = m1.m03;
        this.tmp4[4] = m1.m10;
        this.tmp4[5] = m1.m11;
        this.tmp4[6] = m1.m12;
        this.tmp4[7] = m1.m13;
        this.tmp4[8] = m1.m20;
        this.tmp4[9] = m1.m21;
        this.tmp4[10] = m1.m22;
        this.tmp4[11] = m1.m23;
        this.tmp4[12] = m1.m30;
        this.tmp4[13] = m1.m31;
        this.tmp4[14] = m1.m32;
        this.tmp4[15] = m1.m33;
        if (!this.luDecomposition4(this.tmp4, this.row_perm4)) {
            throw new SingularMatrixException("luDecomposition4(tmp4, row_perm4)");
        }
        this.result4[0] = 1.0;
        this.result4[5] = 1.0;
        this.result4[10] = 1.0;
        this.result4[15] = 1.0;
        this.luBacksubstitution4(this.tmp4, this.row_perm4, this.result4);
        thisM.m00 = this.result4[0];
        thisM.m01 = this.result4[1];
        thisM.m02 = this.result4[2];
        thisM.m03 = this.result4[3];
        thisM.m10 = this.result4[4];
        thisM.m11 = this.result4[5];
        thisM.m12 = this.result4[6];
        thisM.m13 = this.result4[7];
        thisM.m20 = this.result4[8];
        thisM.m21 = this.result4[9];
        thisM.m22 = this.result4[10];
        thisM.m23 = this.result4[11];
        thisM.m30 = this.result4[12];
        thisM.m31 = this.result4[13];
        thisM.m32 = this.result4[14];
        thisM.m33 = this.result4[15];
    }

    boolean luDecomposition4(double[] matrix0, int[] row_perm) {
        int i2;
        for (i2 = 0; i2 < 4; ++i2) {
            this.row_scale4[i2] = 0.0;
        }
        int ptr = 0;
        int rs = 0;
        i2 = 4;
        while (i2-- != 0) {
            double big = 0.0;
            int j2 = 4;
            while (j2-- != 0) {
                double temp = matrix0[ptr++];
                if (!((temp = Math.abs(temp)) > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                return false;
            }
            this.row_scale4[rs++] = 1.0 / big;
        }
        int mtx = 0;
        for (int j3 = 0; j3 < 4; ++j3) {
            double temp;
            int p1;
            int k2;
            int p2;
            double sum;
            int target;
            int i3;
            for (i3 = 0; i3 < j3; ++i3) {
                target = mtx + 4 * i3 + j3;
                sum = matrix0[target];
                int k3 = i3;
                int p12 = mtx + 4 * i3;
                p2 = mtx + j3;
                while (k3-- != 0) {
                    sum -= matrix0[p12] * matrix0[p2];
                    ++p12;
                    p2 += 4;
                }
                matrix0[target] = sum;
            }
            double big = 0.0;
            int imax = -1;
            for (i3 = j3; i3 < 4; ++i3) {
                double d2;
                target = mtx + 4 * i3 + j3;
                sum = matrix0[target];
                k2 = j3;
                p1 = mtx + 4 * i3;
                p2 = mtx + j3;
                while (k2-- != 0) {
                    sum -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += 4;
                }
                matrix0[target] = sum;
                temp = this.row_scale4[i3] * Math.abs(sum);
                if (!(d2 >= big)) continue;
                big = temp;
                imax = i3;
            }
            if (imax < 0) {
                throw new RuntimeException("(imax < 0)");
            }
            if (j3 != imax) {
                k2 = 4;
                p1 = mtx + 4 * imax;
                p2 = mtx + 4 * j3;
                while (k2-- != 0) {
                    temp = matrix0[p1];
                    matrix0[p1++] = matrix0[p2];
                    matrix0[p2++] = temp;
                }
                this.row_scale4[imax] = this.row_scale4[j3];
            }
            row_perm[j3] = imax;
            if (matrix0[mtx + 4 * j3 + j3] == 0.0) {
                return false;
            }
            if (j3 == 3) continue;
            temp = 1.0 / matrix0[mtx + 4 * j3 + j3];
            target = mtx + 4 * (j3 + 1) + j3;
            i3 = 3 - j3;
            while (i3-- != 0) {
                int n2 = target;
                matrix0[n2] = matrix0[n2] * temp;
                target += 4;
            }
        }
        return true;
    }

    void luBacksubstitution4(double[] matrix1, int[] row_perm, double[] matrix2) {
        int rp = 0;
        for (int k2 = 0; k2 < 4; ++k2) {
            int rv;
            int cv = k2;
            int ii = -1;
            for (int i2 = 0; i2 < 4; ++i2) {
                int ip = row_perm[rp + i2];
                double sum = matrix2[cv + 4 * ip];
                matrix2[cv + 4 * ip] = matrix2[cv + 4 * i2];
                if (ii >= 0) {
                    rv = i2 * 4;
                    for (int j2 = ii; j2 <= i2 - 1; ++j2) {
                        sum -= matrix1[rv + j2] * matrix2[cv + 4 * j2];
                    }
                } else if (sum != 0.0) {
                    ii = i2;
                }
                matrix2[cv + 4 * i2] = sum;
            }
            rv = 12;
            int n2 = cv + 12;
            matrix2[n2] = matrix2[n2] / matrix1[rv + 3];
            matrix2[cv + 8] = (matrix2[cv + 8] - matrix1[(rv -= 4) + 3] * matrix2[cv + 12]) / matrix1[rv + 2];
            matrix2[cv + 4] = (matrix2[cv + 4] - matrix1[(rv -= 4) + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 1];
            matrix2[cv + 0] = (matrix2[cv + 0] - matrix1[(rv -= 4) + 1] * matrix2[cv + 4] - matrix1[rv + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 0];
        }
    }

    public final void transform(Matrix4d m2, Tuple4f vecOut) {
        float x = (float)(m2.m00 * (double)vecOut.x + m2.m01 * (double)vecOut.y + m2.m02 * (double)vecOut.z + m2.m03 * (double)vecOut.w);
        float y = (float)(m2.m10 * (double)vecOut.x + m2.m11 * (double)vecOut.y + m2.m12 * (double)vecOut.z + m2.m13 * (double)vecOut.w);
        float z = (float)(m2.m20 * (double)vecOut.x + m2.m21 * (double)vecOut.y + m2.m22 * (double)vecOut.z + m2.m23 * (double)vecOut.w);
        vecOut.w = (float)(m2.m30 * (double)vecOut.x + m2.m31 * (double)vecOut.y + m2.m32 * (double)vecOut.z + m2.m33 * (double)vecOut.w);
        vecOut.x = x;
        vecOut.y = y;
        vecOut.z = z;
    }

    public float[] toArray(Matrix4d m2) {
        this.tempMat16[0] = (float)m2.m00;
        this.tempMat16[1] = (float)m2.m01;
        this.tempMat16[2] = (float)m2.m02;
        this.tempMat16[3] = (float)m2.m03;
        this.tempMat16[4] = (float)m2.m10;
        this.tempMat16[5] = (float)m2.m11;
        this.tempMat16[6] = (float)m2.m12;
        this.tempMat16[7] = (float)m2.m13;
        this.tempMat16[8] = (float)m2.m20;
        this.tempMat16[9] = (float)m2.m21;
        this.tempMat16[10] = (float)m2.m22;
        this.tempMat16[11] = (float)m2.m23;
        this.tempMat16[12] = (float)m2.m30;
        this.tempMat16[13] = (float)m2.m31;
        this.tempMat16[14] = (float)m2.m32;
        this.tempMat16[15] = (float)m2.m33;
        return this.tempMat16;
    }

    public static float[] toArray(Matrix4d m2, float[] a2) {
        a2[0] = (float)m2.m00;
        a2[1] = (float)m2.m01;
        a2[2] = (float)m2.m02;
        a2[3] = (float)m2.m03;
        a2[4] = (float)m2.m10;
        a2[5] = (float)m2.m11;
        a2[6] = (float)m2.m12;
        a2[7] = (float)m2.m13;
        a2[8] = (float)m2.m20;
        a2[9] = (float)m2.m21;
        a2[10] = (float)m2.m22;
        a2[11] = (float)m2.m23;
        a2[12] = (float)m2.m30;
        a2[13] = (float)m2.m31;
        a2[14] = (float)m2.m32;
        a2[15] = (float)m2.m33;
        return a2;
    }

    public float[] toArray(Matrix3d m2) {
        this.tempMat9[0] = (float)m2.m00;
        this.tempMat9[1] = (float)m2.m01;
        this.tempMat9[2] = (float)m2.m02;
        this.tempMat9[3] = (float)m2.m10;
        this.tempMat9[4] = (float)m2.m11;
        this.tempMat9[5] = (float)m2.m12;
        this.tempMat9[6] = (float)m2.m20;
        this.tempMat9[7] = (float)m2.m21;
        this.tempMat9[8] = (float)m2.m22;
        return this.tempMat9;
    }

    public static float[] toArray(Matrix3d m2, float[] a2) {
        a2[0] = (float)m2.m00;
        a2[1] = (float)m2.m01;
        a2[2] = (float)m2.m02;
        a2[3] = (float)m2.m10;
        a2[4] = (float)m2.m11;
        a2[5] = (float)m2.m12;
        a2[6] = (float)m2.m20;
        a2[7] = (float)m2.m21;
        a2[8] = (float)m2.m22;
        return a2;
    }

    public float[] toArray3x4(Matrix3d m2) {
        return Jogl2es2MatrixUtil.toArray3x4(m2, this.tempMat12);
    }

    public static float[] toArray3x4(Matrix3d m2, float[] a2) {
        a2[0] = (float)m2.m00;
        a2[1] = (float)m2.m01;
        a2[2] = (float)m2.m02;
        a2[3] = 0.0f;
        a2[4] = (float)m2.m10;
        a2[5] = (float)m2.m11;
        a2[6] = (float)m2.m12;
        a2[7] = 0.0f;
        a2[8] = (float)m2.m20;
        a2[9] = (float)m2.m21;
        a2[10] = (float)m2.m22;
        a2[11] = 0.0f;
        return a2;
    }

    public double[] toArray3x3(Matrix4d m2) {
        return Jogl2es2MatrixUtil.toArray3x3(m2, this.tempMatD9);
    }

    public static double[] toArray3x3(Matrix4d m2, double[] a2) {
        a2[0] = m2.m00;
        a2[1] = m2.m01;
        a2[2] = m2.m02;
        a2[3] = m2.m10;
        a2[4] = m2.m11;
        a2[5] = m2.m12;
        a2[6] = m2.m20;
        a2[7] = m2.m21;
        a2[8] = m2.m22;
        return a2;
    }

    public void invert(Matrix3d m1) {
        try {
            this.invertGeneral3(m1, m1);
        }
        catch (Exception e2) {
            m1.setIdentity();
        }
    }

    public void invert(Matrix4d m1) {
        try {
            this.invertGeneral4(m1, m1);
        }
        catch (Exception e2) {
            m1.setIdentity();
        }
    }

    public Vector4f transform(Matrix4d m1, Matrix4d m2, float tx, float ty, float tz, float tw) {
        this.tmpV4f.set(tx, ty, tz, tw);
        this.transform(m1, this.tmpV4f);
        this.transform(m2, this.tmpV4f);
        return this.tmpV4f;
    }

    public FloatBuffer toFB4(float[] f2) {
        if (this.matFB4x4 == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(64);
            bb.order(ByteOrder.nativeOrder());
            this.matFB4x4 = bb.asFloatBuffer();
        }
        this.matFB4x4.position(0);
        this.matFB4x4.put(f2);
        this.matFB4x4.position(0);
        return this.matFB4x4;
    }

    public FloatBuffer toFB3(float[] f2) {
        if (this.matFB3x3 == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(64);
            bb.order(ByteOrder.nativeOrder());
            this.matFB3x3 = bb.asFloatBuffer();
        }
        this.matFB3x3.position(0);
        this.matFB3x3.put(f2);
        this.matFB3x3.position(0);
        return this.matFB3x3;
    }

    public FloatBuffer toFB(Matrix4d m2) {
        if (this.matFB4x4 == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(64);
            bb.order(ByteOrder.nativeOrder());
            this.matFB4x4 = bb.asFloatBuffer();
        }
        this.matFB4x4.position(0);
        this.matFB4x4.put(this.toArray(m2));
        this.matFB4x4.position(0);
        return this.matFB4x4;
    }

    public FloatBuffer toFB(Matrix3d m2) {
        if (this.matFB3x3 == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(36);
            bb.order(ByteOrder.nativeOrder());
            this.matFB3x3 = bb.asFloatBuffer();
        }
        this.matFB3x3.position(0);
        this.matFB3x3.put(this.toArray(m2));
        this.matFB3x3.position(0);
        return this.matFB3x3;
    }

    public static float[] transposeInPlace(float[] src) {
        if (src.length == 9) {
            float temp = src[3];
            src[3] = src[1];
            src[1] = temp;
            temp = src[6];
            src[6] = src[2];
            src[2] = temp;
            temp = src[7];
            src[7] = src[5];
            src[5] = temp;
        } else if (src.length == 16) {
            float v1 = src[1];
            float v2 = src[2];
            float v3 = src[3];
            float v6 = src[6];
            float v7 = src[7];
            float v11 = src[11];
            src[1] = src[4];
            src[2] = src[8];
            src[3] = src[12];
            src[4] = v1;
            src[6] = src[9];
            src[7] = src[13];
            src[8] = v2;
            src[9] = v6;
            src[11] = src[14];
            src[12] = v3;
            src[13] = v7;
            src[14] = v11;
        } else {
            throw new UnsupportedOperationException("Only 9 or 16 length float arrays can be transposed!");
        }
        return src;
    }

    public static float halfToFloat(int hbits) {
        int mant = hbits & 0x3FF;
        int exp = hbits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((hbits & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((hbits & 0x8000) << 16 | (exp | mant) << 13);
    }

    public static int halfFromFloat(float fval) {
        int fbits = Float.floatToIntBits(fval);
        int sign = fbits >>> 16 & 0x8000;
        int val = (fbits & Integer.MAX_VALUE) + 4096;
        if (val >= 1199570944) {
            if ((fbits & Integer.MAX_VALUE) >= 1199570944) {
                if (val < 2139095040) {
                    return sign | 0x7C00;
                }
                return sign | 0x7C00 | (fbits & 0x7FFFFF) >>> 13;
            }
            return sign | 0x7BFF;
        }
        if (val >= 0x38800000) {
            return sign | val - 0x38000000 >>> 13;
        }
        if (val < 0x33000000) {
            return sign;
        }
        val = (fbits & Integer.MAX_VALUE) >>> 23;
        return sign | (fbits & 0x7FFFFF | 0x800000) + (0x800000 >>> val - 102) >>> 126 - val;
    }
}

