/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingPolytope;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.IndexedGeometryStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickCone;
import org.jogamp.java3d.PickCylinder;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;

class IndexedTriangleStripArrayRetained
extends IndexedGeometryStripArrayRetained {
    IndexedTriangleStripArrayRetained() {
        this.geoType = 12;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Point3d[] pnts = new Point3d[3];
        double[] sdist = new double[1];
        double minDist = Double.MAX_VALUE;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i2 = 0;
        int count = 0;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        pnts[2] = new Point3d();
        int[] vtxIndexArr = new int[3];
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (i2 < this.stripIndexCounts.length) {
                    for (int k2 = 0; k2 < 2; ++k2) {
                        vtxIndexArr[k2] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[k2]);
                    }
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 2; j2 < scount; ++j2) {
                        vtxIndexArr[2] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[2]);
                        if (this.intersectRay(pnts, pickRay, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                while (i2 < this.stripIndexCounts.length) {
                    for (int k3 = 0; k3 < 2; ++k3) {
                        vtxIndexArr[k3] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[k3]);
                    }
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 2; j2 < scount; ++j2) {
                        vtxIndexArr[2] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[2]);
                        if (this.intersectSegment(pnts, pickSegment.start, pickSegment.end, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 6: {
                BoundingBox bbox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (i2 < this.stripIndexCounts.length) {
                    for (int k4 = 0; k4 < 2; ++k4) {
                        vtxIndexArr[k4] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[k4]);
                    }
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 2; j2 < scount; ++j2) {
                        vtxIndexArr[2] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[2]);
                        if (this.intersectBoundingBox(pnts, bbox, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (i2 < this.stripIndexCounts.length) {
                    for (int k5 = 0; k5 < 2; ++k5) {
                        vtxIndexArr[k5] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[k5]);
                    }
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 2; j2 < scount; ++j2) {
                        vtxIndexArr[2] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[2]);
                        if (this.intersectBoundingSphere(pnts, bsphere, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (i2 < this.stripIndexCounts.length) {
                    for (int k6 = 0; k6 < 2; ++k6) {
                        vtxIndexArr[k6] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[k6]);
                    }
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 2; j2 < scount; ++j2) {
                        vtxIndexArr[2] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[2]);
                        if (this.intersectBoundingPolytope(pnts, bpolytope, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (i2 < this.stripIndexCounts.length) {
                    for (int k7 = 0; k7 < 2; ++k7) {
                        vtxIndexArr[k7] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[k7]);
                    }
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 2; j2 < scount; ++j2) {
                        vtxIndexArr[2] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[2]);
                        if (this.intersectCylinder(pnts, pickCylinder, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (i2 < this.stripIndexCounts.length) {
                    for (int k8 = 0; k8 < 2; ++k8) {
                        vtxIndexArr[k8] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[k8]);
                    }
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 2; j2 < scount; ++j2) {
                        vtxIndexArr[2] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[2]);
                        if (this.intersectCone(pnts, pickCone, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (minDist < Double.MAX_VALUE) {
            iPnt.x = x;
            iPnt.y = y;
            iPnt.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Point3d[] points = new Point3d[3];
        double[] dist = new double[1];
        int i2 = 0;
        int count = 0;
        points[0] = new Point3d();
        points[1] = new Point3d();
        points[2] = new Point3d();
        switch (pnts.length) {
            case 3: {
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], points[0]);
                    this.getVertexData(this.indexCoord[count++], points[1]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 2; j2 < scount; ++j2) {
                        this.getVertexData(this.indexCoord[count++], points[2]);
                        if (this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[1], pnts[2])) {
                            return true;
                        }
                        points[0].set(points[1]);
                        points[1].set(points[2]);
                    }
                }
                break;
            }
            case 4: {
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], points[0]);
                    this.getVertexData(this.indexCoord[count++], points[1]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j3 = 2; j3 < scount; ++j3) {
                        this.getVertexData(this.indexCoord[count++], points[2]);
                        if (this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[1], pnts[2]) || this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[2], pnts[3])) {
                            return true;
                        }
                        points[0].set(points[1]);
                        points[1].set(points[2]);
                    }
                }
                break;
            }
            case 2: {
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], points[0]);
                    this.getVertexData(this.indexCoord[count++], points[1]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j4 = 2; j4 < scount; ++j4) {
                        this.getVertexData(this.indexCoord[count++], points[2]);
                        if (this.intersectSegment(points, pnts[0], pnts[1], dist, null)) {
                            return true;
                        }
                        points[0].set(points[1]);
                        points[1].set(points[2]);
                    }
                }
                break;
            }
            case 1: {
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], points[0]);
                    this.getVertexData(this.indexCoord[count++], points[1]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j5 = 2; j5 < scount; ++j5) {
                        this.getVertexData(this.indexCoord[count++], points[2]);
                        if (this.intersectTriPnt(points[0], points[1], points[2], pnts[0])) {
                            return true;
                        }
                        points[0].set(points[1]);
                        points[1].set(points[2]);
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        int i2 = 0;
        int count = 0;
        Point3d[] pnts = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        while (i2 < this.stripIndexCounts.length) {
            this.getVertexData(this.indexCoord[count++], pnts[0]);
            this.getVertexData(this.indexCoord[count++], pnts[1]);
            thisToOtherVworld.transform(pnts[0]);
            thisToOtherVworld.transform(pnts[1]);
            int scount = this.stripIndexCounts[i2++];
            for (int j2 = 2; j2 < scount; ++j2) {
                this.getVertexData(this.indexCoord[count++], pnts[2]);
                thisToOtherVworld.transform(pnts[2]);
                if (geom.intersect(pnts)) {
                    return true;
                }
                pnts[0].set(pnts[1]);
                pnts[1].set(pnts[2]);
            }
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        int i2 = 0;
        int count = 0;
        Point3d[] pnts = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        switch (targetBound.getPickType()) {
            case 6: {
                BoundingBox box = (BoundingBox)targetBound;
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    this.getVertexData(this.indexCoord[count++], pnts[1]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 2; j2 < scount; ++j2) {
                        this.getVertexData(this.indexCoord[count++], pnts[2]);
                        if (this.intersectBoundingBox(pnts, box, null, null)) {
                            return true;
                        }
                        pnts[0].set(pnts[1]);
                        pnts[1].set(pnts[2]);
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)targetBound;
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    this.getVertexData(this.indexCoord[count++], pnts[1]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j3 = 2; j3 < scount; ++j3) {
                        this.getVertexData(this.indexCoord[count++], pnts[2]);
                        if (this.intersectBoundingSphere(pnts, bsphere, null, null)) {
                            return true;
                        }
                        pnts[0].set(pnts[1]);
                        pnts[1].set(pnts[2]);
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)targetBound;
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    this.getVertexData(this.indexCoord[count++], pnts[1]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j4 = 2; j4 < scount; ++j4) {
                        this.getVertexData(this.indexCoord[count++], pnts[2]);
                        if (this.intersectBoundingPolytope(pnts, bpolytope, null, null)) {
                            return true;
                        }
                        pnts[0].set(pnts[1]);
                        pnts[1].set(pnts[2]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + targetBound);
            }
        }
        return false;
    }

    @Override
    int getClassType() {
        return 3;
    }
}

