/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.IndexedGeometryStripArray;
import org.jogamp.java3d.IndexedLineStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;

public class IndexedLineStripArray
extends IndexedGeometryStripArray {
    IndexedLineStripArray() {
    }

    public IndexedLineStripArray(int vertexCount, int vertexFormat, int indexCount, int[] stripIndexCounts) {
        super(vertexCount, vertexFormat, indexCount, stripIndexCounts);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArray0"));
        }
        if (indexCount < 2) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArray1"));
        }
    }

    public IndexedLineStripArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int indexCount, int[] stripIndexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, indexCount, stripIndexCounts);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArray0"));
        }
        if (indexCount < 2) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArray1"));
        }
    }

    public IndexedLineStripArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int indexCount, int[] stripIndexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes, indexCount, stripIndexCounts);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArray0"));
        }
        if (indexCount < 2) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArray1"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new IndexedLineStripArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        IndexedLineStripArrayRetained rt = (IndexedLineStripArrayRetained)this.retained;
        int[] stripIndexCounts = new int[rt.getNumStrips()];
        rt.getStripIndexCounts(stripIndexCounts);
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        IndexedLineStripArray l2 = new IndexedLineStripArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes, rt.getIndexCount(), stripIndexCounts);
        l2.duplicateNodeComponent(this);
        return l2;
    }
}

