/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.IndexedLineArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;

public class IndexedLineArray
extends IndexedGeometryArray {
    IndexedLineArray() {
    }

    public IndexedLineArray(int vertexCount, int vertexFormat, int indexCount) {
        super(vertexCount, vertexFormat, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray0"));
        }
        if (indexCount < 2 || indexCount % 2 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray1"));
        }
    }

    public IndexedLineArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int indexCount) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray0"));
        }
        if (indexCount < 2 || indexCount % 2 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray1"));
        }
    }

    public IndexedLineArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int indexCount) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray0"));
        }
        if (indexCount < 2 || indexCount % 2 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray1"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new IndexedLineArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        IndexedLineArrayRetained rt = (IndexedLineArrayRetained)this.retained;
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        IndexedLineArray l2 = new IndexedLineArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes, rt.getIndexCount());
        l2.duplicateNodeComponent(this);
        return l2;
    }
}

