/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.AlternateAppearanceRetained;
import org.jogamp.java3d.BHLeafInterface;
import org.jogamp.java3d.BHLeafNode;
import org.jogamp.java3d.BehaviorRetained;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingLeafRetained;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.BranchGroupRetained;
import org.jogamp.java3d.CachedTargets;
import org.jogamp.java3d.CompileState;
import org.jogamp.java3d.FogRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LeafRetained;
import org.jogamp.java3d.LightRetained;
import org.jogamp.java3d.LinkRetained;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.ModelClipRetained;
import org.jogamp.java3d.MorphRetained;
import org.jogamp.java3d.MultipleParentException;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.OrderedGroupRetained;
import org.jogamp.java3d.OrderedPath;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.SharedGroupRetained;
import org.jogamp.java3d.SwitchRetained;
import org.jogamp.java3d.SwitchState;
import org.jogamp.java3d.Targets;
import org.jogamp.java3d.TargetsInterface;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.View;
import org.jogamp.java3d.ViewSpecificGroupRetained;
import org.jogamp.java3d.VirtualUniverse;

class GroupRetained
extends NodeRetained
implements BHLeafInterface {
    ArrayList<NodeRetained> children = new ArrayList(1);
    Bounds collisionBound = null;
    Locale locale = null;
    ArrayList<ArrayList<LightRetained>> lights = null;
    ArrayList<ArrayList<FogRetained>> fogs = null;
    ArrayList<ArrayList<ModelClipRetained>> modelClips = null;
    ArrayList<ArrayList<AlternateAppearanceRetained>> altAppearances = null;
    boolean collisionTarget = false;
    ArrayList<ArrayList<NodeRetained>> childrenSwitchLinks = null;
    int parentSwitchLinkChildIndex = -1;
    ArrayList<OrderedPath> orderedPaths = null;
    BoundingBox collisionVwcBounds;
    ArrayList<GroupRetained> mirrorGroup;
    HashKey key;
    GroupRetained sourceNode;
    BHLeafNode bhLeafNode = null;
    boolean isRoot = false;
    boolean allocatedLights = false;
    boolean allocatedFogs = false;
    boolean allocatedMclips = false;
    boolean allocatedAltApps = false;
    int scopingRefCount = 0;
    ArrayList<NodeRetained> compiledChildrenList = null;
    boolean isInClearLive = false;
    ArrayList<ArrayList<View>> viewLists = null;
    boolean inViewSpecificGroup = false;

    GroupRetained() {
        this.nodeType = 23;
        this.localBounds = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds == null ? null : (Bounds)bounds.clone();
        if (this.source.isLive()) {
            J3dMessage message = new J3dMessage();
            message.type = 34;
            message.threads = 8256;
            message.universe = this.universe;
            message.args[0] = this;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChild(Node child, int index) {
        this.checkValidChild(child, "GroupRetained0");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doSetChild(child, index);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doSetChild(child, index);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doSetChild(Node child, int index) {
        J3dMessage[] messages = null;
        int numMessages = 0;
        int attachStartIndex = 0;
        NodeRetained oldchildr = this.children.get(index);
        if (this.source.isLive()) {
            if (oldchildr != null) {
                numMessages += 3;
                attachStartIndex = 3;
            }
            if (child != null) {
                numMessages += 4;
            }
            messages = new J3dMessage[numMessages];
            for (int i2 = 0; i2 < numMessages; ++i2) {
                messages[i2] = new J3dMessage();
            }
        }
        if (oldchildr != null) {
            oldchildr.setParent(null);
            this.checkClearLive(oldchildr, messages, 0, index, null);
            if (this.source.isLive()) {
                this.universe.notifyStructureChangeListeners(false, (Object)this.source, (BranchGroup)oldchildr.source);
            }
        }
        this.removeChildrenData(index);
        if (child == null) {
            this.children.set(index, null);
            if (messages != null) {
                VirtualUniverse.mc.processMessage(messages);
            }
            return;
        }
        if (this.source.isLive()) {
            this.universe.notifyStructureChangeListeners(true, (Object)this.source, (BranchGroup)child);
        }
        NodeRetained childr = (NodeRetained)child.retained;
        childr.setParent(this);
        this.children.set(index, childr);
        this.insertChildrenData(index);
        this.checkSetLive(childr, index, messages, attachStartIndex, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)childr).isNew = true;
        }
        if (messages != null) {
            VirtualUniverse.mc.processMessage(messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertChild(Node child, int index) {
        this.checkValidChild(child, "GroupRetained1");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.universe.notifyStructureChangeListeners(true, (Object)this.source, (BranchGroup)child);
                this.doInsertChild(child, index);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doInsertChild(child, index);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doInsertChild(Node child, int index) {
        this.insertChildrenData(index);
        for (int i2 = index; i2 < this.children.size(); ++i2) {
            NodeRetained childi = this.children.get(i2);
            if (childi == null) continue;
            ++childi.childIndex;
        }
        if (child == null) {
            this.children.add(index, null);
            return;
        }
        NodeRetained childr = (NodeRetained)child.retained;
        childr.setParent(this);
        this.children.add(index, childr);
        this.checkSetLive(childr, index, null, 0, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)childr).isNew = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(int index) {
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                NodeRetained childr = this.children.get(index);
                this.doRemoveChild(index, null, 0);
                this.universe.setLiveState.clear();
                this.universe.notifyStructureChangeListeners(false, (Object)this.source, (BranchGroup)childr.source);
            }
            this.universe.waitForMC();
        } else {
            this.doRemoveChild(index, null, 0);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    int indexOfChild(Node child) {
        if (child != null) {
            return this.children.indexOf((NodeRetained)child.retained);
        }
        return this.children.indexOf(null);
    }

    void removeChild(Node child) {
        int i2 = this.indexOfChild(child);
        if (i2 >= 0) {
            this.removeChild(i2);
        }
    }

    void removeAllChildren() {
        int n2 = this.children.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.removeChild(i2);
        }
    }

    void doRemoveChild(int index, J3dMessage[] messages, int messageIndex) {
        NodeRetained oldchildr = this.children.get(index);
        int size = this.children.size();
        for (int i2 = index; i2 < size; ++i2) {
            NodeRetained child = this.children.get(i2);
            if (child == null) continue;
            --child.childIndex;
        }
        if (oldchildr != null) {
            oldchildr.setParent(null);
            this.checkClearLive(oldchildr, messages, messageIndex, index, null);
        }
        this.children.remove(index);
        this.removeChildrenData(index);
        if (this.nodeType == 18) {
            SwitchRetained sg = (SwitchRetained)this;
            sg.setWhichChild(sg.whichChild, true);
        }
    }

    Node getChild(int index) {
        NodeRetained sgo = this.children.get(index);
        if (sgo == null) {
            return null;
        }
        return (Node)sgo.source;
    }

    Iterator<Node> getAllChildren() {
        Vector<Node> userChildren = new Vector<Node>(this.children.size());
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            NodeRetained sgo = this.children.get(i2);
            if (sgo != null) {
                userChildren.add((Node)sgo.source);
                continue;
            }
            userChildren.add(null);
        }
        return userChildren.iterator();
    }

    void checkValidChild(Node child, String s) {
        if (child != null && (child instanceof BranchGroup && ((BranchGroupRetained)child.retained).attachedToLocale || ((NodeRetained)child.retained).parent != null)) {
            throw new MultipleParentException(J3dI18N.getString(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(Node child) {
        this.checkValidChild(child, "GroupRetained2");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.universe.notifyStructureChangeListeners(true, (Object)this.source, (BranchGroup)child);
                this.doAddChild(child, null, 0);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doAddChild(child, null, 0);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doAddChild(Node child, J3dMessage[] messages, int messageIndex) {
        this.appendChildrenData();
        if (child == null) {
            this.children.add(null);
            return;
        }
        NodeRetained childr = (NodeRetained)child.retained;
        childr.setParent(this);
        this.children.add(childr);
        this.checkSetLive(childr, this.children.size() - 1, messages, messageIndex, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)childr).isNew = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTo(BranchGroup bg) {
        if (bg != null) {
            ((GroupRetained)bg.retained).dirtyBoundsCache();
        }
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                GroupRetained oldParent = (GroupRetained)((BranchGroupRetained)bg.retained).parent;
                this.doMoveTo(bg);
                this.universe.setLiveState.clear();
                if (oldParent == null) {
                    this.universe.notifyStructureChangeListeners(((BranchGroupRetained)bg.retained).locale, (Object)this.source, bg);
                } else {
                    this.universe.notifyStructureChangeListeners(oldParent.source, (Object)this.source, bg);
                }
            }
            this.universe.waitForMC();
        } else {
            this.doMoveTo(bg);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doMoveTo(BranchGroup branchGroup) {
        J3dMessage[] messages = null;
        int numMessages = 0;
        int detachStartIndex = 0;
        int attachStartIndex = 0;
        if (branchGroup != null) {
            BranchGroupRetained bg = (BranchGroupRetained)branchGroup.retained;
            GroupRetained g2 = (GroupRetained)bg.parent;
            if (g2 != null) {
                if (g2.source.isLive()) {
                    numMessages = 3;
                    attachStartIndex = 3;
                } else {
                    numMessages = 0;
                    attachStartIndex = 0;
                }
            } else {
                numMessages = 3;
                attachStartIndex = 3;
            }
            if (this.source.isLive()) {
                numMessages += 4;
            }
            messages = new J3dMessage[numMessages];
            for (int i2 = 0; i2 < numMessages; ++i2) {
                messages[i2] = new J3dMessage();
                messages[i2].type = -1;
            }
            if (g2 == null) {
                if (bg.locale != null) {
                    bg.locale.doRemoveBranchGraph(branchGroup, messages, detachStartIndex);
                }
            } else {
                g2.doRemoveChild(g2.children.indexOf(bg), messages, detachStartIndex);
            }
        }
        this.doAddChild(branchGroup, messages, attachStartIndex);
        if (numMessages > 0) {
            int count = 0;
            for (int i3 = 0; i3 < numMessages; ++i3) {
                if (messages[i3].type == -1) continue;
                ++count;
            }
            if (count == numMessages) {
                VirtualUniverse.mc.processMessage(messages);
            } else {
                J3dMessage[] ms = null;
                if (count > 0) {
                    ms = new J3dMessage[count];
                }
                int k2 = 0;
                for (int i4 = 0; i4 < numMessages; ++i4) {
                    if (messages[i4].type == -1) continue;
                    ms[k2++] = messages[i4];
                }
                if (ms != null) {
                    VirtualUniverse.mc.processMessage(ms);
                }
            }
        }
    }

    int numChildren() {
        return this.children.size();
    }

    void removeLight(int numLgt, LightRetained[] removelight, HashKey key) {
        block3: {
            block2: {
                if (!this.inSharedGroup) break block2;
                int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                ArrayList<LightRetained> l2 = this.lights.get(hkIndex);
                if (l2 == null) break block3;
                for (int i2 = 0; i2 < numLgt; ++i2) {
                    int index = l2.indexOf(removelight[i2]);
                    l2.remove(index);
                }
                break block3;
            }
            ArrayList<LightRetained> l3 = this.lights.get(0);
            for (int i3 = 0; i3 < numLgt; ++i3) {
                int index = l3.indexOf(removelight[i3]);
                l3.remove(index);
            }
        }
    }

    void addAllNodesForScopedLight(int numLgts, LightRetained[] ml, ArrayList list, HashKey k2) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                k2.set(this.localToVworldKeys[i2]);
                this.processAllNodesForScopedLight(numLgts, ml, list, k2);
            }
        } else {
            this.processAllNodesForScopedLight(numLgts, ml, list, k2);
        }
    }

    void processAllNodesForScopedLight(int numLgts, LightRetained[] ml, ArrayList list, HashKey k2) {
        if (this.allocatedLights) {
            this.addLight(ml, numLgts, k2);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained child = this.children.get(i2);
                if (child == null) continue;
                if (child instanceof GroupRetained && (child.source.isLive() || child.isInSetLive())) {
                    ((GroupRetained)child).processAllNodesForScopedLight(numLgts, ml, list, k2);
                    continue;
                }
                if (child instanceof LinkRetained && (child.source.isLive() || child.isInSetLive())) {
                    int lastCount = k2.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k2.count == 0) {
                        k2.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processAllNodesForScopedLight(numLgts, ml, list, k2.append("+").append(ln.nodeId));
                    k2.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k2);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k2);
            }
        }
    }

    void removeAllNodesForScopedLight(int numLgts, LightRetained[] ml, ArrayList list, HashKey k2) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                k2.set(this.localToVworldKeys[i2]);
                this.processRemoveAllNodesForScopedLight(numLgts, ml, list, k2);
            }
        } else {
            this.processRemoveAllNodesForScopedLight(numLgts, ml, list, k2);
        }
    }

    void processRemoveAllNodesForScopedLight(int numLgts, LightRetained[] ml, ArrayList list, HashKey k2) {
        if (this.allocatedLights) {
            this.removeLight(numLgts, ml, k2);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained child = this.children.get(i2);
                if (child == null) continue;
                if (child instanceof GroupRetained && child.source.isLive() && !((GroupRetained)child).isInClearLive) {
                    ((GroupRetained)child).processRemoveAllNodesForScopedLight(numLgts, ml, list, k2);
                    continue;
                }
                if (child instanceof LinkRetained && child.source.isLive()) {
                    int lastCount = k2.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k2.count == 0) {
                        k2.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processRemoveAllNodesForScopedLight(numLgts, ml, list, k2.append("+").append(ln.nodeId));
                    k2.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k2);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k2);
            }
        }
    }

    void addAllNodesForScopedFog(FogRetained mfog, ArrayList list, HashKey k2) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                k2.set(this.localToVworldKeys[i2]);
                this.processAddNodesForScopedFog(mfog, list, k2);
            }
        } else {
            this.processAddNodesForScopedFog(mfog, list, k2);
        }
    }

    void processAddNodesForScopedFog(FogRetained mfog, ArrayList list, HashKey k2) {
        if (this.allocatedFogs) {
            this.addFog(mfog, k2);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained child = this.children.get(i2);
                if (child == null) continue;
                if (child instanceof GroupRetained && (child.source.isLive() || child.isInSetLive())) {
                    ((GroupRetained)child).processAddNodesForScopedFog(mfog, list, k2);
                    continue;
                }
                if (child instanceof LinkRetained && (child.source.isLive() || child.isInSetLive())) {
                    int lastCount = k2.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k2.count == 0) {
                        k2.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processAddNodesForScopedFog(mfog, list, k2.append("+").append(ln.nodeId));
                    k2.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k2);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k2);
            }
        }
    }

    void removeAllNodesForScopedFog(FogRetained mfog, ArrayList list, HashKey k2) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                k2.set(this.localToVworldKeys[i2]);
                this.processRemoveAllNodesForScopedFog(mfog, list, k2);
            }
        } else {
            this.processRemoveAllNodesForScopedFog(mfog, list, k2);
        }
    }

    void processRemoveAllNodesForScopedFog(FogRetained mfog, ArrayList list, HashKey k2) {
        if (this.allocatedFogs) {
            this.removeFog(mfog, k2);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained child = this.children.get(i2);
                if (child == null) continue;
                if (child instanceof GroupRetained && child.source.isLive() && !((GroupRetained)child).isInClearLive) {
                    ((GroupRetained)child).processRemoveAllNodesForScopedFog(mfog, list, k2);
                    continue;
                }
                if (child instanceof LinkRetained && child.source.isLive()) {
                    int lastCount = k2.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k2.count == 0) {
                        k2.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processRemoveAllNodesForScopedFog(mfog, list, k2.append("+").append(ln.nodeId));
                    k2.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k2);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k2);
            }
        }
    }

    void addAllNodesForScopedModelClip(ModelClipRetained mModelClip, ArrayList list, HashKey k2) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                k2.set(this.localToVworldKeys[i2]);
                this.processAddNodesForScopedModelClip(mModelClip, list, k2);
            }
        } else {
            this.processAddNodesForScopedModelClip(mModelClip, list, k2);
        }
    }

    void processAddNodesForScopedModelClip(ModelClipRetained mModelClip, ArrayList list, HashKey k2) {
        if (this.allocatedMclips) {
            this.addModelClip(mModelClip, k2);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained child = this.children.get(i2);
                if (child == null) continue;
                if (child instanceof GroupRetained && (child.source.isLive() || child.isInSetLive())) {
                    ((GroupRetained)child).processAddNodesForScopedModelClip(mModelClip, list, k2);
                    continue;
                }
                if (child instanceof LinkRetained && (child.source.isLive() || child.isInSetLive())) {
                    int lastCount = k2.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k2.count == 0) {
                        k2.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processAddNodesForScopedModelClip(mModelClip, list, k2.append("+").append(ln.nodeId));
                    k2.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k2);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k2);
            }
        }
    }

    void removeAllNodesForScopedModelClip(ModelClipRetained mModelClip, ArrayList list, HashKey k2) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                k2.set(this.localToVworldKeys[i2]);
                this.processRemoveAllNodesForScopedModelClip(mModelClip, list, k2);
            }
        } else {
            this.processRemoveAllNodesForScopedModelClip(mModelClip, list, k2);
        }
    }

    void processRemoveAllNodesForScopedModelClip(ModelClipRetained mModelClip, ArrayList list, HashKey k2) {
        if (this.allocatedMclips) {
            this.removeModelClip(mModelClip, k2);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained child = this.children.get(i2);
                if (child == null) continue;
                if (child instanceof GroupRetained && child.source.isLive() && !((GroupRetained)child).isInClearLive) {
                    ((GroupRetained)child).processRemoveAllNodesForScopedModelClip(mModelClip, list, k2);
                    continue;
                }
                if (child instanceof LinkRetained && child.source.isLive()) {
                    int lastCount = k2.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k2.count == 0) {
                        k2.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processRemoveAllNodesForScopedModelClip(mModelClip, list, k2.append("+").append(ln.nodeId));
                    k2.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k2);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k2);
            }
        }
    }

    void addAllNodesForScopedAltApp(AlternateAppearanceRetained mAltApp, ArrayList list, HashKey k2) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                k2.set(this.localToVworldKeys[i2]);
                this.processAddNodesForScopedAltApp(mAltApp, list, k2);
            }
        } else {
            this.processAddNodesForScopedAltApp(mAltApp, list, k2);
        }
    }

    void processAddNodesForScopedAltApp(AlternateAppearanceRetained mAltApp, ArrayList list, HashKey k2) {
        if (this.allocatedAltApps) {
            this.addAltApp(mAltApp, k2);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained child = this.children.get(i2);
                if (child == null) continue;
                if (child instanceof GroupRetained && (child.source.isLive() || child.isInSetLive())) {
                    ((GroupRetained)child).processAddNodesForScopedAltApp(mAltApp, list, k2);
                    continue;
                }
                if (child instanceof LinkRetained && child.source.isLive()) {
                    int lastCount = k2.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k2.count == 0) {
                        k2.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processAddNodesForScopedAltApp(mAltApp, list, k2.append("+").append(ln.nodeId));
                    k2.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k2);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k2);
            }
        }
    }

    void removeAllNodesForScopedAltApp(AlternateAppearanceRetained mAltApp, ArrayList list, HashKey k2) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                k2.set(this.localToVworldKeys[i2]);
                this.processRemoveNodesForScopedAltApp(mAltApp, list, k2);
            }
        } else {
            this.processAddNodesForScopedAltApp(mAltApp, list, k2);
        }
    }

    void processRemoveNodesForScopedAltApp(AlternateAppearanceRetained mAltApp, ArrayList list, HashKey k2) {
        if (this.allocatedAltApps) {
            this.removeAltApp(mAltApp, k2);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained child = this.children.get(i2);
                if (child == null) continue;
                if (child instanceof GroupRetained && child.source.isLive() && !((GroupRetained)child).isInClearLive) {
                    ((GroupRetained)child).processRemoveNodesForScopedAltApp(mAltApp, list, k2);
                    continue;
                }
                if (child instanceof LinkRetained && child.source.isLive()) {
                    int lastCount = k2.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k2.count == 0) {
                        k2.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processRemoveNodesForScopedAltApp(mAltApp, list, k2.append("+").append(ln.nodeId));
                    k2.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k2);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k2);
            }
        }
    }

    synchronized void setLightScope() {
        if (!this.allocatedLights) {
            ArrayList newLights;
            this.allocatedLights = true;
            if (this.lights != null) {
                newLights = new ArrayList(this.lights.size());
                int size = this.lights.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    ArrayList<LightRetained> l2 = this.lights.get(i2);
                    if (l2 != null) {
                        newLights.add(new ArrayList<LightRetained>(l2));
                        continue;
                    }
                    newLights.add(null);
                }
            } else if (this.inSharedGroup) {
                newLights = new ArrayList();
                for (int i3 = 0; i3 < this.localToVworldKeys.length; ++i3) {
                    newLights.add(new ArrayList());
                }
            } else {
                newLights = new ArrayList();
                newLights.add(new ArrayList());
            }
            this.lights = newLights;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeLightScope() {
        --this.scopingRefCount;
    }

    synchronized void setFogScope() {
        if (!this.allocatedFogs) {
            ArrayList newFogs;
            this.allocatedFogs = true;
            if (this.fogs != null) {
                newFogs = new ArrayList(this.fogs.size());
                int size = this.fogs.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    ArrayList<FogRetained> l2 = this.fogs.get(i2);
                    if (l2 != null) {
                        newFogs.add(new ArrayList<FogRetained>(l2));
                        continue;
                    }
                    newFogs.add(null);
                }
            } else if (this.inSharedGroup) {
                newFogs = new ArrayList();
                for (int i3 = 0; i3 < this.localToVworldKeys.length; ++i3) {
                    newFogs.add(new ArrayList());
                }
            } else {
                newFogs = new ArrayList();
                newFogs.add(new ArrayList());
            }
            this.fogs = newFogs;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeFogScope() {
        --this.scopingRefCount;
    }

    synchronized void setMclipScope() {
        if (!this.allocatedMclips) {
            ArrayList newMclips;
            this.allocatedMclips = true;
            if (this.modelClips != null) {
                newMclips = new ArrayList(this.modelClips.size());
                int size = this.modelClips.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    ArrayList<ModelClipRetained> l2 = this.modelClips.get(i2);
                    if (l2 != null) {
                        newMclips.add(new ArrayList<ModelClipRetained>(l2));
                        continue;
                    }
                    newMclips.add(null);
                }
            } else if (this.inSharedGroup) {
                newMclips = new ArrayList();
                for (int i3 = 0; i3 < this.localToVworldKeys.length; ++i3) {
                    newMclips.add(new ArrayList());
                }
            } else {
                newMclips = new ArrayList();
                newMclips.add(new ArrayList());
            }
            this.modelClips = newMclips;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeMclipScope() {
        --this.scopingRefCount;
    }

    synchronized void setAltAppScope() {
        if (!this.allocatedAltApps) {
            ArrayList newAltApps;
            this.allocatedAltApps = true;
            if (this.altAppearances != null) {
                newAltApps = new ArrayList(this.altAppearances.size());
                int size = this.altAppearances.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    ArrayList<AlternateAppearanceRetained> l2 = this.altAppearances.get(i2);
                    if (l2 != null) {
                        newAltApps.add(new ArrayList<AlternateAppearanceRetained>(l2));
                        continue;
                    }
                    newAltApps.add(null);
                }
            } else if (this.inSharedGroup) {
                newAltApps = new ArrayList();
                for (int i3 = 0; i3 < this.localToVworldKeys.length; ++i3) {
                    newAltApps.add(new ArrayList());
                }
            } else {
                newAltApps = new ArrayList();
                newAltApps.add(new ArrayList());
            }
            this.altAppearances = newAltApps;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeAltAppScope() {
        --this.scopingRefCount;
    }

    synchronized boolean usedInScoping() {
        return this.scopingRefCount > 0;
    }

    void addLight(LightRetained[] addlight, int numLgts, HashKey key) {
        block3: {
            block2: {
                if (!this.inSharedGroup) break block2;
                int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                ArrayList<LightRetained> l2 = this.lights.get(hkIndex);
                if (l2 == null) break block3;
                for (int i2 = 0; i2 < numLgts; ++i2) {
                    l2.add(addlight[i2]);
                }
                break block3;
            }
            ArrayList<LightRetained> l3 = this.lights.get(0);
            for (int i3 = 0; i3 < numLgts; ++i3) {
                l3.add(addlight[i3]);
            }
        }
    }

    void addFog(FogRetained fog, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<FogRetained> l2 = this.fogs.get(hkIndex);
            if (l2 != null) {
                l2.add(fog);
            }
        } else {
            ArrayList<FogRetained> l3 = this.fogs.get(0);
            l3.add(fog);
        }
    }

    void addModelClip(ModelClipRetained modelClip, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<ModelClipRetained> l2 = this.modelClips.get(hkIndex);
            if (l2 != null) {
                l2.add(modelClip);
            }
        } else {
            ArrayList<ModelClipRetained> l3 = this.modelClips.get(0);
            l3.add(modelClip);
        }
    }

    void addAltApp(AlternateAppearanceRetained altApp, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<AlternateAppearanceRetained> l2 = this.altAppearances.get(hkIndex);
            if (l2 != null) {
                l2.add(altApp);
            }
        } else {
            ArrayList<AlternateAppearanceRetained> l3 = this.altAppearances.get(0);
            l3.add(altApp);
        }
    }

    void removeFog(FogRetained fog, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<FogRetained> l2 = this.fogs.get(hkIndex);
            if (l2 != null) {
                int index = l2.indexOf(fog);
                l2.remove(index);
            }
        } else {
            ArrayList<FogRetained> l3 = this.fogs.get(0);
            int index = l3.indexOf(fog);
            l3.remove(index);
        }
    }

    void removeModelClip(ModelClipRetained modelClip, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<ModelClipRetained> l2 = this.modelClips.get(hkIndex);
            if (l2 != null) {
                int index = l2.indexOf(modelClip);
                l2.remove(index);
            }
        } else {
            ArrayList<ModelClipRetained> l3 = this.modelClips.get(0);
            int index = l3.indexOf(modelClip);
            l3.remove(index);
        }
    }

    void removeAltApp(AlternateAppearanceRetained altApp, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<AlternateAppearanceRetained> l2 = this.altAppearances.get(hkIndex);
            if (l2 != null) {
                int index = l2.indexOf(altApp);
                l2.remove(index);
            }
        } else {
            ArrayList<AlternateAppearanceRetained> l3 = this.altAppearances.get(0);
            int index = l3.indexOf(altApp);
            l3.remove(index);
        }
    }

    @Override
    void updatePickable(HashKey[] keys, boolean[] pick) {
        NodeRetained child;
        int numChildLessOne = this.children.size() - 1;
        super.updatePickable(keys, pick);
        int i2 = 0;
        if (numChildLessOne < 0) {
            return;
        }
        for (i2 = 0; i2 < numChildLessOne; ++i2) {
            child = this.children.get(i2);
            if (child == null) continue;
            child.updatePickable(keys, (boolean[])pick.clone());
        }
        child = this.children.get(i2);
        if (child != null) {
            child.updatePickable(keys, pick);
        }
    }

    @Override
    void updateCollidable(HashKey[] keys, boolean[] collide) {
        NodeRetained child;
        int numChildLessOne = this.children.size() - 1;
        super.updateCollidable(keys, collide);
        int i2 = 0;
        if (numChildLessOne < 0) {
            return;
        }
        for (i2 = 0; i2 < numChildLessOne; ++i2) {
            child = this.children.get(i2);
            if (child == null) continue;
            child.updateCollidable(keys, (boolean[])collide.clone());
        }
        child = this.children.get(i2);
        if (child != null) {
            child.updateCollidable(keys, collide);
        }
    }

    void setAlternateCollisionTarget(boolean target) {
        if (this.collisionTarget == target) {
            return;
        }
        this.collisionTarget = target;
        if (this.source.isLive()) {
            J3dMessage message = new J3dMessage();
            message.threads = 64;
            message.universe = this.universe;
            CachedTargets[] newCtArr = null;
            if (target) {
                this.createMirrorGroup();
                TargetsInterface ti = this.getClosestTargetsInterface(0);
                if (ti != null) {
                    Targets targets = new Targets();
                    int numPath = this.mirrorGroup.size();
                    newCtArr = new CachedTargets[numPath];
                    for (int i2 = 0; i2 < numPath; ++i2) {
                        CachedTargets ct = ti.getCachedTargets(0, i2, -1);
                        if (ct != null) {
                            targets.addNode(this.mirrorGroup.get(i2), 6);
                            newCtArr[i2] = targets.snapShotAdd(ct);
                            continue;
                        }
                        newCtArr[i2] = null;
                    }
                    ti.updateTargetThreads(0, newCtArr);
                    ti.resetCachedTargets(0, newCtArr, -1);
                }
                message.type = 0;
                message.args[0] = this.mirrorGroup.toArray();
                message.args[1] = ti;
                message.args[2] = newCtArr;
            } else {
                TargetsInterface ti = this.getClosestTargetsInterface(0);
                if (ti != null) {
                    Targets targets = new Targets();
                    int numPath = this.mirrorGroup.size();
                    newCtArr = new CachedTargets[numPath];
                    for (int i3 = 0; i3 < numPath; ++i3) {
                        CachedTargets ct = ti.getCachedTargets(0, i3, -1);
                        if (ct != null) {
                            targets.addNode(this.mirrorGroup.get(i3), 6);
                            newCtArr[i3] = targets.snapShotRemove(ct);
                            continue;
                        }
                        newCtArr[i3] = null;
                    }
                    ti.updateTargetThreads(0, newCtArr);
                    ti.resetCachedTargets(0, newCtArr, -1);
                }
                message.type = 1;
                message.args[0] = this.mirrorGroup.toArray();
                message.args[1] = ti;
                message.args[2] = newCtArr;
                this.mirrorGroup = null;
            }
            VirtualUniverse.mc.processMessage(message);
        }
    }

    boolean getAlternateCollisionTarget() {
        return this.collisionTarget;
    }

    void checkSetLive(NodeRetained child, int childIndex, J3dMessage[] messages, int messageIndex, NodeRetained linkNode) {
        this.checkSetLive(child, childIndex, this.localToVworldKeys, this.inSharedGroup, messages, messageIndex, linkNode);
    }

    void checkSetLive(NodeRetained child, int childIndex, HashKey[] keys, boolean isShared, J3dMessage[] messages, int messageIndex, NodeRetained linkNode) {
        SceneGraphObject me = this.source;
        boolean sendMessages = false;
        boolean sendOGMessage = true;
        boolean sendVSGMessage = true;
        if (me.isLive()) {
            J3dMessage createMessage;
            boolean[] collide;
            boolean[] pick;
            SetLiveState s = this.universe.setLiveState;
            s.reset(this.locale);
            s.refCount = this.refCount;
            s.inSharedGroup = isShared;
            s.inBackgroundGroup = this.inBackgroundGroup;
            s.inViewSpecificGroup = this.inViewSpecificGroup;
            s.geometryBackground = this.geometryBackground;
            s.keys = keys;
            s.viewLists = this.viewLists;
            s.parentBranchGroupPaths = this.branchGroupPaths;
            s.branchGroupPaths = new ArrayList(this.branchGroupPaths);
            s.orderedPaths = this.orderedPaths;
            s.lights = this.lights;
            s.altAppearances = this.altAppearances;
            s.fogs = this.fogs;
            s.modelClips = this.modelClips;
            if (!this.inSharedGroup) {
                pick = new boolean[1];
                collide = new boolean[1];
            } else {
                pick = new boolean[this.localToVworldKeys.length];
                collide = new boolean[this.localToVworldKeys.length];
            }
            this.findPickableFlags(pick);
            super.updatePickable(null, pick);
            s.pickable = pick;
            this.findCollidableFlags(collide);
            super.updateCollidable(null, collide);
            s.collidable = collide;
            TargetsInterface transformInterface = this.initTransformStates(s, true);
            TargetsInterface switchInterface = this.initSwitchStates(s, this, child, linkNode, true);
            if (s.inViewSpecificGroup && s.changedViewGroup == null) {
                s.changedViewGroup = new ArrayList();
                s.changedViewList = new ArrayList();
                s.keyList = new int[10];
                s.viewScopedNodeList = new ArrayList();
                s.scopedNodesViewList = new ArrayList();
            }
            this.childCheckSetLive(child, childIndex, s, linkNode);
            CachedTargets[] newCtArr = null;
            newCtArr = this.updateTransformStates(s, transformInterface, true);
            this.updateSwitchStates(s, switchInterface, true);
            if (messages == null) {
                int numMessages = 2;
                if (s.ogList.size() > 0) {
                    ++numMessages;
                } else {
                    sendOGMessage = false;
                }
                if (s.changedViewGroup != null) {
                    ++numMessages;
                } else {
                    sendVSGMessage = false;
                }
                messages = new J3dMessage[numMessages];
                messageIndex = 0;
                for (int mIndex = 0; mIndex < numMessages; ++mIndex) {
                    messages[mIndex] = new J3dMessage();
                }
                sendMessages = true;
            }
            if (sendOGMessage) {
                createMessage = messages[messageIndex++];
                createMessage.threads = 4224;
                createMessage.type = 32;
                createMessage.universe = this.universe;
                createMessage.args[0] = s.ogList.toArray();
                createMessage.args[1] = s.ogChildIdList.toArray();
                createMessage.args[2] = s.ogOrderedIdList.toArray();
                createMessage.args[3] = s.ogCIOList.toArray();
                createMessage.args[4] = s.ogCIOTableList.toArray();
            }
            if (sendVSGMessage) {
                createMessage = messages[messageIndex++];
                createMessage.threads = 4096;
                createMessage.type = 57;
                createMessage.universe = this.universe;
                createMessage.args[0] = s.changedViewGroup;
                createMessage.args[1] = s.changedViewList;
                createMessage.args[2] = s.keyList;
            }
            createMessage = messages[messageIndex++];
            createMessage.threads = s.notifyThreads;
            createMessage.type = 0;
            createMessage.universe = this.universe;
            createMessage.args[0] = s.nodeList.toArray();
            if (newCtArr != null) {
                createMessage.args[1] = transformInterface;
                createMessage.args[2] = newCtArr;
            } else {
                createMessage.args[1] = null;
                createMessage.args[2] = null;
            }
            if (s.viewScopedNodeList != null) {
                createMessage.args[3] = s.viewScopedNodeList;
                createMessage.args[4] = s.scopedNodesViewList;
            }
            int sz = s.behaviorNodes.size();
            for (int i2 = 0; i2 < sz; ++i2) {
                BehaviorRetained b2 = s.behaviorNodes.get(i2);
                b2.executeInitialize();
            }
            s.behaviorNodes.clear();
            createMessage = messages[messageIndex++];
            createMessage.threads = 256;
            createMessage.type = 49;
            createMessage.universe = this.universe;
            if (sendMessages) {
                VirtualUniverse.mc.processMessage(messages);
            }
            if (this.nodeType == 18) {
                SwitchRetained sw = (SwitchRetained)this;
                sw.setWhichChild(sw.whichChild, true);
            }
            s.reset(null);
        }
    }

    void checkClearLive(NodeRetained child, J3dMessage[] messages, int messageIndex, int childIndex, NodeRetained linkNode) {
        this.checkClearLive(child, this.localToVworldKeys, this.inSharedGroup, messages, messageIndex, childIndex, linkNode);
    }

    void checkClearLive(NodeRetained child, HashKey[] keys, boolean isShared, J3dMessage[] messages, int messageIndex, int childIndex, NodeRetained linkNode) {
        SceneGraphObject me = this.source;
        boolean sendMessages = false;
        boolean sendOGMessage = true;
        boolean sendVSGMessage = true;
        if (me.isLive()) {
            J3dMessage destroyMessage;
            SetLiveState s = this.universe.setLiveState;
            s.reset(this.locale);
            s.refCount = this.refCount;
            s.inSharedGroup = isShared;
            s.inBackgroundGroup = this.inBackgroundGroup;
            s.inViewSpecificGroup = this.inViewSpecificGroup;
            s.keys = keys;
            s.fogs = this.fogs;
            s.lights = this.lights;
            s.altAppearances = this.altAppearances;
            s.modelClips = this.modelClips;
            if (s.inViewSpecificGroup && s.changedViewGroup == null) {
                s.changedViewGroup = new ArrayList();
                s.changedViewList = new ArrayList();
                s.keyList = new int[10];
                s.viewScopedNodeList = new ArrayList();
                s.scopedNodesViewList = new ArrayList();
            }
            if (this instanceof OrderedGroupRetained && linkNode == null) {
                OrderedGroupRetained og = (OrderedGroupRetained)this;
                s.ogList.add(og);
                s.ogChildIdList.add(new Integer(childIndex));
                s.ogCIOList.add(og);
                int[] newArr = null;
                if (og.userChildIndexOrder != null) {
                    newArr = new int[og.userChildIndexOrder.length];
                    System.arraycopy(og.userChildIndexOrder, 0, newArr, 0, og.userChildIndexOrder.length);
                }
                s.ogCIOTableList.add(newArr);
            }
            s.viewLists = this.viewLists;
            TargetsInterface transformInterface = this.initTransformStates(s, false);
            TargetsInterface switchInterface = this.initSwitchStates(s, this, child, linkNode, false);
            child.clearLive(s);
            CachedTargets[] newCtArr = null;
            newCtArr = this.updateTransformStates(s, transformInterface, false);
            this.updateSwitchStates(s, switchInterface, false);
            if (messages == null) {
                int numMessages = 1;
                if (s.ogList.size() > 0) {
                    ++numMessages;
                } else {
                    sendOGMessage = false;
                }
                if (s.changedViewGroup != null) {
                    ++numMessages;
                } else {
                    sendVSGMessage = false;
                }
                messages = new J3dMessage[numMessages];
                messageIndex = 0;
                for (int mIndex = 0; mIndex < numMessages; ++mIndex) {
                    messages[mIndex] = new J3dMessage();
                }
                sendMessages = true;
            }
            if (sendOGMessage) {
                destroyMessage = messages[messageIndex++];
                destroyMessage.threads = 4224;
                destroyMessage.type = 33;
                destroyMessage.universe = this.universe;
                destroyMessage.args[0] = s.ogList.toArray();
                destroyMessage.args[1] = s.ogChildIdList.toArray();
                destroyMessage.args[3] = s.ogCIOList.toArray();
                destroyMessage.args[4] = s.ogCIOTableList.toArray();
            }
            destroyMessage = messages[messageIndex++];
            destroyMessage.threads = s.notifyThreads;
            destroyMessage.type = 1;
            destroyMessage.universe = this.universe;
            destroyMessage.args[0] = s.nodeList.toArray();
            if (newCtArr != null) {
                destroyMessage.args[1] = transformInterface;
                destroyMessage.args[2] = newCtArr;
            } else {
                destroyMessage.args[1] = null;
                destroyMessage.args[2] = null;
            }
            if (s.viewScopedNodeList != null) {
                destroyMessage.args[3] = s.viewScopedNodeList;
                destroyMessage.args[4] = s.scopedNodesViewList;
            }
            if (sendVSGMessage) {
                destroyMessage = messages[messageIndex++];
                destroyMessage.threads = 4096;
                destroyMessage.type = 58;
                destroyMessage.universe = this.universe;
                destroyMessage.args[0] = s.changedViewGroup;
                destroyMessage.args[1] = s.keyList;
            }
            if (sendMessages) {
                VirtualUniverse.mc.processMessage(messages);
            }
            s.reset(null);
        }
    }

    TargetsInterface initTransformStates(SetLiveState s, boolean isSetLive) {
        int numPaths = this.inSharedGroup ? s.keys.length : 1;
        TargetsInterface ti = this.getClosestTargetsInterface(0);
        if (isSetLive) {
            s.currentTransforms = this.localToVworld;
            s.currentTransformsIndex = this.localToVworldIndex;
            s.localToVworldKeys = this.localToVworldKeys;
            s.localToVworld = s.currentTransforms;
            s.localToVworldIndex = s.currentTransformsIndex;
            s.parentTransformLink = this.parentTransformLink;
            if (this.parentTransformLink != null) {
                if (this.parentTransformLink instanceof TransformGroupRetained) {
                    TransformGroupRetained tg = (TransformGroupRetained)this.parentTransformLink;
                    s.childTransformLinks = tg.childTransformLinks;
                } else {
                    SharedGroupRetained sg = (SharedGroupRetained)this.parentTransformLink;
                    s.childTransformLinks = sg.childTransformLinks;
                }
            }
        }
        int[] transformLevels = new int[numPaths];
        this.findTransformLevels(transformLevels);
        s.transformLevels = transformLevels;
        if (ti != null) {
            Targets[] newTargets = new Targets[numPaths];
            for (int i2 = 0; i2 < numPaths; ++i2) {
                newTargets[i2] = s.transformLevels[i2] >= 0 ? new Targets() : null;
            }
            s.transformTargets = newTargets;
        }
        return ti;
    }

    CachedTargets[] updateTransformStates(SetLiveState s, TargetsInterface ti, boolean isSetLive) {
        CachedTargets[] newCtArr = null;
        if (ti != null) {
            if (isSetLive) {
                boolean newTargetThreads = false;
                newCtArr = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (s.transformTargets[0] != null) {
                        CachedTargets ct = ti.getCachedTargets(0, 0, -1);
                        if (ct != null) {
                            newCtArr[0] = s.transformTargets[0].snapShotAdd(ct);
                        }
                    } else {
                        newCtArr[0] = null;
                    }
                } else {
                    for (int i2 = 0; i2 < s.keys.length; ++i2) {
                        if (s.transformTargets[i2] != null) {
                            CachedTargets ct = ti.getCachedTargets(0, i2, -1);
                            if (ct == null) continue;
                            newCtArr[i2] = s.transformTargets[i2].snapShotAdd(ct);
                            continue;
                        }
                        newCtArr[i2] = null;
                    }
                }
            } else {
                newCtArr = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (s.transformTargets[0] != null) {
                        CachedTargets ct = ti.getCachedTargets(0, 0, -1);
                        if (ct != null) {
                            newCtArr[0] = s.transformTargets[0].snapShotRemove(ct);
                        }
                    } else {
                        newCtArr[0] = null;
                    }
                } else {
                    for (int i3 = 0; i3 < s.keys.length; ++i3) {
                        if (s.transformTargets[i3] != null) {
                            CachedTargets ct = ti.getCachedTargets(0, i3, -1);
                            if (ct == null) continue;
                            newCtArr[i3] = s.transformTargets[i3].snapShotRemove(ct);
                            continue;
                        }
                        newCtArr[i3] = null;
                    }
                }
            }
            ti.updateTargetThreads(0, newCtArr);
            ti.resetCachedTargets(0, newCtArr, -1);
        }
        return newCtArr;
    }

    TargetsInterface initSwitchStates(SetLiveState s, NodeRetained parentNode, NodeRetained childNode, NodeRetained linkNode, boolean isSetLive) {
        int i2;
        this.findSwitchInfo(s, parentNode, childNode, linkNode);
        TargetsInterface ti = this.getClosestTargetsInterface(1);
        if (ti != null) {
            Targets[] newTargets = null;
            int numPaths = this.inSharedGroup ? s.keys.length : 1;
            newTargets = new Targets[numPaths];
            for (i2 = 0; i2 < numPaths; ++i2) {
                newTargets[i2] = s.switchLevels[i2] >= 0 ? new Targets() : null;
            }
            s.switchTargets = newTargets;
        }
        if (isSetLive) {
            if (this.nodeType == 18) {
                i2 = this.parentSwitchLinkChildIndex;
                s.childSwitchLinks = this.childrenSwitchLinks.get(i2);
                s.parentSwitchLink = this;
            } else if (this.nodeType == 22) {
                i2 = this.parentSwitchLinkChildIndex;
                s.childSwitchLinks = this.childrenSwitchLinks.get(i2);
                s.parentSwitchLink = this;
            } else {
                s.parentSwitchLink = this.parentSwitchLink;
                if (this.parentSwitchLink != null) {
                    i2 = this.parentSwitchLinkChildIndex;
                    s.childSwitchLinks = this.parentSwitchLink.childrenSwitchLinks.get(i2);
                }
            }
            if (ti != null) {
                s.switchStates = ti.getTargetsData(1, this.parentSwitchLinkChildIndex);
            } else {
                s.switchStates = new ArrayList(1);
                s.switchStates.add(new SwitchState(false));
            }
        }
        return ti;
    }

    void updateSwitchStates(SetLiveState s, TargetsInterface ti, boolean isSetLive) {
        if (ti != null) {
            if (isSetLive) {
                CachedTargets[] newCtArr = null;
                newCtArr = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    CachedTargets ct;
                    newCtArr[0] = s.switchTargets[0] != null ? ((ct = ti.getCachedTargets(1, 0, this.parentSwitchLinkChildIndex)) != null ? s.switchTargets[0].snapShotAdd(ct) : s.switchTargets[0].snapShotInit()) : null;
                } else {
                    for (int i2 = 0; i2 < s.keys.length; ++i2) {
                        if (s.switchTargets[i2] != null) {
                            CachedTargets ct = ti.getCachedTargets(1, i2, this.parentSwitchLinkChildIndex);
                            if (ct != null) {
                                newCtArr[i2] = s.switchTargets[i2].snapShotAdd(ct);
                                continue;
                            }
                            newCtArr[i2] = s.switchTargets[i2].snapShotInit();
                            continue;
                        }
                        newCtArr[i2] = null;
                    }
                }
                ti.resetCachedTargets(1, newCtArr, this.parentSwitchLinkChildIndex);
                if (ti instanceof SwitchRetained) {
                    ((SwitchRetained)ti).traverseSwitchParent();
                } else if (ti instanceof SharedGroupRetained) {
                    ((SharedGroupRetained)ti).traverseSwitchParent();
                }
            } else {
                CachedTargets[] newCtArr = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (s.switchTargets[0] != null) {
                        CachedTargets ct = ti.getCachedTargets(1, 0, this.parentSwitchLinkChildIndex);
                        if (ct != null) {
                            newCtArr[0] = s.switchTargets[0].snapShotRemove(ct);
                        }
                    } else {
                        newCtArr[0] = null;
                    }
                } else {
                    for (int i3 = 0; i3 < s.keys.length; ++i3) {
                        if (s.switchTargets[i3] != null) {
                            CachedTargets ct = ti.getCachedTargets(1, i3, this.parentSwitchLinkChildIndex);
                            if (ct == null) continue;
                            newCtArr[i3] = s.switchTargets[i3].snapShotRemove(ct);
                            continue;
                        }
                        newCtArr[i3] = null;
                    }
                }
                ti.resetCachedTargets(1, newCtArr, this.parentSwitchLinkChildIndex);
            }
        }
    }

    void appendChildrenData() {
    }

    void insertChildrenData(int index) {
    }

    void removeChildrenData(int index) {
    }

    TargetsInterface getClosestTargetsInterface(int type) {
        return type == 0 ? (TargetsInterface)((Object)this.parentTransformLink) : (TargetsInterface)((Object)this.parentSwitchLink);
    }

    @Override
    synchronized void updateLocalToVworld() {
        for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
            NodeRetained child = this.children.get(i2);
            if (child == null) continue;
            child.updateLocalToVworld();
        }
    }

    @Override
    void setNodeData(SetLiveState s) {
        super.setNodeData(s);
        this.orderedPaths = s.orderedPaths;
    }

    @Override
    void removeNodeData(SetLiveState s) {
        this.orderedPaths = !this.inSharedGroup || s.keys.length == this.localToVworld.length ? null : s.orderedPaths;
        super.removeNodeData(s);
    }

    @Override
    void setLive(SetLiveState s) {
        this.doSetLive(s);
        super.markAsLive();
    }

    void childDoSetLive(NodeRetained child, int childIndex, SetLiveState s) {
        if (child != null) {
            child.setLive(s);
        }
    }

    void childCheckSetLive(NodeRetained child, int childIndex, SetLiveState s, NodeRetained linkNode) {
        child.setLive(s);
    }

    @Override
    void doSetLive(SetLiveState s) {
        super.doSetLive(s);
        this.locale = s.locale;
        this.inViewSpecificGroup = s.inViewSpecificGroup;
        int nchildren = this.children.size();
        ArrayList<ArrayList<LightRetained>> savedScopedLights = s.lights;
        ArrayList<ArrayList<FogRetained>> savedScopedFogs = s.fogs;
        ArrayList<ArrayList<AlternateAppearanceRetained>> savedScopedAltApps = s.altAppearances;
        ArrayList<ArrayList<ModelClipRetained>> savedScopedMclips = s.modelClips;
        boolean[] oldpickableArray = (boolean[])s.pickable.clone();
        boolean[] oldcollidableArray = (boolean[])s.collidable.clone();
        boolean[] workingpickableArray = new boolean[oldpickableArray.length];
        boolean[] workingcollidableArray = new boolean[oldcollidableArray.length];
        ArrayList<BranchGroupRetained[]> oldBranchGroupPaths = s.branchGroupPaths;
        this.setScopingInfo(s);
        if (!(this instanceof ViewSpecificGroupRetained)) {
            this.viewLists = s.viewLists;
        }
        for (int i2 = 0; i2 < nchildren; ++i2) {
            NodeRetained child = this.children.get(i2);
            System.arraycopy(oldpickableArray, 0, workingpickableArray, 0, oldpickableArray.length);
            System.arraycopy(oldcollidableArray, 0, workingcollidableArray, 0, oldcollidableArray.length);
            s.pickable = workingpickableArray;
            s.collidable = workingcollidableArray;
            s.parentBranchGroupPaths = this.branchGroupPaths;
            s.branchGroupPaths = new ArrayList<BranchGroupRetained[]>(oldBranchGroupPaths);
            s.inViewSpecificGroup = this.inViewSpecificGroup;
            this.childDoSetLive(child, i2, s);
        }
        if (this.collisionTarget) {
            this.processCollisionTarget(s);
        }
        s.lights = savedScopedLights;
        s.fogs = savedScopedFogs;
        s.altAppearances = savedScopedAltApps;
        s.modelClips = savedScopedMclips;
    }

    void setScopingInfo(SetLiveState s) {
        int k2;
        int size;
        ArrayList<LeafRetained> src;
        ArrayList<LeafRetained> l2;
        int hkIndex;
        int i2;
        if (this.allocatedLights) {
            if (s.lights != null) {
                if (this.inSharedGroup) {
                    for (i2 = 0; i2 < s.keys.length; ++i2) {
                        hkIndex = s.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        l2 = this.lights.get(hkIndex);
                        src = s.lights.get(i2);
                        if (src == null) continue;
                        size = src.size();
                        for (k2 = 0; k2 < size; ++k2) {
                            l2.add(src.get(k2));
                        }
                    }
                } else {
                    l2 = this.lights.get(0);
                    src = s.lights.get(0);
                    size = src.size();
                    for (i2 = 0; i2 < size; ++i2) {
                        l2.add((LightRetained)src.get(i2));
                    }
                }
            }
            s.lights = this.lights;
        } else {
            this.lights = s.lights;
        }
        if (this.allocatedFogs) {
            if (s.fogs != null) {
                if (this.inSharedGroup) {
                    for (i2 = 0; i2 < s.keys.length; ++i2) {
                        hkIndex = s.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        l2 = this.fogs.get(hkIndex);
                        src = s.fogs.get(i2);
                        if (src == null) continue;
                        size = src.size();
                        for (k2 = 0; k2 < size; ++k2) {
                            l2.add(src.get(k2));
                        }
                    }
                } else {
                    l2 = this.fogs.get(0);
                    src = s.fogs.get(0);
                    size = src.size();
                    for (i2 = 0; i2 < size; ++i2) {
                        l2.add(src.get(i2));
                    }
                }
            }
            s.fogs = this.fogs;
        } else {
            this.fogs = s.fogs;
        }
        if (this.allocatedMclips) {
            if (s.modelClips != null) {
                if (this.inSharedGroup) {
                    for (i2 = 0; i2 < s.keys.length; ++i2) {
                        hkIndex = s.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        l2 = this.modelClips.get(hkIndex);
                        src = s.modelClips.get(i2);
                        if (src == null) continue;
                        size = src.size();
                        for (k2 = 0; k2 < size; ++k2) {
                            l2.add(src.get(k2));
                        }
                    }
                } else {
                    l2 = this.modelClips.get(0);
                    src = s.modelClips.get(0);
                    size = src.size();
                    for (i2 = 0; i2 < size; ++i2) {
                        l2.add(src.get(i2));
                    }
                }
            }
            s.modelClips = this.modelClips;
        } else {
            this.modelClips = s.modelClips;
        }
        if (this.allocatedAltApps) {
            if (s.altAppearances != null) {
                if (this.inSharedGroup) {
                    for (i2 = 0; i2 < s.keys.length; ++i2) {
                        hkIndex = s.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        l2 = this.altAppearances.get(hkIndex);
                        src = s.altAppearances.get(i2);
                        if (src == null) continue;
                        size = src.size();
                        for (k2 = 0; k2 < size; ++k2) {
                            l2.add(src.get(k2));
                        }
                    }
                } else {
                    l2 = this.altAppearances.get(0);
                    src = s.altAppearances.get(0);
                    size = src.size();
                    for (i2 = 0; i2 < size; ++i2) {
                        l2.add(src.get(i2));
                    }
                }
            }
            s.altAppearances = this.altAppearances;
        } else {
            this.altAppearances = s.altAppearances;
        }
    }

    void processCollisionTarget(SetLiveState s) {
        Bounds bound;
        if (this.mirrorGroup == null) {
            this.mirrorGroup = new ArrayList();
        }
        Bounds bounds = bound = this.collisionBound != null ? this.collisionBound : this.getEffectiveBounds();
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < s.keys.length; ++i2) {
                GroupRetained g2 = new GroupRetained();
                g2.key = s.keys[i2];
                g2.localToVworld = new Transform3D[1][];
                g2.localToVworldIndex = new int[1][];
                int j2 = s.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (j2 < 0) {
                    System.err.println("GroupRetained : Can't find hashKey");
                }
                g2.localToVworld[0] = this.localToVworld[j2];
                g2.localToVworldIndex[0] = this.localToVworldIndex[j2];
                g2.collisionVwcBounds = new BoundingBox();
                g2.collisionVwcBounds.transform(bound, g2.getCurrentLocalToVworld(0));
                g2.sourceNode = this;
                g2.locale = this.locale;
                this.mirrorGroup.add(g2);
                if (s.transformTargets != null && s.transformTargets[i2] != null) {
                    s.transformTargets[i2].addNode(g2, 6);
                }
                s.nodeList.add(g2);
            }
        } else {
            GroupRetained g3 = new GroupRetained();
            g3.localToVworld = new Transform3D[1][];
            g3.localToVworldIndex = new int[1][];
            g3.localToVworld[0] = this.localToVworld[0];
            g3.localToVworldIndex[0] = this.localToVworldIndex[0];
            g3.collisionVwcBounds = new BoundingBox();
            g3.collisionVwcBounds.transform(bound, g3.getCurrentLocalToVworld(0));
            g3.sourceNode = this;
            g3.locale = this.locale;
            this.mirrorGroup.add(g3);
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(g3, 6);
            }
            s.nodeList.add(g3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void computeCombineBounds(Bounds bounds) {
        if (!VirtualUniverse.mc.cacheAutoComputedBounds) {
            if (this.boundsAutoCompute) {
                for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                    NodeRetained child = this.children.get(i2);
                    if (child == null) continue;
                    child.computeCombineBounds(bounds);
                }
            } else {
                Bounds i2 = this.localBounds;
                synchronized (i2) {
                    bounds.combine(this.localBounds);
                }
            }
        } else {
            if (this.validCachedBounds && this.boundsAutoCompute) {
                bounds.combine(this.cachedBounds);
                return;
            }
            if (this.boundsAutoCompute) {
                this.cachedBounds = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
                for (int i3 = this.children.size() - 1; i3 >= 0; --i3) {
                    NodeRetained child = this.children.get(i3);
                    if (child == null) continue;
                    child.computeCombineBounds(this.cachedBounds);
                }
                bounds.combine(this.cachedBounds);
            } else {
                Bounds bounds2 = this.localBounds;
                synchronized (bounds2) {
                    bounds.combine(this.localBounds);
                }
            }
        }
    }

    @Override
    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            if (this.validCachedBounds) {
                return (Bounds)this.cachedBounds.clone();
            }
            Bounds boundingObject = null;
            boundingObject = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained child = this.children.get(i2);
                if (child == null) continue;
                child.computeCombineBounds(boundingObject);
            }
            return boundingObject;
        }
        return super.getBounds();
    }

    @Override
    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    boolean isStaticChildren() {
        if (this.source.getCapability(12) || this.source.getCapability(13)) {
            return false;
        }
        for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
            NodeRetained nodeR = this.children.get(i2);
            if (nodeR == null || !nodeR.source.getCapability(46)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isStatic() {
        return super.isStatic() && this.isStaticChildren();
    }

    @Override
    void setCompiled() {
        super.setCompiled();
        for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
            NodeRetained node = this.children.get(i2);
            if (node == null) continue;
            node.setCompiled();
        }
    }

    @Override
    void traverse(boolean sameLevel, int level) {
        if (!sameLevel) {
            super.traverse(true, level);
            if (this.source.getCapability(12)) {
                System.err.print(" (r)");
            } else if (this.isStatic()) {
                System.err.print(" (s)");
            } else if (this.source.getCapability(13)) {
                System.err.print(" (w)");
            }
        }
        ++level;
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            NodeRetained node = this.children.get(i2);
            if (node == null) continue;
            node.traverse(false, level);
        }
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        this.mergeFlag = 1;
        if (!this.isStatic()) {
            compState.keepTG = true;
            this.mergeFlag = 0;
        }
        if (this.isRoot || this.usedInScoping() || this.parent instanceof SwitchRetained) {
            this.mergeFlag = 0;
        }
        this.compiledChildrenList = new ArrayList(5);
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            NodeRetained node = this.children.get(i2);
            if (node == null) continue;
            node.compile(compState);
        }
    }

    @Override
    void merge(CompileState compState) {
        GroupRetained saveParentGroup = null;
        if (this.mergeFlag != 2) {
            if (this.mergeFlag == 0) {
                super.merge(compState);
                saveParentGroup = compState.parentGroup;
                compState.parentGroup = this;
            }
            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                NodeRetained node = this.children.get(i2);
                if (node == null) continue;
                node.merge(compState);
            }
            if (compState.parentGroup == this) {
                this.children = this.compiledChildrenList;
                compState.doShapeMerge();
                this.compiledChildrenList = null;
                compState.parentGroup = saveParentGroup;
            } else {
                this.children.clear();
            }
            this.mergeFlag = 2;
        } else if (compState.parentGroup != null) {
            compState.parentGroup.compiledChildrenList.add(this);
            this.parent = compState.parentGroup;
        }
    }

    @Override
    void clearLive(SetLiveState s) {
        int k2;
        int size;
        ArrayList<LeafRetained> gl;
        ArrayList<LeafRetained> l2;
        int hkIndex;
        int i2;
        boolean parentScopedLtSize = false;
        boolean parentScopedFogSize = false;
        boolean parentScopedMcSize = false;
        boolean parentScopedAltAppSize = false;
        boolean groupScopedLtSize = false;
        boolean groupScopedFogSize = false;
        boolean groupScopedMcSize = false;
        boolean groupScopedAltAppSize = false;
        this.isInClearLive = true;
        HashKey[] savedLocalToVworldKeys = this.localToVworldKeys;
        super.clearLive(s);
        int nchildren = this.children.size();
        if (!(this instanceof ViewSpecificGroupRetained)) {
            this.viewLists = s.viewLists;
        }
        ArrayList<ArrayList<LightRetained>> savedParentLights = s.lights;
        if (this.allocatedLights) {
            s.lights = this.lights;
        }
        ArrayList<ArrayList<FogRetained>> savedParentFogs = s.fogs;
        if (this.allocatedFogs) {
            s.fogs = this.fogs;
        }
        ArrayList<ArrayList<ModelClipRetained>> savedParentMclips = s.modelClips;
        if (this.allocatedMclips) {
            s.modelClips = this.modelClips;
        }
        ArrayList<ArrayList<AlternateAppearanceRetained>> savedParentAltApps = s.altAppearances;
        if (this.allocatedAltApps) {
            s.altAppearances = this.altAppearances;
        }
        for (i2 = nchildren - 1; i2 >= 0; --i2) {
            NodeRetained child = this.children.get(i2);
            if (this instanceof OrderedGroupRetained) {
                OrderedGroupRetained og = (OrderedGroupRetained)this;
                if (this.refCount + 1 == s.refCount) {
                    s.ogList.add(og);
                    s.ogChildIdList.add(new Integer(i2));
                }
                s.orderedPaths = og.childrenOrderedPaths.get(i2);
            }
            if (child == null) continue;
            child.clearLive(s);
        }
        if (savedParentLights != null && this.allocatedLights) {
            if (this.inSharedGroup) {
                for (i2 = 0; i2 < s.keys.length; ++i2) {
                    hkIndex = s.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    l2 = savedParentLights.get(hkIndex);
                    gl = this.lights.get(hkIndex);
                    if (l2 == null) continue;
                    size = l2.size();
                    for (k2 = 0; k2 < size; ++k2) {
                        gl.remove(l2.get(k2));
                    }
                }
            } else {
                l2 = savedParentLights.get(0);
                gl = this.lights.get(0);
                size = l2.size();
                for (int m2 = 0; m2 < size; ++m2) {
                    gl.remove(l2.get(m2));
                }
            }
        }
        if (savedParentFogs != null && this.allocatedFogs) {
            if (this.inSharedGroup) {
                for (i2 = 0; i2 < s.keys.length; ++i2) {
                    hkIndex = s.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    l2 = savedParentFogs.get(hkIndex);
                    gl = this.fogs.get(hkIndex);
                    if (l2 == null) continue;
                    size = l2.size();
                    for (k2 = 0; k2 < size; ++k2) {
                        gl.remove(l2.get(k2));
                    }
                }
            } else {
                l2 = savedParentFogs.get(0);
                size = l2.size();
                for (int m3 = 0; m3 < size; ++m3) {
                    this.fogs.remove(l2.get(m3));
                }
            }
        }
        if (savedParentMclips != null && this.allocatedMclips) {
            if (this.inSharedGroup) {
                for (i2 = 0; i2 < s.keys.length; ++i2) {
                    hkIndex = s.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    l2 = savedParentMclips.get(hkIndex);
                    ArrayList<ModelClipRetained> gl2 = this.modelClips.get(hkIndex);
                    if (l2 == null) continue;
                    size = l2.size();
                    for (k2 = 0; k2 < size; ++k2) {
                        gl2.remove(l2.get(k2));
                    }
                }
            } else {
                l2 = savedParentMclips.get(0);
                size = l2.size();
                for (int m4 = 0; m4 < size; ++m4) {
                    this.modelClips.remove(l2.get(m4));
                }
            }
        }
        if (savedParentAltApps != null && this.allocatedAltApps) {
            if (this.inSharedGroup) {
                for (i2 = 0; i2 < s.keys.length; ++i2) {
                    hkIndex = s.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    l2 = savedParentAltApps.get(hkIndex);
                    ArrayList<AlternateAppearanceRetained> gl3 = this.altAppearances.get(hkIndex);
                    if (l2 == null) continue;
                    size = l2.size();
                    for (k2 = 0; k2 < size; ++k2) {
                        gl3.remove(l2.get(k2));
                    }
                }
            } else {
                l2 = savedParentAltApps.get(0);
                size = l2.size();
                for (int m5 = 0; m5 < size; ++m5) {
                    this.altAppearances.remove(l2.get(m5));
                }
            }
        }
        if (this.collisionTarget) {
            GroupRetained g2;
            if (this.inSharedGroup) {
                block13: for (i2 = s.keys.length - 1; i2 >= 0; --i2) {
                    HashKey hkey = s.keys[i2];
                    for (int j2 = this.mirrorGroup.size() - 1; j2 >= 0; --j2) {
                        g2 = this.mirrorGroup.get(j2);
                        if (!g2.key.equals((Object)hkey)) continue;
                        s.nodeList.add(this.mirrorGroup.remove(j2));
                        if (s.transformTargets == null || s.transformTargets[j2] == null) continue block13;
                        s.transformTargets[j2].addNode(g2, 6);
                        continue block13;
                    }
                }
            } else {
                g2 = this.mirrorGroup.get(0);
                if (s.transformTargets != null && s.transformTargets[0] != null) {
                    s.transformTargets[0].addNode(g2, 6);
                }
                s.nodeList.add(this.mirrorGroup.remove(0));
            }
        }
        s.lights = savedParentLights;
        s.modelClips = savedParentMclips;
        s.fogs = savedParentFogs;
        s.altAppearances = savedParentAltApps;
        this.isInClearLive = false;
    }

    @Override
    public BoundingBox computeBoundingHull() {
        return this.collisionVwcBounds;
    }

    @Override
    public boolean isEnable() {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    @Override
    public boolean isEnable(int vis) {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    @Override
    public Locale getLocale2() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isNodeSwitchOn(NodeRetained node, HashKey key) {
        NodeRetained prevNode = null;
        if (key != null) {
            key = new HashKey(key);
        }
        Object object = node.universe.sceneGraphLock;
        synchronized (object) {
            do {
                if (node instanceof SwitchRetained && prevNode != null && !GroupRetained.validSwitchChild((SwitchRetained)node, prevNode)) {
                    return false;
                }
                prevNode = node;
                if (node instanceof SharedGroupRetained) {
                    String nodeId = key.getLastNodeId();
                    Vector<NodeRetained> parents = ((SharedGroupRetained)node).parents;
                    for (int i2 = parents.size() - 1; i2 >= 0; --i2) {
                        NodeRetained link = parents.get(i2);
                        if (!link.nodeId.equals(nodeId)) continue;
                        node = link;
                        break;
                    }
                    if (node != prevNode) continue;
                    return false;
                }
                node = node.parent;
            } while (node != null);
        }
        return true;
    }

    static boolean validSwitchChild(SwitchRetained sw, NodeRetained node) {
        int whichChild = sw.whichChild;
        if (whichChild == -1) {
            return false;
        }
        if (whichChild == -2) {
            return true;
        }
        ArrayList children = sw.children;
        if (whichChild >= 0) {
            return children.get(whichChild) == node;
        }
        for (int i2 = children.size() - 1; i2 >= 0; --i2) {
            if (!sw.childMask.get(i2) || children.get(i2) != node) continue;
            return true;
        }
        return false;
    }

    void createMirrorGroup() {
        Bounds bound;
        this.mirrorGroup = new ArrayList();
        Bounds bounds = bound = this.collisionBound != null ? this.collisionBound : this.getEffectiveBounds();
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                GroupRetained g2 = new GroupRetained();
                g2.key = this.localToVworldKeys[i2];
                g2.localToVworld = new Transform3D[1][];
                g2.localToVworldIndex = new int[1][];
                g2.localToVworld[0] = this.localToVworld[i2];
                g2.localToVworldIndex[0] = this.localToVworldIndex[i2];
                g2.collisionVwcBounds = new BoundingBox();
                g2.collisionVwcBounds.transform(bound, g2.getCurrentLocalToVworld());
                g2.sourceNode = this;
                g2.locale = this.locale;
                this.mirrorGroup.add(g2);
            }
        } else {
            GroupRetained g3 = new GroupRetained();
            g3.localToVworld = new Transform3D[1][];
            g3.localToVworldIndex = new int[1][];
            g3.localToVworld[0] = this.localToVworld[0];
            g3.localToVworldIndex[0] = this.localToVworldIndex[0];
            g3.collisionVwcBounds = new BoundingBox();
            g3.collisionVwcBounds.transform(bound, g3.getCurrentLocalToVworld());
            g3.sourceNode = this;
            g3.locale = this.locale;
            this.mirrorGroup.add(g3);
        }
    }

    @Override
    void setBoundsAutoCompute(boolean autoCompute) {
        if (autoCompute != this.boundsAutoCompute) {
            super.setBoundsAutoCompute(autoCompute);
            if (!autoCompute) {
                this.localBounds = this.getEffectiveBounds();
            }
            if (this.source.isLive() && this.collisionBound == null && autoCompute && this.mirrorGroup != null) {
                J3dMessage message = new J3dMessage();
                message.type = 34;
                message.threads = 8256;
                message.universe = this.universe;
                message.args[0] = this;
                VirtualUniverse.mc.processMessage(message);
            }
        }
    }

    @Override
    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute && this.collisionBound == null && this.mirrorGroup != null) {
            J3dMessage message = new J3dMessage();
            message.type = 34;
            message.threads = 8256;
            message.universe = this.universe;
            message.args[0] = this;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    @Override
    int[] processViewSpecificInfo(int mode, HashKey k2, View v, ArrayList vsgList, int[] keyList, ArrayList leafList) {
        int nchildren = this.children.size();
        if (this.source.isLive()) {
            for (int i2 = 0; i2 < nchildren; ++i2) {
                NodeRetained child = this.children.get(i2);
                if (child instanceof LeafRetained) {
                    if (child instanceof LinkRetained) {
                        int lastCount = k2.count;
                        LinkRetained ln = (LinkRetained)child;
                        if (k2.count == 0) {
                            k2.append(this.locale.nodeId);
                        }
                        keyList = ln.sharedGroup.processViewSpecificInfo(mode, k2.append("+").append(ln.nodeId), v, vsgList, keyList, leafList);
                        k2.count = lastCount;
                        continue;
                    }
                    ((LeafRetained)child).getMirrorObjects(leafList, k2);
                    continue;
                }
                keyList = child.processViewSpecificInfo(mode, k2, v, vsgList, keyList, leafList);
            }
        }
        return keyList;
    }

    void findSwitchInfo(SetLiveState s, NodeRetained parentNode, NodeRetained childNode, NodeRetained linkNode) {
        block14: {
            int i2;
            block13: {
                this.parentSwitchLinkChildIndex = -1;
                if (this.inSharedGroup) break block13;
                NodeRetained child = linkNode == null ? childNode : linkNode;
                NodeRetained parent = parentNode;
                while (parent != null) {
                    if (parent instanceof SwitchRetained) {
                        s.switchLevels[0] = s.switchLevels[0] + 1;
                        if (s.closestSwitchParents[0] == null) {
                            s.closestSwitchParents[0] = (SwitchRetained)parent;
                            ++((SwitchRetained)parent).switchIndexCount;
                        }
                        if (this.parentSwitchLinkChildIndex == -1) {
                            this.parentSwitchLinkChildIndex = ((GroupRetained)parent).children.indexOf(child);
                        }
                    } else if (parent instanceof SharedGroupRetained && this.parentSwitchLinkChildIndex == -1) {
                        this.parentSwitchLinkChildIndex = ((GroupRetained)parent).children.indexOf(child);
                    }
                    child = parent;
                    parent = child.parent;
                }
                break block14;
            }
            s.switchLevels = new int[this.localToVworldKeys.length];
            s.closestSwitchParents = new SwitchRetained[this.localToVworldKeys.length];
            s.closestSwitchIndices = new int[this.localToVworldKeys.length];
            for (i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                s.switchLevels[i2] = -1;
                s.closestSwitchParents[i2] = null;
                s.closestSwitchIndices[i2] = -1;
            }
            for (i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                NodeRetained child = linkNode == null ? childNode : linkNode;
                NodeRetained parent = parentNode;
                HashKey key = new HashKey(this.localToVworldKeys[i2]);
                while (parent != null) {
                    block16: {
                        block15: {
                            if (!(parent instanceof SwitchRetained)) break block15;
                            int n2 = i2;
                            s.switchLevels[n2] = s.switchLevels[n2] + 1;
                            if (s.closestSwitchParents[i2] == null) {
                                s.closestSwitchParents[i2] = (SwitchRetained)parent;
                                ++((SwitchRetained)parent).switchIndexCount;
                            }
                            if (this.parentSwitchLinkChildIndex != -1) break block16;
                            this.parentSwitchLinkChildIndex = ((GroupRetained)parent).children.indexOf(child);
                            break block16;
                        }
                        if (parent instanceof SharedGroupRetained) {
                            String nodeId = key.getLastNodeId();
                            Vector<NodeRetained> parents = ((SharedGroupRetained)parent).parents;
                            if (this.parentSwitchLinkChildIndex == -1) {
                                this.parentSwitchLinkChildIndex = ((GroupRetained)parent).children.indexOf(child);
                            }
                            for (int j2 = 0; j2 < parents.size(); ++j2) {
                                NodeRetained ln = parents.get(j2);
                                if (!ln.nodeId.equals(nodeId)) continue;
                                parent = ln;
                                break;
                            }
                        }
                    }
                    child = parent;
                    parent = child.parent;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void gatherBlUsers(ArrayList blUsers, Object[] blArr) {
        for (int i2 = 0; i2 < blArr.length; ++i2) {
            ArrayList users;
            ArrayList arrayList = users = ((BoundingLeafRetained)blArr[i2]).users;
            synchronized (arrayList) {
                blUsers.addAll(users);
                continue;
            }
        }
    }

    @Override
    void searchGeometryAtoms(UnorderList list) {
        for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
            NodeRetained child = this.children.get(i2);
            child.searchGeometryAtoms(list);
        }
    }
}

