/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Arrays;
import org.jogamp.java3d.BHLeafInterface;
import org.jogamp.java3d.BHLeafNode;
import org.jogamp.java3d.BHNode;
import org.jogamp.java3d.BHTree;
import org.jogamp.java3d.BehaviorRetained;
import org.jogamp.java3d.BehaviorStructure;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingLeafRetained;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.J3dStructure;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.MRSWLock;
import org.jogamp.java3d.NnuId;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.RenderBin;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.UpdateTargets;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupIndexedList;
import org.jogamp.java3d.WakeupOnCollisionEntry;
import org.jogamp.java3d.WakeupOnCollisionExit;
import org.jogamp.java3d.WakeupOnCollisionMovement;
import org.jogamp.vecmath.Vector3d;

class GeometryStructure
extends J3dStructure {
    UpdateTargets targets = null;
    private MRSWLock lock = null;
    private Object visLock = new Object();
    private Object collideListLock = new Object();
    private BHTree[] bhTreeArr = null;
    private int bhTreeCount = 0;
    private int bhTreeMax = 1;
    private int bhTreeBlockSize = 5;
    private BHNode[] bhNodeArr = null;
    private int bhNodeCount = 0;
    private int bhNodeMax;
    private int bhNodeBlockSize = 50;
    private Vector3d localeTrans = new Vector3d();
    WakeupIndexedList collideEntryList;
    WakeupIndexedList collideExitList;
    WakeupIndexedList collideMovementList;
    WakeupIndexedList wakeupOnCollisionEntry;
    WakeupIndexedList wakeupOnCollisionExit;
    WakeupIndexedList wakeupOnCollisionMovement;
    boolean reEvaluateWakeupCollisionGAs;
    private boolean transformMsg = false;

    GeometryStructure(VirtualUniverse u) {
        super(u, 64);
        this.bhNodeMax = this.bhNodeBlockSize;
        this.bhNodeArr = new BHNode[this.bhNodeMax];
        this.bhTreeArr = new BHTree[this.bhTreeMax];
        this.lock = new MRSWLock();
        this.collideEntryList = new WakeupIndexedList(WakeupOnCollisionEntry.class, 1, u);
        this.collideExitList = new WakeupIndexedList(WakeupOnCollisionExit.class, 1, u);
        this.collideMovementList = new WakeupIndexedList(WakeupOnCollisionMovement.class, 1, u);
        this.wakeupOnCollisionEntry = new WakeupIndexedList(WakeupOnCollisionEntry.class, 0, u);
        this.wakeupOnCollisionExit = new WakeupIndexedList(WakeupOnCollisionExit.class, 0, u);
        this.wakeupOnCollisionMovement = new WakeupIndexedList(WakeupOnCollisionMovement.class, 0, u);
    }

    @Override
    void processMessages(long referenceTime) {
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg > 0) {
            this.reEvaluateWakeupCollisionGAs = false;
            for (int i2 = 0; i2 < nMsg; ++i2) {
                this.lock.writeLock();
                J3dMessage m2 = messages[i2];
                switch (m2.type) {
                    case 3: {
                        this.transformMsg = true;
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(m2);
                        if (!this.universe.transformStructure.getLazyUpdate()) break;
                        this.transformMsg = true;
                        break;
                    }
                    case 0: {
                        this.insertNodes((Object[])m2.args[0]);
                        this.reEvaluateWakeupCollisionGAs = true;
                        break;
                    }
                    case 1: {
                        this.removeNodes(m2);
                        this.reEvaluateWakeupCollisionGAs = true;
                        break;
                    }
                    case 24: {
                        int comp = (Integer)m2.args[1];
                        if (comp == 1) {
                            m2.args[0] = m2.args[2];
                            this.removeNodes(m2);
                            this.insertNodes((Object[])m2.args[3]);
                            this.reEvaluateWakeupCollisionGAs = true;
                            break;
                        }
                        if (comp != 2) break;
                        this.processVisibleChanged(m2.args[2], (GeometryAtom[])m2.args[3]);
                        break;
                    }
                    case 26: {
                        this.removeNodes(m2);
                        this.insertNodes((Object[])m2.args[1]);
                        break;
                    }
                    case 25: {
                        this.processBoundsChanged((Object[])m2.args[0], false);
                        break;
                    }
                    case 16: {
                        int comp = (Integer)m2.args[1];
                        if (comp == 1) {
                            this.processBoundsChanged((Object[])m2.args[3], false);
                            break;
                        }
                        if (comp != 2) break;
                        this.processVisibleChanged(m2.args[2], (GeometryAtom[])m2.args[3]);
                        break;
                    }
                    case 35: 
                    case 37: {
                        this.processBoundsChanged((Object[])m2.args[0], false);
                        break;
                    }
                    case 17: {
                        this.processBoundsChanged((Object[])m2.args[0], false);
                        break;
                    }
                    case 10: {
                        this.processVisibleChanged(m2.args[2], (GeometryAtom[])m2.args[3]);
                    }
                }
                this.lock.writeUnlock();
                m2.decRefcount();
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                this.lock.writeLock();
                this.processTransformChanged(this.targets);
                this.lock.writeUnlock();
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(messages, 0, nMsg, null);
        }
        this.processCollisionDetection();
    }

    private int getBHTreeIndex(Locale locale) {
        for (int i2 = 0; i2 < this.bhTreeCount; ++i2) {
            if (this.bhTreeArr[i2].locale != locale) continue;
            return i2;
        }
        return -1;
    }

    private int getOrAddBHTreeIndex(Locale locale) {
        int i2;
        for (i2 = 0; i2 < this.bhTreeCount; ++i2) {
            if (this.bhTreeArr[i2].locale != locale) continue;
            return i2;
        }
        if (this.bhTreeCount >= this.bhTreeMax) {
            this.bhTreeMax += this.bhTreeBlockSize;
            BHTree[] oldBhTreeArr = this.bhTreeArr;
            this.bhTreeArr = new BHTree[this.bhTreeMax];
            System.arraycopy(oldBhTreeArr, 0, this.bhTreeArr, 0, oldBhTreeArr.length);
        }
        this.bhTreeArr[this.bhTreeCount] = new BHTree(locale);
        ++this.bhTreeCount;
        return i2;
    }

    private void clearBhNodeArr() {
        for (int i2 = 0; i2 < this.bhNodeCount; ++i2) {
            this.bhNodeArr[i2] = null;
        }
        this.bhNodeCount = 0;
    }

    private void addToBhNodeArr(BHNode bhNode) {
        if (this.bhNodeCount >= this.bhNodeMax) {
            this.bhNodeMax += this.bhNodeBlockSize;
            BHNode[] oldbhNodeArr = this.bhNodeArr;
            this.bhNodeArr = new BHNode[this.bhNodeMax];
            System.arraycopy(oldbhNodeArr, 0, this.bhNodeArr, 0, oldbhNodeArr.length);
        }
        this.bhNodeArr[this.bhNodeCount] = bhNode;
        ++this.bhNodeCount;
    }

    private void processVisibleChanged(Object valueObj, GeometryAtom[] gaArr) {
        boolean visible = true;
        if (gaArr == null || gaArr.length < 1) {
            return;
        }
        int treeIndex = this.getBHTreeIndex(gaArr[0].locale);
        visible = (Boolean)valueObj;
        for (int i2 = gaArr.length - 1; i2 >= 0; --i2) {
            gaArr[i2].visible = visible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNodes(Object[] nodes) {
        this.clearBhNodeArr();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            Object object;
            Object node = nodes[i2];
            if (node instanceof GeometryAtom) {
                object = node;
                synchronized (object) {
                    GeometryAtom geomAtom = (GeometryAtom)node;
                    if (geomAtom.source.inBackgroundGroup) {
                        geomAtom.source.geometryBackground.addBgGeometryAtomList(geomAtom);
                        continue;
                    }
                    BHLeafNode bhLeafNode = new BHLeafNode();
                    bhLeafNode.leafIF = geomAtom;
                    geomAtom.bhLeafNode = bhLeafNode;
                    bhLeafNode.computeBoundingHull();
                    this.addToBhNodeArr(bhLeafNode);
                    continue;
                }
            }
            if (!(node instanceof GroupRetained)) continue;
            object = node;
            synchronized (object) {
                GroupRetained group = (GroupRetained)node;
                BHLeafNode bhLeafNode = new BHLeafNode();
                bhLeafNode.leafIF = group;
                group.bhLeafNode = bhLeafNode;
                bhLeafNode.computeBoundingHull();
                this.addToBhNodeArr(bhLeafNode);
                continue;
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int idx = this.getOrAddBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        BHTree currTree = this.bhTreeArr[idx];
        currTree.insert(this.bhNodeArr, this.bhNodeCount);
        this.clearBhNodeArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void removeNodes(J3dMessage m2) {
        Object[] nodes = (Object[])m2.args[0];
        this.clearBhNodeArr();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            Object object;
            Object node = nodes[i2];
            if (node instanceof GeometryAtom) {
                object = node;
                synchronized (object) {
                    GeometryAtom geomAtom = (GeometryAtom)node;
                    if (geomAtom.source != null && geomAtom.source.inBackgroundGroup) {
                        geomAtom.source.geometryBackground.removeBgGeometryAtomList(geomAtom);
                        continue;
                    }
                    if (geomAtom.bhLeafNode != null) {
                        this.addToBhNodeArr(geomAtom.bhLeafNode);
                        geomAtom.bhLeafNode = null;
                    }
                    continue;
                }
            }
            if (node instanceof GroupRetained) {
                if (((NodeRetained)node).nodeType == 20) continue;
                object = node;
                synchronized (object) {
                    GroupRetained group = (GroupRetained)node;
                    if (group.bhLeafNode != null) {
                        this.addToBhNodeArr(group.bhLeafNode);
                        group.bhLeafNode = null;
                    }
                    continue;
                }
            }
            if (!(node instanceof BehaviorRetained)) continue;
            object = node;
            synchronized (object) {
                BehaviorRetained behav = (BehaviorRetained)node;
                WakeupOnCollisionEntry[] wentryArr = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
                for (int j2 = this.collideEntryList.arraySize() - 1; j2 >= 0; --j2) {
                    WakeupOnCollisionEntry wentry = wentryArr[j2];
                    if (wentry.behav != behav) continue;
                    this.collideEntryList.remove(wentry);
                }
                WakeupOnCollisionExit[] wexitArr = (WakeupOnCollisionExit[])this.collideExitList.toArray();
                for (int j3 = this.collideExitList.arraySize() - 1; j3 >= 0; --j3) {
                    WakeupOnCollisionExit wexit = wexitArr[j3];
                    if (wexit.behav != behav) continue;
                    this.collideExitList.remove(wexit);
                }
                continue;
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int index = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (index < 0) {
            this.clearBhNodeArr();
            return;
        }
        BHTree currTree = this.bhTreeArr[index];
        currTree.delete(this.bhNodeArr, this.bhNodeCount);
        this.clearBhNodeArr();
        this.wakeupOnCollisionEntry.clearMirror();
        this.wakeupOnCollisionMovement.clearMirror();
        this.wakeupOnCollisionExit.clearMirror();
        Object object = this.collideListLock;
        synchronized (object) {
            this.collideEntryList.clearMirror();
            this.collideExitList.clearMirror();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBoundsChanged(Object[] nodes, boolean transformChanged) {
        this.clearBhNodeArr();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            Object node = nodes[i2];
            if (node instanceof GeometryAtom) {
                Object object = node;
                synchronized (object) {
                    GeometryAtom geomAtom = (GeometryAtom)node;
                    if (geomAtom.bhLeafNode != null) {
                        this.addToBhNodeArr(geomAtom.bhLeafNode);
                    }
                    continue;
                }
            }
            if (!(node instanceof GroupRetained)) continue;
            GroupRetained group = (GroupRetained)node;
            if (group.nodeType == 18) continue;
            Object object = node;
            synchronized (object) {
                if (group.bhLeafNode != null) {
                    this.addToBhNodeArr(group.bhLeafNode);
                }
                continue;
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int index = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (index >= 0) {
            this.bhTreeArr[index].boundsChanged(this.bhNodeArr, this.bhNodeCount);
        }
        this.clearBhNodeArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransformChanged(UpdateTargets targets) {
        NnuId nnuId;
        int i2;
        Object[] nodes;
        int j2;
        Object[] nodesArr;
        int size;
        this.clearBhNodeArr();
        UnorderList arrList = targets.targetList[0];
        if (arrList != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (j2 = 0; j2 < size; ++j2) {
                nodes = (Object[])nodesArr[j2];
                for (i2 = 0; i2 < nodes.length; ++i2) {
                    GeometryAtom geomAtom;
                    nnuId = geomAtom = (GeometryAtom)nodes[i2];
                    synchronized (nnuId) {
                        if (geomAtom.bhLeafNode != null) {
                            this.addToBhNodeArr(geomAtom.bhLeafNode);
                        }
                        continue;
                    }
                }
            }
        }
        if ((arrList = targets.targetList[6]) != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (j2 = 0; j2 < size; ++j2) {
                nodes = (Object[])nodesArr[j2];
                for (i2 = 0; i2 < nodes.length; ++i2) {
                    GroupRetained group = (GroupRetained)nodes[i2];
                    if (group.nodeType == 18) continue;
                    nnuId = group;
                    synchronized (nnuId) {
                        if (group.bhLeafNode != null) {
                            this.addToBhNodeArr(group.bhLeafNode);
                        }
                        continue;
                    }
                }
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int index = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (index >= 0) {
            this.bhTreeArr[index].boundsChanged(this.bhNodeArr, this.bhNodeCount);
        }
        this.clearBhNodeArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getVisibleBHTrees(RenderBin rBin, BoundingBox frustumBBox, Locale locale, long referenceTime, boolean stateChanged, int visibilityPolicy) {
        boolean unviInFB = true;
        this.lock.readLock();
        ArrayList bhTrees = new ArrayList();
        if (this.bhTreeCount == 1) {
            Object object = this.visLock;
            synchronized (object) {
                unviInFB = this.bhTreeArr[0].getVisibleBHTrees(rBin, bhTrees, frustumBBox, referenceTime, stateChanged, visibilityPolicy, true);
            }
        }
        BoundingBox localeFrustumBBox = new BoundingBox();
        Object object = this.visLock;
        synchronized (object) {
            for (int j2 = 0; j2 < this.bhTreeCount; ++j2) {
                if (!locale.hiRes.equals(this.bhTreeArr[j2].locale.hiRes)) {
                    this.bhTreeArr[j2].locale.hiRes.difference(locale.hiRes, this.localeTrans);
                    localeFrustumBBox.lower.x = frustumBBox.lower.x + this.localeTrans.x;
                    localeFrustumBBox.lower.y = frustumBBox.lower.y + this.localeTrans.y;
                    localeFrustumBBox.lower.z = frustumBBox.lower.z + this.localeTrans.z;
                    localeFrustumBBox.upper.x = frustumBBox.upper.x + this.localeTrans.x;
                    localeFrustumBBox.upper.y = frustumBBox.upper.y + this.localeTrans.y;
                    localeFrustumBBox.upper.z = frustumBBox.upper.z + this.localeTrans.z;
                } else {
                    frustumBBox.copy(localeFrustumBBox);
                }
                if (this.bhTreeArr[j2].getVisibleBHTrees(rBin, bhTrees, localeFrustumBBox, referenceTime, stateChanged, visibilityPolicy, false)) continue;
                unviInFB = false;
            }
        }
        this.lock.readUnlock();
        return unviInFB;
    }

    GeometryAtom[] pickAll(Locale locale, PickShape shape) {
        UnorderList hitList = new UnorderList(BHNode.class);
        hitList.clear();
        this.lock.readLock();
        int i2 = this.getBHTreeIndex(locale);
        if (i2 < 0) {
            this.lock.readUnlock();
            return null;
        }
        this.bhTreeArr[i2].select(shape, hitList);
        this.lock.readUnlock();
        int size = hitList.size();
        if (size < 1) {
            return null;
        }
        BHNode[] hitArr = (BHNode[])hitList.toArray(false);
        GeometryAtom[] geometryAtoms = new GeometryAtom[size];
        for (i2 = 0; i2 < size; ++i2) {
            geometryAtoms[i2] = (GeometryAtom)((BHLeafNode)hitArr[i2]).leafIF;
        }
        return geometryAtoms;
    }

    GeometryAtom pickAny(Locale locale, PickShape shape) {
        BHNode hitNode = null;
        this.lock.readLock();
        int i2 = this.getBHTreeIndex(locale);
        if (i2 < 0) {
            this.lock.readUnlock();
            return null;
        }
        hitNode = this.bhTreeArr[i2].selectAny(shape);
        this.lock.readUnlock();
        if (hitNode == null) {
            return null;
        }
        return (GeometryAtom)((BHLeafNode)hitNode).leafIF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWakeupOnCollision(WakeupOnCollisionEntry w) {
        boolean needTrigger = true;
        Object object = this.collideListLock;
        synchronized (object) {
            WakeupOnCollisionEntry[] collideEntryArr = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
            for (int i2 = this.collideEntryList.arraySize() - 1; i2 >= 0; --i2) {
                WakeupOnCollisionEntry wentry = collideEntryArr[i2];
                if (wentry.behav != w.behav || wentry.geometryAtoms != w.geometryAtoms) continue;
                this.collideEntryList.remove(i2);
                needTrigger = false;
                break;
            }
        }
        this.wakeupOnCollisionEntry.add(w);
        w.updateCollisionBounds(false);
        BHLeafInterface target = this.collide(w.behav.locale, w.accuracyMode, w.geometryAtoms, w.vwcBounds, w.boundingLeaf, w.armingNode, null);
        if (target != null) {
            this.collideEntryList.add(w);
            w.setTarget(target);
        }
        if (target != null && needTrigger) {
            w.setTriggered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWakeupOnCollision(WakeupOnCollisionExit w) {
        boolean needTrigger = true;
        Object object = this.collideListLock;
        synchronized (object) {
            WakeupOnCollisionExit[] collideExitArr = (WakeupOnCollisionExit[])this.collideExitList.toArray();
            for (int i2 = this.collideExitList.arraySize() - 1; i2 >= 0; --i2) {
                WakeupOnCollisionExit wexit = collideExitArr[i2];
                if (wexit.behav != w.behav || wexit.geometryAtoms != w.geometryAtoms) continue;
                this.collideExitList.remove(i2);
                needTrigger = false;
                break;
            }
        }
        this.wakeupOnCollisionExit.add(w);
        w.updateCollisionBounds(false);
        BHLeafInterface target = this.collide(w.behav.locale, w.accuracyMode, w.geometryAtoms, w.vwcBounds, w.boundingLeaf, w.armingNode, null);
        if (target != null) {
            w.setTarget(target);
            this.collideExitList.add(w);
        }
        if (!needTrigger) {
            return;
        }
        Object object2 = this.collideListLock;
        synchronized (object2) {
            WakeupOnCollisionEntry[] collideEntryArr = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
            for (int i3 = this.collideEntryList.arraySize() - 1; i3 >= 0; --i3) {
                WakeupOnCollisionEntry wentry = collideEntryArr[i3];
                if (wentry.behav != w.behav || wentry.geometryAtoms != w.geometryAtoms) continue;
                if (target != null) break;
                w.setTriggered();
                break;
            }
        }
    }

    void addWakeupOnCollision(WakeupOnCollisionMovement w) {
        this.wakeupOnCollisionMovement.add(w);
        w.updateCollisionBounds(false);
        BHLeafInterface target = this.collide(w.behav.locale, w.accuracyMode, w.geometryAtoms, w.vwcBounds, w.boundingLeaf, w.armingNode, w);
        if (target != null) {
            w.setTarget(target);
            this.collideMovementList.add(w);
        }
    }

    void removeWakeupOnCollision(WakeupOnCollisionEntry wentry) {
        this.wakeupOnCollisionEntry.remove(wentry);
    }

    void removeWakeupOnCollision(WakeupOnCollisionExit wexit) {
        this.wakeupOnCollisionExit.remove(wexit);
    }

    void removeWakeupOnCollision(WakeupOnCollisionMovement wmovement) {
        this.wakeupOnCollisionMovement.remove(wmovement);
        this.collideMovementList.remove(wmovement);
    }

    void processCollisionDetection() {
        int idx;
        BHLeafInterface target;
        int i2;
        WakeupOnCollisionEntry[] wentryArr = (WakeupOnCollisionEntry[])this.wakeupOnCollisionEntry.toArray();
        for (i2 = this.wakeupOnCollisionEntry.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnCollisionEntry wentry = wentryArr[i2];
            wentry.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            target = this.collide(wentry.behav.locale, wentry.accuracyMode, wentry.geometryAtoms, wentry.vwcBounds, wentry.boundingLeaf, wentry.armingNode, null);
            idx = this.collideEntryList.indexOf(wentry);
            if (target != null) {
                if (idx >= 0) continue;
                this.collideEntryList.add(wentry);
                wentry.setTarget(target);
                wentry.setTriggered();
                continue;
            }
            if (idx < 0) continue;
            this.collideEntryList.remove(idx);
        }
        WakeupOnCollisionMovement[] wmoveArr = (WakeupOnCollisionMovement[])this.wakeupOnCollisionMovement.toArray();
        for (i2 = this.wakeupOnCollisionMovement.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnCollisionMovement wmove = wmoveArr[i2];
            wmove.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            target = this.collide(wmove.behav.locale, wmove.accuracyMode, wmove.geometryAtoms, wmove.vwcBounds, wmove.boundingLeaf, wmove.armingNode, wmove);
            idx = this.collideMovementList.indexOf(wmove);
            if (target != null) {
                if (idx < 0) {
                    this.collideMovementList.add(wmove);
                    wmove.setTarget(target);
                    continue;
                }
                if (wmove.duplicateEvent) continue;
                wmove.setTriggered();
                continue;
            }
            if (idx < 0) continue;
            this.collideMovementList.remove(idx);
            wmove.lastSrcBounds = null;
            wmove.lastDstBounds = null;
        }
        WakeupOnCollisionExit[] wexitArr = (WakeupOnCollisionExit[])this.wakeupOnCollisionExit.toArray();
        for (i2 = this.wakeupOnCollisionExit.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnCollisionExit wexit = wexitArr[i2];
            wexit.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            target = this.collide(wexit.behav.locale, wexit.accuracyMode, wexit.geometryAtoms, wexit.vwcBounds, wexit.boundingLeaf, wexit.armingNode, null);
            idx = this.collideExitList.indexOf(wexit);
            if (target != null) {
                if (idx >= 0) continue;
                this.collideExitList.add(wexit);
                wexit.setTarget(target);
                continue;
            }
            if (idx < 0) continue;
            this.collideExitList.remove(idx);
            wexit.setTriggered();
        }
    }

    void checkDuplicateEvent(WakeupOnCollisionMovement wmove, Bounds bound, BHLeafInterface hitNode) {
        if (wmove.lastSrcBounds != null && wmove.lastSrcBounds.equals(bound)) {
            BoundingBox hitBound = hitNode instanceof GeometryAtom ? ((GeometryAtom)hitNode).source.vwcBounds : ((GroupRetained)hitNode).collisionVwcBounds;
            if (wmove.lastDstBounds != null && wmove.lastDstBounds.equals(hitBound)) {
                wmove.duplicateEvent = true;
            } else {
                wmove.duplicateEvent = false;
                wmove.lastDstBounds = (Bounds)((Bounds)hitBound).clone();
            }
        } else {
            wmove.duplicateEvent = false;
            wmove.lastSrcBounds = (Bounds)bound.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BHLeafInterface collide(Locale locale, int accurancyMode, UnorderList geomAtoms, Bounds bound, BoundingLeafRetained boundingLeaf, NodeRetained armingNode, WakeupCriterion cond) {
        this.lock.readLock();
        int idx = this.getBHTreeIndex(locale);
        if (idx < 0) {
            this.lock.readUnlock();
            return null;
        }
        if (geomAtoms != null) {
            BHTree bHTree = this.bhTreeArr[idx];
            synchronized (bHTree) {
                if (bound != null && armingNode instanceof GroupRetained) {
                    BHLeafInterface hitNode = this.bhTreeArr[idx].selectAny(bound, accurancyMode, (GroupRetained)armingNode);
                    if (hitNode == null) {
                        this.lock.readUnlock();
                        return null;
                    }
                    GeometryAtom[] galist = (GeometryAtom[])geomAtoms.toArray(false);
                    hitNode = this.bhTreeArr[idx].selectAny(galist, geomAtoms.arraySize(), accurancyMode);
                    if (hitNode != null) {
                        this.lock.readUnlock();
                        if (cond != null) {
                            this.checkDuplicateEvent((WakeupOnCollisionMovement)cond, bound, hitNode);
                        }
                        return hitNode;
                    }
                } else {
                    GeometryAtom ga = (GeometryAtom)geomAtoms.get(0);
                    BHLeafInterface hitNode = this.bhTreeArr[idx].selectAny(ga, accurancyMode);
                    if (hitNode != null) {
                        this.lock.readUnlock();
                        if (cond != null) {
                            this.checkDuplicateEvent((WakeupOnCollisionMovement)cond, ga.source.vwcBounds, hitNode);
                        }
                        return hitNode;
                    }
                }
            }
        } else {
            if (bound == null) {
                if (boundingLeaf == null) {
                    this.lock.readUnlock();
                    return null;
                }
                bound = boundingLeaf.transformedRegion;
            }
            if (bound == null) {
                this.lock.readUnlock();
                return null;
            }
            if (armingNode instanceof GroupRetained) {
                BHTree bHTree = this.bhTreeArr[idx];
                synchronized (bHTree) {
                    BHLeafInterface hitNode = this.bhTreeArr[idx].selectAny(bound, accurancyMode, (GroupRetained)armingNode);
                    this.lock.readUnlock();
                    if (hitNode != null && cond != null) {
                        this.checkDuplicateEvent((WakeupOnCollisionMovement)cond, bound, hitNode);
                    }
                    return hitNode;
                }
            }
            BHTree bHTree = this.bhTreeArr[idx];
            synchronized (bHTree) {
                BHLeafInterface hitNode = this.bhTreeArr[idx].selectAny(bound, accurancyMode, armingNode);
                this.lock.readUnlock();
                if (hitNode != null && cond != null) {
                    this.checkDuplicateEvent((WakeupOnCollisionMovement)cond, bound, hitNode);
                }
                return hitNode;
            }
        }
        this.lock.readUnlock();
        return null;
    }

    void resetConditionMet() {
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionExit);
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionMovement);
    }

    private void processSwitchChanged(J3dMessage m2) {
    }

    @Override
    void cleanup() {
        this.collideEntryList.clear();
        this.collideExitList.clear();
        this.collideMovementList.clear();
        this.wakeupOnCollisionEntry.clear();
        this.wakeupOnCollisionExit.clear();
        this.wakeupOnCollisionMovement.clear();
    }
}

