/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BHLeafInterface;
import org.jogamp.java3d.BHLeafNode;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.NnuId;
import org.jogamp.java3d.NnuIdManager;
import org.jogamp.java3d.RenderAtom;
import org.jogamp.java3d.RenderAtomListInfo;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Point3d;

class GeometryAtom
implements BHLeafInterface,
NnuId {
    GeometryRetained[] geometryArray = null;
    Transform3D[] lastLocalTransformArray = null;
    Locale locale = null;
    Shape3DRetained source = null;
    BHLeafNode bhLeafNode = null;
    boolean alphaEditable;
    boolean visible = true;
    int geoType = -1;
    RenderAtom[] renderAtoms = new RenderAtom[0];
    int nnuId;
    Point3d[] centroid = null;
    boolean centroidIsDirty = true;
    Object lockObj = new Object();

    GeometryAtom() {
        this.nnuId = NnuIdManager.getId();
    }

    @Override
    public int getId() {
        return this.nnuId;
    }

    @Override
    public int equal(NnuId obj) {
        int keyId = obj.getId();
        if (this.nnuId < keyId) {
            return -1;
        }
        if (this.nnuId > keyId) {
            return 1;
        }
        return 0;
    }

    @Override
    public BoundingBox computeBoundingHull() {
        return this.source.vwcBounds;
    }

    @Override
    public boolean isEnable() {
        return this.source.vwcBounds != null && !this.source.vwcBounds.isEmpty() && this.source.switchState.currentSwitchOn;
    }

    @Override
    public boolean isEnable(int vis) {
        if (this.source.vwcBounds != null && !this.source.vwcBounds.isEmpty() && this.source.switchState.currentSwitchOn) {
            switch (vis) {
                case 0: {
                    return this.visible;
                }
                case 1: {
                    return !this.visible;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Locale getLocale2() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RenderAtom getRenderAtom(View view) {
        Object object = this.lockObj;
        synchronized (object) {
            RenderAtom ra;
            if (this.source.viewList != null && !this.source.viewList.contains(view)) {
                return null;
            }
            int index = view.viewIndex;
            if (index >= this.renderAtoms.length) {
                RenderAtom[] newList = new RenderAtom[index + 1];
                System.arraycopy(this.renderAtoms, 0, newList, 0, this.renderAtoms.length);
                this.renderAtoms = newList;
            }
            if ((ra = this.renderAtoms[index]) == null) {
                this.renderAtoms[index] = ra = new RenderAtom();
                ra.geometryAtom = this;
                boolean isGeoTypeText3D = this.geoType == 16;
                ra.rListInfo = new RenderAtomListInfo[this.geometryArray.length];
                for (int j2 = 0; j2 < ra.rListInfo.length; ++j2) {
                    ra.rListInfo[j2] = new RenderAtomListInfo(ra, j2);
                    if (!isGeoTypeText3D) continue;
                    ra.rListInfo[j2].localToVworld = new Transform3D();
                }
            }
            return ra;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCentroid() {
        if (VirtualUniverse.mc.sortShape3DBounds && !this.source.boundsAutoCompute) {
            Object object = this.lockObj;
            synchronized (object) {
                if (this.centroid == null) {
                    this.centroid = new Point3d[this.geometryArray.length];
                    for (int j2 = 0; j2 < this.centroid.length; ++j2) {
                        this.centroid[j2] = new Point3d();
                        this.source.localBounds.getCenter(this.centroid[j2]);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[j2]);
                    }
                } else {
                    for (int j3 = 0; j3 < this.centroid.length; ++j3) {
                        this.source.localBounds.getCenter(this.centroid[j3]);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[j3]);
                    }
                }
            }
            return;
        }
        Object object = this.lockObj;
        synchronized (object) {
            int j4;
            for (j4 = 0; j4 < this.geometryArray.length; ++j4) {
                if (this.geometryArray[j4] == null) continue;
                Point3d point3d = this.geometryArray[j4].centroid;
                synchronized (point3d) {
                    if (this.geometryArray[j4].recompCentroid) {
                        this.geometryArray[j4].computeCentroid();
                        this.geometryArray[j4].recompCentroid = false;
                    }
                    continue;
                }
            }
            if (this.centroidIsDirty) {
                if (this.centroid == null) {
                    this.centroid = new Point3d[this.geometryArray.length];
                    for (j4 = 0; j4 < this.centroid.length; ++j4) {
                        if (this.geometryArray[j4] == null) continue;
                        this.centroid[j4] = new Point3d(this.geometryArray[j4].centroid);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[j4]);
                    }
                } else {
                    for (j4 = 0; j4 < this.centroid.length; ++j4) {
                        if (this.geometryArray[j4] == null) continue;
                        this.centroid[j4].set(this.geometryArray[j4].centroid);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[j4]);
                    }
                }
                this.centroidIsDirty = false;
            }
        }
    }
}

