/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.ExponentialFogRetained;
import org.jogamp.java3d.Fog;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Node;
import org.jogamp.vecmath.Color3f;

public class ExponentialFog
extends Fog {
    public static final int ALLOW_DENSITY_READ = 16;
    public static final int ALLOW_DENSITY_WRITE = 17;
    private static final int[] readCapabilities = new int[]{16};

    public ExponentialFog() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public ExponentialFog(Color3f color) {
        super(color);
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public ExponentialFog(Color3f color, float density) {
        super(color);
        this.setDefaultReadCapabilities(readCapabilities);
        ((ExponentialFogRetained)this.retained).initDensity(density);
    }

    public ExponentialFog(float r, float g2, float b2) {
        super(r, g2, b2);
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public ExponentialFog(float r, float g2, float b2, float density) {
        super(r, g2, b2);
        this.setDefaultReadCapabilities(readCapabilities);
        ((ExponentialFogRetained)this.retained).initDensity(density);
    }

    public void setDensity(float density) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ExponentialFog0"));
        }
        if (this.isLive()) {
            ((ExponentialFogRetained)this.retained).setDensity(density);
        } else {
            ((ExponentialFogRetained)this.retained).initDensity(density);
        }
    }

    public float getDensity() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ExponentialFog1"));
        }
        return ((ExponentialFogRetained)this.retained).getDensity();
    }

    @Override
    void createRetained() {
        this.retained = new ExponentialFogRetained();
        this.retained.setSource(this);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        ExponentialFog ef = new ExponentialFog();
        ef.duplicateNode(this, forceDuplicate);
        return ef;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        ((ExponentialFogRetained)this.retained).initDensity(((ExponentialFogRetained)originalNode.retained).getDensity());
    }
}

