/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.AttributeBin;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.FogRetained;
import org.jogamp.java3d.LightBin;
import org.jogamp.java3d.LightRetained;
import org.jogamp.java3d.ModelClipRetained;
import org.jogamp.java3d.ObjectUpdate;
import org.jogamp.java3d.RenderAtom;
import org.jogamp.java3d.RenderBin;
import org.jogamp.vecmath.Color3f;

class EnvironmentSet
implements ObjectUpdate {
    static final int LIGHTENABLE_CHANGED = 1;
    static final int AMBIENT_CHANGED = 2;
    static final int FOG_CHANGED = 4;
    static final int MODELCLIP_CHANGED = 8;
    ArrayList<LightRetained> lights = new ArrayList();
    int[] ltPos = null;
    ArrayList<LightRetained> ambLights = new ArrayList();
    LightBin lightBin = null;
    long enableMask = 0L;
    Color3f sceneAmbient = new Color3f();
    RenderBin renderBin = null;
    FogRetained fog = null;
    ModelClipRetained modelClip = null;
    int enableMCMask = 0;
    int enableMCMaskCache = 0;
    EnvironmentSet next = null;
    EnvironmentSet prev = null;
    ArrayList<AttributeBin> addAttributeBins = new ArrayList();
    int canvasDirty = 0;
    long enableMaskCache = 0L;
    boolean onUpdateList = false;
    AttributeBin attributeBinList = null;

    EnvironmentSet(RenderAtom ra, LightRetained[] lightList, FogRetained fog, ModelClipRetained modelClip, RenderBin rb) {
        this.renderBin = rb;
        this.reset(ra, lightList, fog, modelClip);
    }

    private void reset(RenderAtom ra, LightRetained[] lightList, FogRetained fog, ModelClipRetained modelClip) {
        int i2;
        this.prev = null;
        this.next = null;
        this.onUpdateList = false;
        this.attributeBinList = null;
        this.lights.clear();
        this.ambLights.clear();
        this.sceneAmbient.x = 0.0f;
        this.sceneAmbient.y = 0.0f;
        this.sceneAmbient.z = 0.0f;
        if (lightList != null) {
            for (i2 = 0; i2 < lightList.length; ++i2) {
                LightRetained light = lightList[i2];
                if (light.nodeType == 5) {
                    this.ambLights.add(light);
                    this.sceneAmbient.x += light.color.x;
                    this.sceneAmbient.y += light.color.y;
                    this.sceneAmbient.z += light.color.z;
                    continue;
                }
                this.lights.add(light);
            }
            if (this.sceneAmbient.x > 1.0f) {
                this.sceneAmbient.x = 1.0f;
            }
            if (this.sceneAmbient.y > 1.0f) {
                this.sceneAmbient.y = 1.0f;
            }
            if (this.sceneAmbient.z > 1.0f) {
                this.sceneAmbient.z = 1.0f;
            }
        }
        this.fog = fog;
        this.modelClip = modelClip;
        this.enableMCMaskCache = 0;
        if (modelClip != null) {
            for (i2 = 0; i2 < 6; ++i2) {
                if (!modelClip.enables[i2]) continue;
                this.enableMCMaskCache |= 1 << i2;
            }
            this.enableMCMask = this.enableMCMaskCache;
        }
        this.ltPos = new int[this.lights.size()];
        this.enableMask = 0L;
        if (lightList != null) {
            for (i2 = 0; i2 < lightList.length; ++i2) {
                lightList[i2].environmentSets.add(this);
            }
        }
        if (fog != null) {
            fog.environmentSets.add(this);
        }
        if (modelClip != null) {
            modelClip.environmentSets.add(this);
        }
    }

    boolean equals(RenderAtom ra, LightRetained[] lights, FogRetained fog, ModelClipRetained modelClip) {
        if (lights == null && this.ambLights == null) {
            if (this.lights.size() == 0) {
                return this.fog == fog;
            }
            return false;
        }
        if (this.lights.size() + this.ambLights.size() != lights.length) {
            return false;
        }
        for (int i2 = 0; i2 < lights.length; ++i2) {
            if (!(lights[i2].nodeType == 5 ? !this.ambLights.contains(lights[i2]) : !this.lights.contains(lights[i2]))) continue;
            return false;
        }
        if (this.fog != fog) {
            return false;
        }
        return this.modelClip == modelClip;
    }

    boolean equalLights(LightRetained[] lights) {
        if (lights == null && this.ambLights == null && this.lights.size() == 0) {
            return true;
        }
        if (this.lights.size() + this.ambLights.size() != lights.length) {
            return false;
        }
        for (int i2 = 0; i2 < lights.length; ++i2) {
            if (!(lights[i2].nodeType == 5 ? !this.ambLights.contains(lights[i2]) : !this.lights.contains(lights[i2]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateObject() {
        int i2;
        if (this.addAttributeBins.size() > 0) {
            AttributeBin a2 = this.addAttributeBins.get(0);
            if (this.attributeBinList == null) {
                this.attributeBinList = a2;
            } else {
                a2.next = this.attributeBinList;
                this.attributeBinList.prev = a2;
                this.attributeBinList = a2;
            }
            for (i2 = 1; i2 < this.addAttributeBins.size(); ++i2) {
                a2 = this.addAttributeBins.get(i2);
                a2.next = this.attributeBinList;
                this.attributeBinList.prev = a2;
                this.attributeBinList = a2;
            }
        }
        this.addAttributeBins.clear();
        if (this.canvasDirty != 0) {
            Canvas3D[] canvases = this.renderBin.view.getCanvases();
            for (i2 = 0; i2 < canvases.length; ++i2) {
                canvases[i2].canvasDirty |= this.canvasDirty;
            }
            if ((this.canvasDirty & 0x100) != 0) {
                this.updateSceneAmbient();
            }
            if ((this.canvasDirty & 0x80) != 0) {
                this.enableMask = this.enableMaskCache;
            }
            if ((this.canvasDirty & 0x4000) != 0) {
                this.enableMCMask = this.enableMCMaskCache;
            }
            this.canvasDirty = 0;
        }
        this.onUpdateList = false;
    }

    void addAttributeBin(AttributeBin a2, RenderBin rb) {
        a2.environmentSet = this;
        this.addAttributeBins.add(a2);
        if (!this.onUpdateList) {
            rb.objUpdateList.add(this);
            this.onUpdateList = true;
        }
    }

    void removeAttributeBin(AttributeBin a2) {
        a2.environmentSet = null;
        if (this.addAttributeBins.contains(a2)) {
            this.addAttributeBins.remove(this.addAttributeBins.indexOf(a2));
        } else if (a2.prev == null) {
            this.attributeBinList = a2.next;
            if (a2.next != null) {
                a2.next.prev = null;
            }
        } else {
            a2.prev.next = a2.next;
            if (a2.next != null) {
                a2.next.prev = a2.prev;
            }
        }
        a2.prev = null;
        a2.next = null;
        if (a2.definingRenderingAttributes != null && a2.definingRenderingAttributes.changedFrequent != 0) {
            a2.definingRenderingAttributes = null;
        }
        a2.onUpdateList &= ~AttributeBin.ON_CHANGED_FREQUENT_UPDATE_LIST;
        if (this.attributeBinList == null && this.addAttributeBins.size() == 0) {
            int i2;
            int sz = this.lights.size();
            for (i2 = 0; i2 < sz; ++i2) {
                this.lights.get((int)i2).environmentSets.remove(this);
            }
            sz = this.ambLights.size();
            for (i2 = 0; i2 < sz; ++i2) {
                this.ambLights.get((int)i2).environmentSets.remove(this);
            }
            if (this.fog != null) {
                this.fog.environmentSets.remove(this);
            }
            this.lightBin.removeEnvironmentSet(this);
        }
    }

    void updateSceneAmbient() {
        this.sceneAmbient.x = 0.0f;
        this.sceneAmbient.y = 0.0f;
        this.sceneAmbient.z = 0.0f;
        for (int i2 = 0; i2 < this.ambLights.size(); ++i2) {
            LightRetained aL = this.ambLights.get(i2);
            if (!aL.lightOn) continue;
            this.sceneAmbient.x += aL.color.x;
            this.sceneAmbient.y += aL.color.y;
            this.sceneAmbient.z += aL.color.z;
        }
        if (this.sceneAmbient.x > 1.0f) {
            this.sceneAmbient.x = 1.0f;
        }
        if (this.sceneAmbient.y > 1.0f) {
            this.sceneAmbient.y = 1.0f;
        }
        if (this.sceneAmbient.z > 1.0f) {
            this.sceneAmbient.z = 1.0f;
        }
    }

    void render(Canvas3D cv) {
        cv.setStateToUpdate(1, this);
        AttributeBin a2 = this.attributeBinList;
        while (a2 != null) {
            a2.render(cv);
            a2 = a2.next;
        }
    }

    void updateAttributes(Canvas3D cv) {
        boolean updateSceneAmbient = false;
        boolean updateLightEnables = false;
        boolean updateModelClip = false;
        boolean updateFog = false;
        if (cv.environmentSet != this) {
            if (cv.enableMask != this.enableMask) {
                updateLightEnables = true;
            }
            if (cv.sceneAmbient.x != this.sceneAmbient.x || cv.sceneAmbient.y != this.sceneAmbient.y || cv.sceneAmbient.z != this.sceneAmbient.z) {
                updateSceneAmbient = true;
            }
            if (cv.fog != this.fog) {
                updateFog = true;
            }
            if (cv.modelClip != this.modelClip) {
                updateModelClip = true;
            }
        }
        if ((cv.canvasDirty & 0xE180) != 0) {
            if ((cv.canvasDirty & 0x80) != 0) {
                updateLightEnables = true;
            }
            if ((cv.canvasDirty & 0x100) != 0) {
                updateSceneAmbient = true;
            }
            if ((cv.canvasDirty & 0x2000) != 0) {
                updateFog = true;
            }
            if ((cv.canvasDirty & 0x4000) != 0) {
                updateModelClip = true;
            }
            if ((cv.canvasDirty & 0x8000) != 0) {
                updateFog = true;
                updateModelClip = true;
            }
        }
        if (updateLightEnables) {
            cv.setLightEnables(cv.ctx, this.enableMask, this.renderBin.maxLights);
            cv.enableMask = this.enableMask;
        }
        if (updateSceneAmbient) {
            cv.setSceneAmbient(cv.ctx, this.sceneAmbient.x, this.sceneAmbient.y, this.sceneAmbient.z);
            cv.sceneAmbient.set(this.sceneAmbient);
        }
        if (updateFog) {
            if (this.fog != null) {
                double scale = this.lightBin.geometryBackground == null ? cv.canvasViewCache.getVworldToCoexistenceScale() : cv.canvasViewCache.getInfVworldToCoexistenceScale();
                this.fog.update(cv.ctx, scale);
            } else {
                cv.disableFog(cv.ctx);
            }
            cv.fog = this.fog;
        }
        if (updateModelClip) {
            if (this.modelClip != null) {
                this.modelClip.update(cv, this.enableMCMask);
            } else {
                cv.disableModelClip(cv.ctx);
            }
            cv.modelClip = this.modelClip;
        }
        cv.canvasDirty &= 0xFFFF1E7F;
        cv.environmentSet = this;
    }
}

