/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Iterator;
import org.jogamp.java3d.LOD;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.SwitchRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.View;
import org.jogamp.java3d.ViewPlatform;
import org.jogamp.java3d.ViewPlatformRetained;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.vecmath.Point3f;

public class DistanceLOD
extends LOD {
    private double[] distances;
    private Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    private Point3f center = new Point3f();
    private Point3f viewPosition = new Point3f();

    public DistanceLOD() {
        this.distances = new double[1];
        this.distances[0] = 0.0;
    }

    public DistanceLOD(float[] distances) {
        this.distances = new double[distances.length];
        for (int i2 = 0; i2 < distances.length; ++i2) {
            this.distances[i2] = distances[i2];
        }
    }

    public DistanceLOD(float[] distances, Point3f position) {
        this.distances = new double[distances.length];
        for (int i2 = 0; i2 < distances.length; ++i2) {
            this.distances[i2] = distances[i2];
        }
        this.position.set(position);
    }

    public void setPosition(Point3f position) {
        if (((NodeRetained)this.retained).staticTransform != null) {
            ((NodeRetained)this.retained).staticTransform.transform.transform(position, this.position);
        } else {
            this.position.set(position);
        }
    }

    public void getPosition(Point3f position) {
        if (((NodeRetained)this.retained).staticTransform != null) {
            Transform3D invTransform = ((NodeRetained)this.retained).staticTransform.getInvTransform();
            invTransform.transform(this.position, position);
        } else {
            position.set(this.position);
        }
    }

    public int numDistances() {
        return this.distances.length;
    }

    public double getDistance(int whichDistance) {
        return this.distances[whichDistance];
    }

    public void setDistance(int whichDistance, double distance) {
        this.distances[whichDistance] = distance;
    }

    @Override
    public void initialize() {
        this.wakeupOn(this.wakeupFrame);
    }

    @Override
    public void processStimulus(Iterator<WakeupCriterion> criteria) {
        int i2;
        View v = this.getView();
        if (v == null) {
            this.wakeupOn(this.wakeupFrame);
            return;
        }
        ViewPlatform vp = v.getViewPlatform();
        if (vp == null) {
            return;
        }
        double viewDistance = 0.0;
        int index = 0;
        Transform3D localToWorldTrans = new Transform3D();
        localToWorldTrans.set(((NodeRetained)this.retained).getCurrentLocalToVworld());
        localToWorldTrans.transform(this.position, this.center);
        this.viewPosition.x = (float)((ViewPlatformRetained)vp.retained).schedSphere.center.x;
        this.viewPosition.y = (float)((ViewPlatformRetained)vp.retained).schedSphere.center.y;
        this.viewPosition.z = (float)((ViewPlatformRetained)vp.retained).schedSphere.center.z;
        viewDistance = this.center.distance(this.viewPosition);
        viewDistance /= localToWorldTrans.getDistanceScale();
        int nSwitches = this.numSwitches();
        index = this.distances.length;
        if (viewDistance <= this.distances[0]) {
            index = 0;
        } else {
            for (i2 = 1; i2 < this.distances.length; ++i2) {
                if (!(viewDistance > this.distances[i2 - 1]) || !(viewDistance <= this.distances[i2])) continue;
                index = i2;
                break;
            }
        }
        for (i2 = nSwitches - 1; i2 >= 0; --i2) {
            Switch sw = this.getSwitch(i2);
            if (((SwitchRetained)sw.retained).getWhichChild() == index) continue;
            sw.setWhichChild(index);
        }
        this.wakeupOn(this.wakeupFrame);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        DistanceLOD d2 = new DistanceLOD();
        d2.duplicateNode(this, forceDuplicate);
        return d2;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        DistanceLOD lod = (DistanceLOD)originalNode;
        int numD = lod.numDistances();
        this.distances = new double[numD];
        for (int i2 = 0; i2 < numD; ++i2) {
            this.setDistance(i2, lod.getDistance(i2));
        }
        Point3f p = new Point3f();
        lod.getPosition(p);
        this.setPosition(p);
    }

    void mergeTransform(TransformGroupRetained xform) {
        xform.transform.transform(this.position, this.position);
    }
}

