/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.PointSoundRetained;
import org.jogamp.java3d.SoundRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

class ConeSoundRetained
extends PointSoundRetained {
    Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    static final int NO_FILTERING = -1;
    static final int LOW_PASS = 1;
    float[] backAttenuationDistance = null;
    float[] backAttenuationGain = null;
    float[] angularDistance = new float[]{0.0f, 1.5707964f};
    float[] angularGain = new float[]{1.0f, 0.0f};
    int filterType = -1;
    float[] frequencyCutoff = new float[]{-1.0f, -1.0f};

    ConeSoundRetained() {
        this.nodeType = 14;
    }

    void setDistanceGain(Point2f[] frontAttenuation, Point2f[] backAttenuation) {
        this.setDistanceGain(frontAttenuation);
        this.setBackDistanceGain(backAttenuation);
    }

    void setDistanceGain(float[] frontDistance, float[] frontGain, float[] backDistance, float[] backGain) {
        this.setDistanceGain(frontDistance, frontGain);
        this.setBackDistanceGain(backDistance, backGain);
    }

    void setBackDistanceGain(Point2f[] attenuation) {
        if (attenuation == null) {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        } else {
            int attenuationLength = attenuation.length;
            if (attenuationLength == 0) {
                this.backAttenuationDistance = null;
                this.backAttenuationGain = null;
            } else {
                this.backAttenuationDistance = new float[attenuationLength];
                this.backAttenuationGain = new float[attenuationLength];
                for (int i2 = 0; i2 < attenuationLength; ++i2) {
                    this.backAttenuationDistance[i2] = attenuation[i2].x;
                    this.backAttenuationGain[i2] = attenuation[i2].y;
                }
            }
        }
        this.dispatchAttribChange(256, attenuation);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setBackDistanceGain(float[] distance, float[] gain) {
        int i2;
        int distanceLength = 0;
        if (distance == null || gain == null) {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        } else {
            int gainLength = gain.length;
            distanceLength = distance.length;
            if (distanceLength == 0 || gainLength == 0) {
                this.backAttenuationDistance = null;
                this.backAttenuationGain = null;
            } else {
                this.backAttenuationDistance = new float[distanceLength];
                this.backAttenuationGain = new float[distanceLength];
                System.arraycopy(distance, 0, this.backAttenuationDistance, 0, distanceLength);
                if (distanceLength <= gainLength) {
                    System.arraycopy(gain, 0, this.backAttenuationGain, 0, distanceLength);
                } else {
                    System.arraycopy(gain, 0, this.backAttenuationGain, 0, gainLength);
                    for (i2 = gainLength; i2 < distanceLength; ++i2) {
                        this.backAttenuationGain[i2] = gain[gainLength - 1];
                    }
                }
            }
        }
        Point2f[] attenuation = new Point2f[distanceLength];
        for (i2 = 0; i2 < distanceLength; ++i2) {
            attenuation[i2] = new Point2f(this.backAttenuationDistance[i2], this.backAttenuationGain[i2]);
        }
        this.dispatchAttribChange(256, attenuation);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void getDistanceGain(Point2f[] frontAttenuation, Point2f[] backAttenuation) {
        this.getDistanceGain(frontAttenuation);
        this.getBackDistanceGain(backAttenuation);
    }

    void getDistanceGain(float[] frontDistance, float[] frontGain, float[] backDistance, float[] backGain) {
        this.getDistanceGain(frontDistance, frontGain);
        this.getBackDistanceGain(backDistance, backGain);
    }

    void getBackDistanceGain(Point2f[] attenuation) {
        if (attenuation == null) {
            return;
        }
        if (this.backAttenuationDistance == null || this.backAttenuationGain == null) {
            return;
        }
        int distanceLength = this.backAttenuationDistance.length;
        int attenuationLength = attenuation.length;
        if (distanceLength < attenuationLength) {
            distanceLength = attenuationLength;
        }
        for (int i2 = 0; i2 < distanceLength; ++i2) {
            attenuation[i2].x = this.backAttenuationDistance[i2];
            attenuation[i2].y = this.backAttenuationGain[i2];
        }
    }

    void getBackDistanceGain(float[] distance, float[] gain) {
        if (distance == null || gain == null) {
            return;
        }
        if (this.backAttenuationDistance == null || this.backAttenuationGain == null) {
            return;
        }
        int attenuationLength = this.backAttenuationDistance.length;
        int distanceLength = distance.length;
        if (attenuationLength > distanceLength) {
            attenuationLength = distanceLength;
        }
        System.arraycopy(this.backAttenuationDistance, 0, distance, 0, attenuationLength);
        attenuationLength = this.backAttenuationGain.length;
        int gainLength = gain.length;
        if (attenuationLength > gainLength) {
            attenuationLength = gainLength;
        }
        System.arraycopy(this.backAttenuationGain, 0, gain, 0, attenuationLength);
    }

    void setDirection(Vector3f direction) {
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(direction, this.direction);
        } else {
            this.direction.set(direction);
        }
        this.dispatchAttribChange(512, new Vector3f(this.direction));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setDirection(float x, float y, float z) {
        this.direction.x = x;
        this.direction.y = y;
        this.direction.z = z;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction);
        }
        this.dispatchAttribChange(512, new Vector3f(this.direction));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void getDirection(Vector3f direction) {
        if (this.staticTransform != null) {
            Transform3D invTransform = this.staticTransform.getInvTransform();
            invTransform.transform(this.direction, direction);
        } else {
            direction.set(this.direction);
        }
    }

    void getXformDirection(Vector3f direction) {
        direction.set(this.xformDirection);
    }

    void setAngularAttenuation(Point2f[] attenuation) {
        int attenuationLength = 0;
        this.filterType = -1;
        if (attenuation == null) {
            this.angularDistance = null;
            this.angularGain = null;
        } else {
            attenuationLength = attenuation.length;
            if (attenuationLength == 0) {
                this.angularDistance = null;
                this.angularGain = null;
            } else {
                this.angularDistance = new float[attenuationLength];
                this.angularGain = new float[attenuationLength];
                for (int i2 = 0; i2 < attenuationLength; ++i2) {
                    this.angularDistance[i2] = attenuation[i2].x;
                    this.angularGain[i2] = attenuation[i2].y;
                }
            }
        }
        Point3f[] attenuation3f = new Point3f[attenuationLength];
        for (int i3 = 0; i3 < attenuationLength; ++i3) {
            attenuation3f[i3] = new Point3f(this.angularDistance[i3], this.angularGain[i3], -1.0f);
        }
        this.dispatchAttribChange(1024, attenuation3f);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setAngularAttenuation(Point3f[] attenuation) {
        if (attenuation == null) {
            this.angularDistance = null;
            this.angularGain = null;
            this.frequencyCutoff = null;
            this.filterType = -1;
        } else {
            int attenuationLength = attenuation.length;
            if (attenuationLength == 0) {
                this.angularDistance = null;
                this.angularGain = null;
                this.frequencyCutoff = null;
                this.filterType = -1;
            } else {
                this.angularDistance = new float[attenuationLength];
                this.angularGain = new float[attenuationLength];
                this.frequencyCutoff = new float[attenuationLength];
                this.filterType = 1;
                for (int i2 = 0; i2 < attenuationLength; ++i2) {
                    this.angularDistance[i2] = attenuation[i2].x;
                    this.angularGain[i2] = attenuation[i2].y;
                    this.frequencyCutoff[i2] = attenuation[i2].z;
                }
            }
        }
        this.dispatchAttribChange(1024, attenuation);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setAngularAttenuation(float[] distance, float[] gain, float[] filter) {
        int distanceLength = 0;
        if (distance == null || gain == null || filter == null) {
            this.angularDistance = null;
            this.angularGain = null;
            this.frequencyCutoff = null;
            this.filterType = -1;
        } else {
            distanceLength = distance.length;
            int gainLength = gain.length;
            if (distanceLength == 0 || gainLength == 0) {
                this.angularDistance = null;
                this.angularGain = null;
                this.frequencyCutoff = null;
                this.filterType = -1;
            } else {
                int i2;
                int filterLength = filter.length;
                this.angularDistance = new float[distanceLength];
                this.angularGain = new float[distanceLength];
                this.frequencyCutoff = new float[distanceLength];
                System.arraycopy(distance, 0, this.angularDistance, 0, distanceLength);
                if (distanceLength <= gainLength) {
                    System.arraycopy(gain, 0, this.angularGain, 0, distanceLength);
                } else {
                    System.arraycopy(gain, 0, this.angularGain, 0, gainLength);
                    for (i2 = gainLength; i2 < distanceLength; ++i2) {
                        this.angularGain[i2] = gain[gainLength - 1];
                    }
                }
                if (filterLength == 0) {
                    this.filterType = -1;
                } else {
                    this.filterType = 1;
                    if (distanceLength <= filterLength) {
                        System.arraycopy(filter, 0, this.frequencyCutoff, 0, distanceLength);
                    } else {
                        System.arraycopy(filter, 0, this.frequencyCutoff, 0, filterLength);
                        for (i2 = filterLength; i2 < distanceLength; ++i2) {
                            this.frequencyCutoff[i2] = filter[filterLength - 1];
                        }
                    }
                }
            }
        }
        Point3f[] attenuation = new Point3f[distanceLength];
        for (int i3 = 0; i3 < distanceLength; ++i3) {
            attenuation[i3] = this.filterType != -1 ? new Point3f(this.angularDistance[i3], this.angularGain[i3], this.frequencyCutoff[i3]) : new Point3f(this.angularDistance[i3], this.angularGain[i3], -1.0f);
        }
        this.dispatchAttribChange(1024, attenuation);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    int getAngularAttenuationLength() {
        if (this.angularDistance == null) {
            return 0;
        }
        return this.angularDistance.length;
    }

    void getAngularAttenuation(Point3f[] attenuation) {
        if (this.angularDistance == null || this.angularGain == null) {
            return;
        }
        if (attenuation == null) {
            return;
        }
        int distanceLength = this.angularDistance.length;
        if (attenuation.length < distanceLength) {
            distanceLength = attenuation.length;
        }
        for (int i2 = 0; i2 < distanceLength; ++i2) {
            attenuation[i2].x = this.angularDistance[i2];
            attenuation[i2].y = this.angularGain[i2];
            if (this.filterType == -1 || this.frequencyCutoff == null) {
                attenuation[i2].z = -1.0f;
                continue;
            }
            if (this.filterType != 1) continue;
            attenuation[i2].z = this.frequencyCutoff[i2];
        }
    }

    void getAngularAttenuation(float[] distance, float[] gain, float[] filter) {
        if (distance == null || gain == null || filter == null) {
            return;
        }
        if (this.angularDistance == null || this.angularGain == null) {
            return;
        }
        int distanceLength = this.angularDistance.length;
        if (distance.length < distanceLength) {
            distanceLength = distance.length;
        }
        System.arraycopy(this.angularDistance, 0, distance, 0, distanceLength);
        int gainLength = this.angularGain.length;
        if (gain.length < gainLength) {
            gainLength = gain.length;
        }
        System.arraycopy(this.angularGain, 0, gain, 0, gainLength);
        int filterLength = 0;
        if (this.frequencyCutoff == null || this.filterType == -1) {
            filterLength = filter.length;
        } else {
            filterLength = this.frequencyCutoff.length;
            if (filter.length < filterLength) {
                filterLength = filter.length;
            }
        }
        if (this.filterType == -1 || this.frequencyCutoff == null) {
            for (int i2 = 0; i2 < filterLength; ++i2) {
                filter[i2] = -1.0f;
            }
        }
        if (this.filterType == 1) {
            System.arraycopy(this.frequencyCutoff, 0, filter, 0, filterLength);
        }
    }

    @Override
    void updateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        int numSnds = (Integer)objs[2];
        SoundRetained[] mSnds = (SoundRetained[])objs[3];
        if (component == -1) {
            this.initMirrorObject((ConeSoundRetained)objs[2]);
            return;
        }
        if ((component & 0x200) != 0) {
            for (int i2 = 0; i2 < numSnds; ++i2) {
                ConeSoundRetained cone = (ConeSoundRetained)mSnds[i2];
                cone.direction = (Vector3f)objs[4];
                cone.getLastLocalToVworld().transform(cone.direction, cone.xformDirection);
                cone.xformDirection.normalize();
            }
        }
        super.updateMirrorObject(objs);
    }

    synchronized void initMirrorObject(ConeSoundRetained ms) {
        super.initMirrorObject(ms);
        ms.direction.set(this.direction);
        ms.xformDirection.set(this.xformDirection);
    }

    @Override
    void updateTransformChange() {
        Transform3D lastLocalToVworld = this.getLastLocalToVworld();
        super.updateTransformChange();
        lastLocalToVworld.transform(this.direction, this.xformDirection);
        this.xformDirection.normalize();
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        xform.transform.transform(this.direction);
    }
}

