/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.AWTEvent;
import java.util.Arrays;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.BehaviorRetained;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.IndexedUnorderSet;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.J3dStructure;
import org.jogamp.java3d.PhysicalEnvironment;
import org.jogamp.java3d.Sensor;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.UpdateTargets;
import org.jogamp.java3d.View;
import org.jogamp.java3d.ViewPlatform;
import org.jogamp.java3d.ViewPlatformRetained;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupIndexedList;
import org.jogamp.java3d.WakeupOnAWTEvent;
import org.jogamp.java3d.WakeupOnActivation;
import org.jogamp.java3d.WakeupOnBehaviorPost;
import org.jogamp.java3d.WakeupOnDeactivation;
import org.jogamp.java3d.WakeupOnElapsedFrames;
import org.jogamp.java3d.WakeupOnSensorEntry;
import org.jogamp.java3d.WakeupOnSensorExit;
import org.jogamp.java3d.WakeupOnViewPlatformEntry;
import org.jogamp.java3d.WakeupOnViewPlatformExit;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

class BehaviorStructure
extends J3dStructure {
    IndexedUnorderSet behaviors;
    IndexedUnorderSet viewPlatforms;
    IndexedUnorderSet scheduleList;
    UnorderList[] processList = new UnorderList[10];
    Point3d vpCenter = new Point3d();
    Point3d vpTransCenter = new Point3d();
    WakeupIndexedList boundsEntryList;
    WakeupIndexedList boundsExitList;
    WakeupIndexedList currentSensorEntryList;
    WakeupIndexedList currentSensorExitList;
    WakeupIndexedList wakeupOnAWTEvent;
    WakeupIndexedList wakeupOnActivation;
    WakeupIndexedList wakeupOnDeactivation;
    WakeupIndexedList wakeupOnBehaviorPost;
    WakeupIndexedList wakeupOnElapsedFrames;
    WakeupIndexedList wakeupOnViewPlatformEntry;
    WakeupIndexedList wakeupOnViewPlatformExit;
    WakeupIndexedList wakeupOnSensorEntry;
    WakeupIndexedList wakeupOnSensorExit;
    UnorderList transformViewPlatformList = new UnorderList(ViewPlatformRetained.class);
    int activeWakeupOnFrameCount = 0;
    int activeWakeupOnSensorCount = 0;
    UnorderList awtEventsBuffer = new UnorderList(AWTEvent.class);
    int[] postIDBuffer = new int[10];
    int[] clonePostIDBuffer = new int[this.postIDBuffer.length];
    UnorderList behaviorPostBuffer = new UnorderList(Behavior.class);
    Transform3D sensorTransform = new Transform3D();
    Vector3d sensorLoc = new Vector3d();
    Point3d ptSensorLoc = new Point3d();
    UnorderList physicalEnvironments = new UnorderList(1, PhysicalEnvironment.class);
    UnorderList pendingBehaviors = new UnorderList(BehaviorRetained.class);
    boolean branchDetach = false;
    long awtEventTimestamp = 1L;
    boolean transformMsg = false;
    UpdateTargets targets = null;

    BehaviorStructure(VirtualUniverse u) {
        super(u, 256);
        for (int i2 = 9; i2 >= 0; --i2) {
            this.processList[i2] = new UnorderList(BehaviorRetained.class);
        }
        this.behaviors = new IndexedUnorderSet(BehaviorRetained.class, 0, u);
        this.viewPlatforms = new IndexedUnorderSet(ViewPlatformRetained.class, 0, u);
        this.scheduleList = new IndexedUnorderSet(BehaviorRetained.class, 1, u);
        this.boundsEntryList = new WakeupIndexedList(WakeupOnViewPlatformEntry.class, 1, u);
        this.boundsExitList = new WakeupIndexedList(WakeupOnViewPlatformExit.class, 1, u);
        this.currentSensorEntryList = new WakeupIndexedList(WakeupOnSensorEntry.class, 1, u);
        this.currentSensorExitList = new WakeupIndexedList(WakeupOnSensorExit.class, 1, u);
        this.wakeupOnAWTEvent = new WakeupIndexedList(WakeupOnAWTEvent.class, 0, u);
        this.wakeupOnActivation = new WakeupIndexedList(WakeupOnActivation.class, 0, u);
        this.wakeupOnDeactivation = new WakeupIndexedList(WakeupOnDeactivation.class, 0, u);
        this.wakeupOnBehaviorPost = new WakeupIndexedList(WakeupOnBehaviorPost.class, 0, u);
        this.wakeupOnElapsedFrames = new WakeupIndexedList(WakeupOnElapsedFrames.class, 0, u);
        this.wakeupOnViewPlatformEntry = new WakeupIndexedList(WakeupOnViewPlatformEntry.class, 0, u);
        this.wakeupOnViewPlatformExit = new WakeupIndexedList(WakeupOnViewPlatformExit.class, 0, u);
        this.wakeupOnSensorEntry = new WakeupIndexedList(WakeupOnSensorEntry.class, 0, u);
        this.wakeupOnSensorExit = new WakeupIndexedList(WakeupOnSensorExit.class, 0, u);
    }

    @Override
    void processMessages(long referenceTime) {
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg > 0) {
            for (int i2 = 0; i2 < nMsg; ++i2) {
                J3dMessage m2 = messages[i2];
                switch (m2.type) {
                    case 3: {
                        this.transformMsg = true;
                        break;
                    }
                    case 28: {
                        this.processConditionMet((BehaviorRetained)m2.args[0], (Boolean)m2.args[1]);
                        break;
                    }
                    case 0: {
                        this.insertNodes((Object[])m2.args[0]);
                        break;
                    }
                    case 1: {
                        this.removeNodes(m2);
                        break;
                    }
                    case 49: {
                        this.activateBehaviors();
                        break;
                    }
                    case 29: {
                        this.addToScheduleList((BehaviorRetained)m2.args[1]);
                        this.reEvaluateWakeupCount();
                        break;
                    }
                    case 30: {
                        this.removeFromScheduleList((BehaviorRetained)m2.args[1]);
                        this.reEvaluateWakeupCount();
                        break;
                    }
                    case 55: {
                        ((BehaviorRetained)m2.args[1]).schedulingInterval = (Integer)m2.args[2];
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(m2);
                        if (!this.universe.transformStructure.getLazyUpdate()) break;
                        this.transformMsg = true;
                        break;
                    }
                    case 23: {
                        this.processBoundingLeafChanged((Object[])m2.args[3], (Bounds)m2.args[2]);
                        break;
                    }
                    case 4: {
                        this.reEvaluatePhysicalEnvironments();
                        ViewPlatform v = ((View)m2.args[0]).getViewPlatform();
                        if (v == null) break;
                        this.processViewPlatformTransform((ViewPlatformRetained)v.retained);
                        break;
                    }
                    case 48: {
                        ViewPlatformRetained vp = (ViewPlatformRetained)m2.args[0];
                        vp.updateActivationRadius(((Float)m2.args[1]).floatValue());
                        this.processViewPlatformTransform(vp);
                        break;
                    }
                    case 35: {
                        BehaviorRetained behav = (BehaviorRetained)m2.args[1];
                        behav.updateTransformRegion();
                        this.processBehaviorTransform(behav);
                        break;
                    }
                    case 60: {
                        BehaviorRetained behav = (BehaviorRetained)m2.args[0];
                        behav.active = false;
                        this.addToScheduleList(behav);
                    }
                }
                m2.decRefcount();
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                UnorderList arrList = this.targets.targetList[2];
                if (arrList != null) {
                    this.processBehXformChanged(arrList);
                }
                if ((arrList = this.targets.targetList[4]) != null) {
                    this.processVpfXformChanged(arrList);
                }
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(messages, 0, nMsg, null);
        }
        if (this.activeWakeupOnSensorCount <= 0) {
            if (this.activeWakeupOnFrameCount > 0) {
                VirtualUniverse.mc.sendRunMessage(this.universe, 17);
            } else {
                VirtualUniverse.mc.sendRunMessage(this.universe, 1);
            }
        } else {
            this.checkSensorEntryExit();
            if (this.activeWakeupOnFrameCount > 0) {
                VirtualUniverse.mc.sendRunMessage(this.universe, 273);
            } else {
                VirtualUniverse.mc.sendRunMessage(this.universe, 257);
            }
        }
    }

    void insertNodes(Object[] nodes) {
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            Object node = nodes[i2];
            if (node instanceof BehaviorRetained) {
                this.pendingBehaviors.add(node);
                continue;
            }
            if (!(node instanceof ViewPlatformRetained)) continue;
            this.addViewPlatform((ViewPlatformRetained)node);
        }
    }

    void activateBehaviors() {
        BehaviorRetained[] behavArr = (BehaviorRetained[])this.pendingBehaviors.toArray(false);
        for (int i2 = this.pendingBehaviors.arraySize() - 1; i2 >= 0; --i2) {
            BehaviorRetained behav = behavArr[i2];
            behav.wakeupCondition = behav.newWakeupCondition;
            if (behav.wakeupCondition == null) continue;
            behav.wakeupCondition.buildTree(null, 0, behav);
            behav.conditionSet = true;
            this.behaviors.add(behav);
            behav.updateTransformRegion();
            this.addToScheduleList(behav);
        }
        this.pendingBehaviors.clear();
    }

    void addViewPlatform(ViewPlatformRetained vp) {
        int i2;
        BehaviorRetained[] behavArr = (BehaviorRetained[])this.behaviors.toArray(false);
        this.viewPlatforms.add(vp);
        vp.updateTransformRegion();
        if (!vp.isActiveViewPlatform()) {
            return;
        }
        for (i2 = this.behaviors.arraySize() - 1; i2 >= 0; --i2) {
            this.addToScheduleList(behavArr[i2]);
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArr = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        for (i2 = this.wakeupOnViewPlatformEntry.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformEntry wentry = wakeupOnViewPlatformEntryArr[i2];
            if (this.boundsEntryList.contains(wentry) || !wentry.transformedRegion.intersect(vp.center)) continue;
            this.boundsEntryList.add(wentry);
            wentry.triggeredVP = vp;
            wentry.setTriggered();
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArr = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        for (i2 = this.wakeupOnViewPlatformExit.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformExit wexit = wakeupOnViewPlatformExitArr[i2];
            if (this.boundsExitList.contains(wexit) || !wexit.transformedRegion.intersect(vp.center)) continue;
            wexit.triggeredVP = vp;
            this.boundsExitList.add(wexit);
        }
    }

    @Override
    void removeNodes(J3dMessage m2) {
        Object[] nodes = (Object[])m2.args[0];
        boolean behavRemove = false;
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            Object node = nodes[i2];
            if (node instanceof BehaviorRetained) {
                behavRemove = true;
                this.removeBehavior((BehaviorRetained)node);
                continue;
            }
            if (!(node instanceof ViewPlatformRetained)) continue;
            this.removeViewPlatform((ViewPlatformRetained)node);
        }
        this.wakeupOnAWTEvent.clearMirror();
        this.awtEventsBuffer.clearMirror();
        this.wakeupOnBehaviorPost.clearMirror();
        this.behaviorPostBuffer.clearMirror();
        this.wakeupOnSensorEntry.clearMirror();
        this.wakeupOnSensorExit.clearMirror();
        this.branchDetach = true;
        if (behavRemove) {
            WakeupOnAWTEvent[] awtConds = (WakeupOnAWTEvent[])this.wakeupOnAWTEvent.toArray();
            int eventSize = this.wakeupOnAWTEvent.arraySize();
            boolean focusEnable = false;
            boolean keyEnable = false;
            boolean mouseMotionEnable = false;
            boolean mouseEnable = false;
            boolean mouseWheelEnable = false;
            boolean incTimestamp = false;
            for (int i3 = 0; i3 < eventSize; ++i3) {
                WakeupOnAWTEvent awtCond = awtConds[i3];
                int awtId = awtCond.AwtId;
                long eventMask = awtCond.EventMask;
                if (awtId >= 1004 && awtId <= 1005 || (eventMask & 4L) != 0L) {
                    focusEnable = true;
                }
                if (awtId >= 400 && awtId <= 402 || (eventMask & 8L) != 0L) {
                    keyEnable = true;
                }
                if (awtId >= 500 && awtId <= 507) {
                    if (awtId == 506 || awtId == 503) {
                        mouseMotionEnable = true;
                        continue;
                    }
                    if (awtId == 504 || awtId == 505 || awtId == 500 || awtId == 501 || awtId == 502) {
                        mouseEnable = true;
                        continue;
                    }
                    if (awtId != 507) continue;
                    mouseWheelEnable = true;
                    continue;
                }
                if ((eventMask & 0x10L) != 0L) {
                    mouseEnable = true;
                }
                if ((eventMask & 0x20L) != 0L) {
                    mouseMotionEnable = true;
                }
                if ((eventMask & 0x20000L) == 0L) continue;
                mouseWheelEnable = true;
            }
            if (!focusEnable && this.universe.enableFocus) {
                incTimestamp = true;
                this.universe.disableFocusEvents();
            }
            if (!keyEnable && this.universe.enableKey) {
                incTimestamp = true;
                this.universe.disableKeyEvents();
            }
            if (!mouseWheelEnable && this.universe.enableMouseWheel) {
                incTimestamp = true;
                this.universe.disableMouseWheelEvents();
            }
            if (!mouseMotionEnable && this.universe.enableMouseMotion) {
                incTimestamp = true;
                this.universe.disableMouseMotionEvents();
            }
            if (!mouseEnable && this.universe.enableMouse) {
                incTimestamp = true;
                this.universe.disableMouseEvents();
            }
            if (incTimestamp) {
                ++this.awtEventTimestamp;
            }
        }
    }

    void removeViewPlatform(ViewPlatformRetained vp) {
        ViewPlatformRetained triggeredVP;
        int i2;
        this.viewPlatforms.remove(vp);
        BehaviorRetained[] scheduleArr = (BehaviorRetained[])this.scheduleList.toArray(false);
        for (i2 = this.scheduleList.arraySize() - 1; i2 >= 0; --i2) {
            BehaviorRetained behav = scheduleArr[i2];
            if (this.intersectVPRegion(behav.transformedRegion)) continue;
            this.removeFromScheduleList(behav);
        }
        WakeupOnViewPlatformEntry[] boundsEntryArr = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (i2 = this.boundsEntryList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformEntry wentry = boundsEntryArr[i2];
            triggeredVP = this.intersectVPCenter(wentry.transformedRegion);
            if (triggeredVP != null) continue;
            this.boundsEntryList.remove(wentry);
        }
        WakeupOnViewPlatformExit[] boundsExitArr = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        for (i2 = this.boundsExitList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformExit wexit = boundsExitArr[i2];
            triggeredVP = this.intersectVPCenter(wexit.transformedRegion);
            if (triggeredVP != null) continue;
            this.boundsExitList.remove(wexit);
            wexit.setTriggered();
        }
    }

    void removeBehavior(BehaviorRetained behav) {
        this.behaviors.remove(behav);
        if (behav.wakeupCondition != null && behav.wakeupCondition.behav != null) {
            behav.wakeupCondition.cleanTree(this);
            if (behav.universe == this.universe) {
                behav.conditionSet = false;
            }
        }
        WakeupOnViewPlatformEntry[] boundsEntryArr = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (int i2 = this.boundsEntryList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformEntry wentry = boundsEntryArr[i2];
            if (wentry.behav != behav) continue;
            this.boundsEntryList.remove(wentry);
        }
        WakeupOnViewPlatformExit[] boundsExitArr = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        for (int i3 = this.boundsExitList.arraySize() - 1; i3 >= 0; --i3) {
            WakeupOnViewPlatformExit wexit = boundsExitArr[i3];
            if (wexit.behav != behav) continue;
            this.boundsExitList.remove(wexit);
        }
        WakeupOnSensorEntry[] currentSensorEntryArr = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        for (int i4 = this.currentSensorEntryList.arraySize() - 1; i4 >= 0; --i4) {
            WakeupOnSensorEntry sentry = currentSensorEntryArr[i4];
            if (sentry.behav != behav) continue;
            this.currentSensorEntryList.remove(sentry);
        }
        WakeupOnSensorExit[] currentSensorExitArr = (WakeupOnSensorExit[])this.currentSensorExitList.toArray(false);
        for (int i5 = this.currentSensorExitList.arraySize() - 1; i5 >= 0; --i5) {
            WakeupOnSensorExit sexit = currentSensorExitArr[i5];
            if (sexit.behav != behav) continue;
            this.currentSensorExitList.remove(sexit);
        }
        this.removeFromScheduleList(behav);
    }

    void handleAWTEvent(AWTEvent evt) {
        this.awtEventsBuffer.add(evt);
        VirtualUniverse.mc.sendRunMessage(this.universe, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAWTEvent() {
        int awtBufferSize;
        AWTEvent[] events;
        WakeupOnAWTEvent[] awtConds = (WakeupOnAWTEvent[])this.wakeupOnAWTEvent.toArray();
        int eventSize = this.wakeupOnAWTEvent.arraySize();
        UnorderList unorderList = this.awtEventsBuffer;
        synchronized (unorderList) {
            events = (AWTEvent[])this.awtEventsBuffer.toArray();
            awtBufferSize = this.awtEventsBuffer.size();
            this.awtEventsBuffer.clear();
        }
        for (int i2 = 0; i2 < eventSize; ++i2) {
            WakeupOnAWTEvent awtCond = awtConds[i2];
            for (int j2 = 0; j2 < awtBufferSize; ++j2) {
                AWTEvent evt = events[j2];
                int id = evt.getID();
                if (awtCond.AwtId != 0) {
                    if (awtCond.AwtId != id) continue;
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if (id >= 100 && id <= 103 && (awtCond.EventMask & 1L) != 0L) {
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if (id >= 1004 && id <= 1005 && (awtCond.EventMask & 4L) != 0L) {
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if (id >= 400 && id <= 402 && (awtCond.EventMask & 8L) != 0L) {
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if ((id == 500 || id == 504 || id == 505 || id == 501 || id == 502) && (awtCond.EventMask & 0x10L) != 0L) {
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if ((id == 506 || id == 503) && (awtCond.EventMask & 0x20L) != 0L) {
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if (id != 507 || (awtCond.EventMask & 0x20000L) == 0L) continue;
                awtCond.addAWTEvent(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBehaviorPost(Behavior behav, int postid) {
        UnorderList unorderList = this.behaviorPostBuffer;
        synchronized (unorderList) {
            int size = this.behaviorPostBuffer.size();
            if (this.postIDBuffer.length == size) {
                int[] oldbuffer = this.postIDBuffer;
                this.postIDBuffer = new int[size << 1];
                System.arraycopy(oldbuffer, 0, this.postIDBuffer, 0, size);
            }
            this.postIDBuffer[size] = postid;
            this.behaviorPostBuffer.add(behav);
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBehaviorPost() {
        int behavBufferSize;
        Behavior[] behavArr;
        WakeupOnBehaviorPost[] wakeupConds = (WakeupOnBehaviorPost[])this.wakeupOnBehaviorPost.toArray();
        UnorderList unorderList = this.behaviorPostBuffer;
        synchronized (unorderList) {
            behavArr = (Behavior[])this.behaviorPostBuffer.toArray();
            behavBufferSize = this.behaviorPostBuffer.size();
            if (this.clonePostIDBuffer.length < behavBufferSize) {
                this.clonePostIDBuffer = new int[behavBufferSize];
            }
            System.arraycopy(this.postIDBuffer, 0, this.clonePostIDBuffer, 0, behavBufferSize);
            this.behaviorPostBuffer.clear();
        }
        int size = this.wakeupOnBehaviorPost.arraySize();
        for (int i2 = 0; i2 < size; ++i2) {
            WakeupOnBehaviorPost wakeup = wakeupConds[i2];
            for (int j2 = 0; j2 < behavBufferSize; ++j2) {
                Behavior behav = behavArr[j2];
                int postid = this.clonePostIDBuffer[j2];
                if (wakeup.post != postid && wakeup.post != 0 || behav != wakeup.armingBehavior && wakeup.armingBehavior != null) continue;
                wakeup.triggeringBehavior = behav;
                wakeup.triggeringPost = postid;
                wakeup.setTriggered();
            }
        }
    }

    void incElapsedFrames() {
        WakeupOnElapsedFrames[] wakeupConds = (WakeupOnElapsedFrames[])this.wakeupOnElapsedFrames.toArray(true);
        int size = this.wakeupOnElapsedFrames.arraySize();
        int i2 = 0;
        while (i2 < size) {
            wakeupConds[i2++].newFrame();
        }
        if (size > 0) {
            VirtualUniverse.mc.sendRunMessage(this.universe, 257);
        }
        if (this.branchDetach) {
            this.wakeupOnElapsedFrames.clearMirror();
            this.branchDetach = false;
        }
    }

    void removeVPEntryCondition(WakeupCondition w) {
        this.wakeupOnViewPlatformEntry.remove(w);
    }

    void addVPEntryCondition(WakeupOnViewPlatformEntry w) {
        boolean needTrigger = true;
        WakeupOnViewPlatformEntry[] boundsEntryArr = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (int i2 = this.boundsEntryList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformEntry wentry = boundsEntryArr[i2];
            if (wentry.behav != w.behav || !wentry.region.equals(w.region)) continue;
            this.boundsEntryList.remove(i2);
            needTrigger = false;
            break;
        }
        this.wakeupOnViewPlatformEntry.add(w);
        ViewPlatformRetained triggeredVP = this.intersectVPCenter(w.transformedRegion);
        if (triggeredVP != null) {
            this.boundsEntryList.add(w);
        }
        if (needTrigger && triggeredVP != null) {
            w.triggeredVP = triggeredVP;
            w.setTriggered();
        }
    }

    void removeVPExitCondition(WakeupOnViewPlatformExit w) {
        this.wakeupOnViewPlatformExit.remove(w);
    }

    void addVPExitCondition(WakeupOnViewPlatformExit w) {
        boolean needTrigger = true;
        WakeupOnViewPlatformExit[] boundsExitArr = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        for (int i2 = this.boundsExitList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformExit wexit = boundsExitArr[i2];
            if (wexit.behav != w.behav || !wexit.region.equals(w.region)) continue;
            this.boundsExitList.remove(i2);
            needTrigger = false;
            break;
        }
        ViewPlatformRetained triggeredVP = this.intersectVPCenter(w.transformedRegion);
        this.wakeupOnViewPlatformExit.add(w);
        if (triggeredVP != null) {
            w.triggeredVP = triggeredVP;
            this.boundsExitList.add(w);
        }
        if (!needTrigger) {
            return;
        }
        WakeupOnViewPlatformEntry[] boundsEntryArr = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (int i3 = this.boundsEntryList.arraySize() - 1; i3 >= 0; --i3) {
            WakeupOnViewPlatformEntry wentry = boundsEntryArr[i3];
            if (wentry.behav != w.behav || !wentry.region.equals(w.region)) continue;
            if (triggeredVP != null) break;
            w.setTriggered();
            break;
        }
    }

    void removeSensorEntryCondition(WakeupOnSensorEntry w) {
        this.wakeupOnSensorEntry.remove(w);
    }

    void addSensorEntryCondition(WakeupOnSensorEntry w) {
        boolean needTrigger = true;
        WakeupOnSensorEntry[] sensorEntryArr = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        for (int i2 = this.currentSensorEntryList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnSensorEntry wentry = sensorEntryArr[i2];
            if (wentry.behav != w.behav || !wentry.region.equals(w.region)) continue;
            this.currentSensorEntryList.remove(i2);
            needTrigger = false;
            break;
        }
        this.wakeupOnSensorEntry.add(w);
        w.updateTransformRegion();
        Sensor target = this.sensorIntersect(w.transformedRegion);
        if (target != null) {
            w.setTarget(target);
            this.currentSensorEntryList.add(w);
        }
        if (needTrigger && target != null) {
            w.setTriggered();
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 256);
    }

    void removeSensorExitCondition(WakeupOnSensorExit w) {
        this.wakeupOnSensorExit.remove(w);
    }

    void addSensorExitCondition(WakeupOnSensorExit w) {
        boolean needTrigger = true;
        WakeupOnSensorExit[] currentSensorExitArr = (WakeupOnSensorExit[])this.currentSensorExitList.toArray(false);
        for (int i2 = this.currentSensorExitList.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnSensorExit wexit = currentSensorExitArr[i2];
            if (wexit.behav != w.behav || !wexit.region.equals(w.region)) continue;
            this.currentSensorExitList.remove(i2);
            needTrigger = false;
            break;
        }
        w.updateTransformRegion();
        Sensor target = this.sensorIntersect(w.transformedRegion);
        this.wakeupOnSensorExit.add(w);
        if (target != null) {
            w.setTarget(target);
            this.currentSensorExitList.add(w);
        }
        if (!needTrigger) {
            return;
        }
        WakeupOnSensorEntry[] sensorEntryArr = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        for (int i3 = this.currentSensorEntryList.arraySize() - 1; i3 >= 0; --i3) {
            WakeupOnSensorEntry wentry = sensorEntryArr[i3];
            if (wentry.behav != w.behav || !wentry.region.equals(w.region)) continue;
            if (target != null) break;
            w.setTriggered();
            break;
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 256);
    }

    void processConditionMet(BehaviorRetained behav, Boolean checkSchedulingRegion) {
        if (!behav.inCallback && (checkSchedulingRegion == Boolean.FALSE || behav.active)) {
            this.processList[behav.schedulingInterval].add(behav);
        } else if ((behav.wakeupMask & 0x10) != 0 && behav.source != null && behav.source.isLive() && behav.wakeupCondition != null) {
            behav.wakeupCondition.reInsertElapseTimeCond();
        }
    }

    final void processBehXformChanged(UnorderList arrList) {
        int size = arrList.size();
        Object[] nodesArr = arrList.toArray(false);
        for (int i2 = 0; i2 < size; ++i2) {
            Object[] nodes = (Object[])nodesArr[i2];
            for (int j2 = 0; j2 < nodes.length; ++j2) {
                BehaviorRetained beh = (BehaviorRetained)nodes[j2];
                beh.updateTransformRegion();
                this.processBehaviorTransform(beh);
            }
        }
    }

    final void processVpfXformChanged(UnorderList arrList) {
        int size = arrList.size();
        Object[] nodesArr = arrList.toArray(false);
        for (int i2 = 0; i2 < size; ++i2) {
            Object[] nodes = (Object[])nodesArr[i2];
            for (int j2 = 0; j2 < nodes.length; ++j2) {
                this.processViewPlatformTransform((ViewPlatformRetained)nodes[j2]);
            }
        }
    }

    final void processTransformChanged(Object[] leaf) {
        int i2;
        for (i2 = 0; i2 < leaf.length; ++i2) {
            Object node = leaf[i2];
            if (node instanceof BehaviorRetained) {
                ((BehaviorRetained)node).updateTransformRegion();
                this.processBehaviorTransform((BehaviorRetained)node);
                continue;
            }
            if (!(node instanceof ViewPlatformRetained)) continue;
            ((ViewPlatformRetained)node).updateTransformRegion();
            this.transformViewPlatformList.add(node);
        }
        if (this.transformViewPlatformList.size() > 0) {
            ViewPlatformRetained[] vpArr = (ViewPlatformRetained[])this.transformViewPlatformList.toArray(false);
            int size = this.transformViewPlatformList.arraySize();
            for (i2 = 0; i2 < size; ++i2) {
                this.processViewPlatformTransform(vpArr[i2]);
            }
            this.transformViewPlatformList.clear();
        }
    }

    final void processBehaviorTransform(BehaviorRetained behav) {
        if ((behav.wakeupMask & 4) != 0) {
            this.updateVPEntryTransformRegion(behav);
        }
        if ((behav.wakeupMask & 8) != 0) {
            this.updateVPExitTransformRegion(behav);
        }
        if (behav.active) {
            if (!this.intersectVPRegion(behav.transformedRegion)) {
                this.removeFromScheduleList(behav);
            }
        } else {
            this.addToScheduleList(behav);
        }
    }

    void processViewPlatformTransform(ViewPlatformRetained vp) {
        ViewPlatformRetained triggeredVP;
        int idx;
        int i2;
        vp.updateTransformRegion();
        if (!vp.isActiveViewPlatform()) {
            return;
        }
        BehaviorRetained[] behavArr = (BehaviorRetained[])this.behaviors.toArray(false);
        for (i2 = this.behaviors.arraySize() - 1; i2 >= 0; --i2) {
            BehaviorRetained behav = behavArr[i2];
            if (behav.active) {
                if (this.intersectVPRegion(behav.transformedRegion)) continue;
                this.removeFromScheduleList(behav);
                continue;
            }
            this.addToScheduleList(behav);
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArr = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        for (i2 = this.wakeupOnViewPlatformEntry.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformEntry wentry = wakeupOnViewPlatformEntryArr[i2];
            idx = this.boundsEntryList.indexOf(wentry);
            if (idx < 0) {
                if (!wentry.transformedRegion.intersect(vp.center)) continue;
                this.boundsEntryList.add(wentry);
                wentry.triggeredVP = vp;
                wentry.setTriggered();
                continue;
            }
            triggeredVP = this.intersectVPCenter(wentry.transformedRegion);
            if (triggeredVP != null) continue;
            this.boundsEntryList.remove(idx);
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArr = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        for (i2 = this.wakeupOnViewPlatformExit.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformExit wexit = wakeupOnViewPlatformExitArr[i2];
            idx = this.boundsExitList.indexOf(wexit);
            if (idx < 0) {
                if (!wexit.transformedRegion.intersect(vp.center)) continue;
                wexit.triggeredVP = vp;
                this.boundsExitList.add(wexit);
                continue;
            }
            triggeredVP = this.intersectVPCenter(wexit.transformedRegion);
            if (triggeredVP != null) continue;
            this.boundsExitList.remove(idx);
            wexit.setTriggered();
        }
    }

    void updateVPEntryTransformRegion(BehaviorRetained behav) {
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArr = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        for (int i2 = this.wakeupOnViewPlatformEntry.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformEntry wentry = wakeupOnViewPlatformEntryArr[i2];
            if (wentry.behav != behav) continue;
            wentry.updateTransformRegion(behav);
            int idx = this.boundsEntryList.indexOf(wentry);
            ViewPlatformRetained triggeredVP = this.intersectVPCenter(wentry.transformedRegion);
            if (triggeredVP != null) {
                if (idx >= 0) continue;
                this.boundsEntryList.add(wentry);
                wentry.triggeredVP = triggeredVP;
                wentry.setTriggered();
                continue;
            }
            if (idx < 0) continue;
            this.boundsEntryList.remove(idx);
        }
    }

    void updateVPExitTransformRegion(BehaviorRetained behav) {
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArr = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        for (int i2 = this.wakeupOnViewPlatformExit.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnViewPlatformExit wexit = wakeupOnViewPlatformExitArr[i2];
            if (wexit.behav != behav) continue;
            wexit.updateTransformRegion(behav);
            wexit = wakeupOnViewPlatformExitArr[i2];
            int idx = this.boundsExitList.indexOf(wexit);
            ViewPlatformRetained triggeredVP = this.intersectVPCenter(wexit.transformedRegion);
            if (triggeredVP != null) {
                if (idx >= 0) continue;
                wexit.triggeredVP = triggeredVP;
                this.boundsExitList.add(wexit);
                continue;
            }
            if (idx < 0) continue;
            this.boundsExitList.remove(idx);
            wexit.setTriggered();
        }
    }

    void reEvaluatePhysicalEnvironments() {
        ViewPlatformRetained[] vpr = this.universe.getViewPlatformList();
        this.physicalEnvironments.clear();
        for (int i2 = vpr.length - 1; i2 >= 0; --i2) {
            View[] views = vpr[i2].getViewList();
            for (int j2 = views.length - 1; j2 >= 0; --j2) {
                View v = views[j2];
                if (!v.active || this.physicalEnvironments.contains(v.physicalEnvironment)) continue;
                this.physicalEnvironments.add(v.physicalEnvironment);
            }
        }
    }

    void checkSensorEntryExit() {
        Sensor target;
        int idx;
        int i2;
        WakeupOnSensorEntry[] wentryArr = (WakeupOnSensorEntry[])this.wakeupOnSensorEntry.toArray();
        for (i2 = this.wakeupOnSensorEntry.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnSensorEntry wentry = wentryArr[i2];
            idx = this.currentSensorEntryList.indexOf(wentry);
            wentry.updateTransformRegion();
            target = this.sensorIntersect(wentry.transformedRegion);
            if (target != null) {
                if (idx >= 0) continue;
                this.currentSensorEntryList.add(wentry);
                wentry.setTarget(target);
                wentry.setTriggered();
                continue;
            }
            if (idx < 0) continue;
            this.currentSensorEntryList.remove(idx);
        }
        WakeupOnSensorExit[] wexitArr = (WakeupOnSensorExit[])this.wakeupOnSensorExit.toArray();
        for (i2 = this.wakeupOnSensorExit.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnSensorExit wexit = wexitArr[i2];
            idx = this.currentSensorExitList.indexOf(wexit);
            wexit.updateTransformRegion();
            target = this.sensorIntersect(wexit.transformedRegion);
            if (target != null) {
                if (idx >= 0) continue;
                this.currentSensorExitList.add(wexit);
                wexit.setTarget(target);
                continue;
            }
            if (idx < 0) continue;
            this.currentSensorExitList.remove(idx);
            wexit.setTriggered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Sensor sensorIntersect(Bounds behregion) {
        if (behregion == null) {
            return null;
        }
        PhysicalEnvironment[] env = (PhysicalEnvironment[])this.physicalEnvironments.toArray(false);
        int i2 = this.physicalEnvironments.arraySize() - 1;
        while (i2 >= 0) {
            Sensor[] sensors;
            if (env[i2].activeViewRef > 0 && (sensors = env[i2].getSensorList()) != null) {
                for (int j2 = env[i2].users.size() - 1; j2 >= 0; --j2) {
                    View v = env[i2].users.get(j2);
                    Sensor[] sensorArray = sensors;
                    // MONITORENTER : sensors
                    for (int k2 = sensors.length - 1; k2 >= 0; --k2) {
                        Sensor s = sensors[k2];
                        if (s == null) continue;
                        v.getSensorToVworld(s, this.sensorTransform);
                        this.sensorTransform.get(this.sensorLoc);
                        this.ptSensorLoc.set(this.sensorLoc);
                        if (!behregion.intersect(this.ptSensorLoc)) continue;
                        // MONITOREXIT : sensorArray
                        return s;
                    }
                    // MONITOREXIT : sensorArray
                }
            }
            --i2;
        }
        return null;
    }

    final boolean intersectVPRegion(Bounds behregion) {
        if (behregion == null) {
            return false;
        }
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            ViewPlatformRetained vp = vpLists[i2];
            if (!vp.isActiveViewPlatform() || !vp.schedSphere.intersect(behregion)) continue;
            return true;
        }
        return false;
    }

    final ViewPlatformRetained intersectVPCenter(Bounds behregion) {
        if (behregion == null) {
            return null;
        }
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            ViewPlatformRetained vp = vpLists[i2];
            if (!vp.isActiveViewPlatform() || !behregion.intersect(vp.center)) continue;
            return vp;
        }
        return null;
    }

    void notifyDeactivationCondition(BehaviorRetained behav) {
        WakeupOnDeactivation[] wakeupConds = (WakeupOnDeactivation[])this.wakeupOnDeactivation.toArray(false);
        for (int i2 = this.wakeupOnDeactivation.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnDeactivation wakeup = wakeupConds[i2];
            if (wakeup.behav != behav) continue;
            wakeup.setTriggered();
        }
    }

    void notifyActivationCondition(BehaviorRetained behav) {
        WakeupOnActivation[] wakeupConds = (WakeupOnActivation[])this.wakeupOnActivation.toArray(false);
        for (int i2 = this.wakeupOnActivation.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnActivation wakeup = wakeupConds[i2];
            if (wakeup.behav != behav) continue;
            wakeup.setTriggered();
        }
    }

    void processSwitchChanged(J3dMessage m2) {
        int i2;
        Object[] nodes;
        int j2;
        Object[] nodesArr;
        int size;
        UpdateTargets targets = (UpdateTargets)m2.args[0];
        UnorderList arrList = targets.targetList[4];
        if (arrList != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (j2 = 0; j2 < size; ++j2) {
                nodes = (Object[])nodesArr[j2];
                for (i2 = nodes.length - 1; i2 >= 0; --i2) {
                    ViewPlatformRetained vp = (ViewPlatformRetained)nodes[i2];
                    vp.processSwitchChanged();
                }
            }
        }
        if ((arrList = targets.targetList[2]) != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (j2 = 0; j2 < size; ++j2) {
                nodes = (Object[])nodesArr[j2];
                for (i2 = nodes.length - 1; i2 >= 0; --i2) {
                    BehaviorRetained behav = (BehaviorRetained)nodes[i2];
                    if (behav.switchState.currentSwitchOn) {
                        this.addToScheduleList(behav);
                        continue;
                    }
                    this.removeFromScheduleList(behav);
                }
            }
        }
        if ((arrList = targets.targetList[5]) != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            Object[] objArr = (Object[])m2.args[1];
            for (int h2 = 0; h2 < size; ++h2) {
                nodes = (Object[])nodesArr[h2];
                Object[] obj = (Object[])objArr[h2];
                for (i2 = nodes.length - 1; i2 >= 0; --i2) {
                    Object[] users = (Object[])obj[i2];
                    Object[] leafObj = new Object[1];
                    for (j2 = 0; j2 < users.length; ++j2) {
                        if (!(users[j2] instanceof BehaviorRetained)) continue;
                        leafObj[0] = users[j2];
                        this.processTransformChanged(leafObj);
                    }
                }
            }
        }
    }

    void processBoundingLeafChanged(Object[] users, Bounds bound) {
        for (int i2 = users.length - 1; i2 >= 0; --i2) {
            Object leaf = users[i2];
            if (!(leaf instanceof BehaviorRetained)) continue;
            BehaviorRetained behav = (BehaviorRetained)leaf;
            behav.updateTransformRegion(bound);
            this.processBehaviorTransform(behav);
        }
    }

    final void removeFromScheduleList(BehaviorRetained behav) {
        if (behav.active) {
            if ((behav.wakeupMask & 2) != 0) {
                this.notifyDeactivationCondition(behav);
            }
            this.scheduleList.remove(behav);
            behav.active = false;
            if (behav.universe != this.universe) {
                J3dMessage m2 = new J3dMessage();
                m2.threads = 256;
                m2.type = 60;
                m2.universe = behav.universe;
                m2.args[0] = behav;
                VirtualUniverse.mc.processMessage(m2);
            }
        }
    }

    final void addToScheduleList(BehaviorRetained behav) {
        if (!behav.inCallback && !behav.active && behav.enable && behav.switchState.currentSwitchOn && behav.wakeupCondition != null && ((Behavior)behav.source).isLive() && this.intersectVPRegion(behav.transformedRegion)) {
            this.scheduleList.add(behav);
            behav.active = true;
            if ((behav.wakeupMask & 1) != 0) {
                this.notifyActivationCondition(behav);
            }
            if (behav.wakeupCondition != null) {
                behav.wakeupCondition.conditionMet = false;
            }
        }
    }

    void resetConditionMet() {
        BehaviorStructure.resetConditionMet(this.wakeupOnAWTEvent);
        BehaviorStructure.resetConditionMet(this.wakeupOnActivation);
        BehaviorStructure.resetConditionMet(this.wakeupOnDeactivation);
        BehaviorStructure.resetConditionMet(this.wakeupOnBehaviorPost);
        BehaviorStructure.resetConditionMet(this.wakeupOnElapsedFrames);
        BehaviorStructure.resetConditionMet(this.wakeupOnViewPlatformEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnViewPlatformExit);
        BehaviorStructure.resetConditionMet(this.wakeupOnSensorEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnSensorExit);
    }

    static void resetConditionMet(WakeupIndexedList list) {
        WakeupCondition[] wakeups = (WakeupCondition[])list.toArray(false);
        int i2 = list.size() - 1;
        while (i2 >= 0) {
            wakeups[i2--].conditionMet = false;
        }
    }

    void reEvaluateWakeupCount() {
        WakeupOnElapsedFrames[] wakeupConds = (WakeupOnElapsedFrames[])this.wakeupOnElapsedFrames.toArray(true);
        int size = this.wakeupOnElapsedFrames.arraySize();
        int i2 = 0;
        this.activeWakeupOnFrameCount = 0;
        while (i2 < size) {
            WakeupOnElapsedFrames cond = wakeupConds[i2++];
            if (cond.passive || cond.behav == null || !cond.behav.enable) continue;
            ++this.activeWakeupOnFrameCount;
        }
        this.activeWakeupOnSensorCount = 0;
        WakeupOnSensorEntry[] wentryArr = (WakeupOnSensorEntry[])this.wakeupOnSensorEntry.toArray();
        for (i2 = this.wakeupOnSensorEntry.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnSensorEntry wentry = wentryArr[i2];
            if (wentry.behav == null || !wentry.behav.enable) continue;
            ++this.activeWakeupOnSensorCount;
        }
        WakeupOnSensorExit[] wexitArr = (WakeupOnSensorExit[])this.wakeupOnSensorExit.toArray();
        for (i2 = this.wakeupOnSensorExit.arraySize() - 1; i2 >= 0; --i2) {
            WakeupOnSensorExit wexit = wexitArr[i2];
            if (wexit.behav == null || !wexit.behav.enable) continue;
            ++this.activeWakeupOnSensorCount;
        }
    }

    @Override
    void cleanup() {
        this.behaviors.clear();
        this.viewPlatforms.clear();
        this.scheduleList.clear();
        this.boundsEntryList.clear();
        this.boundsExitList.clear();
        this.currentSensorEntryList.clear();
        this.currentSensorExitList.clear();
        this.wakeupOnAWTEvent.clear();
        this.wakeupOnActivation.clear();
        this.wakeupOnDeactivation.clear();
        this.wakeupOnBehaviorPost.clear();
        this.wakeupOnElapsedFrames.clear();
        this.wakeupOnViewPlatformEntry.clear();
        this.wakeupOnViewPlatformExit.clear();
        this.wakeupOnSensorEntry.clear();
        this.wakeupOnSensorExit.clear();
    }
}

