/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Iterator;
import org.jogamp.java3d.BehaviorRetained;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Leaf;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeReferenceTable;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.View;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;

public abstract class Behavior
extends Leaf {
    public abstract void initialize();

    public abstract void processStimulus(Iterator<WakeupCriterion> var1);

    public void setSchedulingBounds(Bounds region) {
        ((BehaviorRetained)this.retained).setSchedulingBounds(region);
    }

    public Bounds getSchedulingBounds() {
        return ((BehaviorRetained)this.retained).getSchedulingBounds();
    }

    public void setSchedulingBoundingLeaf(BoundingLeaf region) {
        ((BehaviorRetained)this.retained).setSchedulingBoundingLeaf(region);
    }

    public BoundingLeaf getSchedulingBoundingLeaf() {
        return ((BehaviorRetained)this.retained).getSchedulingBoundingLeaf();
    }

    @Override
    void createRetained() {
        this.retained = new BehaviorRetained();
        this.retained.setSource(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeupOn(WakeupCondition criteria) {
        BehaviorRetained behavret;
        BehaviorRetained behaviorRetained = behavret = (BehaviorRetained)this.retained;
        synchronized (behaviorRetained) {
            if (!behavret.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("Behavior0"));
            }
        }
        behavret.wakeupOn(criteria);
    }

    protected WakeupCondition getWakeupCondition() {
        return ((BehaviorRetained)this.retained).getWakeupCondition();
    }

    public void postId(int postId) {
        ((BehaviorRetained)this.retained).postId(postId);
    }

    public void setEnable(boolean state) {
        ((BehaviorRetained)this.retained).setEnable(state);
    }

    public boolean getEnable() {
        return ((BehaviorRetained)this.retained).getEnable();
    }

    public static int getNumSchedulingIntervals() {
        return 10;
    }

    public void setSchedulingInterval(int schedulingInterval) {
        if (schedulingInterval < 0 || schedulingInterval >= Behavior.getNumSchedulingIntervals()) {
            throw new IllegalStateException(J3dI18N.getString("Behavior1"));
        }
        ((BehaviorRetained)this.retained).setSchedulingInterval(schedulingInterval);
    }

    public int getSchedulingInterval() {
        return ((BehaviorRetained)this.retained).getSchedulingInterval();
    }

    protected View getView() {
        return ((BehaviorRetained)this.retained).getView();
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        BehaviorRetained attr = (BehaviorRetained)originalNode.retained;
        BehaviorRetained rt = (BehaviorRetained)this.retained;
        rt.setEnable(attr.getEnable());
        rt.setSchedulingBounds(attr.getSchedulingBounds());
        rt.setSchedulingInterval(attr.getSchedulingInterval());
        rt.setSchedulingBoundingLeaf(attr.getSchedulingBoundingLeaf());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        super.updateNodeReferences(referenceTable);
        BehaviorRetained rt = (BehaviorRetained)this.retained;
        BoundingLeaf bl = rt.getSchedulingBoundingLeaf();
        if (bl != null) {
            SceneGraphObject o2 = referenceTable.getNewObjectReference(bl);
            rt.setSchedulingBoundingLeaf((BoundingLeaf)o2);
        }
    }
}

