/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Vector;
import org.jogamp.java3d.BHInsertStructure;
import org.jogamp.java3d.BHInternalNode;
import org.jogamp.java3d.BHLeafInterface;
import org.jogamp.java3d.BHLeafNode;
import org.jogamp.java3d.BHNode;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.RenderBin;
import org.jogamp.java3d.SharedGroupRetained;
import org.jogamp.java3d.UnorderList;
import org.jogamp.vecmath.Point4d;

class BHTree {
    Locale locale;
    private BHNode root;
    private BHInsertStructure insertStructure = null;
    Point4d tPoint4d = new Point4d();
    private boolean stable = false;
    int estMaxDepth;
    static final double LOG_OF_2 = Math.log(2.0);
    static final int DEPTH_UPPER_BOUND = 56;
    static final int INCR_DEPTH_BOUND = 5;
    int depthUpperBound = 56;

    BHTree() {
        this.locale = null;
        this.root = null;
    }

    BHTree(Locale loc) {
        this.locale = loc;
        this.root = null;
    }

    BHTree(BHNode[] bhArr) {
        this.locale = null;
        this.root = null;
        this.create(bhArr);
    }

    void setLocale(Locale loc) {
        this.locale = loc;
    }

    Locale getLocale() {
        return this.locale;
    }

    void cluster(BHInternalNode root, BHNode[] bhArr) {
        if (bhArr == null || bhArr.length < 2 || root == null) {
            return;
        }
        int[] centerValuesIndex = new int[bhArr.length];
        float[][] centerValues = this.computeCenterValues(bhArr, centerValuesIndex);
        this.constructTree(root, bhArr, centerValues, centerValuesIndex);
    }

    void boundsChanged(BHNode[] bhArr, int size) {
        this.markParentChain(bhArr, size);
        this.root.updateMarkedBoundingHull();
    }

    boolean getVisibleBHTrees(RenderBin rBin, ArrayList bhTrees, BoundingBox frustumBBox, long referenceTime, boolean stateChanged, int visibilityPolicy, boolean singleLocale) {
        if (frustumBBox != null && this.root != null) {
            boolean inSide = BHTree.aEncompassB(frustumBBox, this.root.bHull);
            if (singleLocale && !stateChanged && inSide && this.stable) {
                bhTrees.add(this.root);
                return true;
            }
            if (!stateChanged && inSide) {
                this.select(rBin, bhTrees, frustumBBox, this.root, referenceTime, visibilityPolicy, true);
                bhTrees.add(this.root);
                this.stable = true;
            } else {
                this.select(rBin, bhTrees, frustumBBox, this.root, referenceTime, visibilityPolicy, false);
                this.stable = false;
            }
        }
        return false;
    }

    private void select(RenderBin rBin, ArrayList bhTrees, BoundingBox frustumBBox, BHNode bh, long referenceTime, int visibilityPolicy, boolean inSide) {
        if (bh == null || bh.bHull.isEmpty()) {
            return;
        }
        switch (bh.nodeType) {
            case 2: {
                if (!(((BHLeafNode)bh).leafIF instanceof GeometryAtom) || !((BHLeafNode)bh).isEnable(visibilityPolicy) || !inSide && !frustumBBox.intersect(bh.bHull)) break;
                rBin.processGeometryAtom((GeometryAtom)((BHLeafNode)bh).leafIF, referenceTime);
                if (inSide) break;
                bhTrees.add(bh);
                break;
            }
            case 1: {
                if (inSide) {
                    this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getRightChild(), referenceTime, visibilityPolicy, true);
                    this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getLeftChild(), referenceTime, visibilityPolicy, true);
                    break;
                }
                if (BHTree.aEncompassB(frustumBBox, bh.bHull)) {
                    bhTrees.add(bh);
                    this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getRightChild(), referenceTime, visibilityPolicy, true);
                    this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getLeftChild(), referenceTime, visibilityPolicy, true);
                    break;
                }
                if (!frustumBBox.intersect(bh.bHull)) break;
                this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getRightChild(), referenceTime, visibilityPolicy, false);
                this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getLeftChild(), referenceTime, visibilityPolicy, false);
            }
        }
    }

    static boolean aEncompassB(BoundingBox aBox, BoundingBox bBox) {
        return aBox.upper.x >= bBox.upper.x && aBox.upper.y >= bBox.upper.y && aBox.upper.z >= bBox.upper.z && aBox.lower.x <= bBox.lower.x && aBox.lower.y <= bBox.lower.y && aBox.lower.z <= bBox.lower.z;
    }

    BHLeafInterface selectAny(GeometryAtom atom, int accurancyMode) {
        if (atom.source.geometryList == null) {
            return null;
        }
        BHNode bhNode = this.doSelectAny(atom, this.root, accurancyMode);
        if (bhNode == null) {
            return null;
        }
        return ((BHLeafNode)bhNode).leafIF;
    }

    BHLeafInterface selectAny(GeometryAtom[] atoms, int size, int accurancyMode) {
        BHNode bhNode = this.doSelectAny(atoms, size, this.root, accurancyMode);
        if (bhNode == null) {
            return null;
        }
        return ((BHLeafNode)bhNode).leafIF;
    }

    private BHNode doSelectAny(GeometryAtom[] atoms, int atomSize, BHNode bh, int accurancyMode) {
        if (bh == null || bh.bHull.isEmpty()) {
            return null;
        }
        switch (bh.nodeType) {
            case 2: {
                BHLeafInterface leaf = ((BHLeafNode)bh).leafIF;
                if (leaf instanceof GeometryAtom) {
                    GeometryAtom leafAtom = (GeometryAtom)leaf;
                    if (((BHLeafNode)bh).isEnable() && leafAtom.source.isCollidable) {
                        int i2;
                        for (i2 = atomSize - 1; i2 >= 0; --i2) {
                            if (atoms[i2] != leafAtom) continue;
                            return null;
                        }
                        for (i2 = atomSize - 1; i2 >= 0; --i2) {
                            GeometryAtom atom = atoms[i2];
                            if (atom.source.sourceNode == leafAtom.source.sourceNode || !atom.source.collisionVwcBound.intersect(leafAtom.source.collisionVwcBound) || accurancyMode != 11 && (leafAtom.source.geometryList == null || !atom.source.intersectGeometryList(leafAtom.source))) continue;
                            return bh;
                        }
                    }
                } else if (leaf instanceof GroupRetained && ((BHLeafNode)bh).isEnable() && ((GroupRetained)leaf).sourceNode.collidable) {
                    for (int i3 = atomSize - 1; i3 >= 0; --i3) {
                        GeometryAtom atom = atoms[i3];
                        if (!atom.source.collisionVwcBound.intersect(bh.bHull) || accurancyMode != 11 && !atom.source.intersectGeometryList(atom.source.getCurrentLocalToVworld(0), bh.bHull)) continue;
                        return bh;
                    }
                }
                return null;
            }
            case 1: {
                for (int i4 = atomSize - 1; i4 >= 0; --i4) {
                    GeometryAtom atom = atoms[i4];
                    if (!atom.source.collisionVwcBound.intersect(bh.bHull)) continue;
                    BHNode hitNode = this.doSelectAny(atoms, atomSize, ((BHInternalNode)bh).getRightChild(), accurancyMode);
                    if (hitNode != null) {
                        return hitNode;
                    }
                    return this.doSelectAny(atoms, atomSize, ((BHInternalNode)bh).getLeftChild(), accurancyMode);
                }
                return null;
            }
        }
        return null;
    }

    private BHNode doSelectAny(GeometryAtom atom, BHNode bh, int accurancyMode) {
        if (bh == null || bh.bHull.isEmpty()) {
            return null;
        }
        switch (bh.nodeType) {
            case 2: {
                BHLeafInterface leaf = ((BHLeafNode)bh).leafIF;
                if (leaf instanceof GeometryAtom) {
                    GeometryAtom leafAtom = (GeometryAtom)leaf;
                    if (atom.source.sourceNode != leafAtom.source.sourceNode && ((BHLeafNode)bh).isEnable() && leafAtom.source.isCollidable && atom.source.collisionVwcBound.intersect(leafAtom.source.collisionVwcBound) && (accurancyMode == 11 || leafAtom.source.geometryList != null && atom.source.intersectGeometryList(leafAtom.source))) {
                        return bh;
                    }
                } else if (leaf instanceof GroupRetained && ((BHLeafNode)bh).isEnable() && ((GroupRetained)leaf).sourceNode.collidable && atom.source.collisionVwcBound.intersect(bh.bHull) && (accurancyMode == 11 || atom.source.intersectGeometryList(atom.source.getCurrentLocalToVworld(0), bh.bHull))) {
                    return bh;
                }
                return null;
            }
            case 1: {
                if (atom.source.collisionVwcBound.intersect(bh.bHull)) {
                    BHNode hitNode = this.doSelectAny(atom, ((BHInternalNode)bh).getRightChild(), accurancyMode);
                    if (hitNode != null) {
                        return hitNode;
                    }
                    return this.doSelectAny(atom, ((BHInternalNode)bh).getLeftChild(), accurancyMode);
                }
                return null;
            }
        }
        return null;
    }

    BHLeafInterface selectAny(Bounds bound, int accurancyMode, NodeRetained armingNode) {
        if (bound == null) {
            return null;
        }
        BHNode bhNode = this.doSelectAny(bound, this.root, accurancyMode, armingNode);
        if (bhNode == null) {
            return null;
        }
        return ((BHLeafNode)bhNode).leafIF;
    }

    private BHNode doSelectAny(Bounds bound, BHNode bh, int accurancyMode, NodeRetained armingNode) {
        if (bh == null || bh.bHull.isEmpty()) {
            return null;
        }
        switch (bh.nodeType) {
            case 2: {
                BHLeafInterface leaf = ((BHLeafNode)bh).leafIF;
                if (leaf instanceof GeometryAtom) {
                    GeometryAtom leafAtom = (GeometryAtom)leaf;
                    if (((BHLeafNode)bh).isEnable() && leafAtom.source.isCollidable && bound.intersect(leafAtom.source.collisionVwcBound) && (accurancyMode == 11 || leafAtom.source.geometryList != null && leafAtom.source.intersectGeometryList(leafAtom.source.getCurrentLocalToVworld(0), bound))) {
                        return bh;
                    }
                } else if (leaf instanceof GroupRetained && leaf != armingNode && ((BHLeafNode)bh).isEnable() && ((GroupRetained)leaf).sourceNode.collidable && bound.intersect(bh.bHull)) {
                    return bh;
                }
                return null;
            }
            case 1: {
                if (bound.intersect(bh.bHull)) {
                    BHNode hitNode = this.doSelectAny(bound, ((BHInternalNode)bh).getRightChild(), accurancyMode, armingNode);
                    if (hitNode != null) {
                        return hitNode;
                    }
                    return this.doSelectAny(bound, ((BHInternalNode)bh).getLeftChild(), accurancyMode, armingNode);
                }
                return null;
            }
        }
        return null;
    }

    BHLeafInterface selectAny(Bounds bound, int accurancyMode, GroupRetained armingGroup) {
        if (bound == null) {
            return null;
        }
        BHNode bhNode = this.doSelectAny(bound, this.root, accurancyMode, armingGroup);
        if (bhNode == null) {
            return null;
        }
        return ((BHLeafNode)bhNode).leafIF;
    }

    private BHNode doSelectAny(Bounds bound, BHNode bh, int accurancyMode, GroupRetained armingGroup) {
        if (bh == null || bh.bHull.isEmpty()) {
            return null;
        }
        switch (bh.nodeType) {
            case 2: {
                BHLeafInterface leaf = ((BHLeafNode)bh).leafIF;
                if (leaf instanceof GeometryAtom) {
                    GeometryAtom leafAtom = (GeometryAtom)leaf;
                    if (((BHLeafNode)bh).isEnable() && leafAtom.source.isCollidable && bound.intersect(leafAtom.source.collisionVwcBound) && !this.isDescendent(leafAtom.source.sourceNode, armingGroup, leafAtom.source.key) && (accurancyMode == 11 || leafAtom.source.geometryList != null && leafAtom.source.intersectGeometryList(leafAtom.source.getCurrentLocalToVworld(0), bound))) {
                        return bh;
                    }
                } else if (leaf instanceof GroupRetained) {
                    GroupRetained group = (GroupRetained)leaf;
                    if (((BHLeafNode)bh).isEnable() && group.sourceNode.collidable && bound.intersect(bh.bHull) && !this.isDescendent(group.sourceNode, armingGroup, group.key)) {
                        return bh;
                    }
                }
                return null;
            }
            case 1: {
                if (bound.intersect(bh.bHull)) {
                    BHNode hitNode = this.doSelectAny(bound, ((BHInternalNode)bh).getRightChild(), accurancyMode, armingGroup);
                    if (hitNode != null) {
                        return hitNode;
                    }
                    return this.doSelectAny(bound, ((BHInternalNode)bh).getLeftChild(), accurancyMode, armingGroup);
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDescendent(NodeRetained node, GroupRetained group, HashKey key) {
        Object object = group.universe.sceneGraphLock;
        synchronized (object) {
            if (node.inSharedGroup && key != null) {
                key = new HashKey(key);
            }
            do {
                if (node == group) {
                    return true;
                }
                if (!(node instanceof SharedGroupRetained)) continue;
                String nodeId = key.getLastNodeId();
                NodeRetained prevNode = node;
                Vector<NodeRetained> parents = ((SharedGroupRetained)node).parents;
                for (int i2 = parents.size() - 1; i2 >= 0; --i2) {
                    NodeRetained link = parents.get(i2);
                    if (!link.nodeId.equals(nodeId)) continue;
                    node = link;
                    break;
                }
                if (prevNode != node) continue;
                return true;
            } while ((node = node.parent) != null);
        }
        return false;
    }

    void select(PickShape pickShape, UnorderList hitArrList) {
        if (pickShape == null || this.root == null) {
            return;
        }
        this.doSelect(pickShape, hitArrList, this.root, this.tPoint4d);
    }

    private void doSelect(PickShape pickShape, UnorderList hitArrList, BHNode bh, Point4d pickPos) {
        if (bh == null || bh.bHull.isEmpty()) {
            return;
        }
        switch (bh.nodeType) {
            case 2: {
                if (!((BHLeafNode)bh).isEnable() || !(((BHLeafNode)bh).leafIF instanceof GeometryAtom) || !((GeometryAtom)((BHLeafNode)bh).leafIF).source.isPickable || !pickShape.intersect(bh.bHull, pickPos)) break;
                hitArrList.add(bh);
                break;
            }
            case 1: {
                if (!pickShape.intersect(bh.bHull, pickPos)) break;
                this.doSelect(pickShape, hitArrList, ((BHInternalNode)bh).getRightChild(), pickPos);
                this.doSelect(pickShape, hitArrList, ((BHInternalNode)bh).getLeftChild(), pickPos);
            }
        }
    }

    BHNode selectAny(PickShape pickShape) {
        if (pickShape == null || this.root == null) {
            return null;
        }
        return this.doSelectAny(pickShape, this.root, this.tPoint4d);
    }

    private BHNode doSelectAny(PickShape pickShape, BHNode bh, Point4d pickPos) {
        BHNode hitNode = null;
        if (bh == null || bh.bHull.isEmpty()) {
            return null;
        }
        switch (bh.nodeType) {
            case 2: {
                if (!((BHLeafNode)bh).isEnable() || !(((BHLeafNode)bh).leafIF instanceof GeometryAtom) || !((GeometryAtom)((BHLeafNode)bh).leafIF).source.isPickable || !pickShape.intersect(bh.bHull, pickPos)) break;
                return bh;
            }
            case 1: {
                if (!pickShape.intersect(bh.bHull, pickPos)) break;
                hitNode = this.doSelectAny(pickShape, ((BHInternalNode)bh).getRightChild(), pickPos);
                if (hitNode != null) {
                    return hitNode;
                }
                return this.doSelectAny(pickShape, ((BHInternalNode)bh).getLeftChild(), pickPos);
            }
        }
        return null;
    }

    private void create(BHNode[] bhArr) {
        if (bhArr == null) {
            this.root = null;
            return;
        }
        if (bhArr.length == 1) {
            bhArr[0].computeBoundingHull();
            this.root = bhArr[0];
            return;
        }
        int[] centerValuesIndex = new int[bhArr.length];
        float[][] centerValues = this.computeCenterValues(bhArr, centerValuesIndex);
        this.root = new BHInternalNode();
        this.constructTree((BHInternalNode)this.root, bhArr, centerValues, centerValuesIndex);
    }

    void insert(BHNode[] bhArr, int size) {
        if (bhArr == null || size < 1 || bhArr.length < 1) {
            return;
        }
        if (this.root == null) {
            BHNode[] newbhArr = new BHNode[size];
            System.arraycopy(bhArr, 0, newbhArr, 0, size);
            this.create(newbhArr);
            return;
        }
        if (this.root.nodeType == 2) {
            BHNode[] oldBhArr = bhArr;
            bhArr = new BHNode[size + 1];
            System.arraycopy(oldBhArr, 0, bhArr, 0, size);
            bhArr[size] = this.root;
            this.create(bhArr);
            return;
        }
        if (this.insertStructure == null) {
            this.insertStructure = new BHInsertStructure(size);
        } else {
            this.insertStructure.clear();
        }
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.root.isInside(bhArr[i2].bHull)) {
                ((BHInternalNode)this.root).insert(bhArr[i2], this.insertStructure);
                continue;
            }
            this.root.bHull.combine(bhArr[i2].bHull);
            this.insertStructure.lookupAndInsert(this.root, bhArr[i2]);
        }
        this.insertStructure.updateBoundingTree(this);
        this.insertStructure.clear();
        this.estMaxDepth += (int)(Math.log(size) / LOG_OF_2) + 1;
        if (this.estMaxDepth > this.depthUpperBound) {
            int maxDepth = this.root.computeMaxDepth(0);
            int leafCount = this.root.countNumberOfLeaves();
            double compDepth = Math.log(leafCount) / LOG_OF_2;
            if (maxDepth > this.depthUpperBound) {
                this.reConstructTree(leafCount);
                maxDepth = this.root.computeMaxDepth(0);
            }
            if (maxDepth > this.depthUpperBound) {
                this.depthUpperBound += 5;
            } else if (this.depthUpperBound != 56 && (double)maxDepth * 1.5 < (double)this.depthUpperBound) {
                this.depthUpperBound -= 5;
                if (this.depthUpperBound < 56) {
                    this.depthUpperBound = 56;
                }
            }
            this.estMaxDepth = maxDepth;
        }
    }

    private void markParentChain(BHNode[] nArr, int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            BHNode node = nArr[i2];
            node.mark = true;
            while (node.parent != null && !node.parent.mark) {
                node = node.parent;
                node.mark = true;
            }
        }
    }

    private void markParentChain(BHNode node) {
        node.mark = true;
        while (node.parent != null && !node.parent.mark) {
            node = node.parent;
            node.mark = true;
        }
    }

    void delete(BHNode[] bhArr, int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            if (bhArr[i2] == null || bhArr[i2].nodeType != 2) continue;
            this.markParentChain(bhArr[i2]);
        }
        this.root = this.root.deleteAndUpdateMarkedNodes();
    }

    float[][] computeCenterValues(BHNode[] bhArr, int[] cIndex) {
        float[][] centers = new float[bhArr.length][3];
        for (int i2 = 0; i2 < bhArr.length; ++i2) {
            cIndex[i2] = i2;
            bhArr[i2].computeBoundingHull();
            centers[i2][0] = (float)(bhArr[i2].bHull.upper.x + bhArr[i2].bHull.lower.x) / 2.0f;
            centers[i2][1] = (float)(bhArr[i2].bHull.upper.y + bhArr[i2].bHull.lower.y) / 2.0f;
            centers[i2][2] = (float)(bhArr[i2].bHull.upper.z + bhArr[i2].bHull.lower.z) / 2.0f;
        }
        return centers;
    }

    void computeMeansAndSumSquares(float[][] centerValues, int[] centerValuesIndex, float[] means, float[] ss) {
        int i2;
        float[] sumCenters = new float[3];
        float temp = 0.0f;
        int arrLen = centerValuesIndex.length;
        for (i2 = 2; i2 >= 0; --i2) {
            sumCenters[i2] = 0.0f;
            ss[i2] = 0.0f;
        }
        for (i2 = arrLen - 1; i2 >= 0; --i2) {
            sumCenters[0] = sumCenters[0] + centerValues[centerValuesIndex[i2]][0];
            sumCenters[1] = sumCenters[1] + centerValues[centerValuesIndex[i2]][1];
            sumCenters[2] = sumCenters[2] + centerValues[centerValuesIndex[i2]][2];
        }
        means[0] = sumCenters[0] / (float)arrLen;
        means[1] = sumCenters[1] / (float)arrLen;
        means[2] = sumCenters[2] / (float)arrLen;
        for (i2 = arrLen - 1; i2 >= 0; --i2) {
            temp = centerValues[centerValuesIndex[i2]][0] - means[0];
            ss[0] = ss[0] + temp * temp;
            temp = centerValues[centerValuesIndex[i2]][1] - means[1];
            ss[1] = ss[1] + temp * temp;
            temp = centerValues[centerValuesIndex[i2]][2] - means[2];
            ss[2] = ss[2] + temp * temp;
        }
    }

    int findSplitAxis(float[] ss) {
        int splitAxis = -1;
        float maxSS = 0.0f;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!(ss[i2] > maxSS)) continue;
            maxSS = ss[i2];
            splitAxis = i2;
        }
        return splitAxis;
    }

    void constructTree(BHInternalNode parent, BHNode[] bhArr, float[][] centerValues, int[] centerValuesIndex) {
        int i2;
        int rightSetCount = 0;
        int leftSetCount = 0;
        float[] means = new float[3];
        float[] ss = new float[3];
        this.computeMeansAndSumSquares(centerValues, centerValuesIndex, means, ss);
        int splitAxis = this.findSplitAxis(ss);
        boolean[] leftOrRightSet = new boolean[bhArr.length];
        if (splitAxis == -1) {
            for (i2 = 0; i2 < bhArr.length; ++i2) {
                if (leftSetCount > rightSetCount) {
                    ++rightSetCount;
                    leftOrRightSet[i2] = false;
                    continue;
                }
                ++leftSetCount;
                leftOrRightSet[i2] = true;
            }
        } else {
            for (i2 = 0; i2 < bhArr.length; ++i2) {
                if (centerValues[centerValuesIndex[i2]][splitAxis] < means[splitAxis]) {
                    ++leftSetCount;
                    leftOrRightSet[i2] = true;
                    continue;
                }
                if (centerValues[centerValuesIndex[i2]][splitAxis] > means[splitAxis]) {
                    ++rightSetCount;
                    leftOrRightSet[i2] = false;
                    continue;
                }
                if (leftSetCount > rightSetCount) {
                    ++rightSetCount;
                    leftOrRightSet[i2] = false;
                    continue;
                }
                ++leftSetCount;
                leftOrRightSet[i2] = true;
            }
        }
        if (leftSetCount == bhArr.length) {
            rightSetCount = 0;
            leftSetCount = 0;
            for (i2 = 0; i2 < bhArr.length; ++i2) {
                if (leftSetCount > rightSetCount) {
                    ++rightSetCount;
                    leftOrRightSet[i2] = false;
                    continue;
                }
                ++leftSetCount;
                leftOrRightSet[i2] = true;
            }
        } else if (rightSetCount == bhArr.length) {
            rightSetCount = 0;
            leftSetCount = 0;
            for (i2 = 0; i2 < bhArr.length; ++i2) {
                if (leftSetCount > rightSetCount) {
                    ++rightSetCount;
                    leftOrRightSet[i2] = false;
                    continue;
                }
                ++leftSetCount;
                leftOrRightSet[i2] = true;
            }
        }
        BHNode[] rightSet = new BHNode[rightSetCount];
        BHNode[] leftSet = new BHNode[leftSetCount];
        int[] centerValuesIndexR = new int[rightSetCount];
        int[] centerValuesIndexL = new int[leftSetCount];
        rightSetCount = 0;
        leftSetCount = 0;
        for (i2 = 0; i2 < bhArr.length; ++i2) {
            if (leftOrRightSet[i2]) {
                leftSet[leftSetCount] = bhArr[i2];
                centerValuesIndexL[leftSetCount] = centerValuesIndex[i2];
                ++leftSetCount;
                continue;
            }
            rightSet[rightSetCount] = bhArr[i2];
            centerValuesIndexR[rightSetCount] = centerValuesIndex[i2];
            ++rightSetCount;
        }
        if (rightSet.length != 1) {
            parent.rChild = new BHInternalNode();
            parent.rChild.setParent(parent);
            this.constructTree((BHInternalNode)parent.rChild, rightSet, centerValues, centerValuesIndexR);
        } else {
            parent.rChild = rightSet[0];
            parent.rChild.setParent(parent);
        }
        if (leftSet.length != 1) {
            parent.lChild = new BHInternalNode();
            parent.lChild.setParent(parent);
            this.constructTree((BHInternalNode)parent.lChild, leftSet, centerValues, centerValuesIndexL);
        } else {
            parent.lChild = leftSet[0];
            parent.lChild.setParent(parent);
        }
        parent.combineBHull(parent.rChild, parent.lChild);
    }

    void reConstructTree(int numOfLeaf) {
        if (this.root == null) {
            return;
        }
        BHNode[] bhArr = new BHNode[numOfLeaf];
        int[] index = new int[]{0};
        this.root.destroyTree(bhArr, index);
        this.create(bhArr);
    }

    void gatherTreeStatistics() {
        int leafCount = this.root.countNumberOfLeaves();
        int internalCount = this.root.countNumberOfInternals();
        int maxDepth = this.root.computeMaxDepth(0);
        float averageDepth = this.root.computeAverageLeafDepth(leafCount, 0);
        System.err.println("Statistics for tree = " + this);
        System.err.println("Total Number of nodes in tree = " + (leafCount + internalCount));
        System.err.println("Number of Leaf Nodes = " + leafCount);
        System.err.println("Number of Internal Nodes = " + internalCount);
        System.err.println("Maximum Leaf depth = " + maxDepth);
        System.err.println("Average Leaf depth = " + averageDepth);
        System.err.println("root.bHull = " + this.root.bHull);
    }

    void printTree(BHNode bh) {
        if (bh != null) {
            if (bh.nodeType == 1) {
                System.err.println("BH_TYPE_INTERNAL - bHull : " + bh);
                System.err.println(bh.bHull);
                System.err.println("rChild : " + ((BHInternalNode)bh).rChild + " lChild : " + ((BHInternalNode)bh).lChild);
                this.printTree(((BHInternalNode)bh).rChild);
                this.printTree(((BHInternalNode)bh).lChild);
            } else if (bh.nodeType == 2) {
                System.err.println("BH_TYPE_LEAF - bHull : " + bh);
                System.err.println(bh.bHull);
            }
        }
    }
}

