/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Random;
import org.jogamp.java3d.BHInternalNode;
import org.jogamp.java3d.BHNode;
import org.jogamp.java3d.BHTree;

class BHInsertStructure {
    static boolean debug = false;
    static boolean debug2 = false;
    Random randomNumber = new Random(0L);
    ArrayList[] bhListArr = null;
    ArrayList[] oldBhListArr = null;
    BHNode[] bhListArrRef = null;
    BHNode[] oldBhListArrRef = null;
    int bhListArrCnt = 0;
    int bhListArrMaxCnt = 0;
    int blockSize = 0;

    BHInsertStructure(int length) {
        if (length > 50) {
            length = 50;
        }
        this.blockSize = 50;
        this.bhListArr = new ArrayList[length];
        this.bhListArrRef = new BHNode[length];
        this.bhListArrCnt = 0;
        this.bhListArrMaxCnt = length;
    }

    void clear() {
        for (int i2 = 0; i2 < this.bhListArrCnt; ++i2) {
            this.bhListArr[i2].clear();
            this.bhListArrRef[i2] = null;
        }
        this.bhListArrCnt = 0;
    }

    void lookupAndInsert(BHNode parent, BHNode child) {
        boolean found = false;
        for (int i2 = 0; i2 < this.bhListArrCnt; ++i2) {
            if (this.bhListArrRef[i2] != parent) continue;
            this.bhListArr[i2].add(child);
            found = true;
            break;
        }
        if (!found) {
            if (this.bhListArrCnt >= this.bhListArrMaxCnt) {
                if (debug) {
                    System.err.println("(1) Expanding bhListArr array ...");
                }
                this.bhListArrMaxCnt += this.blockSize;
                this.oldBhListArr = this.bhListArr;
                this.oldBhListArrRef = this.bhListArrRef;
                this.bhListArr = new ArrayList[this.bhListArrMaxCnt];
                this.bhListArrRef = new BHNode[this.bhListArrMaxCnt];
                System.arraycopy(this.oldBhListArr, 0, this.bhListArr, 0, this.oldBhListArr.length);
                System.arraycopy(this.oldBhListArrRef, 0, this.bhListArrRef, 0, this.oldBhListArrRef.length);
            }
            this.bhListArrRef[this.bhListArrCnt] = parent;
            this.bhListArr[this.bhListArrCnt] = new ArrayList();
            this.bhListArr[this.bhListArrCnt].add(child);
            ++this.bhListArrCnt;
        }
    }

    void updateBoundingTree(BHTree bhTree) {
        for (int i2 = 0; i2 < this.bhListArrCnt; ++i2) {
            int cnt = 0;
            BHNode child1 = ((BHInternalNode)this.bhListArrRef[i2]).getLeftChild();
            BHNode child2 = ((BHInternalNode)this.bhListArrRef[i2]).getRightChild();
            if (child1 != null) {
                ++cnt;
            }
            if (child2 != null) {
                ++cnt;
            }
            int size = this.bhListArr[i2].size();
            BHNode[] bhArr = new BHNode[cnt + size];
            this.bhListArr[i2].toArray(bhArr);
            cnt = 0;
            if (child1 != null) {
                bhArr[size] = child1;
                bhArr[size + ++cnt] = child2;
            }
            if (debug2 && (child1 == null || child2 == null)) {
                System.err.println("child1 or child2 is null ...");
                System.err.println("This is bad, it shouldn't happen");
            }
            ((BHInternalNode)this.bhListArrRef[i2]).setRightChild(null);
            ((BHInternalNode)this.bhListArrRef[i2]).setLeftChild(null);
            bhTree.cluster((BHInternalNode)this.bhListArrRef[i2], bhArr);
        }
    }
}

