/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.AppearanceRetained;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.BoundingLeafRetained;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.IllegalSceneGraphException;
import org.jogamp.java3d.IllegalSharingException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LeafRetained;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.VirtualUniverse;

class AlternateAppearanceRetained
extends LeafRetained {
    static final int APPEARANCE_CHANGED = 1;
    static final int SCOPE_CHANGED = 2;
    static final int BOUNDS_CHANGED = 4;
    static final int BOUNDINGLEAF_CHANGED = 8;
    static final int INIT_MIRROR = 16;
    static final int CLEAR_MIRROR = 32;
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Vector<GroupRetained> scopes = new Vector();
    boolean inImmCtx = false;
    static final int targetThreads = 4224;
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    Bounds region = null;
    AlternateAppearanceRetained mirrorAltApp = null;
    AppearanceRetained appearance;
    AlternateAppearanceRetained sgAltApp = null;
    boolean isViewScoped = false;

    AlternateAppearanceRetained() {
        this.nodeType = 27;
        this.localBounds = new BoundingBox((Bounds)null);
    }

    void initAppearance(Appearance app) {
        this.appearance = app != null ? (AppearanceRetained)app.retained : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppearance(Appearance app) {
        Object object;
        if (this.appearance != null) {
            object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.clearLive(this.refCount);
            }
        }
        this.initAppearance(app);
        if (this.appearance != null) {
            object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.sendMessage(1, this.appearance != null ? this.appearance.mirror : null);
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    void initInfluencingBounds(Bounds region) {
        this.regionOfInfluence = region != null ? (Bounds)region.clone() : null;
    }

    void setInfluencingBounds(Bounds region) {
        this.initInfluencingBounds(region);
        this.sendMessage(4, region != null ? region.clone() : null);
    }

    Bounds getInfluencingBounds() {
        return this.regionOfInfluence != null ? (Bounds)this.regionOfInfluence.clone() : null;
    }

    void initInfluencingBoundingLeaf(BoundingLeaf region) {
        this.boundingLeaf = region != null ? (BoundingLeafRetained)region.retained : null;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf region) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorAltApp);
        }
        if (region != null) {
            this.boundingLeaf = (BoundingLeafRetained)region.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorAltApp);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(8, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null);
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void initScope(Group scope, int index) {
        this.scopes.setElementAt((GroupRetained)scope.retained, index);
    }

    void setScope(Group scope, int index) {
        ArrayList removeScopeList = new ArrayList();
        ArrayList addScopeList = new ArrayList();
        Object[] scopeInfo = new Object[3];
        GroupRetained group = this.scopes.get(index);
        this.tempKey.reset();
        group.removeAllNodesForScopedAltApp(this.mirrorAltApp, removeScopeList, this.tempKey);
        group = (GroupRetained)scope.retained;
        this.initScope(scope, index);
        this.tempKey.reset();
        group.addAllNodesForScopedAltApp(this.mirrorAltApp, addScopeList, this.tempKey);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    Group getScope(int index) {
        return (Group)this.scopes.elementAt((int)index).source;
    }

    void initInsertScope(Node scope, int index) {
        GroupRetained group = (GroupRetained)scope.retained;
        this.scopes.insertElementAt(group, index);
        group.setAltAppScope();
    }

    void insertScope(Node scope, int index) {
        Object[] scopeInfo = new Object[3];
        ArrayList addScopeList = new ArrayList();
        GroupRetained group = (GroupRetained)scope.retained;
        this.initInsertScope(scope, index);
        group = (GroupRetained)scope.retained;
        this.tempKey.reset();
        group.addAllNodesForScopedAltApp(this.mirrorAltApp, addScopeList, this.tempKey);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = null;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    void initRemoveScope(int index) {
        GroupRetained group = this.scopes.remove(index);
        group.removeAltAppScope();
    }

    void removeScope(int index) {
        Object[] scopeInfo = new Object[3];
        ArrayList removeScopeList = new ArrayList();
        GroupRetained group = this.scopes.elementAt(index);
        this.tempKey.reset();
        group.removeAllNodesForScopedAltApp(this.mirrorAltApp, removeScopeList, this.tempKey);
        this.initRemoveScope(index);
        scopeInfo[0] = null;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    void removeScope(Group scope) {
        int ind = this.indexOfScope(scope);
        if (ind >= 0) {
            this.removeScope(ind);
        }
    }

    void initRemoveScope(Group scope) {
        int ind = this.indexOfScope(scope);
        if (ind >= 0) {
            this.initRemoveScope(ind);
        }
    }

    void removeAllScopes() {
        ArrayList removeScopeList = new ArrayList();
        int n2 = this.scopes.size();
        for (int index = n2 - 1; index >= 0; --index) {
            GroupRetained group = this.scopes.elementAt(index);
            this.tempKey.reset();
            group.removeAllNodesForScopedAltApp(this.mirrorAltApp, removeScopeList, this.tempKey);
            this.initRemoveScope(index);
        }
        Object[] scopeInfo = new Object[]{null, removeScopeList, Boolean.FALSE};
        this.sendMessage(2, scopeInfo);
    }

    void initRemoveAllScopes() {
        int n2 = this.scopes.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.initRemoveScope(i2);
        }
    }

    Iterator<Group> getAllScopes() {
        Iterator<GroupRetained> elm = this.scopes.iterator();
        Vector<Group> v = new Vector<Group>(this.scopes.size());
        while (elm.hasNext()) {
            v.add((Group)elm.next().source);
        }
        return v.iterator();
    }

    int indexOfScope(Group scope) {
        if (scope != null) {
            return this.scopes.indexOf(scope.retained);
        }
        return this.scopes.indexOf(null);
    }

    void initAddScope(Group scope) {
        GroupRetained group = (GroupRetained)scope.retained;
        this.scopes.addElement(group);
        group.setAltAppScope();
    }

    void addScope(Group scope) {
        Object[] scopeInfo = new Object[3];
        ArrayList addScopeList = new ArrayList();
        GroupRetained group = (GroupRetained)scope.retained;
        this.initAddScope(scope);
        this.tempKey.reset();
        group.addAllNodesForScopedAltApp(this.mirrorAltApp, addScopeList, this.tempKey);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = null;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    int numScopes() {
        return this.scopes.size();
    }

    void setInImmCtx(boolean inCtx) {
        this.inImmCtx = inCtx;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    boolean isScoped() {
        return this.scopes != null;
    }

    void updateImmediateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        if ((component & 1) != 0) {
            this.mirrorAltApp.appearance = (AppearanceRetained)objs[2];
        }
        if ((component & 4) != 0) {
            this.mirrorAltApp.regionOfInfluence = (Bounds)objs[2];
            if (this.mirrorAltApp.boundingLeaf == null) {
                if (objs[2] != null) {
                    this.mirrorAltApp.region = this.mirrorAltApp.regionOfInfluence.copy(this.mirrorAltApp.region);
                    this.mirrorAltApp.region.transform(this.mirrorAltApp.regionOfInfluence, this.getCurrentLocalToVworld());
                } else {
                    this.mirrorAltApp.region = null;
                }
            }
        } else if ((component & 8) != 0) {
            this.mirrorAltApp.boundingLeaf = (BoundingLeafRetained)objs[2];
            if (objs[2] != null) {
                this.mirrorAltApp.region = this.mirrorAltApp.boundingLeaf.transformedRegion;
            } else if (this.mirrorAltApp.regionOfInfluence != null) {
                this.mirrorAltApp.region = this.mirrorAltApp.regionOfInfluence.copy(this.mirrorAltApp.region);
                this.mirrorAltApp.region.transform(this.mirrorAltApp.regionOfInfluence, this.getCurrentLocalToVworld());
            } else {
                this.mirrorAltApp.region = null;
            }
        } else if ((component & 2) != 0) {
            Shape3DRetained obj;
            int i2;
            Object[] scopeList = (Object[])objs[2];
            ArrayList addList = (ArrayList)scopeList[0];
            ArrayList removeList = (ArrayList)scopeList[1];
            boolean isScoped = (Boolean)scopeList[2];
            if (addList != null) {
                this.mirrorAltApp.isScoped = isScoped;
                for (i2 = 0; i2 < addList.size(); ++i2) {
                    obj = ((GeometryAtom)addList.get((int)i2)).source;
                    obj.addAltApp(this.mirrorAltApp);
                }
            }
            if (removeList != null) {
                this.mirrorAltApp.isScoped = isScoped;
                for (i2 = 0; i2 < removeList.size(); ++i2) {
                    obj = ((GeometryAtom)removeList.get((int)i2)).source;
                    obj.removeAltApp(this.mirrorAltApp);
                }
            }
        }
    }

    @Override
    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.switchState.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.getCurrentLocalToVworld());
        } else {
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setLive(SetLiveState s) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("AlternateAppearanceRetained13"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("AlternateAppearanceRetained15"));
        }
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("AlternateAppearanceRetained16"));
        }
        super.doSetLive(s);
        if (this.appearance != null) {
            if (this.appearance.getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("AlternateAppearanceRetained14"));
            }
            Object object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.setLive(this.inBackgroundGroup, s.refCount);
            }
        }
        if (this.mirrorAltApp == null) {
            this.mirrorAltApp = (AlternateAppearanceRetained)this.clone();
            this.mirrorAltApp.boundingLeaf = null;
            this.mirrorAltApp.sgAltApp = this;
        }
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorAltApp);
        }
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this.mirrorAltApp);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this.mirrorAltApp);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this.mirrorAltApp, 1);
            s.notifyThreads |= 0x2000;
        }
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this.mirrorAltApp, 1);
        }
        this.mirrorAltApp.switchState = s.switchStates.get(0);
        s.notifyThreads |= 0x1080;
        super.markAsLive();
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4096;
        createMessage.universe = this.universe;
        createMessage.type = 41;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(16);
        ArrayList addScopeList = new ArrayList();
        for (int i2 = 0; i2 < this.scopes.size(); ++i2) {
            GroupRetained group = this.scopes.get(i2);
            this.tempKey.reset();
            group.addAllNodesForScopedAltApp(this.mirrorAltApp, addScopeList, this.tempKey);
        }
        Object[] scopeInfo = new Object[]{this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE, addScopeList};
        createMessage.args[2] = scopeInfo;
        createMessage.args[3] = this.appearance != null ? this.appearance.mirror : null;
        Object[] obj = new Object[]{this.boundingLeaf, this.regionOfInfluence != null ? this.regionOfInfluence.clone() : null};
        createMessage.args[4] = obj;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    void initMirrorObject(Object[] args) {
        Object[] scopeInfo = (Object[])args[2];
        Boolean scoped = (Boolean)scopeInfo[0];
        ArrayList shapeList = (ArrayList)scopeInfo[1];
        AppearanceRetained app = (AppearanceRetained)args[3];
        BoundingLeafRetained bl = (BoundingLeafRetained)((Object[])args[4])[0];
        Bounds bnds = (Bounds)((Object[])args[4])[1];
        for (int i2 = 0; i2 < shapeList.size(); ++i2) {
            Shape3DRetained shape = ((GeometryAtom)shapeList.get((int)i2)).source;
            shape.addAltApp(this.mirrorAltApp);
        }
        this.mirrorAltApp.isScoped = scoped;
        if (app != null) {
            this.mirrorAltApp.appearance = app;
        }
        if (bl != null) {
            this.mirrorAltApp.boundingLeaf = bl.mirrorBoundingLeaf;
            this.mirrorAltApp.region = this.boundingLeaf.transformedRegion;
        } else {
            this.mirrorAltApp.boundingLeaf = null;
            this.mirrorAltApp.region = null;
        }
        if (bnds != null) {
            this.mirrorAltApp.regionOfInfluence = bnds;
            if (this.mirrorAltApp.region == null) {
                this.mirrorAltApp.region = (Bounds)this.regionOfInfluence.clone();
                this.mirrorAltApp.region.transform(this.regionOfInfluence, this.getLastLocalToVworld());
            }
        } else {
            this.mirrorAltApp.regionOfInfluence = null;
        }
    }

    void clearMirrorObject(Object[] args) {
        ArrayList shapeList = (ArrayList)args[2];
        ArrayList removeScopeList = new ArrayList();
        for (int i2 = 0; i2 < shapeList.size(); ++i2) {
            Shape3DRetained shape = ((GeometryAtom)shapeList.get((int)i2)).source;
            shape.removeAltApp(this.mirrorAltApp);
        }
        this.mirrorAltApp.isScoped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearLive(SetLiveState s) {
        if (this.appearance != null) {
            Object object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.clearLive(s.refCount);
            }
        }
        super.clearLive(s);
        s.notifyThreads |= 0x1080;
        if (this.mirrorAltApp.boundingLeaf != null) {
            this.mirrorAltApp.boundingLeaf.removeUser(this.mirrorAltApp);
        }
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this.mirrorAltApp);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this.mirrorAltApp);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this.mirrorAltApp, 1);
            s.notifyThreads |= 0x2000;
        }
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this.mirrorAltApp, 1);
        }
        if (this.scopes.size() > 0) {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 4096;
            createMessage.universe = this.universe;
            createMessage.type = 41;
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(32);
            ArrayList removeScopeList = new ArrayList();
            for (int i2 = 0; i2 < this.scopes.size(); ++i2) {
                GroupRetained group = this.scopes.get(i2);
                this.tempKey.reset();
                group.removeAllNodesForScopedAltApp(this.mirrorAltApp, removeScopeList, this.tempKey);
            }
            createMessage.args[2] = removeScopeList;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void updateTransformChange() {
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.sgAltApp.getCurrentLocalToVworld());
        }
    }

    final void sendMessage(int attrMask, Object attr) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.universe = this.universe;
        createMessage.type = 41;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void getMirrorObjects(ArrayList leafList, HashKey key) {
        leafList.add(this.mirrorAltApp);
    }

    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        throw new RuntimeException("method not implemented");
    }
}

