/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.J3dClock;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.VirtualUniverse;

public class Alpha
extends NodeComponent {
    private int loopCount;
    public static final int INCREASING_ENABLE = 1;
    public static final int DECREASING_ENABLE = 2;
    private int mode;
    private float triggerTime;
    private float phaseDelay;
    private float increasingAlpha;
    private long increasingAlphaRamp;
    private float incAlphaRampInternal;
    private float alphaAtOne;
    private float decreasingAlpha;
    private long decreasingAlphaRamp;
    private float decAlphaRampInternal;
    private float alphaAtZero;
    private long pauseTime = 0L;
    private boolean paused = false;
    private float stopTime;
    private long startTime = MasterControl.systemStartTime;

    public Alpha() {
        this.loopCount = -1;
        this.mode = 1;
        this.increasingAlpha = 1.0f;
    }

    public Alpha(int loopCount, int mode, long triggerTime, long phaseDelayDuration, long increasingAlphaDuration, long increasingAlphaRampDuration, long alphaAtOneDuration, long decreasingAlphaDuration, long decreasingAlphaRampDuration, long alphaAtZeroDuration) {
        this.loopCount = loopCount;
        this.mode = mode;
        this.triggerTime = (float)triggerTime * 0.001f;
        this.phaseDelay = (float)phaseDelayDuration * 0.001f;
        this.increasingAlpha = (float)increasingAlphaDuration * 0.001f;
        this.alphaAtOne = (float)alphaAtOneDuration * 0.001f;
        this.increasingAlphaRamp = increasingAlphaRampDuration;
        this.incAlphaRampInternal = (float)increasingAlphaRampDuration * 0.001f;
        if (this.incAlphaRampInternal > 0.5f * this.increasingAlpha) {
            this.incAlphaRampInternal = 0.5f * this.increasingAlpha;
        }
        this.decreasingAlpha = (float)decreasingAlphaDuration * 0.001f;
        this.alphaAtZero = (float)alphaAtZeroDuration * 0.001f;
        this.decreasingAlphaRamp = decreasingAlphaRampDuration;
        this.decAlphaRampInternal = (float)decreasingAlphaRampDuration * 0.001f;
        if (this.decAlphaRampInternal > 0.5f * this.decreasingAlpha) {
            this.decAlphaRampInternal = 0.5f * this.decreasingAlpha;
        }
        this.computeStopTime();
    }

    public Alpha(int loopCount, long triggerTime, long phaseDelayDuration, long increasingAlphaDuration, long increasingAlphaRampDuration, long alphaAtOneDuration) {
        this(loopCount, 1, triggerTime, phaseDelayDuration, increasingAlphaDuration, increasingAlphaRampDuration, alphaAtOneDuration, 0L, 0L, 0L);
    }

    public Alpha(int loopCount, long increasingAlphaDuration) {
        this.mode = 1;
        this.increasingAlpha = (float)increasingAlphaDuration * 0.001f;
        this.loopCount = loopCount;
        if (loopCount >= 0) {
            this.stopTime = (float)loopCount * this.increasingAlpha;
        }
    }

    public void pause() {
        this.pause(J3dClock.currentTimeMillis());
    }

    public void pause(long time) {
        if (time <= 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("Alpha0"));
        }
        this.paused = true;
        this.pauseTime = time;
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public void resume() {
        this.resume(J3dClock.currentTimeMillis());
    }

    public void resume(long time) {
        if (time <= 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("Alpha0"));
        }
        if (this.paused) {
            long newStartTime = this.startTime + time - this.pauseTime;
            this.paused = false;
            this.pauseTime = 0L;
            this.setStartTime(newStartTime);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getPauseTime() {
        return this.pauseTime;
    }

    public float value() {
        long currentTime = this.paused ? this.pauseTime : J3dClock.currentTimeMillis();
        return this.value(currentTime);
    }

    public float value(long atTime) {
        float interpolatorTime = (float)(atTime - this.startTime) * 0.001f;
        if ((this.mode & 1) != 0 && (this.mode & 2) == 0) {
            if (interpolatorTime <= this.triggerTime + this.phaseDelay) {
                return 0.0f;
            }
            if (this.loopCount != -1 && interpolatorTime >= this.stopTime) {
                return 1.0f;
            }
            if (this.incAlphaRampInternal == 0.0f) {
                float alpha = this.mfmod(interpolatorTime - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne), this.increasingAlpha + this.alphaAtOne) / this.increasingAlpha;
                if (alpha > 1.0f) {
                    alpha = 1.0f;
                }
                return alpha;
            }
            float alphaRampDuration = this.incAlphaRampInternal;
            float dt = this.mfmod(interpolatorTime - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne), this.increasingAlpha + this.alphaAtOne);
            if (dt >= this.increasingAlpha) {
                float alpha = 1.0f;
                return alpha;
            }
            float a1 = 1.0f / (this.increasingAlpha * alphaRampDuration - alphaRampDuration * alphaRampDuration);
            float alpha = dt < alphaRampDuration ? 0.5f * a1 * dt * dt : (dt < this.increasingAlpha - alphaRampDuration ? 0.5f * a1 * alphaRampDuration * alphaRampDuration + (dt - alphaRampDuration) * a1 * alphaRampDuration : a1 * alphaRampDuration * alphaRampDuration + (this.increasingAlpha - 2.0f * alphaRampDuration) * a1 * alphaRampDuration - 0.5f * a1 * (this.increasingAlpha - dt) * (this.increasingAlpha - dt));
            return alpha;
        }
        if ((this.mode & 1) == 0 && (this.mode & 2) != 0) {
            if (interpolatorTime <= this.triggerTime + this.phaseDelay) {
                return 1.0f;
            }
            if (this.loopCount != -1 && interpolatorTime >= this.stopTime) {
                return 0.0f;
            }
            if (this.decAlphaRampInternal == 0.0f) {
                float alpha = this.mfmod(interpolatorTime - this.triggerTime - this.phaseDelay + 6.0f * (this.decreasingAlpha + this.alphaAtZero), this.decreasingAlpha + this.alphaAtZero) / this.decreasingAlpha;
                if (alpha > 1.0f) {
                    alpha = 0.0f;
                    return alpha;
                }
                alpha = 1.0f - alpha;
                return alpha;
            }
            float alphaRampDuration = this.decAlphaRampInternal;
            float dt = this.mfmod(interpolatorTime - this.triggerTime - this.phaseDelay + 6.0f * (this.decreasingAlpha + this.alphaAtZero), this.decreasingAlpha + this.alphaAtZero);
            if (dt >= this.decreasingAlpha) {
                float alpha = 0.0f;
                return alpha;
            }
            float a1 = 1.0f / (this.decreasingAlpha * alphaRampDuration - alphaRampDuration * alphaRampDuration);
            float alpha = dt < alphaRampDuration ? 0.5f * a1 * dt * dt : (dt < this.decreasingAlpha - alphaRampDuration ? 0.5f * a1 * alphaRampDuration * alphaRampDuration + (dt - alphaRampDuration) * a1 * alphaRampDuration : a1 * alphaRampDuration * alphaRampDuration + (this.decreasingAlpha - 2.0f * alphaRampDuration) * a1 * alphaRampDuration - 0.5f * a1 * (this.decreasingAlpha - dt) * (this.decreasingAlpha - dt));
            alpha = 1.0f - alpha;
            return alpha;
        }
        if ((this.mode & 1) != 0 && (this.mode & 2) != 0) {
            float dt;
            if (interpolatorTime <= this.triggerTime + this.phaseDelay) {
                return 0.0f;
            }
            if (this.loopCount != -1 && interpolatorTime >= this.stopTime) {
                return 0.0f;
            }
            if (this.incAlphaRampInternal == 0.0f && this.decAlphaRampInternal == 0.0f) {
                float dt2 = this.mfmod(interpolatorTime - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero), this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero);
                float alpha = dt2 / this.increasingAlpha;
                if (alpha < 1.0f) {
                    return alpha;
                }
                if ((dt2 -= this.increasingAlpha) < this.alphaAtOne) {
                    alpha = 1.0f;
                    return alpha;
                }
                alpha = (dt2 -= this.alphaAtOne) / this.decreasingAlpha;
                alpha = alpha < 1.0f ? 1.0f - alpha : 0.0f;
                return alpha;
            }
            float alphaRampDuration = this.incAlphaRampInternal;
            if (alphaRampDuration == 0.0f) {
                alphaRampDuration = 1.0E-5f;
            }
            if ((dt = this.mfmod(interpolatorTime - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero), this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero)) <= this.increasingAlpha) {
                float a1 = 1.0f / (this.increasingAlpha * alphaRampDuration - alphaRampDuration * alphaRampDuration);
                float alpha = dt < alphaRampDuration ? 0.5f * a1 * dt * dt : (dt < this.increasingAlpha - alphaRampDuration ? 0.5f * a1 * alphaRampDuration * alphaRampDuration + (dt - alphaRampDuration) * a1 * alphaRampDuration : a1 * alphaRampDuration * alphaRampDuration + (this.increasingAlpha - 2.0f * alphaRampDuration) * a1 * alphaRampDuration - 0.5f * a1 * (this.increasingAlpha - dt) * (this.increasingAlpha - dt));
                return alpha;
            }
            if (dt <= this.increasingAlpha + this.alphaAtOne) {
                float alpha = 1.0f;
                return alpha;
            }
            if (dt >= this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha) {
                float alpha = 0.0f;
                return alpha;
            }
            dt -= this.increasingAlpha + this.alphaAtOne;
            alphaRampDuration = this.decAlphaRampInternal;
            if (alphaRampDuration == 0.0f) {
                alphaRampDuration = 1.0E-5f;
            }
            float a1 = 1.0f / (this.decreasingAlpha * alphaRampDuration - alphaRampDuration * alphaRampDuration);
            float alpha = dt < alphaRampDuration ? 0.5f * a1 * dt * dt : (dt < this.decreasingAlpha - alphaRampDuration ? 0.5f * a1 * alphaRampDuration * alphaRampDuration + (dt - alphaRampDuration) * a1 * alphaRampDuration : a1 * alphaRampDuration * alphaRampDuration + (this.decreasingAlpha - 2.0f * alphaRampDuration) * a1 * alphaRampDuration - 0.5f * a1 * (this.decreasingAlpha - dt) * (this.decreasingAlpha - dt));
            alpha = 1.0f - alpha;
            return alpha;
        }
        return 0.0f;
    }

    float mfmod(float a2, float b2) {
        float ta = a2;
        float tb = b2;
        if (tb < 0.0f) {
            tb = -tb;
        }
        if (ta < 0.0f) {
            ta = -ta;
        }
        int fmint = (int)(ta / tb);
        float fm = ta - (float)fmint * tb;
        if (a2 < 0.0f) {
            return b2 - fm;
        }
        return fm;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getTriggerTime() {
        return (long)(this.triggerTime * 1000.0f);
    }

    public void setTriggerTime(long triggerTime) {
        this.triggerTime = (float)triggerTime * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getPhaseDelayDuration() {
        return (long)(this.phaseDelay * 1000.0f);
    }

    public void setPhaseDelayDuration(long phaseDelayDuration) {
        this.phaseDelay = (float)phaseDelayDuration * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getIncreasingAlphaDuration() {
        return (long)(this.increasingAlpha * 1000.0f);
    }

    public void setIncreasingAlphaDuration(long increasingAlphaDuration) {
        this.increasingAlpha = (float)increasingAlphaDuration * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getIncreasingAlphaRampDuration() {
        return this.increasingAlphaRamp;
    }

    public void setIncreasingAlphaRampDuration(long increasingAlphaRampDuration) {
        this.increasingAlphaRamp = increasingAlphaRampDuration;
        this.incAlphaRampInternal = (float)increasingAlphaRampDuration * 0.001f;
        if (this.incAlphaRampInternal > 0.5f * this.increasingAlpha) {
            this.incAlphaRampInternal = 0.5f * this.increasingAlpha;
        }
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getAlphaAtOneDuration() {
        return (long)(this.alphaAtOne * 1000.0f);
    }

    public void setAlphaAtOneDuration(long alphaAtOneDuration) {
        this.alphaAtOne = (float)alphaAtOneDuration * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getDecreasingAlphaDuration() {
        return (long)(this.decreasingAlpha * 1000.0f);
    }

    public void setDecreasingAlphaDuration(long decreasingAlphaDuration) {
        this.decreasingAlpha = (float)decreasingAlphaDuration * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getDecreasingAlphaRampDuration() {
        return this.decreasingAlphaRamp;
    }

    public void setDecreasingAlphaRampDuration(long decreasingAlphaRampDuration) {
        this.decreasingAlphaRamp = decreasingAlphaRampDuration;
        this.decAlphaRampInternal = (float)decreasingAlphaRampDuration * 0.001f;
        if (this.decAlphaRampInternal > 0.5f * this.decreasingAlpha) {
            this.decAlphaRampInternal = 0.5f * this.decreasingAlpha;
        }
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getAlphaAtZeroDuration() {
        return (long)(this.alphaAtZero * 1000.0f);
    }

    public void setAlphaAtZeroDuration(long alphaAtZeroDuration) {
        this.alphaAtZero = (float)alphaAtZeroDuration * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public boolean finished() {
        long currentTime = this.paused ? this.pauseTime : J3dClock.currentTimeMillis();
        return this.loopCount != -1 && (float)(currentTime - this.startTime) * 0.001f > this.stopTime;
    }

    private final void computeStopTime() {
        if (this.loopCount >= 0) {
            float sum = 0.0f;
            if ((this.mode & 1) != 0) {
                sum = this.increasingAlpha + this.alphaAtOne;
            }
            if ((this.mode & 2) != 0) {
                sum += this.decreasingAlpha + this.alphaAtZero;
            }
            this.stopTime = this.triggerTime + this.phaseDelay + (float)this.loopCount * sum;
        } else {
            this.stopTime = 0.0f;
        }
    }

    Alpha cloneAlpha() {
        Alpha a2 = new Alpha();
        a2.setStartTime(this.getStartTime());
        a2.setLoopCount(this.getLoopCount());
        a2.setMode(this.getMode());
        a2.setTriggerTime(this.getTriggerTime());
        a2.setPhaseDelayDuration(this.getPhaseDelayDuration());
        a2.setIncreasingAlphaDuration(this.getIncreasingAlphaDuration());
        a2.setIncreasingAlphaRampDuration(this.getIncreasingAlphaRampDuration());
        a2.setAlphaAtOneDuration(this.getAlphaAtOneDuration());
        a2.setDecreasingAlphaDuration(this.getDecreasingAlphaDuration());
        a2.setDecreasingAlphaRampDuration(this.getDecreasingAlphaRampDuration());
        a2.setAlphaAtZeroDuration(this.getAlphaAtZeroDuration());
        return a2;
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

