/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.XVisualInfo;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.X11GLXContext;
import jogamp.opengl.x11.glx.X11GLXDrawable;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;

public class X11PixmapGLXDrawable
extends X11GLXDrawable {
    private long pixmap;

    protected X11PixmapGLXDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, false);
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.createPixmap();
        } else {
            this.destroyPixmap();
        }
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new X11GLXContext(this, gLContext);
    }

    private void createPixmap() {
        NativeSurface nativeSurface = this.getNativeSurface();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
        XVisualInfo xVisualInfo = x11GLXGraphicsConfiguration.getXVisualInfo();
        int n2 = xVisualInfo.getDepth();
        AbstractGraphicsScreen abstractGraphicsScreen = x11GLXGraphicsConfiguration.getScreen();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        long l2 = abstractGraphicsDevice.getHandle();
        int n3 = abstractGraphicsScreen.getIndex();
        this.pixmap = X11Lib.XCreatePixmap(l2, X11Lib.RootWindow(l2, n3), this.surface.getSurfaceWidth(), this.surface.getSurfaceHeight(), n2);
        if (this.pixmap == 0L) {
            throw new GLException("XCreatePixmap failed");
        }
        long l3 = GLX.glXCreateGLXPixmap(l2, xVisualInfo, this.pixmap);
        if (l3 == 0L) {
            X11Lib.XFreePixmap(l2, this.pixmap);
            this.pixmap = 0L;
            throw new GLException("glXCreateGLXPixmap failed");
        }
        ((MutableSurface)nativeSurface).setSurfaceHandle(l3);
        if (DEBUG) {
            System.err.println(X11PixmapGLXDrawable.getThreadName() + ": Created pixmap " + X11PixmapGLXDrawable.toHexString(this.pixmap) + ", GLXPixmap " + X11PixmapGLXDrawable.toHexString(l3) + ", display " + X11PixmapGLXDrawable.toHexString(l2));
        }
    }

    protected void destroyPixmap() {
        long l2;
        if (this.pixmap == 0L) {
            return;
        }
        NativeSurface nativeSurface = this.getNativeSurface();
        long l3 = nativeSurface.getDisplayHandle();
        long l4 = nativeSurface.getSurfaceHandle();
        if (DEBUG) {
            System.err.println(X11PixmapGLXDrawable.getThreadName() + ": Destroying pixmap " + X11PixmapGLXDrawable.toHexString(this.pixmap) + ", GLXPixmap " + X11PixmapGLXDrawable.toHexString(l4) + ", display " + X11PixmapGLXDrawable.toHexString(l3));
        }
        if (DEBUG && (l2 = GLX.glXGetCurrentContext()) != 0L) {
            System.err.println("WARNING: found context " + X11PixmapGLXDrawable.toHexString(l2) + " current during pixmap destruction");
        }
        GLX.glXMakeCurrent(l3, 0L, 0L);
        GLX.glXDestroyGLXPixmap(l3, l4);
        X11Lib.XFreePixmap(l3, this.pixmap);
        l4 = 0L;
        this.pixmap = 0L;
        ((MutableSurface)nativeSurface).setSurfaceHandle(0L);
        l3 = 0L;
    }
}

