/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.stereo;

import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.opengl.math.FovHVHalves;
import com.jogamp.opengl.math.VectorUtil;

public final class ScaleAndOffset2D {
    final float[] scale;
    final float[] offset;
    private static final float[] vec2Half = new float[]{0.5f, 0.5f};

    public String toString() {
        return "[offset " + this.offset[0] + " / " + this.offset[1] + ", scale " + this.scale[0] + " x " + this.scale[1] + "]";
    }

    public ScaleAndOffset2D(float[] fArray, float[] fArray2) {
        this.scale = fArray;
        this.offset = fArray2;
    }

    public ScaleAndOffset2D(FovHVHalves fovHVHalves) {
        FovHVHalves fovHVHalves2 = fovHVHalves.toTangents();
        float f2 = 2.0f / (fovHVHalves2.left + fovHVHalves2.right);
        float f3 = 2.0f / (fovHVHalves2.top + fovHVHalves2.bottom);
        float f4 = (fovHVHalves2.left - fovHVHalves2.right) * f2 * 0.5f;
        float f5 = (fovHVHalves2.top - fovHVHalves2.bottom) * f3 * 0.5f;
        this.scale = new float[]{f2, f3};
        this.offset = new float[]{f4, f5};
    }

    public ScaleAndOffset2D(FovHVHalves fovHVHalves, DimensionImmutable dimensionImmutable, RectangleImmutable rectangleImmutable) {
        ScaleAndOffset2D scaleAndOffset2D = new ScaleAndOffset2D(fovHVHalves);
        float[] fArray = new float[2];
        float[] fArray2 = new float[2];
        float[] fArray3 = VectorUtil.scaleVec2(fArray, scaleAndOffset2D.scale, 0.5f);
        float[] fArray4 = VectorUtil.addVec2(fArray2, VectorUtil.scaleVec2(fArray2, scaleAndOffset2D.offset, 0.5f), vec2Half);
        float[] fArray5 = new float[]{(float)rectangleImmutable.getWidth() / (float)dimensionImmutable.getWidth(), (float)rectangleImmutable.getHeight() / (float)dimensionImmutable.getHeight()};
        float[] fArray6 = new float[]{(float)rectangleImmutable.getX() / (float)dimensionImmutable.getWidth(), (float)rectangleImmutable.getY() / (float)dimensionImmutable.getHeight()};
        VectorUtil.scaleVec2(fArray3, fArray3, fArray5);
        VectorUtil.addVec2(fArray4, VectorUtil.scaleVec2(fArray4, fArray4, fArray5), fArray6);
        this.scale = fArray3;
        this.offset = fArray4;
    }

    public final float[] convertToTanFovSpace(float[] fArray) {
        float[] fArray2 = new float[2];
        return VectorUtil.divVec2(fArray2, VectorUtil.subVec2(fArray2, fArray, this.offset), this.scale);
    }
}

