/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkMultiple;

public class PngChunkSPLT
extends PngChunkMultiple {
    public static final String ID = "sPLT";
    private String palName;
    private int sampledepth;
    private int[] palette;

    public PngChunkSPLT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.palName.getBytes(PngHelperInternal.charsetLatin1));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write((byte)this.sampledepth);
            int n2 = this.getNentries();
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < 4; ++i3) {
                    if (this.sampledepth == 8) {
                        PngHelperInternal.writeByte(byteArrayOutputStream, (byte)this.palette[i2 * 5 + i3]);
                        continue;
                    }
                    PngHelperInternal.writeInt2(byteArrayOutputStream, this.palette[i2 * 5 + i3]);
                }
                PngHelperInternal.writeInt2(byteArrayOutputStream, this.palette[i2 * 5 + 4]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ChunkRaw chunkRaw = this.createEmptyChunk(byArray.length, false);
            chunkRaw.data = byArray;
            return chunkRaw;
        }
        catch (IOException iOException) {
            throw new PngjException(iOException);
        }
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < chunkRaw.data.length; ++n2) {
            if (chunkRaw.data[n2] != 0) continue;
            n3 = n2;
            break;
        }
        if (n3 <= 0 || n3 > chunkRaw.data.length - 2) {
            throw new PngjException("bad sPLT chunk: no separator found");
        }
        this.palName = new String(chunkRaw.data, 0, n3, PngHelperInternal.charsetLatin1);
        this.sampledepth = PngHelperInternal.readInt1fromByte(chunkRaw.data, n3 + 1);
        n2 = (chunkRaw.data.length - (n3 += 2)) / (this.sampledepth == 8 ? 6 : 10);
        this.palette = new int[n2 * 5];
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.sampledepth == 8) {
                n8 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n3++);
                n7 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n3++);
                n6 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n3++);
                n5 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n3++);
            } else {
                n8 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n3);
                n7 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n3 += 2);
                n6 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n3 += 2);
                n5 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n3 += 2);
                n3 += 2;
            }
            int n9 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n3);
            n3 += 2;
            this.palette[n4++] = n8;
            this.palette[n4++] = n7;
            this.palette[n4++] = n6;
            this.palette[n4++] = n5;
            this.palette[n4++] = n9;
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkSPLT pngChunkSPLT = (PngChunkSPLT)pngChunk;
        this.palName = pngChunkSPLT.palName;
        this.sampledepth = pngChunkSPLT.sampledepth;
        this.palette = new int[pngChunkSPLT.palette.length];
        System.arraycopy(pngChunkSPLT.palette, 0, this.palette, 0, this.palette.length);
    }

    public int getNentries() {
        return this.palette.length / 5;
    }

    public String getPalName() {
        return this.palName;
    }

    public void setPalName(String string) {
        this.palName = string;
    }

    public int getSampledepth() {
        return this.sampledepth;
    }

    public void setSampledepth(int n2) {
        this.sampledepth = n2;
    }

    public int[] getPalette() {
        return this.palette;
    }

    public void setPalette(int[] nArray) {
        this.palette = nArray;
    }
}

