/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.PngjOutputException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunksList;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class ChunksListForWrite
extends ChunksList {
    private final List<PngChunk> queuedChunks = new ArrayList<PngChunk>();
    private final HashMap<String, Integer> alreadyWrittenKeys = new HashMap();

    public ChunksListForWrite(ImageInfo imageInfo) {
        super(imageInfo);
    }

    public List<? extends PngChunk> getQueuedById(String string) {
        return this.getQueuedById(string, null);
    }

    public List<? extends PngChunk> getQueuedById(String string, String string2) {
        return ChunksListForWrite.getXById(this.queuedChunks, string, string2);
    }

    public PngChunk getQueuedById1(String string, String string2, boolean bl) {
        List<? extends PngChunk> list = this.getQueuedById(string, string2);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1 && (bl || !list.get(0).allowsMultiple())) {
            throw new PngjException("unexpected multiple chunks id=" + string);
        }
        return list.get(list.size() - 1);
    }

    public PngChunk getQueuedById1(String string, boolean bl) {
        return this.getQueuedById1(string, null, bl);
    }

    public PngChunk getQueuedById1(String string) {
        return this.getQueuedById1(string, false);
    }

    public boolean removeChunk(PngChunk pngChunk) {
        return this.queuedChunks.remove(pngChunk);
    }

    public boolean queue(PngChunk pngChunk) {
        this.queuedChunks.add(pngChunk);
        return true;
    }

    private static boolean shouldWrite(PngChunk pngChunk, int n2) {
        int n3;
        int n4;
        if (n2 == 2) {
            return pngChunk.id.equals("PLTE");
        }
        if (n2 % 2 == 0) {
            throw new PngjOutputException("bad chunk group?");
        }
        if (pngChunk.getOrderingConstraint().mustGoBeforePLTE()) {
            n4 = 1;
            n3 = 1;
        } else if (pngChunk.getOrderingConstraint().mustGoBeforeIDAT()) {
            n4 = 3;
            n3 = pngChunk.getOrderingConstraint().mustGoAfterPLTE() ? 3 : 1;
        } else {
            n4 = 5;
            n3 = 1;
        }
        int n5 = n4;
        if (pngChunk.hasPriority()) {
            n5 = n3;
        }
        if (ChunkHelper.isUnknown(pngChunk) && pngChunk.getChunkGroup() > 0) {
            n5 = pngChunk.getChunkGroup();
        }
        if (n2 == n5) {
            return true;
        }
        return n2 > n5 && n2 <= n4;
    }

    public int writeChunks(OutputStream outputStream, int n2) {
        int n3 = 0;
        Iterator<PngChunk> iterator = this.queuedChunks.iterator();
        while (iterator.hasNext()) {
            PngChunk pngChunk = iterator.next();
            if (!ChunksListForWrite.shouldWrite(pngChunk, n2)) continue;
            if (ChunkHelper.isCritical(pngChunk.id) && !pngChunk.id.equals("PLTE")) {
                throw new PngjOutputException("bad chunk queued: " + pngChunk);
            }
            if (this.alreadyWrittenKeys.containsKey(pngChunk.id) && !pngChunk.allowsMultiple()) {
                throw new PngjOutputException("duplicated chunk does not allow multiple: " + pngChunk);
            }
            pngChunk.write(outputStream);
            this.chunks.add(pngChunk);
            this.alreadyWrittenKeys.put(pngChunk.id, this.alreadyWrittenKeys.containsKey(pngChunk.id) ? this.alreadyWrittenKeys.get(pngChunk.id) + 1 : 1);
            pngChunk.setChunkGroup(n2);
            iterator.remove();
            ++n3;
        }
        return n3;
    }

    public List<PngChunk> getQueuedChunks() {
        return this.queuedChunks;
    }

    @Override
    public String toString() {
        return "ChunkList: written: " + this.chunks.size() + " queue: " + this.queuedChunks.size();
    }

    @Override
    public String toStringFull() {
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        stringBuilder.append("\n Written:\n");
        for (PngChunk pngChunk : this.chunks) {
            stringBuilder.append(pngChunk).append(" G=" + pngChunk.getChunkGroup() + "\n");
        }
        if (!this.queuedChunks.isEmpty()) {
            stringBuilder.append(" Queued:\n");
            for (PngChunk pngChunk : this.queuedChunks) {
                stringBuilder.append(pngChunk).append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

