/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import jogamp.opengl.util.pngj.FilterType;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.ImageLines;
import jogamp.opengl.util.pngj.PngDeinterlacer;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngIDatChunkInputStream;
import jogamp.opengl.util.pngj.PngjExceptionInternal;
import jogamp.opengl.util.pngj.PngjInputException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkLoadBehaviour;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.ChunksList;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkIDAT;
import jogamp.opengl.util.pngj.chunks.PngChunkIHDR;
import jogamp.opengl.util.pngj.chunks.PngChunkSkipped;
import jogamp.opengl.util.pngj.chunks.PngMetadata;

public class PngReader {
    public final ImageInfo imgInfo;
    protected final String filename;
    private ChunkLoadBehaviour chunkLoadBehaviour = ChunkLoadBehaviour.LOAD_CHUNK_ALWAYS;
    private boolean shouldCloseStream = true;
    private long maxTotalBytesRead = 0xC800000L;
    private int maxBytesMetadata = 0x500000;
    private int skipChunkMaxSize = 0x200000;
    private String[] skipChunkIds = new String[]{"fdAT"};
    private HashSet<String> skipChunkIdsSet;
    protected final PngMetadata metadata;
    protected final ChunksList chunksList;
    protected ImageLine imgLine;
    protected final int buffersLen;
    protected byte[] rowb = null;
    protected byte[] rowbprev = null;
    protected byte[] rowbfilter = null;
    private final boolean interlaced;
    private final PngDeinterlacer deinterlacer;
    private boolean crcEnabled = true;
    private boolean unpackedMode = false;
    private Inflater inflater = null;
    protected int currentChunkGroup = -1;
    protected int rowNum = -1;
    private long offset = 0L;
    private int bytesChunksLoaded;
    protected final InputStream inputStream;
    protected InflaterInputStream idatIstream;
    protected PngIDatChunkInputStream iIdatCstream;
    protected CRC32 crctest;

    public PngReader(InputStream inputStream, String string) {
        this.filename = string == null ? "" : string;
        this.inputStream = inputStream;
        this.chunksList = new ChunksList(null);
        this.metadata = new PngMetadata(this.chunksList);
        byte[] byArray = new byte[8];
        PngHelperInternal.readBytes(inputStream, byArray, 0, byArray.length);
        this.offset += (long)byArray.length;
        if (!Arrays.equals(byArray, PngHelperInternal.getPngIdSignature())) {
            throw new PngjInputException("Bad PNG signature");
        }
        this.currentChunkGroup = 0;
        int n2 = PngHelperInternal.readInt4(inputStream);
        this.offset += 4L;
        if (n2 != 13) {
            throw new PngjInputException("IDHR chunk len != 13 ?? " + n2);
        }
        byte[] byArray2 = new byte[4];
        PngHelperInternal.readBytes(inputStream, byArray2, 0, 4);
        if (!Arrays.equals(byArray2, ChunkHelper.b_IHDR)) {
            throw new PngjInputException("IHDR not found as first chunk??? [" + ChunkHelper.toString(byArray2) + "]");
        }
        this.offset += 4L;
        PngChunkIHDR pngChunkIHDR = (PngChunkIHDR)this.readChunk(byArray2, n2, false);
        boolean bl = (pngChunkIHDR.getColormodel() & 4) != 0;
        boolean bl2 = (pngChunkIHDR.getColormodel() & 1) != 0;
        boolean bl3 = pngChunkIHDR.getColormodel() == 0 || pngChunkIHDR.getColormodel() == 4;
        this.imgInfo = new ImageInfo(pngChunkIHDR.getCols(), pngChunkIHDR.getRows(), pngChunkIHDR.getBitspc(), bl, bl3, bl2);
        this.interlaced = pngChunkIHDR.getInterlaced() == 1;
        this.deinterlacer = this.interlaced ? new PngDeinterlacer(this.imgInfo) : null;
        this.buffersLen = this.imgInfo.bytesPerRow + 1;
        if (pngChunkIHDR.getFilmeth() != 0 || pngChunkIHDR.getCompmeth() != 0 || (pngChunkIHDR.getInterlaced() & 0xFFFE) != 0) {
            throw new PngjInputException("compression method o filter method or interlaced unrecognized ");
        }
        if (pngChunkIHDR.getColormodel() < 0 || pngChunkIHDR.getColormodel() > 6 || pngChunkIHDR.getColormodel() == 1 || pngChunkIHDR.getColormodel() == 5) {
            throw new PngjInputException("Invalid colormodel " + pngChunkIHDR.getColormodel());
        }
        if (pngChunkIHDR.getBitspc() != 1 && pngChunkIHDR.getBitspc() != 2 && pngChunkIHDR.getBitspc() != 4 && pngChunkIHDR.getBitspc() != 8 && pngChunkIHDR.getBitspc() != 16) {
            throw new PngjInputException("Invalid bit depth " + pngChunkIHDR.getBitspc());
        }
    }

    private boolean firstChunksNotYetRead() {
        return this.currentChunkGroup < 1;
    }

    private void allocateBuffers() {
        if (this.rowbfilter == null || this.rowbfilter.length < this.buffersLen) {
            this.rowbfilter = new byte[this.buffersLen];
            this.rowb = new byte[this.buffersLen];
            this.rowbprev = new byte[this.buffersLen];
        }
    }

    private void readLastAndClose() {
        if (this.currentChunkGroup < 5) {
            try {
                this.idatIstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.readLastChunks();
        }
        this.close();
    }

    private void close() {
        if (this.currentChunkGroup < 6) {
            try {
                this.idatIstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentChunkGroup = 6;
        }
        if (this.shouldCloseStream) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                throw new PngjInputException("error closing input stream!", exception);
            }
        }
    }

    private void unfilterRow(int n2) {
        byte by = this.rowbfilter[0];
        FilterType filterType = FilterType.getByVal(by);
        if (filterType == null) {
            throw new PngjInputException("Filter type " + by + " invalid");
        }
        switch (filterType) {
            case FILTER_NONE: {
                this.unfilterRowNone(n2);
                break;
            }
            case FILTER_SUB: {
                this.unfilterRowSub(n2);
                break;
            }
            case FILTER_UP: {
                this.unfilterRowUp(n2);
                break;
            }
            case FILTER_AVERAGE: {
                this.unfilterRowAverage(n2);
                break;
            }
            case FILTER_PAETH: {
                this.unfilterRowPaeth(n2);
                break;
            }
            default: {
                throw new PngjInputException("Filter type " + by + " not implemented");
            }
        }
        if (this.crctest != null) {
            this.crctest.update(this.rowb, 1, this.buffersLen - 1);
        }
    }

    private void unfilterRowAverage(int n2) {
        int n3 = 1 - this.imgInfo.bytesPixel;
        int n4 = 1;
        while (n4 <= n2) {
            int n5 = n3 > 0 ? this.rowb[n3] & 0xFF : 0;
            this.rowb[n4] = (byte)(this.rowbfilter[n4] + (n5 + (this.rowbprev[n4] & 0xFF)) / 2);
            ++n4;
            ++n3;
        }
    }

    private void unfilterRowNone(int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.rowb[i2] = this.rowbfilter[i2];
        }
    }

    private void unfilterRowPaeth(int n2) {
        int n3 = 1 - this.imgInfo.bytesPixel;
        int n4 = 1;
        while (n4 <= n2) {
            int n5 = n3 > 0 ? this.rowb[n3] & 0xFF : 0;
            int n6 = n3 > 0 ? this.rowbprev[n3] & 0xFF : 0;
            this.rowb[n4] = (byte)(this.rowbfilter[n4] + PngHelperInternal.filterPaethPredictor(n5, this.rowbprev[n4] & 0xFF, n6));
            ++n4;
            ++n3;
        }
    }

    private void unfilterRowSub(int n2) {
        int n3;
        for (n3 = 1; n3 <= this.imgInfo.bytesPixel; ++n3) {
            this.rowb[n3] = this.rowbfilter[n3];
        }
        int n4 = 1;
        n3 = this.imgInfo.bytesPixel + 1;
        while (n3 <= n2) {
            this.rowb[n3] = (byte)(this.rowbfilter[n3] + this.rowb[n4]);
            ++n3;
            ++n4;
        }
    }

    private void unfilterRowUp(int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.rowb[i2] = (byte)(this.rowbfilter[i2] + this.rowbprev[i2]);
        }
    }

    private final void readFirstChunks() {
        int n2;
        if (!this.firstChunksNotYetRead()) {
            return;
        }
        int n3 = 0;
        boolean bl = false;
        byte[] byArray = new byte[4];
        this.currentChunkGroup = 1;
        while (!bl) {
            n3 = PngHelperInternal.readInt4(this.inputStream);
            this.offset += 4L;
            if (n3 < 0) break;
            PngHelperInternal.readBytes(this.inputStream, byArray, 0, 4);
            this.offset += 4L;
            if (Arrays.equals(byArray, ChunkHelper.b_IDAT)) {
                bl = true;
                this.currentChunkGroup = 4;
                this.chunksList.appendReadChunk(new PngChunkIDAT(this.imgInfo, n3, this.offset - 8L), this.currentChunkGroup);
                break;
            }
            if (Arrays.equals(byArray, ChunkHelper.b_IEND)) {
                throw new PngjInputException("END chunk found before image data (IDAT) at offset=" + this.offset);
            }
            if (Arrays.equals(byArray, ChunkHelper.b_PLTE)) {
                this.currentChunkGroup = 2;
            }
            this.readChunk(byArray, n3, false);
            if (!Arrays.equals(byArray, ChunkHelper.b_PLTE)) continue;
            this.currentChunkGroup = 3;
        }
        int n4 = n2 = bl ? n3 : -1;
        if (n2 < 0) {
            throw new PngjInputException("first idat chunk not found!");
        }
        this.iIdatCstream = new PngIDatChunkInputStream(this.inputStream, n2, this.offset);
        if (this.inflater == null) {
            this.inflater = new Inflater();
        } else {
            this.inflater.reset();
        }
        this.idatIstream = new InflaterInputStream(this.iIdatCstream, this.inflater);
        if (!this.crcEnabled) {
            this.iIdatCstream.disableCrcCheck();
        }
    }

    void readLastChunks() {
        this.currentChunkGroup = 5;
        if (!this.iIdatCstream.isEnded()) {
            this.iIdatCstream.forceChunkEnd();
        }
        int n2 = this.iIdatCstream.getLenLastChunk();
        byte[] byArray = this.iIdatCstream.getIdLastChunk();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        while (!bl) {
            bl3 = false;
            if (!bl2) {
                n2 = PngHelperInternal.readInt4(this.inputStream);
                this.offset += 4L;
                if (n2 < 0) {
                    throw new PngjInputException("bad chuck len " + n2);
                }
                PngHelperInternal.readBytes(this.inputStream, byArray, 0, 4);
                this.offset += 4L;
            }
            bl2 = false;
            if (Arrays.equals(byArray, ChunkHelper.b_IDAT)) {
                bl3 = true;
            } else if (Arrays.equals(byArray, ChunkHelper.b_IEND)) {
                this.currentChunkGroup = 6;
                bl = true;
            }
            this.readChunk(byArray, n2, bl3);
        }
        if (!bl) {
            throw new PngjInputException("end chunk not found - offset=" + this.offset);
        }
    }

    private PngChunk readChunk(byte[] byArray, int n2, boolean bl) {
        if (n2 < 0) {
            throw new PngjInputException("invalid chunk lenght: " + n2);
        }
        if (this.skipChunkIdsSet == null && this.currentChunkGroup > 0) {
            this.skipChunkIdsSet = new HashSet<String>(Arrays.asList(this.skipChunkIds));
        }
        String string = ChunkHelper.toString(byArray);
        boolean bl2 = ChunkHelper.isCritical(string);
        PngChunk pngChunk = null;
        boolean bl3 = bl;
        if (this.maxTotalBytesRead > 0L && (long)n2 + this.offset > this.maxTotalBytesRead) {
            throw new PngjInputException("Maximum total bytes to read exceeeded: " + this.maxTotalBytesRead + " offset:" + this.offset + " clen=" + n2);
        }
        if (this.currentChunkGroup > 0 && !bl2) {
            boolean bl4 = bl3 = bl3 || this.skipChunkMaxSize > 0 && n2 >= this.skipChunkMaxSize || this.skipChunkIdsSet.contains(string) || this.maxBytesMetadata > 0 && n2 > this.maxBytesMetadata - this.bytesChunksLoaded || !ChunkHelper.shouldLoad(string, this.chunkLoadBehaviour);
        }
        if (bl3) {
            PngHelperInternal.skipBytes(this.inputStream, n2);
            PngHelperInternal.readInt4(this.inputStream);
            pngChunk = new PngChunkSkipped(string, this.imgInfo, n2);
        } else {
            ChunkRaw chunkRaw = new ChunkRaw(n2, byArray, true);
            chunkRaw.readChunkData(this.inputStream, this.crcEnabled || bl2);
            pngChunk = PngChunk.factory(chunkRaw, this.imgInfo);
            if (!pngChunk.crit) {
                this.bytesChunksLoaded += chunkRaw.len;
            }
        }
        pngChunk.setOffset(this.offset - 8L);
        this.chunksList.appendReadChunk(pngChunk, this.currentChunkGroup);
        this.offset += (long)n2 + 4L;
        return pngChunk;
    }

    protected void logWarn(String string) {
        System.err.println(string);
    }

    public ChunkLoadBehaviour getChunkLoadBehaviour() {
        return this.chunkLoadBehaviour;
    }

    public void setChunkLoadBehaviour(ChunkLoadBehaviour chunkLoadBehaviour) {
        this.chunkLoadBehaviour = chunkLoadBehaviour;
    }

    public ChunksList getChunksList() {
        if (this.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.chunksList;
    }

    int getCurrentChunkGroup() {
        return this.currentChunkGroup;
    }

    public PngMetadata getMetadata() {
        if (this.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.metadata;
    }

    public ImageLine readRow(int n2) {
        if (this.imgLine == null) {
            this.imgLine = new ImageLine(this.imgInfo, ImageLine.SampleType.INT, this.unpackedMode);
        }
        return this.imgLine.sampleType != ImageLine.SampleType.BYTE ? this.readRowInt(n2) : this.readRowByte(n2);
    }

    public ImageLine readRowInt(int n2) {
        if (this.imgLine == null) {
            this.imgLine = new ImageLine(this.imgInfo, ImageLine.SampleType.INT, this.unpackedMode);
        }
        if (this.imgLine.getRown() == n2) {
            return this.imgLine;
        }
        this.readRowInt(this.imgLine.scanline, n2);
        this.imgLine.setFilterUsed(FilterType.getByVal(this.rowbfilter[0]));
        this.imgLine.setRown(n2);
        return this.imgLine;
    }

    public ImageLine readRowByte(int n2) {
        if (this.imgLine == null) {
            this.imgLine = new ImageLine(this.imgInfo, ImageLine.SampleType.BYTE, this.unpackedMode);
        }
        if (this.imgLine.getRown() == n2) {
            return this.imgLine;
        }
        this.readRowByte(this.imgLine.scanlineb, n2);
        this.imgLine.setFilterUsed(FilterType.getByVal(this.rowbfilter[0]));
        this.imgLine.setRown(n2);
        return this.imgLine;
    }

    public final int[] readRow(int[] nArray, int n2) {
        return this.readRowInt(nArray, n2);
    }

    public final int[] readRowInt(int[] nArray, int n2) {
        if (nArray == null) {
            nArray = new int[this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
        }
        if (!this.interlaced) {
            if (n2 <= this.rowNum) {
                throw new PngjInputException("rows must be read in increasing order: " + n2);
            }
            int n3 = 0;
            while (this.rowNum < n2) {
                n3 = this.readRowRaw(this.rowNum + 1);
            }
            this.decodeLastReadRowToInt(nArray, n3);
        } else {
            if (this.deinterlacer.getImageInt() == null) {
                this.deinterlacer.setImageInt(this.readRowsInt().scanlines);
            }
            System.arraycopy(this.deinterlacer.getImageInt()[n2], 0, nArray, 0, this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked);
        }
        return nArray;
    }

    public final byte[] readRowByte(byte[] byArray, int n2) {
        if (byArray == null) {
            byArray = new byte[this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
        }
        if (!this.interlaced) {
            if (n2 <= this.rowNum) {
                throw new PngjInputException("rows must be read in increasing order: " + n2);
            }
            int n3 = 0;
            while (this.rowNum < n2) {
                n3 = this.readRowRaw(this.rowNum + 1);
            }
            this.decodeLastReadRowToByte(byArray, n3);
        } else {
            if (this.deinterlacer.getImageByte() == null) {
                this.deinterlacer.setImageByte(this.readRowsByte().scanlinesb);
            }
            System.arraycopy(this.deinterlacer.getImageByte()[n2], 0, byArray, 0, this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked);
        }
        return byArray;
    }

    public ImageLine getRow(int n2) {
        return this.readRow(n2);
    }

    private void decodeLastReadRowToInt(int[] nArray, int n2) {
        if (this.imgInfo.bitDepth <= 8) {
            int n3 = 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.rowb[n3++] & 0xFF;
            }
        } else {
            int n4 = 0;
            int n5 = 1;
            while (n5 <= n2) {
                nArray[n4] = ((this.rowb[n5++] & 0xFF) << 8) + (this.rowb[n5++] & 0xFF);
                ++n4;
            }
        }
        if (this.imgInfo.packed && this.unpackedMode) {
            ImageLine.unpackInplaceInt(this.imgInfo, nArray, nArray, false);
        }
    }

    private void decodeLastReadRowToByte(byte[] byArray, int n2) {
        if (this.imgInfo.bitDepth <= 8) {
            System.arraycopy(this.rowb, 1, byArray, 0, n2);
        } else {
            int n3 = 0;
            for (int i2 = 1; i2 < n2; i2 += 2) {
                byArray[n3] = this.rowb[i2];
                ++n3;
            }
        }
        if (this.imgInfo.packed && this.unpackedMode) {
            ImageLine.unpackInplaceByte(this.imgInfo, byArray, byArray, false);
        }
    }

    public ImageLines readRowsInt(int n2, int n3, int n4) {
        if (n3 < 0) {
            n3 = (this.imgInfo.rows - n2) / n4;
        }
        if (n4 < 1 || n2 < 0 || n3 * n4 + n2 > this.imgInfo.rows) {
            throw new PngjInputException("bad args");
        }
        ImageLines imageLines = new ImageLines(this.imgInfo, ImageLine.SampleType.INT, this.unpackedMode, n2, n3, n4);
        if (!this.interlaced) {
            for (int i2 = 0; i2 < this.imgInfo.rows; ++i2) {
                int n5 = this.readRowRaw(i2);
                int n6 = imageLines.imageRowToMatrixRowStrict(i2);
                if (n6 < 0) continue;
                this.decodeLastReadRowToInt(imageLines.scanlines[n6], n5);
            }
        } else {
            int[] nArray = new int[this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
            for (int i3 = 1; i3 <= 7; ++i3) {
                this.deinterlacer.setPass(i3);
                for (int i4 = 0; i4 < this.deinterlacer.getRows(); ++i4) {
                    int n7 = this.readRowRaw(i4);
                    int n8 = this.deinterlacer.getCurrRowReal();
                    int n9 = imageLines.imageRowToMatrixRowStrict(n8);
                    if (n9 < 0) continue;
                    this.decodeLastReadRowToInt(nArray, n7);
                    this.deinterlacer.deinterlaceInt(nArray, imageLines.scanlines[n9], !this.unpackedMode);
                }
            }
        }
        this.end();
        return imageLines;
    }

    public ImageLines readRowsInt() {
        return this.readRowsInt(0, this.imgInfo.rows, 1);
    }

    public ImageLines readRowsByte(int n2, int n3, int n4) {
        if (n3 < 0) {
            n3 = (this.imgInfo.rows - n2) / n4;
        }
        if (n4 < 1 || n2 < 0 || n3 * n4 + n2 > this.imgInfo.rows) {
            throw new PngjInputException("bad args");
        }
        ImageLines imageLines = new ImageLines(this.imgInfo, ImageLine.SampleType.BYTE, this.unpackedMode, n2, n3, n4);
        if (!this.interlaced) {
            for (int i2 = 0; i2 < this.imgInfo.rows; ++i2) {
                int n5 = this.readRowRaw(i2);
                int n6 = imageLines.imageRowToMatrixRowStrict(i2);
                if (n6 < 0) continue;
                this.decodeLastReadRowToByte(imageLines.scanlinesb[n6], n5);
            }
        } else {
            byte[] byArray = new byte[this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
            for (int i3 = 1; i3 <= 7; ++i3) {
                this.deinterlacer.setPass(i3);
                for (int i4 = 0; i4 < this.deinterlacer.getRows(); ++i4) {
                    int n7 = this.readRowRaw(i4);
                    int n8 = this.deinterlacer.getCurrRowReal();
                    int n9 = imageLines.imageRowToMatrixRowStrict(n8);
                    if (n9 < 0) continue;
                    this.decodeLastReadRowToByte(byArray, n7);
                    this.deinterlacer.deinterlaceByte(byArray, imageLines.scanlinesb[n9], !this.unpackedMode);
                }
            }
        }
        this.end();
        return imageLines;
    }

    public ImageLines readRowsByte() {
        return this.readRowsByte(0, this.imgInfo.rows, 1);
    }

    private int readRowRaw(int n2) {
        if (n2 == 0) {
            if (this.firstChunksNotYetRead()) {
                this.readFirstChunks();
            }
            this.allocateBuffers();
            if (this.interlaced) {
                Arrays.fill(this.rowb, (byte)0);
            }
        }
        int n3 = this.imgInfo.bytesPerRow;
        if (this.interlaced) {
            if (n2 < 0 || n2 > this.deinterlacer.getRows() || n2 != 0 && n2 != this.deinterlacer.getCurrRowSubimg() + 1) {
                throw new PngjInputException("invalid row in interlaced mode: " + n2);
            }
            this.deinterlacer.setRow(n2);
            n3 = (this.imgInfo.bitspPixel * this.deinterlacer.getPixelsToRead() + 7) / 8;
            if (n3 < 1) {
                throw new PngjExceptionInternal("wtf??");
            }
        } else if (n2 < 0 || n2 >= this.imgInfo.rows || n2 != this.rowNum + 1) {
            throw new PngjInputException("invalid row: " + n2);
        }
        this.rowNum = n2;
        byte[] byArray = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = byArray;
        PngHelperInternal.readBytes(this.idatIstream, this.rowbfilter, 0, n3 + 1);
        this.offset = this.iIdatCstream.getOffset();
        if (this.offset < 0L) {
            throw new PngjExceptionInternal("bad offset ??" + this.offset);
        }
        if (this.maxTotalBytesRead > 0L && this.offset >= this.maxTotalBytesRead) {
            throw new PngjInputException("Reading IDAT: Maximum total bytes to read exceeeded: " + this.maxTotalBytesRead + " offset:" + this.offset);
        }
        this.rowb[0] = 0;
        this.unfilterRow(n3);
        this.rowb[0] = this.rowbfilter[0];
        if (this.rowNum == this.imgInfo.rows - 1 && !this.interlaced || this.interlaced && this.deinterlacer.isAtLastRow()) {
            this.readLastAndClose();
        }
        return n3;
    }

    public void readSkippingAllRows() {
        if (this.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        this.iIdatCstream.disableCrcCheck();
        this.allocateBuffers();
        try {
            int n2;
            while ((n2 = this.iIdatCstream.read(this.rowbfilter, 0, this.buffersLen)) >= 0) {
            }
        }
        catch (IOException iOException) {
            throw new PngjInputException("error in raw read of IDAT", iOException);
        }
        this.offset = this.iIdatCstream.getOffset();
        if (this.offset < 0L) {
            throw new PngjExceptionInternal("bad offset ??" + this.offset);
        }
        if (this.maxTotalBytesRead > 0L && this.offset >= this.maxTotalBytesRead) {
            throw new PngjInputException("Reading IDAT: Maximum total bytes to read exceeeded: " + this.maxTotalBytesRead + " offset:" + this.offset);
        }
        this.readLastAndClose();
    }

    public void setMaxTotalBytesRead(long l2) {
        this.maxTotalBytesRead = l2;
    }

    public long getMaxTotalBytesRead() {
        return this.maxTotalBytesRead;
    }

    public void setMaxBytesMetadata(int n2) {
        this.maxBytesMetadata = n2;
    }

    public int getMaxBytesMetadata() {
        return this.maxBytesMetadata;
    }

    public void setSkipChunkMaxSize(int n2) {
        this.skipChunkMaxSize = n2;
    }

    public int getSkipChunkMaxSize() {
        return this.skipChunkMaxSize;
    }

    public void setSkipChunkIds(String[] stringArray) {
        this.skipChunkIds = stringArray == null ? new String[]{} : stringArray;
    }

    public String[] getSkipChunkIds() {
        return this.skipChunkIds;
    }

    public void setShouldCloseStream(boolean bl) {
        this.shouldCloseStream = bl;
    }

    public void end() {
        if (this.currentChunkGroup < 6) {
            this.close();
        }
    }

    public boolean isInterlaced() {
        return this.interlaced;
    }

    public void setUnpackedMode(boolean bl) {
        this.unpackedMode = bl;
    }

    public boolean isUnpackedMode() {
        return this.unpackedMode;
    }

    public void reuseBuffersFrom(PngReader pngReader) {
        if (pngReader == null) {
            return;
        }
        if (pngReader.currentChunkGroup < 5) {
            throw new PngjInputException("PngReader to be reused have not yet ended reading pixels");
        }
        if (pngReader.rowbfilter != null && pngReader.rowbfilter.length >= this.buffersLen) {
            this.rowbfilter = pngReader.rowbfilter;
            this.rowb = pngReader.rowb;
            this.rowbprev = pngReader.rowbprev;
        }
        this.inflater = pngReader.inflater;
    }

    public void setCrcCheckDisabled() {
        this.crcEnabled = false;
    }

    long getCrctestVal() {
        return this.crctest.getValue();
    }

    void initCrctest() {
        this.crctest = new CRC32();
    }

    public String toString() {
        return "filename=" + this.filename + " " + this.imgInfo.toString();
    }
}

