/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import jogamp.opengl.util.pngj.PngReader;
import jogamp.opengl.util.pngj.PngjInputException;
import jogamp.opengl.util.pngj.PngjOutputException;

public class PngHelperInternal {
    public static final Charset charsetLatin1 = Charset.forName("ISO-8859-1");
    public static final Charset charsetUTF8 = Charset.forName("UTF-8");
    static final boolean DEBUG = false;
    private static final ThreadLocal<CRC32> crcProvider = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };

    public static byte[] getPngIdSignature() {
        return new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    }

    public static int doubleToInt100000(double d2) {
        return (int)(d2 * 100000.0 + 0.5);
    }

    public static double intToDouble100000(int n2) {
        return (double)n2 / 100000.0;
    }

    public static int readByte(InputStream inputStream) {
        try {
            return inputStream.read();
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading byte", iOException);
        }
    }

    public static int readInt2(InputStream inputStream) {
        try {
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            if (n2 == -1 || n3 == -1) {
                return -1;
            }
            return (n2 << 8) + n3;
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading readInt2", iOException);
        }
    }

    public static int readInt4(InputStream inputStream) {
        try {
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            if (n2 == -1 || n3 == -1 || n4 == -1 || n5 == -1) {
                return -1;
            }
            return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading readInt4", iOException);
        }
    }

    public static int readInt1fromByte(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    public static int readInt2fromBytes(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 16 | byArray[n2 + 1] & 0xFF;
    }

    public static int readInt4fromBytes(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public static void writeByte(OutputStream outputStream, byte by) {
        try {
            outputStream.write(by);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void writeInt2(OutputStream outputStream, int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        PngHelperInternal.writeBytes(outputStream, byArray);
    }

    public static void writeInt4(OutputStream outputStream, int n2) {
        byte[] byArray = new byte[4];
        PngHelperInternal.writeInt4tobytes(n2, byArray, 0);
        PngHelperInternal.writeBytes(outputStream, byArray);
    }

    public static void writeInt2tobytes(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 & 0xFF);
    }

    public static void writeInt4tobytes(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 24 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3 + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 & 0xFF);
    }

    public static void readBytes(InputStream inputStream, byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        try {
            int n4;
            for (int i2 = 0; i2 < n3; i2 += n4) {
                n4 = inputStream.read(byArray, n2 + i2, n3 - i2);
                if (n4 >= 1) continue;
                throw new PngjInputException("error reading bytes, " + n4 + " !=" + n3);
            }
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading", iOException);
        }
    }

    public static void skipBytes(InputStream inputStream, long l2) {
        try {
            while (l2 > 0L) {
                long l3 = inputStream.skip(l2);
                if (l3 > 0L) {
                    l2 -= l3;
                    continue;
                }
                if (l3 == 0L) {
                    if (inputStream.read() == -1) break;
                    --l2;
                    continue;
                }
                throw new IOException("skip() returned a negative value ???");
            }
        }
        catch (IOException iOException) {
            throw new PngjInputException(iOException);
        }
    }

    public static void writeBytes(OutputStream outputStream, byte[] byArray) {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void writeBytes(OutputStream outputStream, byte[] byArray, int n2, int n3) {
        try {
            outputStream.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void logdebug(String string) {
    }

    public static CRC32 getCRC() {
        return crcProvider.get();
    }

    public static int filterRowNone(int n2) {
        return n2 & 0xFF;
    }

    public static int filterRowSub(int n2, int n3) {
        return n2 - n3 & 0xFF;
    }

    public static int filterRowUp(int n2, int n3) {
        return n2 - n3 & 0xFF;
    }

    public static int filterRowAverage(int n2, int n3, int n4) {
        return n2 - (n3 + n4) / 2 & 0xFF;
    }

    public static int filterRowPaeth(int n2, int n3, int n4, int n5) {
        return n2 - PngHelperInternal.filterPaethPredictor(n3, n4, n5) & 0xFF;
    }

    public static int unfilterRowNone(int n2) {
        return n2 & 0xFF;
    }

    public static int unfilterRowSub(int n2, int n3) {
        return n2 + n3 & 0xFF;
    }

    public static int unfilterRowUp(int n2, int n3) {
        return n2 + n3 & 0xFF;
    }

    public static int unfilterRowAverage(int n2, int n3, int n4) {
        return n2 + (n3 + n4) / 2 & 0xFF;
    }

    public static int unfilterRowPaeth(int n2, int n3, int n4, int n5) {
        return n2 + PngHelperInternal.filterPaethPredictor(n3, n4, n5) & 0xFF;
    }

    static final int filterPaethPredictor(int n2, int n3, int n4) {
        int n5;
        int n6 = n2 + n3 - n4;
        int n7 = n6 >= n2 ? n6 - n2 : n2 - n6;
        int n8 = n6 >= n3 ? n6 - n3 : n3 - n6;
        int n9 = n5 = n6 >= n4 ? n6 - n4 : n4 - n6;
        if (n7 <= n8 && n7 <= n5) {
            return n2;
        }
        if (n8 <= n5) {
            return n3;
        }
        return n4;
    }

    public static final void initCrcForTests(PngReader pngReader) {
        pngReader.initCrctest();
    }

    public static final long getCrctestVal(PngReader pngReader) {
        return pngReader.getCrctestVal();
    }
}

