/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import jogamp.opengl.util.pngj.FilterType;
import jogamp.opengl.util.pngj.ImageInfo;

class FilterWriteStrategy {
    private static final int COMPUTE_STATS_EVERY_N_LINES = 8;
    final ImageInfo imgInfo;
    public final FilterType configuredType;
    private FilterType currentType;
    private int lastRowTested = -1000000;
    private final double[] lastSums = new double[5];
    private final double[] lastEntropies = new double[5];
    private double[] preference = new double[]{1.1, 1.1, 1.1, 1.1, 1.2};
    private int discoverEachLines = -1;
    private final double[] histogram1 = new double[256];

    FilterWriteStrategy(ImageInfo imageInfo, FilterType filterType) {
        this.imgInfo = imageInfo;
        this.configuredType = filterType;
        this.currentType = filterType.val < 0 ? (imageInfo.rows < 8 && imageInfo.cols < 8 || imageInfo.indexed || imageInfo.bitDepth < 8 ? FilterType.FILTER_NONE : FilterType.FILTER_PAETH) : filterType;
        if (filterType == FilterType.FILTER_AGGRESSIVE) {
            this.discoverEachLines = 8;
        }
        if (filterType == FilterType.FILTER_VERYAGGRESSIVE) {
            this.discoverEachLines = 1;
        }
    }

    boolean shouldTestAll(int n2) {
        if (this.discoverEachLines > 0 && this.lastRowTested + this.discoverEachLines <= n2) {
            this.currentType = null;
            return true;
        }
        return false;
    }

    public void setPreference(double d2, double d3, double d4, double d5, double d6) {
        this.preference = new double[]{d2, d3, d4, d5, d6};
    }

    public boolean computesStatistics() {
        return this.discoverEachLines > 0;
    }

    void fillResultsForFilter(int n2, FilterType filterType, double d2, int[] nArray, boolean bl) {
        this.lastRowTested = n2;
        this.lastSums[filterType.val] = d2;
        if (nArray != null) {
            double d3 = n2 == 0 ? 0.0 : 0.3;
            double d4 = 1.0 - d3;
            double d5 = 0.0;
            for (int i2 = 0; i2 < 256; ++i2) {
                double d6 = (double)nArray[i2] / (double)this.imgInfo.cols;
                d6 = this.histogram1[i2] * d3 + d6 * d4;
                if (bl) {
                    d5 += d6 > 1.0E-8 ? d6 * Math.log(d6) : 0.0;
                    continue;
                }
                this.histogram1[i2] = d6;
            }
            this.lastEntropies[filterType.val] = -d5;
        }
    }

    FilterType gimmeFilterType(int n2, boolean bl) {
        if (this.currentType == null) {
            if (n2 == 0) {
                this.currentType = FilterType.FILTER_SUB;
            } else {
                double d2 = Double.MAX_VALUE;
                for (int i2 = 0; i2 < 5; ++i2) {
                    double d3 = bl ? this.lastEntropies[i2] : this.lastSums[i2];
                    if (!((d3 /= this.preference[i2]) <= d2)) continue;
                    d2 = d3;
                    this.currentType = FilterType.getByVal(i2);
                }
            }
        }
        if (this.configuredType == FilterType.FILTER_CYCLIC) {
            this.currentType = FilterType.getByVal((this.currentType.val + 1) % 5);
        }
        return this.currentType;
    }
}

