/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;

public abstract class MacOSXCGLDrawable
extends GLDrawableImpl {
    List<WeakReference<MacOSXCGLContext>> createdContexts = new ArrayList<WeakReference<MacOSXCGLContext>>();
    private boolean haveSetOpenGLMode = false;
    private GLBackendType openGLMode = GLBackendType.NSOPENGL;

    public MacOSXCGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, boolean bl) {
        super(gLDrawableFactory, nativeSurface, bl);
        this.initOpenGLImpl(this.getOpenGLMode());
    }

    @Override
    protected void setRealizedImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void associateContext(GLContext gLContext, boolean bl) {
        List<WeakReference<MacOSXCGLContext>> list = this.createdContexts;
        synchronized (list) {
            if (bl) {
                MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)gLContext;
                this.createdContexts.add(new WeakReference<MacOSXCGLContext>(macOSXCGLContext));
            } else {
                int n2 = 0;
                while (n2 < this.createdContexts.size()) {
                    MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)this.createdContexts.get(n2).get();
                    if (macOSXCGLContext == null || macOSXCGLContext == gLContext) {
                        this.createdContexts.remove(n2);
                        continue;
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void swapBuffersImpl(boolean bl) {
        if (bl) {
            List<WeakReference<MacOSXCGLContext>> list = this.createdContexts;
            synchronized (list) {
                int n2 = 0;
                while (n2 < this.createdContexts.size()) {
                    MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)this.createdContexts.get(n2).get();
                    if (macOSXCGLContext != null) {
                        macOSXCGLContext.swapBuffers();
                        ++n2;
                        continue;
                    }
                    this.createdContexts.remove(n2);
                }
            }
        }
    }

    public void setOpenGLMode(GLBackendType gLBackendType) {
        if (gLBackendType == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.setRealized(false);
        if (DEBUG) {
            System.err.println("MacOSXCGLDrawable: Switching context mode " + (Object)((Object)this.openGLMode) + " -> " + (Object)((Object)gLBackendType));
        }
        this.initOpenGLImpl(gLBackendType);
        this.openGLMode = gLBackendType;
        this.haveSetOpenGLMode = true;
    }

    public final GLBackendType getOpenGLMode() {
        return this.openGLMode;
    }

    protected void initOpenGLImpl(GLBackendType gLBackendType) {
    }

    public static enum GLBackendType {
        NSOPENGL(0),
        CGL(1);

        public final int id;

        private GLBackendType(int n3) {
            this.id = n3;
        }
    }
}

