/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.nurbs;

import jogamp.opengl.glu.nurbs.Backend;
import jogamp.opengl.glu.nurbs.CArrayOfFloats;
import jogamp.opengl.glu.nurbs.CArrayOfQuiltspecs;
import jogamp.opengl.glu.nurbs.Flist;
import jogamp.opengl.glu.nurbs.Knotvector;
import jogamp.opengl.glu.nurbs.Mapdesc;
import jogamp.opengl.glu.nurbs.Quiltspec;
import jogamp.opengl.glu.nurbs.Splinespec;

public class Quilt {
    private static final int MAXDIM = 2;
    Mapdesc mapdesc;
    public CArrayOfQuiltspecs qspec;
    public CArrayOfQuiltspecs eqspec;
    public CArrayOfFloats cpts;
    public Quilt next;

    public Quilt(Mapdesc mapdesc) {
        this.mapdesc = mapdesc;
        Quiltspec[] quiltspecArray = new Quiltspec[2];
        for (int i2 = 0; i2 < quiltspecArray.length; ++i2) {
            quiltspecArray[i2] = new Quiltspec();
        }
        this.qspec = new CArrayOfQuiltspecs(quiltspecArray);
    }

    public void toBezier(Knotvector knotvector, Knotvector knotvector2, CArrayOfFloats cArrayOfFloats, int n2) {
        Splinespec splinespec = new Splinespec(2);
        splinespec.kspecinit(knotvector, knotvector2);
        splinespec.select();
        splinespec.layout(n2);
        splinespec.setupquilt(this);
        splinespec.copy(cArrayOfFloats);
        splinespec.transform();
    }

    public void toBezier(Knotvector knotvector, CArrayOfFloats cArrayOfFloats, int n2) {
        Splinespec splinespec = new Splinespec(1);
        splinespec.kspecinit(knotvector);
        splinespec.select();
        splinespec.layout(n2);
        splinespec.setupquilt(this);
        splinespec.copy(cArrayOfFloats);
        splinespec.transform();
    }

    public void downloadAll(float[] fArray, float[] fArray2, Backend backend) {
        Quilt quilt = this;
        while (quilt != null) {
            quilt.select(fArray, fArray2);
            quilt.download(backend);
            quilt = quilt.next;
        }
    }

    private void download(Backend backend) {
        if (this.getDimension() == 2) {
            CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(this.cpts);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)0).offset);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)1).offset);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)0).index * this.qspec.get((int)0).order * this.qspec.get((int)0).stride);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)1).index * this.qspec.get((int)1).order * this.qspec.get((int)1).stride);
            backend.surfpts(this.mapdesc.getType(), cArrayOfFloats, this.qspec.get((int)0).stride, this.qspec.get((int)1).stride, this.qspec.get((int)0).order, this.qspec.get((int)1).order, this.qspec.get((int)0).breakpoints[this.qspec.get((int)0).index], this.qspec.get((int)0).breakpoints[this.qspec.get((int)0).index + 1], this.qspec.get((int)1).breakpoints[this.qspec.get((int)1).index], this.qspec.get((int)1).breakpoints[this.qspec.get((int)1).index + 1]);
        } else {
            CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(this.cpts.getArray(), 0);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)0).offset);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)0).index * this.qspec.get((int)0).order * this.qspec.get((int)0).stride);
            backend.curvpts(this.mapdesc.getType(), cArrayOfFloats, this.qspec.get((int)0).stride, this.qspec.get((int)0).order, this.qspec.get((int)0).breakpoints[this.qspec.get((int)0).index], this.qspec.get((int)0).breakpoints[this.qspec.get((int)0).index + 1]);
        }
    }

    private int getDimension() {
        return this.eqspec.getPointer() - this.qspec.getPointer();
    }

    private void select(float[] fArray, float[] fArray2) {
        int n2 = this.eqspec.getPointer() - this.qspec.getPointer();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            for (n3 = this.qspec.get((int)i2).width - 1; !(n3 < 0 || this.qspec.get((int)i2).breakpoints[n3] <= fArray[i2] && fArray2[i2] <= this.qspec.get((int)i2).breakpoints[n3 + 1]); --n3) {
            }
            assert (n3 != -1);
            this.qspec.get((int)i2).index = n3;
        }
    }

    public void getRange(float[] fArray, float[] fArray2, Flist flist) {
        this.getRange(fArray, fArray2, 0, flist);
    }

    private void getRange(float[] fArray, float[] fArray2, int n2, Flist flist) {
        Quilt quilt = this;
        fArray[n2] = quilt.qspec.get((int)n2).breakpoints[0];
        fArray2[n2] = quilt.qspec.get((int)n2).breakpoints[quilt.qspec.get((int)n2).width];
        int n3 = 0;
        Quilt quilt2 = quilt;
        while (quilt2 != null) {
            if (quilt2.qspec.get((int)n2).breakpoints[0] > fArray[n2]) {
                fArray[n2] = quilt2.qspec.get((int)n2).breakpoints[0];
            }
            if (quilt2.qspec.get((int)n2).breakpoints[quilt2.qspec.get((int)n2).width] < fArray2[n2]) {
                fArray2[n2] = quilt2.qspec.get((int)n2).breakpoints[quilt2.qspec.get((int)n2).width];
            }
            n3 += quilt2.qspec.get((int)n2).width + 1;
            quilt2 = quilt2.next;
        }
        flist.grow(n3);
        quilt2 = quilt;
        while (quilt2 != null) {
            for (int i2 = 0; i2 <= quilt2.qspec.get((int)n2).width; ++i2) {
                flist.add(quilt2.qspec.get((int)n2).breakpoints[i2]);
            }
            quilt2 = quilt2.next;
        }
        flist.filter();
        flist.taper(fArray[n2], fArray2[n2]);
    }

    public int isCulled() {
        if (this.mapdesc.isCulling()) {
            return 0;
        }
        return 1;
    }

    public void getRange(float[] fArray, float[] fArray2, Flist flist, Flist flist2) {
        this.getRange(fArray, fArray2, 0, flist);
        this.getRange(fArray, fArray2, 1, flist2);
    }

    public void findRates(Flist flist, Flist flist2, float[] fArray) {
    }
}

