/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;

public class EGLGLCapabilities
extends GLCapabilities {
    private long eglcfg;
    private final int eglcfgid;
    private final int renderableType;
    private final int nativeVisualID;

    public EGLGLCapabilities(long l2, int n2, int n3, GLProfile gLProfile, int n4) {
        super(gLProfile);
        this.eglcfg = l2;
        this.eglcfgid = n2;
        if (!EGLGLCapabilities.isCompatible(gLProfile, n4)) {
            throw new GLException("Requested GLProfile " + gLProfile + " not compatible with EGL-RenderableType[" + EGLGLCapabilities.renderableTypeToString(null, n4) + "]");
        }
        this.renderableType = n4;
        this.nativeVisualID = n3;
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new GLException(runtimeException);
        }
    }

    protected final void setEGLConfig(long l2) {
        this.eglcfg = l2;
    }

    public final long getEGLConfig() {
        return this.eglcfg;
    }

    public final int getEGLConfigID() {
        return this.eglcfgid;
    }

    public final int getRenderableType() {
        return this.renderableType;
    }

    public final int getNativeVisualID() {
        return this.nativeVisualID;
    }

    @Override
    public final int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        switch (vIDType) {
            case INTRINSIC: 
            case EGL_CONFIG: {
                return this.getEGLConfigID();
            }
            case NATIVE: {
                return this.getNativeVisualID();
            }
        }
        throw new NativeWindowException("Invalid type <" + (Object)((Object)vIDType) + ">");
    }

    public static boolean isCompatible(GLProfile gLProfile, int n2) {
        if (null == gLProfile) {
            return true;
        }
        if (0 != (n2 & 0x40) && gLProfile.usesNativeGLES3()) {
            return true;
        }
        if (0 != (n2 & 4) && gLProfile.usesNativeGLES2()) {
            return true;
        }
        if (0 != (n2 & 1) && gLProfile.usesNativeGLES1()) {
            return true;
        }
        return 0 != (n2 & 8) && !gLProfile.usesNativeGLES();
    }

    public static GLProfile getCompatible(EGLGraphicsDevice eGLGraphicsDevice, int n2) {
        if (0 != (n2 & 0x40) && GLProfile.isAvailable(eGLGraphicsDevice, "GLES3")) {
            return GLProfile.get(eGLGraphicsDevice, "GLES3");
        }
        if (0 != (n2 & 4) && GLProfile.isAvailable(eGLGraphicsDevice, "GLES2")) {
            return GLProfile.get(eGLGraphicsDevice, "GLES2");
        }
        if (0 != (n2 & 1) && GLProfile.isAvailable(eGLGraphicsDevice, "GLES1")) {
            return GLProfile.get(eGLGraphicsDevice, "GLES1");
        }
        if (0 != (n2 & 8)) {
            return GLProfile.getDefault(eGLGraphicsDevice);
        }
        return null;
    }

    public static StringBuilder renderableTypeToString(StringBuilder stringBuilder, int n2) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = true;
        stringBuilder.append("0x").append(Integer.toHexString(n2)).append(": ");
        if (0 != (n2 & 8)) {
            stringBuilder.append("GL");
            bl = false;
        }
        if (0 != (n2 & 1)) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("GLES1");
            bl = false;
        }
        if (0 != (n2 & 4)) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("GLES2");
            bl = false;
        }
        if (0 != (n2 & 0x40)) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("GLES3");
            bl = false;
        }
        if (0 != (n2 & 0x30A1)) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("VG");
            bl = false;
        }
        return stringBuilder;
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("egl cfg 0x").append(Integer.toHexString(this.eglcfgid));
        stringBuilder.append(", vid 0x").append(Integer.toHexString(this.nativeVisualID)).append(": ");
        super.toString(stringBuilder);
        stringBuilder.append(", [");
        EGLGLCapabilities.renderableTypeToString(stringBuilder, this.renderableType);
        return stringBuilder.append("]");
    }
}

