/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.awt;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.opengl.Debug;
import jogamp.opengl.awt.AWTUtil;

public class Java2D {
    private static boolean DEBUG = Debug.debug("Java2D");
    private static boolean isHeadless;
    private static boolean isOGLPipelineActive;
    private static boolean isOGLPipelineResourceCompatible;
    private static Method invokeWithOGLContextCurrentMethod;
    private static Method isQueueFlusherThreadMethod;
    private static Method getOGLViewportMethod;
    private static Method getOGLScissorBoxMethod;
    private static Method getOGLSurfaceIdentifierMethod;
    private static Method getOGLTextureTypeMethod;
    private static boolean fbObjectSupportInitialized;
    private static Method invokeWithOGLSharedContextCurrentMethod;
    private static Method getOGLSurfaceTypeMethod;
    public static final int UNDEFINED = 0;
    public static final int WINDOW = 1;
    public static final int PBUFFER = 2;
    public static final int TEXTURE = 3;
    public static final int FLIP_BACKBUFFER = 4;
    public static final int FBOBJECT = 5;
    private static boolean initializedJ2DFBOShareContext;
    private static GLContext j2dFBOShareContext;
    private static Method createOGLContextOnSurfaceMethod;
    private static Method makeOGLContextCurrentOnSurfaceMethod;
    private static Method destroyOGLContextMethod;

    public static boolean isOGLPipelineActive() {
        return isOGLPipelineActive;
    }

    public static boolean isOGLPipelineResourceCompatible() {
        return isOGLPipelineResourceCompatible;
    }

    public static boolean isFBOEnabled() {
        return fbObjectSupportInitialized;
    }

    public static boolean isQueueFlusherThread() {
        Java2D.checkActive();
        try {
            return (Boolean)isQueueFlusherThreadMethod.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static void invokeWithOGLContextCurrent(Graphics graphics, Runnable runnable) throws GLException {
        Java2D.checkActive();
        try {
            Java2D.initFBOShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
            AWTUtil.lockToolkit();
            try {
                invokeWithOGLContextCurrentMethod.invoke(null, graphics, runnable);
            }
            finally {
                AWTUtil.unlockToolkit();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static boolean invokeWithOGLSharedContextCurrent(GraphicsConfiguration graphicsConfiguration, Runnable runnable) throws GLException {
        boolean bl;
        Java2D.checkCompatible();
        AWTUtil.lockToolkit();
        try {
            bl = (Boolean)invokeWithOGLSharedContextCurrentMethod.invoke(null, graphicsConfiguration, runnable);
        }
        catch (Throwable throwable) {
            try {
                AWTUtil.unlockToolkit();
                throw throwable;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new GLException(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw (InternalError)new InternalError().initCause(exception);
            }
        }
        AWTUtil.unlockToolkit();
        return bl;
    }

    public static Rectangle getOGLViewport(Graphics graphics, int n2, int n3) {
        Java2D.checkCompatible();
        try {
            return (Rectangle)getOGLViewportMethod.invoke(null, graphics, n2, n3);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static Rectangle getOGLScissorBox(Graphics graphics) {
        Java2D.checkCompatible();
        try {
            return (Rectangle)getOGLScissorBoxMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static Object getOGLSurfaceIdentifier(Graphics graphics) {
        Java2D.checkCompatible();
        try {
            return getOGLSurfaceIdentifierMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static int getOGLSurfaceType(Graphics graphics) {
        Java2D.checkCompatible();
        try {
            if (!fbObjectSupportInitialized) {
                return 0;
            }
            return (Integer)getOGLSurfaceTypeMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static int getOGLTextureType(Graphics graphics) {
        Java2D.checkCompatible();
        if (getOGLTextureTypeMethod == null) {
            return 3553;
        }
        try {
            return (Integer)getOGLTextureTypeMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static GLContext filterShareContext(GLContext gLContext) {
        if (isHeadless) {
            return gLContext;
        }
        Java2D.initFBOShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
        if (j2dFBOShareContext != null) {
            return j2dFBOShareContext;
        }
        return gLContext;
    }

    public static GLContext getShareContext(GraphicsDevice graphicsDevice) {
        Java2D.initFBOShareContext(graphicsDevice);
        return j2dFBOShareContext;
    }

    public static long createOGLContextOnSurface(Graphics graphics, long l2) {
        Java2D.checkCompatible();
        try {
            return (Long)createOGLContextOnSurfaceMethod.invoke(null, graphics, l2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static boolean makeOGLContextCurrentOnSurface(Graphics graphics, long l2) {
        Java2D.checkCompatible();
        try {
            return (Boolean)makeOGLContextCurrentOnSurfaceMethod.invoke(null, graphics, l2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static void destroyOGLContext(long l2) {
        Java2D.checkCompatible();
        try {
            destroyOGLContextMethod.invoke(null, l2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    private static void checkActive() {
        if (!Java2D.isOGLPipelineActive()) {
            throw new GLException("Java2D OpenGL pipeline not active");
        }
    }

    private static void checkCompatible() {
        if (!Java2D.isOGLPipelineResourceCompatible()) {
            throw new GLException("Java2D OpenGL pipeline not resource compatible");
        }
    }

    private static void initFBOShareContext(GraphicsDevice graphicsDevice) {
        if (Java2D.isOGLPipelineResourceCompatible() && Java2D.isFBOEnabled() && !initializedJ2DFBOShareContext) {
            initializedJ2DFBOShareContext = true;
            if (DEBUG) {
                System.err.println("Starting initialization of J2D FBO share context");
            }
            Java2D.invokeWithOGLSharedContextCurrent(graphicsDevice.getDefaultConfiguration(), new Runnable(){

                @Override
                public void run() {
                    j2dFBOShareContext = GLDrawableFactory.getFactory(GLProfile.getDefault(GLProfile.getDefaultDevice())).createExternalGLContext();
                }
            });
            if (DEBUG) {
                System.err.println("Ending initialization of J2D FBO share context");
            }
        }
    }

    static {
        SecurityUtil.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Throwable throwable;
                block21: {
                    if (DEBUG) {
                        System.err.println("Checking for Java2D/OpenGL support");
                    }
                    throwable = null;
                    try {
                        String string;
                        boolean bl;
                        isHeadless = true;
                        boolean bl2 = PlatformPropsImpl.OS_TYPE == Platform.OSType.MACOS;
                        boolean bl3 = true;
                        Object object = System.getProperty("sun.java2d.opengl");
                        if (null != object) {
                            bl3 = Boolean.valueOf((String)object);
                        }
                        boolean bl4 = bl = !bl3;
                        if (!bl && !bl2) {
                            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                            string = graphicsConfiguration.getClass().getName();
                        } else {
                            if (DEBUG) {
                                System.err.println("Java2D support disabled: by Property " + bl + ", by OS " + bl2);
                            }
                            Object var2_11 = null;
                            string = "nil";
                        }
                        isHeadless = false;
                        if (DEBUG) {
                            System.err.println("Java2D support: default GraphicsConfiguration = " + string);
                        }
                        isOGLPipelineActive = string.startsWith("sun.java2d.opengl");
                        isOGLPipelineResourceCompatible = isOGLPipelineActive;
                        if (!isOGLPipelineActive) break block21;
                        try {
                            block24: {
                                block23: {
                                    Class<?> clazz;
                                    block22: {
                                        clazz = Class.forName("sun.java2d.opengl.OGLUtilities");
                                        invokeWithOGLContextCurrentMethod = clazz.getDeclaredMethod("invokeWithOGLContextCurrent", Graphics.class, Runnable.class);
                                        invokeWithOGLContextCurrentMethod.setAccessible(true);
                                        isQueueFlusherThreadMethod = clazz.getDeclaredMethod("isQueueFlusherThread", new Class[0]);
                                        isQueueFlusherThreadMethod.setAccessible(true);
                                        if (!isOGLPipelineResourceCompatible) break block21;
                                        getOGLViewportMethod = clazz.getDeclaredMethod("getOGLViewport", Graphics.class, Integer.TYPE, Integer.TYPE);
                                        getOGLViewportMethod.setAccessible(true);
                                        getOGLScissorBoxMethod = clazz.getDeclaredMethod("getOGLScissorBox", Graphics.class);
                                        getOGLScissorBoxMethod.setAccessible(true);
                                        getOGLSurfaceIdentifierMethod = clazz.getDeclaredMethod("getOGLSurfaceIdentifier", Graphics.class);
                                        getOGLSurfaceIdentifierMethod.setAccessible(true);
                                        fbObjectSupportInitialized = true;
                                        try {
                                            invokeWithOGLSharedContextCurrentMethod = clazz.getDeclaredMethod("invokeWithOGLSharedContextCurrent", GraphicsConfiguration.class, Runnable.class);
                                            invokeWithOGLSharedContextCurrentMethod.setAccessible(true);
                                            getOGLSurfaceTypeMethod = clazz.getDeclaredMethod("getOGLSurfaceType", Graphics.class);
                                            getOGLSurfaceTypeMethod.setAccessible(true);
                                        }
                                        catch (Exception exception) {
                                            fbObjectSupportInitialized = false;
                                            if (!DEBUG) break block22;
                                            exception.printStackTrace();
                                            System.err.println("Info: Disabling Java2D/JOGL FBO support");
                                        }
                                    }
                                    try {
                                        getOGLTextureTypeMethod = clazz.getDeclaredMethod("getOGLTextureType", Graphics.class);
                                        getOGLTextureTypeMethod.setAccessible(true);
                                    }
                                    catch (Exception exception) {
                                        if (!DEBUG) break block23;
                                        exception.printStackTrace();
                                        System.err.println("Info: GL_ARB_texture_rectangle FBO support disabled");
                                    }
                                }
                                object = null;
                                try {
                                    object = Class.forName("sun.java2d.opengl.CGLSurfaceData");
                                }
                                catch (Exception exception) {
                                    if (!DEBUG) break block24;
                                    exception.printStackTrace();
                                    System.err.println("Info: Unable to find class sun.java2d.opengl.CGLSurfaceData for OS X");
                                }
                            }
                            if (object != null) {
                                fbObjectSupportInitialized = false;
                                createOGLContextOnSurfaceMethod = ((Class)object).getDeclaredMethod("createOGLContextOnSurface", Graphics.class, Long.TYPE);
                                createOGLContextOnSurfaceMethod.setAccessible(true);
                                makeOGLContextCurrentOnSurfaceMethod = ((Class)object).getDeclaredMethod("makeOGLContextCurrentOnSurface", Graphics.class, Long.TYPE);
                                makeOGLContextCurrentOnSurfaceMethod.setAccessible(true);
                                destroyOGLContextMethod = ((Class)object).getDeclaredMethod("destroyOGLContext", Long.TYPE);
                                destroyOGLContextMethod.setAccessible(true);
                            }
                        }
                        catch (Exception exception) {
                            throwable = exception;
                            if (DEBUG) {
                                System.err.println("Info: Disabling Java2D/JOGL integration");
                            }
                            isOGLPipelineActive = false;
                            isOGLPipelineResourceCompatible = false;
                        }
                    }
                    catch (HeadlessException headlessException) {
                    }
                    catch (Error error) {
                        throwable = error;
                    }
                }
                if (DEBUG) {
                    if (null != throwable) {
                        throwable.printStackTrace();
                    }
                    System.err.println("JOGL/Java2D OGL Pipeline active " + isOGLPipelineActive + ", resourceCompatible " + isOGLPipelineResourceCompatible);
                }
                return null;
            }
        });
    }
}

