/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLBufferStorage;
import com.jogamp.opengl.GLException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jogamp.opengl.Debug;
import jogamp.opengl.GLBufferStateTracker;

public class GLBufferObjectTracker {
    protected static final boolean DEBUG;
    private final IntObjectHashMap bufferName2StorageMap = new IntObjectHashMap();
    private static final String GL_INVALID_OPERATION = "GL_INVALID_OPERATION";
    private static final String GL_INVALID_VALUE = "GL_INVALID_VALUE";
    private static final String warning = "WARNING";
    private static final String msgClazzName = "GLBufferObjectTracker";
    private static final String msgUnmapped = "notifyBufferUnmapped()";
    private static final String msgCreateBound = "createBoundBufferStorage()";
    private static final String msgCreateNamed = "createNamedBufferStorage()";
    private static final String msgMapBuffer = "mapBuffer()";

    public GLBufferObjectTracker() {
        this.bufferName2StorageMap.setKeyNotFoundValue(null);
    }

    public final synchronized void createBufferStorage(GLBufferStateTracker gLBufferStateTracker, GL gL, int n2, long l2, Buffer buffer, int n3, int n4, CreateStorageDispatch createStorageDispatch) throws GLException {
        boolean bl;
        int n5;
        int n6 = gL.glGetError();
        if (DEBUG && 0 != n6) {
            System.err.printf("%s.%s glerr-pre 0x%X%n", msgClazzName, msgCreateBound, n6);
        }
        if (0 == (n5 = gLBufferStateTracker.getBoundBufferObject(n2, gL))) {
            throw new GLException(String.format("%s: Buffer for target 0x%X not bound", GL_INVALID_OPERATION, n2));
        }
        boolean bl2 = 0 != n3;
        boolean bl3 = bl = bl2 && 0L > l2 || !bl2 && 0L >= l2;
        if (bl) {
            throw new GLException(String.format("%s: Invalid size %d for %s buffer %d on target 0x%X", GL_INVALID_VALUE, l2, bl2 ? "mutable" : "immutable", n5, n2));
        }
        createStorageDispatch.create(n2, l2, buffer, bl2 ? n3 : n4);
        int n7 = gL.glGetError();
        if (0 != n7) {
            throw new GLException(String.format("GL-Error 0x%X while creating %s storage for target 0x%X -> buffer %d of size %d with data %s", n7, bl2 ? "mutable" : "immutable", n2, n5, l2, buffer));
        }
        GLBufferStorageImpl gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.get(n5);
        if (null != gLBufferStorageImpl) {
            gLBufferStorageImpl.reset(l2, n3, n4);
            if (DEBUG) {
                System.err.printf("%s.%s target: 0x%X -> reset %d: %s%n", msgClazzName, msgCreateBound, n2, n5, gLBufferStorageImpl);
            }
        } else {
            GLBufferStorageImpl gLBufferStorageImpl2 = new GLBufferStorageImpl(n5, l2, n3, n4);
            this.bufferName2StorageMap.put(n5, gLBufferStorageImpl2);
            if (DEBUG) {
                System.err.printf("%s.%s target: 0x%X -> new %d: %s%n", msgClazzName, msgCreateBound, n2, n5, gLBufferStorageImpl2);
            }
        }
    }

    public final synchronized void createBufferStorage(GL gL, int n2, long l2, Buffer buffer, int n3, int n4, CreateStorageDispatch createStorageDispatch) throws GLException {
        boolean bl;
        int n5 = gL.glGetError();
        if (DEBUG && 0 != n5) {
            System.err.printf("%s.%s glerr-pre 0x%X%n", msgClazzName, msgCreateNamed, n5);
        }
        boolean bl2 = 0 != n3;
        boolean bl3 = bl = bl2 && 0L > l2 || !bl2 && 0L >= l2;
        if (bl) {
            throw new GLException(String.format("%s: Invalid size %d for %s buffer %d", GL_INVALID_VALUE, l2, bl2 ? "mutable" : "immutable", n2));
        }
        createStorageDispatch.create(n2, l2, buffer, bl2 ? n3 : n4);
        int n6 = gL.glGetError();
        if (0 != n6) {
            throw new GLException(String.format("GL-Error 0x%X while creating %s storage for buffer %d of size %d with data %s", n6, bl2 ? "mutable" : "immutable", n2, l2, buffer));
        }
        GLBufferStorageImpl gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.get(n2);
        if (null != gLBufferStorageImpl) {
            gLBufferStorageImpl.reset(l2, n3, n4);
            if (DEBUG) {
                System.err.printf("%s.%s direct: reset %d: %s%n", msgClazzName, msgCreateNamed, n2, gLBufferStorageImpl);
            }
        } else {
            GLBufferStorageImpl gLBufferStorageImpl2 = new GLBufferStorageImpl(n2, l2, n3, n4);
            this.bufferName2StorageMap.put(n2, gLBufferStorageImpl2);
            if (DEBUG) {
                System.err.printf("%s.%s direct: new %d: %s%n", msgClazzName, msgCreateNamed, n2, gLBufferStorageImpl2);
            }
        }
    }

    public final synchronized void notifyBuffersDeleted(int n2, int[] nArray, int n3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.notifyBufferDeleted(nArray[i2 + n3], i2, n2);
        }
    }

    public final synchronized void notifyBuffersDeleted(int n2, IntBuffer intBuffer) {
        int n3 = intBuffer.position();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.notifyBufferDeleted(intBuffer.get(i2 + n3), i2, n2);
        }
    }

    private final synchronized void notifyBufferDeleted(int n2, int n3, int n4) {
        GLBufferStorageImpl gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.put(n2, null);
        if (DEBUG) {
            System.err.printf("%s.notifyBuffersDeleted()[%d/%d]: %d: %s -> null%n", msgClazzName, n3 + 1, n4, n2, gLBufferStorageImpl);
        }
        if (null == gLBufferStorageImpl) {
            if (DEBUG) {
                System.err.printf("%s: %s.notifyBuffersDeleted()[%d/%d]: Buffer %d not tracked%n", warning, msgClazzName, n3 + 1, n4, n2);
                ExceptionUtils.dumpStack(System.err);
            }
            return;
        }
        gLBufferStorageImpl.setMappedBuffer(null);
    }

    public final synchronized GLBufferStorage mapBuffer(GLBufferStateTracker gLBufferStateTracker, GL gL, int n2, int n3, MapBufferAllDispatch mapBufferAllDispatch) throws GLException {
        return this.mapBufferImpl(gLBufferStateTracker, gL, n2, false, 0L, 0L, n3, (MapBufferDispatch)mapBufferAllDispatch);
    }

    public final synchronized GLBufferStorage mapBuffer(GLBufferStateTracker gLBufferStateTracker, GL gL, int n2, long l2, long l3, int n3, MapBufferRangeDispatch mapBufferRangeDispatch) throws GLException {
        return this.mapBufferImpl(gLBufferStateTracker, gL, n2, true, l2, l3, n3, (MapBufferDispatch)mapBufferRangeDispatch);
    }

    public final synchronized GLBufferStorage mapBuffer(int n2, int n3, MapBufferAllDispatch mapBufferAllDispatch) throws GLException {
        return this.mapBufferImpl(0, n2, true, false, 0L, 0L, n3, (MapBufferDispatch)mapBufferAllDispatch);
    }

    public final synchronized GLBufferStorage mapBuffer(int n2, long l2, long l3, int n3, MapBufferRangeDispatch mapBufferRangeDispatch) throws GLException {
        return this.mapBufferImpl(0, n2, true, true, l2, l3, n3, (MapBufferDispatch)mapBufferRangeDispatch);
    }

    private final synchronized GLBufferStorage mapBufferImpl(GLBufferStateTracker gLBufferStateTracker, GL gL, int n2, boolean bl, long l2, long l3, int n3, MapBufferDispatch mapBufferDispatch) throws GLException {
        int n4 = gLBufferStateTracker.getBoundBufferObject(n2, gL);
        if (0 == n4) {
            throw new GLException(String.format("%s.%s: %s Buffer for target 0x%X not bound", msgClazzName, msgMapBuffer, GL_INVALID_OPERATION, n2));
        }
        return this.mapBufferImpl(n2, n4, false, bl, l2, l3, n3, mapBufferDispatch);
    }

    private final synchronized GLBufferStorage mapBufferImpl(int n2, int n3, boolean bl, boolean bl2, long l2, long l3, int n4, MapBufferDispatch mapBufferDispatch) throws GLException {
        GLBufferStorageImpl gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.get(n3);
        if (null == gLBufferStorageImpl) {
            throw new GLException("Buffer with name " + n3 + " not tracked");
        }
        if (null != gLBufferStorageImpl.getMappedBuffer()) {
            throw new GLException(String.format("%s.%s: %s Buffer storage of target 0x%X -> %d: %s is already mapped", msgClazzName, msgMapBuffer, GL_INVALID_OPERATION, n2, n3, gLBufferStorageImpl));
        }
        long l4 = gLBufferStorageImpl.getSize();
        if (0L > l4) {
            throw new GLException(String.format("%s.%s: %s Buffer storage of target 0x%X -> %d: %s is of less-than zero", msgClazzName, msgMapBuffer, GL_INVALID_OPERATION, n2, n3, gLBufferStorageImpl));
        }
        if (!bl2) {
            l3 = l4;
            l2 = 0L;
        }
        if (l3 + l2 > l4) {
            throw new GLException(String.format("%s.%s: %s Out of range: offset %d, length %d, buffer storage of target 0x%X -> %d: %s", msgClazzName, msgMapBuffer, GL_INVALID_VALUE, l2, l3, n2, n3, gLBufferStorageImpl));
        }
        if (0L >= l3 || 0L > l2) {
            throw new GLException(String.format("%s.%s: %s Invalid values: offset %d, length %d, buffer storage of target 0x%X -> %d: %s", msgClazzName, msgMapBuffer, GL_INVALID_VALUE, l2, l3, n2, n3, gLBufferStorageImpl));
        }
        if (0L == l4) {
            return gLBufferStorageImpl;
        }
        long l5 = bl ? (bl2 ? ((MapBufferRangeDispatch)mapBufferDispatch).mapBuffer(n3, l2, l3, n4) : ((MapBufferAllDispatch)mapBufferDispatch).mapBuffer(n3, n4)) : (bl2 ? ((MapBufferRangeDispatch)mapBufferDispatch).mapBuffer(n2, l2, l3, n4) : ((MapBufferAllDispatch)mapBufferDispatch).mapBuffer(n2, n4));
        if (0L == l5) {
            if (DEBUG) {
                System.err.printf("%s.%s: %s MapBuffer null result for target 0x%X -> %d: %s, off %d, len %d, acc 0x%X%n", msgClazzName, msgMapBuffer, warning, n2, n3, gLBufferStorageImpl, l2, l3, n4);
                ExceptionUtils.dumpStack(System.err);
            }
        } else {
            ByteBuffer byteBuffer = mapBufferDispatch.allocNioByteBuffer(l5, l3);
            Buffers.nativeOrder(byteBuffer);
            if (DEBUG) {
                System.err.printf("%s.%s: Target 0x%X -> %d: %s, off %d, len %d, acc 0x%X%n", msgClazzName, msgClazzName, n2, n3, gLBufferStorageImpl.toString(false), l2, l3, n4);
            }
            gLBufferStorageImpl.setMappedBuffer(byteBuffer);
        }
        return gLBufferStorageImpl;
    }

    public final synchronized boolean unmapBuffer(GLBufferStateTracker gLBufferStateTracker, GL gL, int n2, UnmapBufferDispatch unmapBufferDispatch) {
        GLBufferStorageImpl gLBufferStorageImpl;
        int n3 = gLBufferStateTracker.getBoundBufferObject(n2, gL);
        if (0 == n3) {
            if (DEBUG) {
                System.err.printf("%s: %s.%s: Buffer for target 0x%X not bound%n", warning, msgClazzName, msgUnmapped, n2);
                ExceptionUtils.dumpStack(System.err);
            }
            gLBufferStorageImpl = null;
        } else {
            gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.get(n3);
            if (DEBUG && null == gLBufferStorageImpl) {
                System.err.printf("%s: %s.%s: Buffer %d not tracked%n", warning, msgClazzName, msgUnmapped, n3);
                ExceptionUtils.dumpStack(System.err);
            }
        }
        boolean bl = unmapBufferDispatch.unmap(n2);
        if (bl && null != gLBufferStorageImpl) {
            gLBufferStorageImpl.setMappedBuffer(null);
        }
        if (DEBUG) {
            System.err.printf("%s.%s %s target: 0x%X -> %d: %s%n", msgClazzName, msgUnmapped, bl ? "OK" : "Failed", n2, n3, gLBufferStorageImpl.toString(false));
            if (!bl) {
                ExceptionUtils.dumpStack(System.err);
            }
        }
        return bl;
    }

    public final synchronized boolean unmapBuffer(int n2, UnmapBufferDispatch unmapBufferDispatch) {
        boolean bl;
        GLBufferStorageImpl gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.get(n2);
        if (DEBUG && null == gLBufferStorageImpl) {
            System.err.printf("%s: %s.%s: Buffer %d not tracked%n", warning, msgClazzName, msgUnmapped, n2);
            ExceptionUtils.dumpStack(System.err);
        }
        if ((bl = unmapBufferDispatch.unmap(n2)) && null != gLBufferStorageImpl) {
            gLBufferStorageImpl.setMappedBuffer(null);
        }
        if (DEBUG) {
            System.err.printf("%s.%s %s %d: %s%n", msgClazzName, msgUnmapped, bl ? "OK" : "Failed", n2, gLBufferStorageImpl.toString(false));
            if (!bl) {
                ExceptionUtils.dumpStack(System.err);
            }
        }
        return bl;
    }

    public final synchronized GLBufferStorage getBufferStorage(int n2) {
        return (GLBufferStorageImpl)this.bufferName2StorageMap.get(n2);
    }

    public final synchronized void clear() {
        if (DEBUG) {
            System.err.printf("%s.clear() - Thread %s%n", msgClazzName, Thread.currentThread().getName());
        }
        this.bufferName2StorageMap.clear();
    }

    static {
        Debug.initSingleton();
        DEBUG = PropertyAccess.isPropertyDefined("jogl.debug.GLBufferObjectTracker", true);
    }

    public static interface CreateStorageDispatch {
        public void create(int var1, long var2, Buffer var4, int var5);
    }

    static final class GLBufferStorageImpl
    extends GLBufferStorage {
        GLBufferStorageImpl(int n2, long l2, int n3, int n4) {
            super(n2, l2, n3, n4);
        }

        @Override
        protected final void reset(long l2, int n2, int n3) {
            super.reset(l2, n2, n3);
        }

        @Override
        protected final void setMappedBuffer(ByteBuffer byteBuffer) {
            super.setMappedBuffer(byteBuffer);
        }
    }

    public static interface MapBufferDispatch {
        public ByteBuffer allocNioByteBuffer(long var1, long var3);
    }

    public static interface MapBufferRangeDispatch
    extends MapBufferDispatch {
        public long mapBuffer(int var1, long var2, long var4, int var6);
    }

    public static interface MapBufferAllDispatch
    extends MapBufferDispatch {
        public long mapBuffer(int var1, int var2);
    }

    public static interface UnmapBufferDispatch {
        public boolean unmap(int var1);
    }
}

