/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.macosx;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.OffscreenLayerOption;
import com.jogamp.nativewindow.ScalableSurface;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MonitorEvent;
import com.jogamp.opengl.math.FloatUtil;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.DriverClearFocus;
import jogamp.newt.driver.DriverUpdatePosition;
import jogamp.newt.driver.macosx.DisplayDriver;
import jogamp.newt.driver.macosx.MacKeyUtil;

public class WindowDriver
extends WindowImpl
implements MutableSurface,
DriverClearFocus,
DriverUpdatePosition {
    private static final int NSBorderlessWindowMask = 0;
    private static final int NSTitledWindowMask = 1;
    private static final int NSClosableWindowMask = 2;
    private static final int NSMiniaturizableWindowMask = 4;
    private static final int NSResizableWindowMask = 8;
    private static final int NSBackingStoreRetained = 0;
    private static final int NSBackingStoreNonretained = 1;
    private static final int NSBackingStoreBuffered = 2;
    private volatile long surfaceHandle = 0L;
    private long sscSurfaceHandle = 0L;
    private boolean isOffscreenInstance = false;
    private boolean resizeAnimatorPaused = false;

    private boolean updatePixelScale(boolean bl, boolean bl2, boolean bl3, float f2, float f3) {
        float f4;
        float f5 = FloatUtil.isZero(f2, 1.1920929E-7f) ? 1.0f : f2;
        float[] fArray = new float[]{f5, f5};
        this.maxPixelScale[0] = f4 = FloatUtil.isZero(f3, 1.1920929E-7f) ? 1.0f : f3;
        this.maxPixelScale[1] = f4;
        if (SurfaceScaleUtils.setNewPixelScale(this.hasPixelScale, this.hasPixelScale, fArray, this.minPixelScale, this.maxPixelScale, DEBUG_IMPLEMENTATION ? this.getClass().getName() : null)) {
            if (bl && bl2 && bl3) {
                new InterruptSource.Thread(){

                    @Override
                    public void run() {
                        WindowDriver.this.updatePixelPosSize(true, true);
                    }
                }.start();
            } else {
                this.updatePixelPosSize(bl, bl2);
            }
            return true;
        }
        return false;
    }

    private boolean updateMaxScreenPixelScaleByDisplayID(boolean bl) {
        float f2 = OSXUtil.GetScreenPixelScaleByDisplayID(this.getDisplayID());
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.updatePixelScale.1: req " + this.reqPixelScale[0] + ", has " + this.hasPixelScale[0] + ", max " + f2);
        }
        return this.updatePixelScale(bl, true, false, this.hasPixelScale[0], f2);
    }

    private boolean updatePixelScaleByWindowHandle(boolean bl) {
        long l2 = this.getWindowHandle();
        if (0L != l2) {
            float f2 = OSXUtil.GetScreenPixelScale(l2);
            float f3 = OSXUtil.GetWindowPixelScale(l2);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("WindowDriver.updatePixelScale.2: req " + this.reqPixelScale[0] + ", has " + this.hasPixelScale[0] + ", new " + f3 + ", max " + f2);
            }
            return this.updatePixelScale(bl, true, false, f3, f2);
        }
        return false;
    }

    protected void updatePixelScale(boolean bl, float f2, float f3, float f4, boolean bl2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.updatePixelScale.3: req " + this.reqPixelScale[0] + ", has " + this.hasPixelScale[0] + ", old " + f2 + ", new " + f3 + ", max " + f4 + ", changed " + bl2);
        }
        this.updatePixelScale(true, bl, true, f3, f4);
    }

    @Override
    protected final void instantiationFinishedImpl() {
        this.updateMaxScreenPixelScaleByDisplayID(false);
    }

    @Override
    protected void setScreen(ScreenImpl screenImpl) {
        super.setScreen(screenImpl);
        this.updateMaxScreenPixelScaleByDisplayID(false);
    }

    @Override
    protected void monitorModeChanged(MonitorEvent monitorEvent, boolean bl) {
        this.updatePixelScaleByWindowHandle(false);
    }

    @Override
    public final boolean setSurfaceScale(float[] fArray) {
        super.setSurfaceScale(fArray);
        boolean bl = false;
        if (this.isNativeValid()) {
            if (this.isOffscreenInstance) {
                NativeWindow nativeWindow = this.getParent();
                if (nativeWindow instanceof ScalableSurface) {
                    ScalableSurface scalableSurface = (ScalableSurface)((Object)nativeWindow);
                    scalableSurface.setSurfaceScale(this.reqPixelScale);
                    scalableSurface.getMaximumSurfaceScale(this.maxPixelScale);
                    scalableSurface.getMinimumSurfaceScale(this.minPixelScale);
                    float[] fArray2 = scalableSurface.getCurrentSurfaceScale(new float[2]);
                    bl = this.updatePixelScale(true, true, true, fArray2[0], this.maxPixelScale[0]);
                } else {
                    bl = this.updatePixelScale(true, true, true, this.reqPixelScale[0], this.maxPixelScale[0]);
                }
            } else {
                final float[] fArray3 = new float[2];
                System.arraycopy(this.hasPixelScale, 0, fArray3, 0, 2);
                if (SurfaceScaleUtils.setNewPixelScale(fArray3, fArray3, this.reqPixelScale, this.minPixelScale, this.maxPixelScale, DEBUG_IMPLEMENTATION ? this.getClass().getName() : null)) {
                    OSXUtil.RunOnMainThread(true, false, new Runnable(){

                        @Override
                        public void run() {
                            long l2 = WindowDriver.this.getWindowHandle();
                            WindowDriver.this.setPixelScale0(l2, WindowDriver.this.surfaceHandle, fArray3[0]);
                            float f2 = OSXUtil.GetWindowPixelScale(l2);
                            WindowDriver.this.updatePixelScale(true, true, false, f2, WindowDriver.this.maxPixelScale[0]);
                        }
                    });
                    bl = true;
                }
            }
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.setPixelScale: min[" + this.minPixelScale[0] + ", " + this.minPixelScale[1] + "], max[" + this.maxPixelScale[0] + ", " + this.maxPixelScale[1] + "], req[" + this.reqPixelScale[0] + ", " + this.reqPixelScale[1] + "] -> result[" + this.hasPixelScale[0] + ", " + this.hasPixelScale[1] + "] - changed " + bl + ", realized " + this.isNativeValid());
        }
        return bl;
    }

    @Override
    protected void createNativeImpl(boolean[] blArray) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(this.getScreen().getDisplay().getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, this.getScreen().getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        this.reconfigureWindowImpl(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getReconfigureMask(Integer.MIN_VALUE, true));
        if (!this.isNativeValid()) {
            throw new NativeWindowException("Error creating window");
        }
    }

    @Override
    protected void closeNativeImpl() {
        block4: {
            try {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.CloseAction " + Thread.currentThread().getName());
                }
                final long l2 = this.getWindowHandle();
                this.visibleChanged(false);
                this.setWindowHandle(0L);
                this.surfaceHandle = 0L;
                this.sscSurfaceHandle = 0L;
                this.isOffscreenInstance = false;
                this.resizeAnimatorPaused = false;
                if (0L != l2) {
                    OSXUtil.RunOnMainThread(false, true, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.close0(l2);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (!DEBUG_IMPLEMENTATION) break block4;
                Exception exception = new Exception("Warning: closeNative failed - " + Thread.currentThread().getName(), throwable);
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected int lockSurfaceImpl() {
        long l2 = this.getWindowHandle();
        long l3 = this.surfaceHandle;
        if (0L != l3 && 0L != l2) {
            return this.lockSurface0(l2, l3) ? 3 : 1;
        }
        return 1;
    }

    @Override
    protected void unlockSurfaceImpl() {
        long l2 = this.getWindowHandle();
        long l3 = this.surfaceHandle;
        if (0L != l2 && 0L != l3 && !this.unlockSurface0(l2, l3)) {
            throw new NativeWindowException("Failed to unlock surface, probably not locked!");
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return 0L != this.sscSurfaceHandle ? this.sscSurfaceHandle : this.surfaceHandle;
    }

    @Override
    public void setSurfaceHandle(long l2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.setSurfaceHandle(): 0x" + Long.toHexString(l2));
        }
        this.sscSurfaceHandle = l2;
        if (this.isNativeValid() && 0L != this.sscSurfaceHandle) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.orderOut0(0L != WindowDriver.this.getParentWindowHandle() ? WindowDriver.this.getParentWindowHandle() : WindowDriver.this.getWindowHandle());
                }
            });
        }
    }

    @Override
    protected void setTitleImpl(final String string) {
        OSXUtil.RunOnMainThread(false, false, new Runnable(){

            @Override
            public void run() {
                WindowDriver.this.setTitle0(WindowDriver.this.getWindowHandle(), string);
            }
        });
    }

    @Override
    protected void requestFocusImpl(final boolean bl) {
        final boolean bl2 = this.isFullscreen();
        boolean bl3 = this.isOffscreenInstance;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: requestFocusImpl(), isOffscreenInstance " + bl3 + ", isFullscreen " + bl2);
        }
        if (!bl3) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.requestFocus0(WindowDriver.this.getWindowHandle(), bl);
                    if (bl2) {
                        WindowDriver.this.focusChanged(false, true);
                    }
                }
            });
        } else {
            this.focusChanged(false, true);
        }
    }

    @Override
    public final void clearFocus() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: clearFocus(), isOffscreenInstance " + this.isOffscreenInstance);
        }
        if (!this.isOffscreenInstance) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.resignFocus0(WindowDriver.this.getWindowHandle());
                }
            });
        } else {
            this.focusChanged(false, false);
        }
    }

    private boolean useParentLocation(NativeWindow nativeWindow) {
        return !this.isFullscreen() && null != nativeWindow && 0L != nativeWindow.getWindowHandle();
    }

    @Override
    public void updatePosition(int n2, int n3) {
        long l2 = this.getWindowHandle();
        if (0L != l2 && !this.isOffscreenInstance) {
            NativeWindow nativeWindow = this.getParent();
            boolean bl = this.useParentLocation(nativeWindow);
            final Point point = bl ? this.getLocationOnScreenByParent(n2, n3, nativeWindow) : (Point)WindowDriver.getLocationOnScreen0(l2, n2, n3);
            if (DEBUG_IMPLEMENTATION) {
                int n4 = nativeWindow.getX();
                int n5 = nativeWindow.getY();
                System.err.println("MacWindow: updatePosition() parent[" + bl + " " + n4 + "/" + n5 + "] " + n2 + "/" + n3 + " ->  " + n2 + "/" + n3 + " rel-client-pos, " + point + " screen-client-pos");
            }
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.setWindowClientTopLeftPoint0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY(), WindowDriver.this.isVisible());
                }
            });
            this.positionChanged(true, true, n2, n3);
        }
    }

    @Override
    protected final int getSupportedReconfigMaskImpl() {
        return 32765;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n2, int n3, int n4, int n5, final int n6) {
        Point point;
        NativeWindow nativeWindow = this.getParent();
        final boolean bl = this.useParentLocation(nativeWindow);
        boolean bl2 = WindowDriver.isOffscreenInstance(this, nativeWindow);
        boolean bl3 = this.isOffscreenInstance = 0L != this.sscSurfaceHandle || bl2;
        if (this.isOffscreenInstance) {
            n2 = 0;
            n3 = 0;
            point = new Point(0, 0);
        } else if (bl) {
            point = this.getLocationOnScreenByParent(n2, n3, nativeWindow);
        } else {
            if (0 != (0xC00000 & n6)) {
                int[] nArray = new int[]{n2, n3, n4, n5};
                this.reconfigMaximizedManual(n6, nArray, this.getInsets());
                n2 = nArray[0];
                n3 = nArray[1];
                n4 = nArray[2];
                n5 = nArray[3];
            }
            point = new Point(n2, n3);
        }
        int n7 = n2;
        int n8 = n3;
        final int n9 = n4;
        final int n10 = n5;
        boolean bl4 = this.hasFocus();
        if (DEBUG_IMPLEMENTATION) {
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.getGraphicsConfiguration();
            AbstractGraphicsConfiguration abstractGraphicsConfiguration2 = null != nativeWindow ? nativeWindow.getGraphicsConfiguration() : null;
            System.err.println("MacWindow reconfig.0: " + n7 + "/" + n8 + " -> clientPosOnScreen " + point + " - " + n9 + "x" + n10 + ", " + WindowDriver.getReconfigStateMaskString(n6) + ",\n\t useParent " + bl + ", parent type " + (null != nativeWindow ? nativeWindow.getClass().getName() : null) + ",\n\t   this-chosenCaps " + (null != abstractGraphicsConfiguration ? abstractGraphicsConfiguration.getChosenCapabilities() : null) + ",\n\t parent-chosenCaps " + (null != abstractGraphicsConfiguration2 ? abstractGraphicsConfiguration2.getChosenCapabilities() : null) + ", isOffscreenInstance(sscSurfaceHandle " + WindowDriver.toHexString(this.sscSurfaceHandle) + ", ioi: " + bl2 + ") -> " + this.isOffscreenInstance);
        }
        final long l2 = this.getWindowHandle();
        if (0 != (Integer.MIN_VALUE & n6) && 0 == (1 & n6)) {
            if (0L != l2 && !this.isOffscreenInstance) {
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.orderOut0(l2);
                        WindowDriver.this.visibleChanged(false);
                    }
                });
            } else {
                this.visibleChanged(false);
            }
        }
        if (0L == l2 && 0 != (1 & n6) || 0 != (0x20000000 & n6) || 0 != (0x10000000 & n6) || 0 != (0x8000000 & n6) || 0 != (0x4000000 & n6) || 0 != (0x1000000 & n6) || 0 != (0x200000 & n6)) {
            if (this.isOffscreenInstance) {
                this.createWindow(true, 0L != l2, point, 64, 64, n6);
            } else {
                this.createWindow(false, 0L != l2, point, n9, n10, n6);
            }
            this.updatePixelScaleByWindowHandle(false);
            if (this.isOffscreenInstance) {
                super.sizeChanged(false, true, n9, n10, true);
                this.positionChanged(false, true, n7, n8);
            } else {
                OSXUtil.RunOnMainThread(true, false, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.updateSizePosInsets0(WindowDriver.this.getWindowHandle(), false);
                    }
                });
            }
            this.visibleChanged(0 != (1 & n6));
            if (bl4) {
                this.requestFocusImpl(true);
            }
        } else if (0L != l2) {
            if (n9 > 0 && n10 > 0) {
                if (!this.isOffscreenInstance) {
                    OSXUtil.RunOnMainThread(true, false, new Runnable(){

                        @Override
                        public void run() {
                            if (bl && 0 == (1 & n6)) {
                                RectangleImmutable rectangleImmutable = WindowDriver.this.getScreen().getViewportInWindowUnits();
                                WindowDriver.this.setWindowClientTopLeftPointAndSize0(l2, rectangleImmutable.getX() + 2 * rectangleImmutable.getWidth(), rectangleImmutable.getY() + 2 * rectangleImmutable.getHeight(), n9, n10, false);
                            } else {
                                WindowDriver.this.setWindowClientTopLeftPointAndSize0(l2, point.getX(), point.getY(), n9, n10, 0 != (1 & n6));
                                WindowDriver.this.updateSizePosInsets0(l2, false);
                            }
                        }
                    });
                } else {
                    super.sizeChanged(false, true, n9, n10, false);
                    this.positionChanged(false, true, n7, n8);
                }
            }
            if (0 != (Integer.MIN_VALUE & n6) && 0 != (1 & n6)) {
                if (!this.isOffscreenInstance) {
                    OSXUtil.RunOnMainThread(false, false, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.orderFront0(WindowDriver.this.getWindowHandle());
                            WindowDriver.this.visibleChanged(true);
                        }
                    });
                } else {
                    this.visibleChanged(true);
                }
            }
        } else {
            throw new InternalError("Null windowHandle but no re-creation triggered, check visibility: " + this.getStateMaskString());
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow reconfig.X: " + this.getLocationOnScreenImpl(0, 0) + " " + this.getWidth() + "x" + this.getHeight() + ", insets " + this.getInsets() + ", " + this.getStateMaskString());
        }
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n2, int n3) {
        NativeWindow nativeWindow = this.getParent();
        if (this.useParentLocation(nativeWindow)) {
            return this.getLocationOnScreenByParent(n2, n3, nativeWindow);
        }
        long l2 = this.getWindowHandle();
        if (!this.isOffscreenInstance && 0L != l2) {
            return (Point)WindowDriver.getLocationOnScreen0(l2, n2, n3);
        }
        return new Point(n2, n3);
    }

    private Point getLocationOnScreenByParent(int n2, int n3, NativeWindow nativeWindow) {
        if (nativeWindow instanceof OffscreenLayerOption && ((OffscreenLayerOption)((Object)nativeWindow)).isOffscreenLayerSurfaceEnabled()) {
            return new Point(n2, n3).translate(nativeWindow.getLocationOnScreen(null));
        }
        return new Point(n2, n3).translate(OSXUtil.GetLocationOnScreen(nativeWindow.getWindowHandle(), 0, 0));
    }

    protected void screenPositionChanged(final boolean bl, final int n2, final int n3) {
        if (this.isNativeValid()) {
            final NativeWindow nativeWindow = this.getParent();
            boolean bl2 = this.useParentLocation(nativeWindow);
            if (!bl2 || this.isOffscreenInstance) {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.positionChanged.0 (Screen Pos - TOP): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n2 + "/" + n3);
                }
                this.positionChanged(bl, true, n2, n3);
            } else if (bl2 && !this.isVisible()) {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.positionChanged.1 (Screen Pos - invisible CHILD): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + ", ignoring absPos " + n2 + "/" + n3);
                }
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Point point = new Point(n2, n3);
                        Point point2 = nativeWindow instanceof OffscreenLayerOption && ((OffscreenLayerOption)((Object)nativeWindow)).isOffscreenLayerSurfaceEnabled() ? nativeWindow.getLocationOnScreen(null) : OSXUtil.GetLocationOnScreen(nativeWindow.getWindowHandle(), 0, 0);
                        point.translate(point2.scale(-1, -1));
                        if (Window.DEBUG_IMPLEMENTATION) {
                            System.err.println("MacWindow.positionChanged.1 (Screen Pos - CHILD): (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") " + WindowDriver.this.getX() + "/" + WindowDriver.this.getY() + " -> absPos " + n2 + "/" + n3 + ", parentOnScreen " + point2 + " -> " + point);
                        }
                        WindowDriver.this.positionChanged(false, true, point.getX(), point.getY());
                    }
                };
                if (bl) {
                    new InterruptSource.Thread(null, runnable).start();
                } else {
                    runnable.run();
                }
            }
        } else if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.positionChanged.2 (Screen Pos - IGN): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n2 + "/" + n3);
        }
    }

    @Override
    protected boolean sizeChanged(boolean bl, boolean bl2, int n2, int n3, boolean bl3) {
        int[] nArray = this.getWindowSizeI();
        int[] nArray2 = this.getPixelSizeI();
        if (bl3 || bl2 && (nArray[0] != n2 || nArray[1] != n3) || !bl2 && (nArray2[0] != n2 || nArray2[1] != n3)) {
            NativeWindow nativeWindow;
            boolean bl4;
            if (this.isNativeValid() && this.isVisible() && !this.isOffscreenInstance && (bl4 = this.useParentLocation(nativeWindow = this.getParent()))) {
                int n4 = this.getX();
                int n5 = this.getY();
                final Point point = this.getLocationOnScreenByParent(n4, n5, nativeWindow);
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow: sizeChanged() parent[" + bl4 + " " + n4 + "/" + n5 + "] " + this.getX() + "/" + this.getY() + " " + n2 + "x" + n3 + " ->  " + point + " screen-client-pos");
                }
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.setWindowClientTopLeftPoint0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY(), WindowDriver.this.isVisible());
                    }
                });
            }
            this.superSizeChangedOffThread(bl, bl2, n2, n3, bl3);
            return true;
        }
        return false;
    }

    private void superSizeChangedOffThread(boolean bl, final boolean bl2, final int n2, final int n3, final boolean bl3) {
        if (bl) {
            new InterruptSource.Thread(){

                @Override
                public void run() {
                    WindowDriver.super.sizeChanged(false, bl2, n2, n3, bl3);
                }
            }.start();
        } else {
            WindowDriver.super.sizeChanged(false, bl2, n2, n3, bl3);
        }
    }

    protected void sizeScreenPosInsetsChanged(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2, boolean bl3) {
        WindowImpl.LifecycleHook lifecycleHook = this.getLifecycleHook();
        if (bl3 && !this.resizeAnimatorPaused && null != lifecycleHook) {
            this.resizeAnimatorPaused = lifecycleHook.pauseRenderingAction();
        }
        this.sizeChanged(bl, false, n4, n5, bl2);
        this.screenPositionChanged(bl, n2, n3);
        this.insetsChanged(false, n6, n7, n8, n9);
        if (!bl3 && this.resizeAnimatorPaused) {
            this.resizeAnimatorPaused = false;
            if (null != lifecycleHook) {
                lifecycleHook.resumeRenderingAction();
            }
        }
    }

    @Override
    protected void setPointerIconImpl(PointerIconImpl pointerIconImpl) {
        if (!this.isOffscreenInstance) {
            final long l2 = null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L;
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.setPointerIcon0(WindowDriver.this.getWindowHandle(), l2);
                }
            });
        }
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        if (!this.isOffscreenInstance) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.setPointerVisible0(WindowDriver.this.getWindowHandle(), WindowDriver.this.hasFocus(), bl);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    protected boolean confinePointerImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            WindowDriver.confinePointer0(this.getWindowHandle(), bl);
            return true;
        }
        return false;
    }

    @Override
    protected void warpPointerImpl(int n2, int n3) {
        if (!this.isOffscreenInstance) {
            WindowDriver.warpPointer0(this.getWindowHandle(), SurfaceScaleUtils.scaleInv(n2, this.getPixelScaleX()), SurfaceScaleUtils.scaleInv(n3, this.getPixelScaleY()));
        }
    }

    @Override
    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n2, int n3, int n4, short s2, float[] fArray, float f2) {
        super.doMouseEvent(bl, bl2, s, n2, SurfaceScaleUtils.scale(n3, this.getPixelScaleX()), SurfaceScaleUtils.scale(n4, this.getPixelScaleY()), s2, fArray, f2);
    }

    @Override
    public final void sendKeyEvent(short s, int n2, short s2, short s3, char c2) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    @Override
    public final void enqueueKeyEvent(boolean bl, short s, int n2, short s2, short s3, char c2) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    protected final void enqueueKeyEvent(boolean bl, short s, int n2, short s2, char c2, char c3) {
        short s3 = MacKeyUtil.validateKeyCode(s2, c2);
        short s4 = '\u0000' != c3 ? KeyEvent.utf16ToVKey(c3) : (short)0;
        short s5 = 0 != s4 ? s4 : s3;
        switch (s) {
            case 301: {
                if (!this.isKeyCodeTracked(s3)) break;
                this.setKeyPressed(s3, false);
                break;
            }
            case 300: {
                if (!this.isKeyCodeTracked(s3) || !this.setKeyPressed(s3, true)) break;
                super.enqueueKeyEvent(bl, (short)301, n2 |= 0x20000000, s3, s5, c2);
            }
        }
        super.enqueueKeyEvent(bl, s, n2, s3, s5, c2);
    }

    protected int getDisplayID() {
        if (!this.isOffscreenInstance) {
            return this.getDisplayID0(this.getWindowHandle());
        }
        return 0;
    }

    private void createWindow(final boolean bl, boolean bl2, final PointImmutable pointImmutable, final int n2, final int n3, final int n4) {
        final long l2 = this.getParentWindowHandle();
        final long l3 = this.getWindowHandle();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.createWindow on thread " + Thread.currentThread().getName() + ": offscreen " + bl + ", recreate " + bl2 + ", pS " + pointImmutable + ", " + n2 + "x" + n3 + ", reqPixelScale " + this.reqPixelScale[0] + ", state " + WindowDriver.getReconfigStateMaskString(n4) + ", preWinHandle " + WindowDriver.toHexString(l3) + ", parentWin " + WindowDriver.toHexString(l2) + ", surfaceHandle " + WindowDriver.toHexString(this.surfaceHandle));
        }
        try {
            if (0L != l3) {
                this.setWindowHandle(0L);
                if (0L == this.surfaceHandle) {
                    throw new NativeWindowException("Internal Error - create w/ window, but no Newt NSView");
                }
            } else if (0L != this.surfaceHandle) {
                throw new NativeWindowException("Internal Error - create w/o window, but has Newt NSView");
            }
            int n5 = 0;
            if (0 != (0x10 & n4) || bl) {
                n5 = 0;
            } else {
                n5 = 7;
                if (0 != (0x100 & n4)) {
                    n5 |= 8;
                }
            }
            final int n6 = n5;
            final long[] lArray = new long[]{0L};
            OSXUtil.RunOnMainThread(true, false, new Runnable(){

                @Override
                public void run() {
                    boolean bl2 = WindowDriver.this.getGraphicsConfiguration().getChosenCapabilities().isBackgroundOpaque() && !bl;
                    lArray[0] = WindowDriver.this.createWindow1(l3, l2, pointImmutable.getX(), pointImmutable.getY(), n2, n3, WindowDriver.this.reqPixelScale[0], 0 != (0x800 & n4), n6, 2, bl2, !bl && 0 != (0x20 & n4), !bl && 0 != (0x40 & n4), !bl && 0 != (1 & n4), WindowDriver.this.surfaceHandle);
                    WindowDriver.this.surfaceHandle = OSXUtil.GetNSView(lArray[0]);
                    if (bl) {
                        WindowDriver.this.orderOut0(0L != l2 ? l2 : lArray[0]);
                    } else {
                        WindowDriver.this.setTitle0(lArray[0], WindowDriver.this.getTitle());
                    }
                }
            });
            if (lArray[0] == 0L || 0L == this.surfaceHandle) {
                throw new NativeWindowException("Could not create native window " + Thread.currentThread().getName() + " " + this);
            }
            this.setWindowHandle(lArray[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static native boolean initIDs0();

    private native long createWindow1(long var1, long var3, int var5, int var6, int var7, int var8, float var9, boolean var10, int var11, int var12, boolean var13, boolean var14, boolean var15, boolean var16, long var17);

    private native int getDisplayID0(long var1);

    private native void setPixelScale0(long var1, long var3, float var5);

    private native boolean lockSurface0(long var1, long var3);

    private native boolean unlockSurface0(long var1, long var3);

    private native void requestFocus0(long var1, boolean var3);

    private native void resignFocus0(long var1);

    private native void orderOut0(long var1);

    private native void orderFront0(long var1);

    private native void close0(long var1);

    private native void setTitle0(long var1, String var3);

    private native long contentView0(long var1);

    private native void changeContentView0(long var1, long var3, long var5);

    private native void setWindowClientTopLeftPointAndSize0(long var1, int var3, int var4, int var5, int var6, boolean var7);

    private native void setWindowClientTopLeftPoint0(long var1, int var3, int var4, boolean var5);

    private native void updateSizePosInsets0(long var1, boolean var3);

    private static native Object getLocationOnScreen0(long var0, int var2, int var3);

    private static native void setPointerIcon0(long var0, long var2);

    private static native void setPointerVisible0(long var0, boolean var2, boolean var3);

    private static native void confinePointer0(long var0, boolean var2);

    private static native void warpPointer0(long var0, int var2, int var3);

    static {
        DisplayDriver.initSingleton();
    }
}

