/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.egl.gbm;

import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import jogamp.nativewindow.drm.DRMUtil;
import jogamp.nativewindow.drm.DrmMode;
import jogamp.nativewindow.drm.drmModeConnector;
import jogamp.nativewindow.drm.drmModeEncoder;
import jogamp.nativewindow.drm.drmModeModeInfo;
import jogamp.newt.MonitorModeProps;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.egl.gbm.DisplayDriver;
import jogamp.newt.driver.linux.LinuxMouseTracker;

public class ScreenDriver
extends ScreenImpl {
    DrmMode drmMode;
    protected int[] crtc_ids;
    private final Object pointerIconSync = new Object();
    private PointerIconImpl activePointerIcon;
    private boolean activePointerIconVisible;
    private PointerIconImpl defaultPointerIcon = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createNativeImpl() {
        this.aScreen = new DefaultGraphicsScreen(this.getDisplay().getGraphicsDevice(), this.screen_idx);
        this.drmMode = DrmMode.create(DRMUtil.getDrmFd(), true);
        if (DEBUG) {
            this.drmMode.print(System.err);
        }
        Object object = this.pointerIconSync;
        synchronized (object) {
            this.defaultPointerIcon = ((DisplayDriver)this.display).defaultPointerIcon;
        }
        if (DEBUG) {
            System.err.println("Screen.createNativeImpl: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        if (DEBUG) {
            System.err.println("Screen.closeNativeImpl: " + this);
        }
        Object object = this.pointerIconSync;
        synchronized (object) {
            this.defaultPointerIcon = null;
            this.activePointerIcon = null;
            this.activePointerIconVisible = false;
        }
        this.drmMode.destroy();
        this.drmMode = null;
    }

    @Override
    protected int validateScreenIndex(int n2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectNativeMonitorModesAndDevicesImpl(MonitorModeProps.Cache cache) {
        drmModeConnector[] drmModeConnectorArray = this.drmMode.getConnectors();
        drmModeEncoder[] drmModeEncoderArray = this.drmMode.getEncoder();
        drmModeModeInfo[] drmModeModeInfoArray = this.drmMode.getModes();
        int[] nArray = new int[8];
        int n2 = 0;
        nArray[n2++] = 8;
        nArray[n2++] = drmModeModeInfoArray[0].getHdisplay();
        nArray[n2++] = drmModeModeInfoArray[0].getVdisplay();
        nArray[n2++] = 32;
        nArray[n2++] = drmModeModeInfoArray[0].getVrefresh() * 100;
        nArray[n2++] = 0;
        nArray[n2++] = 0;
        nArray[n2++] = 0;
        MonitorMode monitorMode = MonitorModeProps.streamInMonitorMode(null, cache, nArray, 0);
        int n3 = drmModeEncoderArray[0].getCrtc_id();
        nArray = new int[14];
        n2 = 0;
        nArray[n2++] = nArray.length;
        nArray[n2++] = n3;
        nArray[n2++] = 0;
        nArray[n2++] = 1;
        nArray[n2++] = drmModeConnectorArray[0].getMmWidth();
        nArray[n2++] = drmModeConnectorArray[0].getMmHeight();
        nArray[n2++] = 0;
        nArray[n2++] = 0;
        nArray[n2++] = drmModeModeInfoArray[0].getHdisplay();
        nArray[n2++] = drmModeModeInfoArray[0].getVdisplay();
        nArray[n2++] = 0;
        nArray[n2++] = 0;
        nArray[n2++] = drmModeModeInfoArray[0].getHdisplay();
        nArray[n2++] = drmModeModeInfoArray[0].getVdisplay();
        MonitorModeProps.streamInMonitorDevice(cache, this, n3, null, monitorMode, null, false, cache.monitorModes, nArray, 0, null);
        this.crtc_ids = new int[]{drmModeEncoderArray[0].getCrtc_id()};
        Object object = this.pointerIconSync;
        synchronized (object) {
            if (null != this.defaultPointerIcon) {
                LinuxMouseTracker linuxMouseTracker = LinuxMouseTracker.getSingleton();
                if (null != linuxMouseTracker) {
                    this.setPointerIconActive(this.defaultPointerIcon, linuxMouseTracker.getLastX(), linuxMouseTracker.getLastY());
                } else {
                    this.setPointerIconActive(this.defaultPointerIcon, 0, 0);
                }
            }
        }
    }

    @Override
    protected MonitorMode queryCurrentMonitorModeImpl(MonitorDevice monitorDevice) {
        return monitorDevice.getSupportedModes().get(0);
    }

    @Override
    protected boolean setCurrentMonitorModeImpl(MonitorDevice monitorDevice, MonitorMode monitorMode) {
        return false;
    }

    @Override
    protected void calcVirtualScreenOriginAndSize(Rectangle rectangle, Rectangle rectangle2) {
        rectangle.set(0, 0, this.drmMode.getModes()[0].getHdisplay(), this.drmMode.getModes()[0].getVdisplay());
        rectangle2.set(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPointerIconActive(PointerIconImpl pointerIconImpl, int n2, int n3) {
        Object object = this.pointerIconSync;
        synchronized (object) {
            if (DisplayDriver.DEBUG_POINTER_ICON) {
                System.err.println("Screen.PointerIcon.set.0: " + Thread.currentThread().getName());
                System.err.println("Screen.PointerIcon.set.0: crtc id " + Display.toHexString(this.crtc_ids[0]) + ", active [" + this.activePointerIcon + ", visible " + this.activePointerIconVisible + "] -> " + pointerIconImpl);
            }
            if (null != this.activePointerIcon && this.activePointerIconVisible) {
                ((DisplayDriver)this.display).setPointerIcon(this.crtc_ids[0], this.activePointerIcon.validatedHandle(), false, 0, 0, n2, n3);
            }
            if (null == pointerIconImpl && null != this.defaultPointerIcon) {
                pointerIconImpl = ((DisplayDriver)this.display).defaultPointerIcon;
            }
            if (null != pointerIconImpl) {
                PointImmutable pointImmutable = pointerIconImpl.getHotspot();
                ((DisplayDriver)this.display).setPointerIcon(this.crtc_ids[0], pointerIconImpl.validatedHandle(), true, pointImmutable.getX(), pointImmutable.getY(), n2, n3);
                this.activePointerIconVisible = true;
            } else {
                this.activePointerIconVisible = false;
            }
            this.activePointerIcon = pointerIconImpl;
            if (DisplayDriver.DEBUG_POINTER_ICON) {
                System.err.println("Screen.PointerIcon.set.X: active [" + this.activePointerIcon + ", visible " + this.activePointerIconVisible + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActivePointerIconVisible(boolean bl, int n2, int n3) {
        Object object = this.pointerIconSync;
        synchronized (object) {
            if (DisplayDriver.DEBUG_POINTER_ICON) {
                System.err.println("Screen.PointerIcon.visible: crtc id " + Display.toHexString(this.crtc_ids[0]) + ", active [" + this.activePointerIcon + ", visible " + this.activePointerIconVisible + "] -> visible " + bl);
            }
            if (this.activePointerIconVisible != bl) {
                if (null != this.activePointerIcon) {
                    PointImmutable pointImmutable = this.activePointerIcon.getHotspot();
                    ((DisplayDriver)this.display).setPointerIcon(this.crtc_ids[0], this.activePointerIcon.validatedHandle(), bl, pointImmutable.getX(), pointImmutable.getY(), n2, n3);
                }
                this.activePointerIconVisible = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveActivePointerIcon(int n2, int n3) {
        Object object = this.pointerIconSync;
        synchronized (object) {
            if (DisplayDriver.DEBUG_POINTER_ICON) {
                System.err.println("Screen.PointerIcon.move: crtc id " + Display.toHexString(this.crtc_ids[0]) + ", active [" + this.activePointerIcon + ", visible " + this.activePointerIconVisible + "], " + n2 + "/" + n3);
            }
            if (null != this.activePointerIcon && this.activePointerIconVisible) {
                ((DisplayDriver)this.display).movePointerIcon(this.crtc_ids[0], n2, n3);
            }
        }
    }

    protected static native boolean initIDs();

    protected native void initNative(long var1);

    static {
        DisplayDriver.initSingleton();
    }
}

