/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.nativewindow.NativeWindowException;
import java.util.ArrayList;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.nativewindow.windows.RegisteredClass;

public class RegisteredClassFactory {
    private static final boolean DEBUG = Debug.debug("RegisteredClass");
    private static final ArrayList<RegisteredClassFactory> registeredFactories;
    private static final long hInstance;
    private final String classBaseName;
    private final long wndProc;
    private final boolean useDummyDispatchThread;
    private final long iconSmallHandle;
    private final long iconBigHandle;
    private RegisteredClass sharedClass = null;
    private int classIter = 0;
    private int sharedRefCount = 0;
    private final Object sync = new Object();

    private String toHexString(long l2) {
        return "0x" + Long.toHexString(l2);
    }

    public final String toString() {
        return "RegisteredClassFactory[moduleHandle " + this.toHexString(hInstance) + ", " + this.classBaseName + ", wndProc " + this.toHexString(this.wndProc) + ", useDDT " + this.useDummyDispatchThread + ", shared[refCount " + this.sharedRefCount + ", class " + this.sharedClass + "]]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownSharedClasses() {
        ArrayList<RegisteredClassFactory> arrayList = registeredFactories;
        synchronized (arrayList) {
            if (DEBUG) {
                System.err.println("RegisteredClassFactory.shutdownSharedClasses: " + registeredFactories.size());
            }
            for (int i2 = 0; i2 < registeredFactories.size(); ++i2) {
                RegisteredClassFactory registeredClassFactory = registeredFactories.get(i2);
                Object object = registeredClassFactory.sync;
                synchronized (object) {
                    if (null != registeredClassFactory.sharedClass) {
                        GDIUtil.DestroyWindowClass0(registeredClassFactory.sharedClass.getHInstance(), registeredClassFactory.sharedClass.getName(), registeredClassFactory.sharedClass.getHDispThreadContext());
                        registeredClassFactory.sharedClass = null;
                        registeredClassFactory.sharedRefCount = 0;
                        registeredClassFactory.classIter = 0;
                        if (DEBUG) {
                            System.err.println("RegisteredClassFactory #" + i2 + "/" + registeredFactories.size() + ": shutdownSharedClasses : " + registeredClassFactory.sharedClass);
                        }
                    } else if (DEBUG) {
                        System.err.println("RegisteredClassFactory #" + i2 + "/" + registeredFactories.size() + ": null");
                    }
                    continue;
                }
            }
        }
    }

    public static long getHInstance() {
        return hInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredClassFactory(String string, long l2, boolean bl, long l3, long l4) {
        this.classBaseName = string;
        this.wndProc = l2;
        this.useDummyDispatchThread = bl;
        this.iconSmallHandle = l3;
        this.iconBigHandle = l4;
        ArrayList<RegisteredClassFactory> arrayList = registeredFactories;
        synchronized (arrayList) {
            registeredFactories.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredClass getSharedClass() throws NativeWindowException {
        Object object = this.sync;
        synchronized (object) {
            if (0 == this.sharedRefCount) {
                long l2;
                if (null != this.sharedClass) {
                    throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass not null: " + this.sharedClass);
                }
                String string = null;
                boolean bl = false;
                int n2 = this.classIter - 1;
                while (!bl && n2 != this.classIter) {
                    string = this.classBaseName + this.classIter;
                    ++this.classIter;
                    bl = GDIUtil.CreateWindowClass0(hInstance, string, this.wndProc, this.iconSmallHandle, this.iconBigHandle);
                }
                if (!bl) {
                    throw new NativeWindowException("Error: Could not create WindowClass: " + string);
                }
                if (this.useDummyDispatchThread) {
                    l2 = GDIUtil.CreateDummyDispatchThread0();
                    if (0L == l2) {
                        throw new NativeWindowException("Error: Could not create DDT " + string);
                    }
                } else {
                    l2 = 0L;
                }
                this.sharedClass = new RegisteredClass(hInstance, string, l2);
                if (DEBUG) {
                    System.err.println("RegisteredClassFactory getSharedClass (" + this.sharedRefCount + ") initialized: " + this.sharedClass);
                }
            } else if (null == this.sharedClass) {
                throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass is null");
            }
            ++this.sharedRefCount;
        }
        return this.sharedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSharedClass() {
        Object object = this.sync;
        synchronized (object) {
            if (0 == this.sharedRefCount) {
                if (null != this.sharedClass) {
                    throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass not null: " + this.sharedClass);
                }
                return;
            }
            --this.sharedRefCount;
            if (null == this.sharedClass) {
                throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass is null");
            }
            if (0 == this.sharedRefCount) {
                GDIUtil.DestroyWindowClass0(this.sharedClass.getHInstance(), this.sharedClass.getName(), this.sharedClass.getHDispThreadContext());
                if (DEBUG) {
                    System.err.println("RegisteredClassFactory releaseSharedClass (" + this.sharedRefCount + ") released: " + this.sharedClass);
                }
                this.sharedClass = null;
                this.sharedRefCount = 0;
                this.classIter = 0;
            }
        }
    }

    public int getSharedRefCount() {
        return this.sharedRefCount;
    }

    static {
        hInstance = GDI.GetApplicationHandle();
        if (0L == hInstance) {
            throw new NativeWindowException("Error: Null ModuleHandle for Application");
        }
        registeredFactories = new ArrayList();
    }
}

