/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.macosx;

import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import jogamp.nativewindow.macosx.OSXUtil;

public class OSXDummyUpstreamSurfaceHook
extends UpstreamSurfaceHookMutableSize {
    long nsWindow = 0L;

    public OSXDummyUpstreamSurfaceHook(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    public final void create(ProxySurface proxySurface) {
        if (0L == this.nsWindow && 0L == proxySurface.getSurfaceHandle()) {
            this.nsWindow = OSXUtil.CreateNSWindow(0, 0, 64, 64);
            if (0L == this.nsWindow) {
                throw new NativeWindowException("Error NS window 0");
            }
            long l2 = OSXUtil.GetNSView(this.nsWindow);
            if (0L == l2) {
                throw new NativeWindowException("Error NS view 0");
            }
            proxySurface.setSurfaceHandle(l2);
            proxySurface.addUpstreamOptionBits(64);
        }
        proxySurface.addUpstreamOptionBits(256);
    }

    @Override
    public final void destroy(ProxySurface proxySurface) {
        if (proxySurface.containsUpstreamOptionBits(64)) {
            if (0L == this.nsWindow || 0L == proxySurface.getSurfaceHandle()) {
                throw new InternalError("Owns upstream surface, but no OSX view/window: " + proxySurface + ", nsWindow 0x" + Long.toHexString(this.nsWindow));
            }
            OSXUtil.DestroyNSWindow(this.nsWindow);
            this.nsWindow = 0L;
            proxySurface.setSurfaceHandle(0L);
            proxySurface.clearUpstreamOptionBits(64);
        }
    }
}

