/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import jogamp.nativewindow.drm.DRMLib;
import jogamp.nativewindow.drm.DRMUtil;

public class GBMDummyUpstreamSurfaceHook
extends UpstreamSurfaceHookMutableSize {
    private long gbmDevice = 0L;

    public GBMDummyUpstreamSurfaceHook(int n2, int n3) {
        super(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void create(ProxySurface proxySurface) {
        AbstractGraphicsDevice abstractGraphicsDevice = proxySurface.getGraphicsConfiguration().getScreen().getDevice();
        int n2 = DRMUtil.GBM_FORMAT_XRGB8888;
        abstractGraphicsDevice.lock();
        try {
            if (0L == proxySurface.getSurfaceHandle()) {
                this.gbmDevice = DRMLib.gbm_create_device(DRMUtil.getDrmFd());
                if (0L == this.gbmDevice) {
                    throw new NativeWindowException("Creating dummy GBM device failed");
                }
                long l2 = DRMLib.gbm_surface_create(this.gbmDevice, 64, 64, n2, 5);
                if (0L == l2) {
                    throw new NativeWindowException("Creating dummy GBM surface failed");
                }
                proxySurface.setSurfaceHandle(l2);
                proxySurface.addUpstreamOptionBits(64);
            }
            proxySurface.addUpstreamOptionBits(256);
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy(ProxySurface proxySurface) {
        if (proxySurface.containsUpstreamOptionBits(64)) {
            AbstractGraphicsDevice abstractGraphicsDevice = proxySurface.getGraphicsConfiguration().getScreen().getDevice();
            long l2 = proxySurface.getSurfaceHandle();
            if (0L == this.gbmDevice) {
                throw new InternalError("GBM device handle is null");
            }
            if (0L == l2) {
                throw new InternalError("Owns upstream surface, but has no GBM surface: " + proxySurface);
            }
            abstractGraphicsDevice.lock();
            try {
                DRMLib.gbm_surface_destroy(l2);
                proxySurface.setSurfaceHandle(0L);
                DRMLib.gbm_device_destroy(this.gbmDevice);
                this.gbmDevice = 0L;
                proxySurface.clearUpstreamOptionBits(64);
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
    }
}

